/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config.filter;

import com.android.ddmlib.Log;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.invoker.TestInvocation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.service.TradefedFeatureClient;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.proto.tradefed.feature.FeatureResponse;
import com.proto.tradefed.feature.PartResponse;
import java.util.HashMap;
import java.util.Set;

public class OptionFetcher
implements AutoCloseable {
    private static final Set<String> OPTION_TO_FETCH = ImmutableSet.of("retry-isolation-grade", "avd-in-parent", "enable-tracing", "auto-collect", "skip-retry-in-presubmit", "skip-retrying-list", new String[0]);
    private TradefedFeatureClient mClient;

    public OptionFetcher() {
        this(new TradefedFeatureClient());
    }

    OptionFetcher(TradefedFeatureClient client) {
        this.mClient = client;
    }

    public void fetchParentOptions(IConfiguration config) {
        if (!TestInvocation.isSubprocess(config)) {
            return;
        }
        try {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("option_name", Joiner.on(",").join(OPTION_TO_FETCH));
            FeatureResponse rep = this.mClient.triggerFeature("getCommandOptions", args);
            if (rep.hasErrorInfo()) {
                LogUtil.CLog.e("%s", rep.getErrorInfo());
                return;
            }
            if (rep.hasMultiPartResponse()) {
                for (PartResponse part : rep.getMultiPartResponse().getResponsePartList()) {
                    LogUtil.CLog.logAndDisplay(Log.LogLevel.DEBUG, "Fetched: %s=%s from parent.", part.getKey(), part.getValue());
                    try {
                        config.injectOptionValue(part.getKey(), part.getValue());
                    }
                    catch (ConfigurationException e) {
                        LogUtil.CLog.e(e);
                    }
                }
            } else if (!Strings.isNullOrEmpty(rep.getResponse())) {
                try {
                    config.injectOptionValue("retry-isolation-grade", rep.getResponse().trim());
                }
                catch (ConfigurationException e) {
                    LogUtil.CLog.e(e);
                }
            }
        }
        catch (RuntimeException e) {
            LogUtil.CLog.e(e);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.mClient != null) {
            this.mClient.close();
        }
    }
}

