/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config.gcs;

import com.android.tradefed.config.ConfigurationDef;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.ConfigurationFactory;
import com.android.tradefed.config.IConfigurationFactory;
import com.android.tradefed.config.IConfigurationServer;
import com.android.tradefed.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;

public class GCSConfigurationFactory
extends ConfigurationFactory {
    private static IConfigurationFactory sInstance = null;
    private IConfigurationServer mConfigServer;
    private File mConfigDownloaded = null;

    GCSConfigurationFactory(IConfigurationServer configServer) {
        this.mConfigServer = configServer;
    }

    public static IConfigurationFactory getInstance(IConfigurationServer configServer) {
        if (sInstance == null) {
            sInstance = new GCSConfigurationFactory(configServer);
        }
        return sInstance;
    }

    @Override
    protected BufferedInputStream getConfigStream(String name) throws ConfigurationException {
        InputStream configStream = this.getBundledConfigStream(name);
        if (configStream == null) {
            configStream = this.mConfigServer.getConfig(name);
            if (configStream == null) {
                throw new ConfigurationException(String.format("Could not find configuration '%s'", name));
            }
            try {
                File tfDir = null;
                String tfPath = System.getProperty("TF_JAR_DIR");
                if (tfPath != null) {
                    tfDir = tfPath.equals(".") ? new File("").getAbsoluteFile() : new File(tfPath).getAbsoluteFile();
                }
                this.mConfigDownloaded = FileUtil.createTempFile("gcs-downloaded-global-config", ".xml", tfDir);
                this.mConfigDownloaded.deleteOnExit();
                FileUtil.writeToFile(configStream, this.mConfigDownloaded);
                configStream.reset();
            }
            catch (IOException e) {
                throw new ConfigurationException(e.getMessage());
            }
        }
        return new BufferedInputStream(configStream);
    }

    public File getLatestDownloadedFile() {
        return this.mConfigDownloaded;
    }

    @Override
    protected ConfigurationDef getConfigurationDef(String name, boolean isGlobal, Map<String, String> templateMap) throws ConfigurationException {
        return new GCSConfigLoader(isGlobal).getConfigurationDef(name, templateMap);
    }

    protected class GCSConfigLoader
    extends ConfigurationFactory.ConfigLoader {
        public GCSConfigLoader(boolean isGlobalConfig) {
            super(isGlobalConfig);
        }

        @Override
        protected String findConfigName(String name, String parentName) throws ConfigurationException {
            if (this.isBundledConfig(name)) {
                return name;
            }
            if (parentName == null || this.isBundledConfig(parentName)) {
                return name;
            }
            return this.getPath(parentName, name);
        }

        String getPath(String parent, String filename) {
            Path parentPath = Paths.get(parent, new String[0]).getParent();
            if (parentPath == null) {
                return filename;
            }
            return parentPath.resolve(filename).normalize().toString();
        }

        @Override
        protected void trackConfig(String name, ConfigurationDef def) {
        }
    }
}

