/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config.gcs;

import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.IConfigurationServer;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.util.GCSFileDownloader;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Scanner;

@OptionClass(alias="gcs-config-server", global_namespace=false)
public class GCSConfigurationServer
implements IConfigurationServer {
    private static final String DEFAULT_MAPPING = "host-config.txt";
    @Option(name="bucket-name", description="Google Cloud Storage bucket name.", mandatory=true)
    private String mBucketName;
    @Option(name="host-config-mapping-filename", description="Mapping file maps hostname to its config.")
    private String mHostConfigMapping = "host-config.txt";
    @Option(name="cluster", description="The cluster name mapping to the actual config the host will use.")
    private String mCluster = null;
    @Option(name="config-path", description="The config path relative to the bucket the host will use.")
    private String mCurrentHostConfig = null;
    private GCSFileDownloader mGCSFileDownloader = null;
    private String mHostname = null;

    @Override
    public String getCurrentHostConfig() throws ConfigurationException {
        if (this.mCurrentHostConfig == null) {
            this.mCurrentHostConfig = this.getHostConfig(this.currentHostname(), this.mCluster);
        }
        return this.mCurrentHostConfig;
    }

    protected String getHostConfig(String hostname, String cluster) throws ConfigurationException {
        System.out.format("Downloading %s.\n", this.mHostConfigMapping);
        InputStream hostConfigMapping = this.downloadFileToInputStream(this.mHostConfigMapping);
        if (cluster == null) {
            System.out.printf("Use hostname %s to get config.\n", hostname);
            return this.getHostConfig(hostConfigMapping, hostname, (key, candidate) -> this.sameHost(key, candidate));
        }
        System.out.printf("Use cluster name %s to get config.\n", cluster);
        return this.getHostConfig(hostConfigMapping, cluster, (key, candidate) -> key.equals(candidate));
    }

    private String getHostConfig(InputStream hostConfigMappingFile, String key, IMatcher matcher) throws ConfigurationException {
        try (Scanner scanner = new Scanner(hostConfigMappingFile);){
            while (scanner.hasNextLine()) {
                String[] hostMap;
                String line = scanner.nextLine().trim();
                if (line.startsWith("#") || line.isEmpty() || line.startsWith("[") || (hostMap = line.split(",")).length < 3) continue;
                if (!matcher.match(key, hostMap[0])) continue;
                String string = hostMap[2];
                return string;
            }
            throw new ConfigurationException(String.format("There is no config for %s.", key));
        }
    }

    protected boolean sameHost(String currentHostname, String hostname) {
        if (currentHostname.equals(hostname)) {
            return true;
        }
        return currentHostname.startsWith(hostname + ".");
    }

    @VisibleForTesting
    String currentHostname() throws ConfigurationException {
        if (this.mHostname == null) {
            try {
                this.mHostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                throw new ConfigurationException("failed to get host name", e);
            }
        }
        return this.mHostname;
    }

    @Override
    public InputStream getConfig(String name) throws ConfigurationException {
        System.out.format("Downloading %s.\n", name);
        return this.downloadFileToInputStream(name);
    }

    @VisibleForTesting
    InputStream downloadFileToInputStream(String name) throws ConfigurationException {
        try {
            return this.getFileDownloader().downloadFile(this.mBucketName, name);
        }
        catch (IOException e) {
            throw new ConfigurationException("failed to download from GCS", e);
        }
    }

    protected File downloadFile(String name) throws ConfigurationException {
        try {
            return this.getFileDownloader().downloadFile(String.format("gs://%s/%s", this.mBucketName, name));
        }
        catch (BuildRetrievalError e) {
            throw new ConfigurationException("failed to download from GCS", e);
        }
    }

    GCSFileDownloader getFileDownloader() {
        if (this.mGCSFileDownloader == null) {
            this.mGCSFileDownloader = new GCSFileDownloader();
        }
        return this.mGCSFileDownloader;
    }

    static interface IMatcher {
        public boolean match(String var1, String var2);
    }
}

