/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config.proxy;

import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.proto.FileProtoResultReporter;
import com.android.tradefed.result.proto.StreamProtoResultReporter;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.List;

public class AutomatedReporters {
    public static final String PROTO_REPORTING_PORT = "PROTO_REPORTING_PORT";
    public static final String PROTO_REPORTING_FILE = "PROTO_REPORTING_FILE";
    public static final String PROTO_REPORTING_FILE_GRANULAR = "PROTO_REPORTING_FILE_GRANULAR";
    public static final ImmutableSet<String> REPORTER_MAPPING = ImmutableSet.of("PROTO_REPORTING_PORT", "PROTO_REPORTING_FILE", "PROTO_REPORTING_FILE_GRANULAR");

    public void applyAutomatedReporters(IConfiguration configuration) {
        for (String key : REPORTER_MAPPING) {
            String envValue = this.getEnv(key);
            if (envValue == null) continue;
            switch (key) {
                case "PROTO_REPORTING_PORT": {
                    StreamProtoResultReporter streamProto = new StreamProtoResultReporter();
                    try {
                        streamProto.setProtoReportPort(Integer.parseInt(envValue));
                        List<ITestInvocationListener> listeners = configuration.getTestInvocationListeners();
                        listeners.add(streamProto);
                        configuration.setTestInvocationListeners(listeners);
                    }
                    catch (NumberFormatException e) {
                        LogUtil.CLog.e(e);
                    }
                    break;
                }
                case "PROTO_REPORTING_FILE": {
                    FileProtoResultReporter fileReporter = new FileProtoResultReporter();
                    fileReporter.setOutputFile(new File(envValue));
                    fileReporter.setDelimitedOutput(false);
                    fileReporter.setGranularResults(false);
                    this.addToReporters(configuration, fileReporter);
                    break;
                }
                case "PROTO_REPORTING_FILE_GRANULAR": {
                    FileProtoResultReporter fileReporterGranular = new FileProtoResultReporter();
                    fileReporterGranular.setOutputFile(new File(envValue));
                    fileReporterGranular.setDelimitedOutput(false);
                    fileReporterGranular.setGranularResults(true);
                    this.addToReporters(configuration, fileReporterGranular);
                    break;
                }
            }
        }
    }

    protected String getEnv(String key) {
        return System.getenv(key);
    }

    private void addToReporters(IConfiguration configuration, ITestInvocationListener reporter) {
        List<ITestInvocationListener> listeners = configuration.getTestInvocationListeners();
        listeners.add(reporter);
        configuration.setTestInvocationListeners(listeners);
    }
}

