/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config.proxy;

import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.Option;
import com.android.tradefed.log.LogUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;

public final class ProxyConfiguration {
    public static final String PROXY_CONFIG_TYPE_KEY = "proxy-config";
    private static final String PROXY_CONFIG_OPTION_NAME = "proxy-configuration";
    @Option(name="proxy-configuration", description="Point to an external configuration to be run instead.")
    private File mProxyConfig;

    public boolean isProxySet() {
        return this.mProxyConfig != null;
    }

    public File getProxyConfig() {
        if (this.mProxyConfig == null || !this.mProxyConfig.exists()) {
            LogUtil.CLog.e("No proxy configuration is configured: %s", this.mProxyConfig);
            return null;
        }
        if (this.mProxyConfig.isDirectory()) {
            LogUtil.CLog.e("Proxy configuration must be a file, found a directory: %s", this.mProxyConfig);
            return null;
        }
        return this.mProxyConfig;
    }

    public static String[] clearCommandline(String[] originalCommand) throws ConfigurationException {
        ArrayList<String> argsList = new ArrayList<String>(Arrays.asList(originalCommand));
        try {
            while (argsList.contains("--proxy-configuration")) {
                int index = argsList.indexOf("--proxy-configuration");
                if (index == -1) continue;
                argsList.remove(index + 1);
                argsList.remove(index);
            }
        }
        catch (RuntimeException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
        return argsList.toArray(new String[0]);
    }
}

