/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config.proxy;

import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.Option;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.UniqueMultiMap;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class TradefedDelegator {
    public static final String DELEGATE_OBJECT = "DELEGATE";
    private static final String DELETEGATED_OPTION_NAME = "delegated-tf";
    @Option(name="delegated-tf", description="Points to the root dir of another Tradefed binary that will be used to drive the invocation")
    private File mDelegatedTfRootDir;
    @Option(name="invocation-data", description="Mirror of CommandOptions#INVOCATION_DATA")
    private UniqueMultiMap<String, String> mInvocationData = new UniqueMultiMap();
    @Option(name="cts-params", description="This option is special and can mess up the best effort parser, define it so it knows how to parse it.")
    private List<String> mCtsParams = new ArrayList<String>();
    private String[] mCommandLine = null;

    public boolean shouldUseDelegation() {
        return this.mDelegatedTfRootDir != null;
    }

    public File getTfRootDir() {
        return this.mDelegatedTfRootDir;
    }

    public String createClasspath() throws IOException {
        Set<File> jars = FileUtil.findFilesObject(this.mDelegatedTfRootDir, ".*\\.jar");
        return Joiner.on(":").join(jars);
    }

    public void setCommandLine(String[] command) {
        this.mCommandLine = command;
    }

    public String[] getCommandLine() {
        return this.mCommandLine;
    }

    public boolean isStaging() {
        return this.mInvocationData.containsKey("staging") && !this.mInvocationData.containsKey("staging_delegated");
    }

    public static String[] clearCommandline(String[] originalCommand) throws ConfigurationException {
        String[] commandLine = TradefedDelegator.clearCommandlineFromOneArg(originalCommand, DELETEGATED_OPTION_NAME);
        return commandLine;
    }

    private static String[] clearCommandlineFromOneArg(String[] originalCommand, String optionName) throws ConfigurationException {
        ArrayList<String> argsList = new ArrayList<String>(Arrays.asList(originalCommand));
        try {
            while (argsList.contains("--" + optionName)) {
                int index = argsList.indexOf("--" + optionName);
                if (index == -1) continue;
                argsList.remove(index + 1);
                argsList.remove(index);
            }
        }
        catch (RuntimeException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
        return argsList.toArray(new String[0]);
    }
}

