/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config.remote;

import com.android.tradefed.build.BuildRetrievalError;
import java.io.File;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class ExtendedFile
extends File {
    private String mBuildId;
    private String mBuildTarget;
    private String mBranch;
    private Future<BuildRetrievalError> mParallelDownload;

    ExtendedFile(String path) {
        super(path);
    }

    public ExtendedFile(File file2, String buildId, String buildTarget) {
        super(file2.getAbsolutePath());
        this.mBuildId = buildId;
        this.mBuildTarget = buildTarget;
    }

    public ExtendedFile(File file2, String buildId, String buildTarget, String branch) {
        this(file2, buildId, buildTarget);
        this.mBranch = branch;
    }

    public String getBuildId() {
        return this.mBuildId;
    }

    public String getBuildTarget() {
        return this.mBuildTarget;
    }

    public String getBranch() {
        return this.mBranch;
    }

    public void setDownloadFuture(Future<BuildRetrievalError> download) {
        this.mParallelDownload = download;
    }

    public void cancelDownload() {
        if (!this.isDownloadingInParallel()) {
            return;
        }
        try {
            this.mParallelDownload.cancel(true);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void waitForDownload() throws BuildRetrievalError {
        if (!this.isDownloadingInParallel()) {
            return;
        }
        try {
            BuildRetrievalError error = this.mParallelDownload.get();
            if (error == null) {
                return;
            }
            throw error;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new BuildRetrievalError(String.format("Error during parallel download: %s", e.getMessage()), e);
        }
    }

    public boolean isDownloadingInParallel() {
        return this.mParallelDownload != null;
    }

    public boolean isDoneDownloadingInParallel() {
        if (this.mParallelDownload == null) {
            return true;
        }
        return this.mParallelDownload.isDone();
    }
}

