/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config.remote;

import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.build.gcs.GCSDownloaderHelper;
import com.android.tradefed.config.DynamicRemoteFileResolver;
import com.android.tradefed.config.remote.ExtendedFile;
import com.android.tradefed.config.remote.IRemoteFileResolver;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.invoker.tracing.TracePropagatingExecutorService;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.GCSFileDownloader;
import com.android.tradefed.util.RunUtil;
import java.io.File;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;

public class GcsRemoteFileResolver
implements IRemoteFileResolver {
    public static final String PROTOCOL = "gs";
    private static final long SLEEP_INTERVAL_MS = 5000L;
    private static final String RETRY_TIMEOUT_MS_ARG = "retry_timeout_ms";
    private GCSDownloaderHelper mHelper = null;

    @Override
    public IRemoteFileResolver.ResolvedFile resolveRemoteFile(IRemoteFileResolver.RemoteFileResolverArgs args) throws BuildRetrievalError {
        File consideredFile = args.getConsideredFile();
        String path = consideredFile.getPath();
        File destFile = GCSFileDownloader.createTempFileForRemote(path, null);
        try {
            if (this.canUseParallelDownload(args.getQueryArgs())) {
                Map.Entry<File, Future<BuildRetrievalError>> parallelDownload = this.fetchResourceWithRetryParallel(path, args.getQueryArgs(), destFile);
                ExtendedFile eFile = new ExtendedFile(parallelDownload.getKey(), "gcs", "gcs");
                eFile.setDownloadFuture(parallelDownload.getValue());
                return new IRemoteFileResolver.ResolvedFile(eFile);
            }
            this.fetchResourceWithRetry(path, args.getQueryArgs(), destFile);
            return new IRemoteFileResolver.ResolvedFile(DynamicRemoteFileResolver.unzipIfRequired(destFile, args.getQueryArgs()));
        }
        catch (IOException e) {
            FileUtil.deleteFile(destFile);
            LogUtil.CLog.e(e);
            throw new BuildRetrievalError(String.format("Failed to download %s due to: %s", path, e.getMessage()), (Throwable)e, InfraErrorIdentifier.GCS_ERROR);
        }
    }

    @Override
    @Nonnull
    public String getSupportedProtocol() {
        return PROTOCOL;
    }

    protected GCSDownloaderHelper getDownloader() {
        if (this.mHelper == null) {
            this.mHelper = new GCSDownloaderHelper();
        }
        return this.mHelper;
    }

    void sleep() {
        RunUtil.getDefault().sleep(5000L);
    }

    private void fetchResourceWithRetry(String path, Map<String, String> queryArgs, File destFile) throws BuildRetrievalError {
        try (CloseableTraceScope ignored = new CloseableTraceScope("gs_download " + path);){
            String timeoutStringValue = queryArgs.get(RETRY_TIMEOUT_MS_ARG);
            if (timeoutStringValue == null) {
                this.getDownloader().fetchTestResource(destFile, path);
                return;
            }
            long timeout = System.currentTimeMillis() + Long.parseLong(timeoutStringValue);
            BuildRetrievalError error = null;
            while (System.currentTimeMillis() < timeout) {
                try {
                    this.getDownloader().fetchTestResource(destFile, path);
                    return;
                }
                catch (BuildRetrievalError e) {
                    error = e;
                    this.sleep();
                }
            }
            throw error;
        }
    }

    private Map.Entry<File, Future<BuildRetrievalError>> fetchResourceWithRetryParallel(String path, Map<String, String> queryArgs, File destFile) {
        CompletableFuture<BuildRetrievalError> futureClient = CompletableFuture.supplyAsync(() -> {
            try {
                this.fetchResourceWithRetry(path, queryArgs, destFile);
                return null;
            }
            catch (BuildRetrievalError e) {
                return e;
            }
        }, TracePropagatingExecutorService.create(ForkJoinPool.commonPool()));
        return new AbstractMap.SimpleEntry<File, Future<BuildRetrievalError>>(destFile, futureClient);
    }

    private boolean canUseParallelDownload(Map<String, String> query) {
        String unzipValue = query.get("unzip");
        if (unzipValue != null && "true".equals(unzipValue.toLowerCase())) {
            return false;
        }
        String parallelValue = query.get("parallel");
        return parallelValue == null || !"false".equals(parallelValue.toLowerCase());
    }
}

