/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config.remote;

import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.config.DynamicRemoteFileResolver;
import com.android.tradefed.config.remote.IRemoteFileResolver;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.MultiMap;
import com.android.tradefed.util.net.HttpHelper;
import com.android.tradefed.util.net.IHttpHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.annotation.Nonnull;

public class HttpRemoteFileResolver
implements IRemoteFileResolver {
    public static final String PROTOCOL_HTTP = "http";

    @Override
    public IRemoteFileResolver.ResolvedFile resolveRemoteFile(IRemoteFileResolver.RemoteFileResolverArgs args) throws BuildRetrievalError {
        File consideredFile = args.getConsideredFile();
        String path = consideredFile.getPath();
        path = path.replaceFirst(":/", "://");
        IHttpHelper downloader = this.getDownloader();
        File downloadedFile = null;
        try {
            downloadedFile = FileUtil.createTempFile(FileUtil.getBaseName(consideredFile.getName()), FileUtil.getExtension(consideredFile.getName()));
            downloader.doGet(downloader.buildUrl(path, new MultiMap<String, String>(args.getQueryArgs())), new FileOutputStream(downloadedFile));
            return new IRemoteFileResolver.ResolvedFile(DynamicRemoteFileResolver.unzipIfRequired(downloadedFile, args.getQueryArgs()));
        }
        catch (IOException | RuntimeException e) {
            FileUtil.deleteFile(downloadedFile);
            throw new BuildRetrievalError(String.format("Failed to download %s due to: %s", path, e.getMessage()), e);
        }
    }

    @Override
    @Nonnull
    public String getSupportedProtocol() {
        return PROTOCOL_HTTP;
    }

    protected IHttpHelper getDownloader() {
        return new HttpHelper();
    }
}

