/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config.remote;

import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public interface IRemoteFileResolver {
    @Nonnull
    default public File resolveRemoteFiles(File consideredFile) throws BuildRetrievalError {
        throw new BuildRetrievalError("Should not have been called", (ErrorIdentifier)InfraErrorIdentifier.ARTIFACT_UNSUPPORTED_PATH);
    }

    @Nonnull
    default public File resolveRemoteFiles(File consideredFile, Map<String, String> queryArgs) throws BuildRetrievalError {
        return this.resolveRemoteFiles(consideredFile);
    }

    @Nonnull
    default public ResolvedFile resolveRemoteFile(RemoteFileResolverArgs args) throws BuildRetrievalError {
        File file2 = this.resolveRemoteFiles(args.getConsideredFile(), args.getQueryArgs());
        return new ResolvedFile(file2);
    }

    @Nonnull
    public String getSupportedProtocol();

    default public void setPrimaryDevice(ITestDevice device) {
    }

    public static class RemoteFileResolverArgs {
        private File mConsideredFile;
        private Map<String, String> mQueryArgs = new LinkedHashMap<String, String>();
        private File mDestinationDir;

        public RemoteFileResolverArgs setConsideredFile(File consideredFile) {
            this.mConsideredFile = consideredFile;
            return this;
        }

        public RemoteFileResolverArgs addQueryArg(String key, String value) {
            this.mQueryArgs.put(key, value);
            return this;
        }

        public RemoteFileResolverArgs addQueryArgs(Map<String, String> queryArgs) {
            this.mQueryArgs.putAll(queryArgs);
            return this;
        }

        public RemoteFileResolverArgs setDestinationDir(File destinationDir) {
            this.mDestinationDir = destinationDir;
            return this;
        }

        public File getConsideredFile() {
            return this.mConsideredFile;
        }

        public Map<String, String> getQueryArgs() {
            return this.mQueryArgs;
        }

        public File getDestinationDir() {
            return this.mDestinationDir;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.mConsideredFile == null ? 0 : this.mConsideredFile.hashCode());
            result = 31 * result + (this.mDestinationDir == null ? 0 : this.mDestinationDir.hashCode());
            result = 31 * result + (this.mQueryArgs == null ? 0 : this.mQueryArgs.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RemoteFileResolverArgs other = (RemoteFileResolverArgs)obj;
            if (this.mConsideredFile == null ? other.mConsideredFile != null : !this.mConsideredFile.equals(other.mConsideredFile)) {
                return false;
            }
            if (this.mDestinationDir == null ? other.mDestinationDir != null : !this.mDestinationDir.equals(other.mDestinationDir)) {
                return false;
            }
            return !(this.mQueryArgs == null ? other.mQueryArgs != null : !this.mQueryArgs.equals(other.mQueryArgs));
        }
    }

    public static class ResolvedFile {
        private File mResolvedFile;
        private boolean mShouldCleanUp = true;

        public ResolvedFile(File resolvedFile) {
            this.mResolvedFile = resolvedFile;
        }

        public File getResolvedFile() {
            return this.mResolvedFile;
        }

        public ResolvedFile cleanUp(boolean cleanUp) {
            this.mShouldCleanUp = cleanUp;
            return this;
        }

        public boolean shouldCleanUp() {
            return this.mShouldCleanUp;
        }
    }
}

