/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config.remote;

import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.config.remote.IRemoteFileResolver;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import java.io.File;
import javax.annotation.Nonnull;

public class LocalFileResolver
implements IRemoteFileResolver {
    public static final String PROTOCOL = "file";

    @Override
    public IRemoteFileResolver.ResolvedFile resolveRemoteFile(IRemoteFileResolver.RemoteFileResolverArgs args) throws BuildRetrievalError {
        String path = args.getConsideredFile().getPath();
        String pathWithoutProtocol = path.replaceFirst("file:", "");
        File localFile = new File(pathWithoutProtocol);
        if (localFile.exists()) {
            return new IRemoteFileResolver.ResolvedFile(localFile).cleanUp(false);
        }
        throw new BuildRetrievalError(String.format("Failed to find local file %s.", localFile), (ErrorIdentifier)InfraErrorIdentifier.ARTIFACT_NOT_FOUND);
    }

    @Override
    @Nonnull
    public String getSupportedProtocol() {
        return PROTOCOL;
    }
}

