/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config.yaml;

import com.android.tradefed.config.ConfigurationDef;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.yaml.IDefaultObjectLoader;
import com.android.tradefed.config.yaml.YamlClassOptionsParser;
import com.android.tradefed.config.yaml.YamlTestDependencies;
import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.error.YAMLException;

public final class ConfigurationYamlParser {
    private static final String DESCRIPTION_KEY = "description";
    public static final String PRE_SETUP_ACTION_KEY = "pre_setup_action";
    public static final String TARGET_PREPARERS_KEY = "target_preparers";
    public static final String DEPENDENCIES_KEY = "dependencies";
    public static final String TESTS_KEY = "tests";
    private static final List<String> REQUIRED_KEYS = ImmutableList.of("description", "dependencies", "tests");
    private Set<String> mSeenKeys = new HashSet<String>();
    private boolean mCreatedAsModule = false;

    public void parse(ConfigurationDef configDef, String source, InputStream yamlInput, boolean createdAsModule) throws ConfigurationException {
        this.mCreatedAsModule = createdAsModule;
        configDef.setMultiDeviceMode(false);
        Yaml yaml = new Yaml(new SafeConstructor(new LoaderOptions()));
        try {
            configDef.addOptionDef("test-tag", null, source, source, "cmd_options");
            Map yamlObjects = (Map)yaml.load(yamlInput);
            this.translateYamlInTradefed(configDef, yamlObjects);
        }
        catch (YAMLException e) {
            throw new ConfigurationException(String.format("Failed to parse yaml file: '%s'.", source), e);
        }
    }

    private void translateYamlInTradefed(ConfigurationDef configDef, Map<String, Object> yamlObjects) throws ConfigurationException {
        if (yamlObjects.containsKey(DESCRIPTION_KEY)) {
            configDef.setDescription((String)yamlObjects.get(DESCRIPTION_KEY));
            this.mSeenKeys.add(DESCRIPTION_KEY);
        }
        YamlClassOptionsParser presetupClassAndOptions = null;
        if (yamlObjects.containsKey(PRE_SETUP_ACTION_KEY)) {
            List objList = (List)yamlObjects.get(PRE_SETUP_ACTION_KEY);
            presetupClassAndOptions = new YamlClassOptionsParser(objList);
            this.mSeenKeys.add(PRE_SETUP_ACTION_KEY);
        }
        LinkedHashSet<String> dependencyFiles = new LinkedHashSet();
        YamlTestDependencies testDeps = null;
        if (yamlObjects.containsKey(DEPENDENCIES_KEY)) {
            List objList = (List)yamlObjects.get(DEPENDENCIES_KEY);
            testDeps = new YamlTestDependencies(objList);
            dependencyFiles = this.collectDependencyFiles(testDeps);
            this.mSeenKeys.add(DEPENDENCIES_KEY);
        }
        YamlClassOptionsParser runnerInfo = null;
        if (yamlObjects.containsKey(TESTS_KEY)) {
            List objList = (List)yamlObjects.get(TESTS_KEY);
            runnerInfo = new YamlClassOptionsParser(objList);
            this.mSeenKeys.add(TESTS_KEY);
        }
        YamlClassOptionsParser preparerInfo = null;
        if (yamlObjects.containsKey(TARGET_PREPARERS_KEY)) {
            List objList = (List)yamlObjects.get(TARGET_PREPARERS_KEY);
            preparerInfo = new YamlClassOptionsParser(objList);
            this.mSeenKeys.add(TARGET_PREPARERS_KEY);
        }
        if (!this.mSeenKeys.containsAll(REQUIRED_KEYS)) {
            HashSet<String> missingKeys = new HashSet<String>(REQUIRED_KEYS);
            missingKeys.removeAll(this.mSeenKeys);
            throw new ConfigurationException(String.format("'%s' keys are required and were not found.", missingKeys));
        }
        IDefaultObjectLoader.LoaderConfiguration loadConfiguration = new IDefaultObjectLoader.LoaderConfiguration();
        loadConfiguration.setConfigurationDef(configDef).addDependencies(dependencyFiles).setCreatedAsModule(this.mCreatedAsModule);
        ServiceLoader<IDefaultObjectLoader> serviceLoader = ServiceLoader.load(IDefaultObjectLoader.class);
        for (IDefaultObjectLoader loader : serviceLoader) {
            loader.addDefaultObjects(loadConfiguration);
        }
        if (presetupClassAndOptions != null) {
            this.convertClassAndOptionsToObjects(configDef, presetupClassAndOptions.getClassesAndOptions(), "target_preparer");
        }
        if (testDeps != null) {
            this.convertDependenciesToObjects(configDef, testDeps);
        }
        if (runnerInfo != null) {
            this.convertClassAndOptionsToObjects(configDef, runnerInfo.getClassesAndOptions(), "test");
        }
        if (preparerInfo != null) {
            this.convertClassAndOptionsToObjects(configDef, preparerInfo.getClassesAndOptions(), "target_preparer");
        }
    }

    private Set<String> collectDependencyFiles(YamlTestDependencies testDeps) {
        LinkedHashSet<String> dependencies = new LinkedHashSet<String>();
        List<String> apks = testDeps.apks();
        dependencies.addAll(apks);
        Map<String, String> deviceFiles = testDeps.deviceFiles();
        for (Map.Entry<String, String> toPush : deviceFiles.entrySet()) {
            dependencies.add(toPush.getKey());
        }
        dependencies.addAll(testDeps.files());
        return dependencies;
    }

    private void convertDependenciesToObjects(ConfigurationDef def, YamlTestDependencies testDeps) {
        Map<String, String> deviceFiles;
        List<String> apks = testDeps.apks();
        if (!apks.isEmpty()) {
            String className = "com.android.tradefed.targetprep.suite.SuiteApkInstaller";
            int classCount = def.addConfigObjectDef("target_preparer", className);
            String optionName = String.format("%s%c%d%c%s", className, Character.valueOf(':'), classCount, Character.valueOf(':'), "test-file-name");
            for (String apk : apks) {
                def.addOptionDef(optionName, null, apk, def.getName(), "target_preparer");
            }
        }
        if (!(deviceFiles = testDeps.deviceFiles()).isEmpty()) {
            String className = "com.android.tradefed.targetprep.PushFilePreparer";
            int classCount = def.addConfigObjectDef("target_preparer", className);
            String optionName = String.format("%s%c%d%c%s", className, Character.valueOf(':'), classCount, Character.valueOf(':'), "push-file");
            for (Map.Entry<String, String> toPush : deviceFiles.entrySet()) {
                def.addOptionDef(optionName, toPush.getKey(), toPush.getValue(), def.getName(), "target_preparer");
            }
        }
    }

    private void convertClassAndOptionsToObjects(ConfigurationDef def, List<YamlClassOptionsParser.ClassAndOptions> classAndOptionsList, String configObjType) {
        if (classAndOptionsList.isEmpty()) {
            return;
        }
        for (YamlClassOptionsParser.ClassAndOptions classOptions : classAndOptionsList) {
            String className = classOptions.mClass;
            int classCount = def.addConfigObjectDef(configObjType, className);
            for (Map.Entry<String, String> options : classOptions.mOptions.entries()) {
                String optionName = String.format("%s%c%d%c%s", className, Character.valueOf(':'), classCount, Character.valueOf(':'), options.getKey());
                def.addOptionDef(optionName, null, options.getValue(), def.getName(), configObjType);
            }
        }
    }
}

