/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config.yaml;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class YamlClassOptionsParser {
    private static final String OPTIONS_KEY = "options";
    private List<ClassAndOptions> mListClassAndOptions = new ArrayList<ClassAndOptions>();

    public YamlClassOptionsParser(List<Object> objList) {
        for (Object obj : objList) {
            if (obj instanceof String) {
                ClassAndOptions classOptions = new ClassAndOptions();
                this.mListClassAndOptions.add(classOptions);
                classOptions.mClass = (String)obj;
                continue;
            }
            if (!(obj instanceof Map)) continue;
            Map objEntry = (Map)obj;
            for (String classString : objEntry.keySet()) {
                ClassAndOptions classOptions = new ClassAndOptions();
                this.mListClassAndOptions.add(classOptions);
                classOptions.mClass = classString;
                Map map = (Map)objEntry.get(classString);
                if (map == null) continue;
                for (Map.Entry entry : map.entrySet()) {
                    if (!OPTIONS_KEY.equals(entry.getKey())) continue;
                    List optionMapList = (List)entry.getValue();
                    for (Map optionMap : optionMapList) {
                        for (Map.Entry optionVal : optionMap.entrySet()) {
                            classOptions.mOptions.put((String)optionVal.getKey(), optionVal.getValue().toString());
                        }
                    }
                }
            }
        }
    }

    public List<ClassAndOptions> getClassesAndOptions() {
        return this.mListClassAndOptions;
    }

    class ClassAndOptions {
        public String mClass;
        public Multimap<String, String> mOptions = LinkedListMultimap.create();

        ClassAndOptions() {
        }
    }
}

