/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config.yaml;

import com.android.tradefed.config.ConfigurationException;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class YamlTestDependencies {
    private static final String APKS_KEY = "apks";
    private static final String FILES_KEY = "files";
    private static final String DEVICE_FILES_KEY = "device_files";
    private static final Set<String> DEPENDENCY_KEYS = ImmutableSet.of("apks", "files", "device_files");
    private List<String> mApkDependencies = new ArrayList<String>();
    private List<String> mFileDependencies = new ArrayList<String>();
    private Map<String, String> mDeviceFileDependencies = new HashMap<String, String>();

    public YamlTestDependencies(List<Map<String, Object>> dependencies) throws ConfigurationException {
        if (dependencies == null) {
            return;
        }
        for (Map<String, Object> dependencyEntry : dependencies) {
            if (dependencyEntry.containsKey(APKS_KEY)) {
                for (String apk : (List)dependencyEntry.get(APKS_KEY)) {
                    this.mApkDependencies.add(apk.trim());
                }
            }
            if (dependencyEntry.containsKey(FILES_KEY)) {
                for (String apk : (List)dependencyEntry.get(FILES_KEY)) {
                    this.mFileDependencies.add(apk.trim());
                }
            }
            if (dependencyEntry.containsKey(DEVICE_FILES_KEY)) {
                this.mDeviceFileDependencies = (Map)dependencyEntry.get(DEVICE_FILES_KEY);
            }
            if (DEPENDENCY_KEYS.containsAll(dependencyEntry.keySet())) continue;
            HashSet<String> unexpectedKeys = new HashSet<String>(dependencyEntry.keySet());
            unexpectedKeys.removeAll(DEPENDENCY_KEYS);
            throw new ConfigurationException(String.format("keys '%s' in '%s' are unexpected", unexpectedKeys, "dependencies"));
        }
    }

    public List<String> apks() {
        return new ArrayList<String>(this.mApkDependencies);
    }

    public List<String> files() {
        return new ArrayList<String>(this.mFileDependencies);
    }

    public Map<String, String> deviceFiles() {
        return new HashMap<String, String>(this.mDeviceFileDependencies);
    }
}

