/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.IDevice;
import com.android.tradefed.device.IAndroidDebugBridge;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class AndroidDebugBridgeWrapper
implements IAndroidDebugBridge {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^.*(\\d+)\\.(\\d+)\\.(\\d+).*");
    private static final Pattern REVISION_PATTERN = Pattern.compile(".*(Revision )(.*)$");
    private static final Pattern SUB_VERSION_PATTERN = Pattern.compile(".*(Version )(.*)");
    private static final Pattern PATH_PATTERN = Pattern.compile(".*(Installed as )(.*)");
    private AndroidDebugBridge mAdbBridge = null;

    AndroidDebugBridgeWrapper() {
    }

    @Override
    public IDevice[] getDevices() {
        if (this.mAdbBridge == null) {
            throw new IllegalStateException("getDevices called before init");
        }
        return this.mAdbBridge.getDevices();
    }

    @Override
    public void addDeviceChangeListener(AndroidDebugBridge.IDeviceChangeListener listener) {
        AndroidDebugBridge.addDeviceChangeListener(listener);
    }

    @Override
    public void removeDeviceChangeListener(AndroidDebugBridge.IDeviceChangeListener listener) {
        AndroidDebugBridge.removeDeviceChangeListener(listener);
    }

    @Override
    public void init(boolean clientSupport, String adbOsLocation) {
        AndroidDebugBridge.init(clientSupport);
        this.mAdbBridge = AndroidDebugBridge.createBridge(adbOsLocation, false);
    }

    @Override
    public String getAdbVersion(String adbOsLocation) {
        CommandResult res = this.getRunUtil().runTimedCmd((long)DdmPreferences.getTimeOut(), adbOsLocation, "version");
        if (CommandStatus.SUCCESS.equals((Object)res.getStatus())) {
            Matcher installPath;
            Matcher subVersion;
            StringBuilder version = new StringBuilder();
            Matcher m = VERSION_PATTERN.matcher(res.getStdout());
            if (!m.find()) {
                return null;
            }
            version.append(m.group(1));
            version.append(".");
            version.append(m.group(2));
            version.append(".");
            version.append(m.group(3));
            Matcher revision = REVISION_PATTERN.matcher(res.getStdout());
            if (revision.find()) {
                version.append("-");
                version.append(revision.group(2));
            }
            if ((subVersion = SUB_VERSION_PATTERN.matcher(res.getStdout())).find()) {
                version.append(" subVersion: ");
                version.append(subVersion.group(2));
            }
            if ((installPath = PATH_PATTERN.matcher(res.getStdout())).find()) {
                version.append(" install path: ");
                version.append(installPath.group(2));
            }
            return version.toString();
        }
        LogUtil.CLog.e("Failed to read adb version:\nstdout:%s\nstderr:%s", res.getStdout(), res.getStderr());
        return null;
    }

    @Override
    public void terminate() {
        AndroidDebugBridge.terminate();
    }

    @Override
    public void disconnectBridge() {
        AndroidDebugBridge.disconnectBridge();
    }

    IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }
}

