/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.device.TestDeviceState;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class BackgroundDeviceAction
extends Thread {
    public static final String BACKGROUND_DEVICE_ACTION = "BackgroundDeviceAction";
    private static final long ONLINE_POLL_INTERVAL_MS = 10000L;
    private IShellOutputReceiver mReceiver;
    private ITestDevice mTestDevice;
    private String mCommand;
    private String mDescriptor;
    private boolean mIsCancelled;
    private int mLogStartDelay;

    public BackgroundDeviceAction(String command, String descriptor, ITestDevice device, IShellOutputReceiver receiver, int startDelay) {
        super("BackgroundDeviceAction-" + command);
        this.mCommand = command;
        this.mDescriptor = descriptor;
        this.mTestDevice = device;
        this.mReceiver = receiver;
        this.mLogStartDelay = startDelay;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        String separator = String.format("\n========== beginning of new [%s] output ==========\n", this.mDescriptor);
        while (!this.isCancelled()) {
            try (CloseableTraceScope ignore = new CloseableTraceScope();){
                if (this.mLogStartDelay > 0) {
                    LogUtil.CLog.d("Sleep for %d before starting %s for %s.", this.mLogStartDelay, this.mDescriptor, this.mTestDevice.getSerialNumber());
                    this.getRunUtil().sleep(this.mLogStartDelay);
                }
                this.blockUntilOnlineNoThrow();
                if (this.isCancelled()) break;
                LogUtil.CLog.d("Starting %s for %s.", this.mDescriptor, this.mTestDevice.getSerialNumber());
                this.mReceiver.addOutput(separator.getBytes(), 0, separator.length());
                try {
                    this.mTestDevice.getIDevice().executeShellCommand(this.mCommand, this.mReceiver, 0L, TimeUnit.MILLISECONDS);
                }
                catch (AdbCommandRejectedException e) {
                    this.getRunUtil().sleep(10000L);
                    this.waitForDeviceRecovery(e.getClass().getName());
                }
                catch (ShellCommandUnresponsiveException | TimeoutException | IOException e) {
                    this.waitForDeviceRecovery(e.getClass().getName());
                }
            }
        }
    }

    protected void waitForDeviceRecovery(String exceptionType) {
        LogUtil.CLog.d("%s while running %s on %s. May see duplicated content in log.", exceptionType, this.mDescriptor, this.mTestDevice.getSerialNumber());
        this.blockUntilOnlineNoThrow();
    }

    public synchronized void cancel() {
        this.mIsCancelled = true;
        this.interrupt();
    }

    public synchronized boolean isCancelled() {
        return this.mIsCancelled;
    }

    IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }

    private void blockUntilOnlineNoThrow() {
        LogUtil.CLog.d("Waiting for device %s online before starting.", this.mTestDevice.getSerialNumber());
        while (!this.isCancelled()) {
            if (this.mTestDevice.getIDevice() instanceof StubDevice || !TestDeviceState.ONLINE.equals((Object)this.mTestDevice.getDeviceState())) {
                this.getRunUtil().sleep(10000L);
                continue;
            }
            LogUtil.CLog.d("Device %s now online.", this.mTestDevice.getSerialNumber());
            break;
        }
    }
}

