/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.tradefed.log.LogUtil;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BatteryTemperature {
    public Integer getBatteryTemperature(IDevice device) {
        DumpsysBatteryTemperatureReceiver receiver = new DumpsysBatteryTemperatureReceiver();
        try {
            device.executeShellCommand("dumpsys battery", receiver);
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException e) {
            return 0;
        }
        return receiver.getDeviceBatteryTemp();
    }

    class DumpsysBatteryTemperatureReceiver
    extends MultiLineReceiver {
        private static final int DUMPSYS_BATTERY_TEMP_SCALE = 10;
        private static final String BATTERY_REGEX = "temperature: ([0-9]+)";
        private int mDeviceBatteryTemp = 0;

        DumpsysBatteryTemperatureReceiver() {
        }

        public int getDeviceBatteryTemp() {
            return this.mDeviceBatteryTemp;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public void processNewLines(String[] lines) {
            for (String line : lines) {
                Pattern p = Pattern.compile(BATTERY_REGEX);
                Matcher m = p.matcher(line);
                if (!m.find()) continue;
                String tempString = m.group(1);
                try {
                    this.mDeviceBatteryTemp = Integer.parseInt(tempString);
                    this.mDeviceBatteryTemp /= 10;
                }
                catch (NumberFormatException e) {
                    LogUtil.CLog.w("Failed to parse battery temperature: %s", line);
                }
            }
        }
    }
}

