/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.tradefed.device.DeviceAllocationState;
import com.android.tradefed.device.DeviceEvent;

interface DeviceAllocationEventHandler {
    public DeviceAllocationState handleDeviceEvent(DeviceEvent var1);

    public static class IgnoredHandler
    implements DeviceAllocationEventHandler {
        @Override
        public DeviceAllocationState handleDeviceEvent(DeviceEvent event) {
            switch (event) {
                case DISCONNECTED: {
                    return DeviceAllocationState.Unknown;
                }
                case EXPLICIT_ALLOCATE_REQUEST: {
                    return DeviceAllocationState.Allocated;
                }
                case FORCE_ALLOCATE_REQUEST: {
                    return DeviceAllocationState.Allocated;
                }
            }
            return DeviceAllocationState.Ignored;
        }
    }

    public static class UnavailableHandler
    implements DeviceAllocationEventHandler {
        @Override
        public DeviceAllocationState handleDeviceEvent(DeviceEvent event) {
            switch (event) {
                case FORCE_ALLOCATE_REQUEST: {
                    return DeviceAllocationState.Allocated;
                }
                case DISCONNECTED: {
                    return DeviceAllocationState.Unknown;
                }
                case FORCE_AVAILABLE: {
                    return DeviceAllocationState.Available;
                }
            }
            return DeviceAllocationState.Unavailable;
        }
    }

    public static class AllocatedHandler
    implements DeviceAllocationEventHandler {
        @Override
        public DeviceAllocationState handleDeviceEvent(DeviceEvent event) {
            switch (event) {
                case FREE_UNAVAILABLE: {
                    return DeviceAllocationState.Unavailable;
                }
                case FREE_AVAILABLE: {
                    return DeviceAllocationState.Available;
                }
                case FREE_UNRESPONSIVE: {
                    return DeviceAllocationState.Available;
                }
                case FREE_UNKNOWN: {
                    return DeviceAllocationState.Unknown;
                }
            }
            return DeviceAllocationState.Allocated;
        }
    }

    public static class AvailableHandler
    implements DeviceAllocationEventHandler {
        @Override
        public DeviceAllocationState handleDeviceEvent(DeviceEvent event) {
            switch (event) {
                case FORCE_ALLOCATE_REQUEST: 
                case ALLOCATE_REQUEST: 
                case EXPLICIT_ALLOCATE_REQUEST: {
                    return DeviceAllocationState.Allocated;
                }
                case STATE_CHANGE_OFFLINE: {
                    return DeviceAllocationState.Unavailable;
                }
                case DISCONNECTED: {
                    return DeviceAllocationState.Unknown;
                }
            }
            return DeviceAllocationState.Available;
        }
    }

    public static class CheckingAvailHandler
    implements DeviceAllocationEventHandler {
        @Override
        public DeviceAllocationState handleDeviceEvent(DeviceEvent event) {
            switch (event) {
                case FORCE_ALLOCATE_REQUEST: {
                    return DeviceAllocationState.Allocated;
                }
                case AVAILABLE_CHECK_PASSED: {
                    return DeviceAllocationState.Available;
                }
                case AVAILABLE_CHECK_FAILED: {
                    return DeviceAllocationState.Unavailable;
                }
                case AVAILABLE_CHECK_IGNORED: {
                    return DeviceAllocationState.Ignored;
                }
                case FORCE_AVAILABLE: {
                    return DeviceAllocationState.Available;
                }
                case STATE_CHANGE_OFFLINE: {
                    return DeviceAllocationState.Unavailable;
                }
                case DISCONNECTED: {
                    return DeviceAllocationState.Unavailable;
                }
            }
            return DeviceAllocationState.Checking_Availability;
        }
    }

    public static class UnknownHandler
    implements DeviceAllocationEventHandler {
        @Override
        public DeviceAllocationState handleDeviceEvent(DeviceEvent event) {
            switch (event) {
                case FORCE_ALLOCATE_REQUEST: {
                    return DeviceAllocationState.Allocated;
                }
                case CONNECTED_ONLINE: {
                    return DeviceAllocationState.Checking_Availability;
                }
                case CONNECTED_OFFLINE: {
                    return DeviceAllocationState.Unavailable;
                }
                case STATE_CHANGE_ONLINE: {
                    return DeviceAllocationState.Checking_Availability;
                }
                case STATE_CHANGE_OFFLINE: {
                    return DeviceAllocationState.Unavailable;
                }
                case FORCE_AVAILABLE: {
                    return DeviceAllocationState.Available;
                }
                case FASTBOOT_DETECTED: {
                    return DeviceAllocationState.Available;
                }
            }
            return DeviceAllocationState.Unknown;
        }
    }
}

