/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.PropertyFetcher;
import com.android.tradefed.command.remote.DeviceDescriptor;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.config.IGlobalConfiguration;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.AndroidDebugBridgeWrapper;
import com.android.tradefed.device.DeviceAllocationState;
import com.android.tradefed.device.DeviceEvent;
import com.android.tradefed.device.DeviceMonitorMultiplexer;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.DeviceSelectionOptions;
import com.android.tradefed.device.DeviceStateMonitor;
import com.android.tradefed.device.FastbootHelper;
import com.android.tradefed.device.FreeDeviceState;
import com.android.tradefed.device.IAndroidDebugBridge;
import com.android.tradefed.device.IDeviceManager;
import com.android.tradefed.device.IDeviceMonitor;
import com.android.tradefed.device.IDeviceRecovery;
import com.android.tradefed.device.IDeviceSelection;
import com.android.tradefed.device.IDeviceStateMonitor;
import com.android.tradefed.device.IManagedTestDevice;
import com.android.tradefed.device.IManagedTestDeviceFactory;
import com.android.tradefed.device.IMultiDeviceRecovery;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.ManagedDeviceList;
import com.android.tradefed.device.ManagedTestDeviceFactory;
import com.android.tradefed.device.NullDevice;
import com.android.tradefed.device.RemoteAvdIDevice;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.device.StubLocalAndroidVirtualDevice;
import com.android.tradefed.device.TcpDevice;
import com.android.tradefed.device.TestDevice;
import com.android.tradefed.device.TestDeviceState;
import com.android.tradefed.device.WaitDeviceRecovery;
import com.android.tradefed.device.cloud.VmRemoteDevice;
import com.android.tradefed.host.IHostOptions;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.log.ILogRegistry;
import com.android.tradefed.log.LogRegistry;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.util.ArrayUtil;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.SizeLimitedOutputStream;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.TableFormatter;
import com.android.tradefed.util.ZipUtil2;
import com.android.tradefed.util.hostmetric.IHostMonitor;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

@OptionClass(alias="dmgr", global_namespace=false)
public class DeviceManager
implements IDeviceManager {
    public static final String UNKNOWN_DISPLAY_STRING = "unknown";
    private static final long FASTBOOT_CMD_TIMEOUT = 60000L;
    private static final long FASTBOOT_POLL_WAIT_TIME = 5000L;
    private static final int CHECK_WAIT_DEVICE_AVAIL_MS = 30000;
    private static final long MAX_EMULATOR_OUTPUT = 0x1400000L;
    private static final String EMULATOR_OUTPUT = "emulator_log";
    private static final long AVAILABLE_DEV_TIMEOUT_MAX_MS = 1000L;
    static final IDeviceSelection ANY_DEVICE_OPTIONS = new DeviceSelectionOptions();
    private static final String NULL_DEVICE_SERIAL_PREFIX = "null-device";
    private static final String EMULATOR_SERIAL_PREFIX = "emulator";
    private static final String TCP_DEVICE_SERIAL_PREFIX = "tcp-device";
    private static final String GCE_DEVICE_SERIAL_PREFIX = "gce-device";
    private static final String REMOTE_DEVICE_SERIAL_PREFIX = "remote-device";
    private static final String LOCAL_VIRTUAL_DEVICE_SERIAL_PREFIX = "local-virtual-device";
    private static final String DEVICE_LIST_PATTERN = ".*\n(%s)\\s+(device|offline|recovery).*";
    protected DeviceMonitorMultiplexer mDvcMon = new DeviceMonitorMultiplexer();
    private Boolean mDvcMonRunning = false;
    private boolean mIsInitialized = false;
    private ManagedDeviceList mManagedDeviceList;
    private IAndroidDebugBridge mAdbBridge;
    private ManagedDeviceListener mManagedDeviceListener;
    protected boolean mFastbootEnabled;
    private Set<IDeviceManager.IFastbootListener> mFastbootListeners;
    private FastbootMonitor mFastbootMonitor;
    private boolean mIsTerminated = false;
    private IDeviceSelection mGlobalDeviceFilter;
    private IDeviceSelection mDeviceSelectionOptions;
    @Option(name="max-emulators", description="the maximum number of emulators that can be allocated at one time")
    private int mNumEmulatorSupported = 1;
    @Option(name="max-null-devices", description="the maximum number of no device runs that can be allocated at one time.")
    private int mNumNullDevicesSupported = 7;
    @Option(name="max-tcp-devices", description="the maximum number of tcp devices that can be allocated at one time")
    private int mNumTcpDevicesSupported = 1;
    @Option(name="max-gce-devices", description="the maximum number of remote gce devices that can be allocated at one time")
    private int mNumGceDevicesSupported = 1;
    @Option(name="max-remote-devices", description="the maximum number of remote devices that can be allocated at one time")
    private int mNumRemoteDevicesSupported = 1;
    @Option(name="max-local-virtual-devices", description="the maximum number of local virtual devices that can be allocated at one time")
    private int mNumLocalVirtualDevicesSupported = 0;
    private boolean mSynchronousMode = false;
    @Option(name="device-recovery-interval", description="the interval in ms between attempts to recover unavailable devices.", isTimeVal=true)
    private long mDeviceRecoveryInterval = 1800000L;
    @Option(name="adb-path", description="path of the adb binary to use, default use the one in $PATH.")
    private String mAdbPath = "adb";
    @Option(name="fastboot-path", description="path of the fastboot binary to use, default use the one in $PATH.")
    private File mFastbootFile = new File("fastboot");
    @Option(name="enabled-filesystem-check", description="Whether or not to check the file system type as part of device storage readiness")
    private boolean mMountFileSystemCheckEnabled = true;
    private File mUnpackedFastbootDir = null;
    private File mUnpackedFastboot = null;
    private DeviceRecoverer mDeviceRecoverer;
    private List<IHostMonitor> mGlobalHostMonitors = null;
    private CountDownLatch mFirstDeviceAdded = new CountDownLatch(1);
    private boolean mAdbBridgeNeedRestart = false;
    private Map<String, String> mMonitoringTcpFastbootDevices = new HashMap<String, String>();

    @Override
    public void init() {
        this.init(null, null);
    }

    @Override
    public void init(IDeviceSelection globalDeviceFilter, List<IDeviceMonitor> globalDeviceMonitors) {
        this.init(globalDeviceFilter, globalDeviceMonitors, new ManagedTestDeviceFactory(this.mFastbootEnabled, this, this.mDvcMon));
    }

    public synchronized void init(IDeviceSelection globalDeviceFilter, List<IDeviceMonitor> globalDeviceMonitors, IManagedTestDeviceFactory deviceFactory) {
        FastbootHelper fastboot;
        if (this.mIsInitialized) {
            throw new IllegalStateException("already initialized");
        }
        if (globalDeviceFilter == null) {
            globalDeviceFilter = this.getGlobalConfig().getDeviceRequirements();
        }
        if (globalDeviceMonitors == null) {
            globalDeviceMonitors = this.getGlobalConfig().getDeviceMonitors();
        }
        this.mGlobalHostMonitors = this.getGlobalConfig().getHostMonitors();
        if (this.mGlobalHostMonitors != null) {
            for (IHostMonitor hm : this.mGlobalHostMonitors) {
                hm.start();
            }
        }
        this.mIsInitialized = true;
        this.mGlobalDeviceFilter = globalDeviceFilter;
        if (globalDeviceMonitors != null) {
            this.mDvcMon.addMonitors(globalDeviceMonitors);
        }
        this.mManagedDeviceList = new ManagedDeviceList(deviceFactory);
        if (".zip".equals(FileUtil.getExtension(this.mFastbootFile.getName()))) {
            try {
                this.mUnpackedFastbootDir = ZipUtil2.extractZipToTemp(this.mFastbootFile, "unpacked-fastboot");
                this.mUnpackedFastboot = FileUtil.findFile(this.mUnpackedFastbootDir, "fastboot");
            }
            catch (IOException e) {
                LogUtil.CLog.e("Failed to unpacked zipped fastboot.");
                LogUtil.CLog.e(e);
                FileUtil.recursiveDelete(this.mUnpackedFastbootDir);
                this.mUnpackedFastbootDir = null;
            }
        }
        if ((fastboot = new FastbootHelper(this.getRunUtil(), this.getFastbootPath())).isFastbootAvailable()) {
            this.mFastbootListeners = Collections.synchronizedSet(new HashSet());
            this.mFastbootMonitor = new FastbootMonitor();
            this.startFastbootMonitor();
            this.mFastbootEnabled = true;
            deviceFactory.setFastbootEnabled(this.mFastbootEnabled);
            LogUtil.CLog.d("Using Fastboot from: '%s'", this.getFastbootPath());
        } else {
            LogUtil.CLog.w("Fastboot is not available.");
            this.mFastbootListeners = null;
            this.mFastbootMonitor = null;
            this.mFastbootEnabled = false;
            deviceFactory.setFastbootEnabled(this.mFastbootEnabled);
        }
        try (CloseableTraceScope ignored = new CloseableTraceScope("startAdbBridgeAndDependentServices");){
            this.startAdbBridgeAndDependentServices();
        }
        PropertyFetcher.enableCachingMutableProps(false);
    }

    private synchronized void startAdbBridgeAndDependentServices() {
        DdmPreferences.setTimeOut(120000);
        this.mAdbBridge = this.createAdbBridge();
        this.mManagedDeviceListener = new ManagedDeviceListener();
        this.mAdbBridge.addDeviceChangeListener(this.mManagedDeviceListener);
        if (this.mDvcMon != null && !this.mDvcMonRunning.booleanValue()) {
            this.mDvcMon.setDeviceLister(new IDeviceMonitor.DeviceLister(){

                @Override
                public List<DeviceDescriptor> listDevices() {
                    return DeviceManager.this.listAllDevices();
                }

                @Override
                public DeviceDescriptor getDeviceDescriptor(String serial) {
                    return DeviceManager.this.getDeviceDescriptor(serial);
                }
            });
            this.mDvcMon.run();
            this.mDvcMonRunning = true;
        }
        this.mAdbBridge.init(false, this.mAdbPath);
        try (CloseableTraceScope add = new CloseableTraceScope("add_devices");){
            this.addEmulators();
            this.addNullDevices();
            this.addTcpDevices();
            this.addGceDevices();
            this.addRemoteDevices();
            this.addLocalVirtualDevices();
            this.addNetworkDevices();
        }
        List<IMultiDeviceRecovery> recoverers = this.getGlobalConfig().getMultiDeviceRecoveryHandlers();
        if (recoverers != null && !recoverers.isEmpty()) {
            for (IMultiDeviceRecovery recoverer : recoverers) {
                recoverer.setFastbootPath(this.getFastbootPath());
            }
            this.mDeviceRecoverer = new DeviceRecoverer(recoverers);
            this.startDeviceRecoverer();
        } else {
            LogUtil.CLog.d("No IMultiDeviceRecovery configured.");
        }
    }

    @VisibleForTesting
    boolean shouldAdbBridgeBeRestarted() {
        return this.mAdbBridgeNeedRestart;
    }

    @Override
    public synchronized void restartAdbBridge() {
        if (this.mAdbBridgeNeedRestart) {
            this.mAdbBridgeNeedRestart = false;
            this.startAdbBridgeAndDependentServices();
        }
    }

    void setSynchronousMode(boolean syncMode) {
        this.mSynchronousMode = syncMode;
    }

    private void checkInit() {
        if (!this.mIsInitialized) {
            throw new IllegalStateException("DeviceManager has not been initialized");
        }
    }

    void startFastbootMonitor() {
        this.mFastbootMonitor.start();
    }

    void startDeviceRecoverer() {
        this.mDeviceRecoverer.start();
    }

    IGlobalConfiguration getGlobalConfig() {
        return GlobalConfiguration.getInstance();
    }

    IHostOptions getHostOptions() {
        return this.getGlobalConfig().getHostOptions();
    }

    IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }

    IRunUtil createRunUtil() {
        return new RunUtil();
    }

    private void checkAndAddAvailableDevice(final IManagedTestDevice testDevice) {
        if (this.mGlobalDeviceFilter != null && !this.mGlobalDeviceFilter.matches(testDevice.getIDevice())) {
            LogUtil.CLog.logAndDisplay(Log.LogLevel.INFO, "device %s doesn't match global filter, ignoring", testDevice.getSerialNumber());
            this.mManagedDeviceList.handleDeviceEvent(testDevice, DeviceEvent.AVAILABLE_CHECK_IGNORED);
            return;
        }
        String threadName = String.format("Check device %s", testDevice.getSerialNumber());
        Runnable checkRunnable = new Runnable(){

            @Override
            public void run() {
                LogUtil.CLog.d("checking new '%s' '%s' responsiveness", testDevice.getClass().getName(), testDevice.getSerialNumber());
                if (testDevice.getMonitor().waitForDeviceShell(30000L)) {
                    IManagedTestDevice.DeviceEventResponse r = DeviceManager.this.mManagedDeviceList.handleDeviceEvent(testDevice, DeviceEvent.AVAILABLE_CHECK_PASSED);
                    if (r.stateChanged && r.allocationState == DeviceAllocationState.Available) {
                        LogUtil.CLog.logAndDisplay(Log.LogLevel.INFO, "Detected new device %s", testDevice.getSerialNumber());
                    } else {
                        LogUtil.CLog.d("Device %s failed or ignored responsiveness check, ", testDevice.getSerialNumber());
                    }
                } else {
                    IManagedTestDevice.DeviceEventResponse r = DeviceManager.this.mManagedDeviceList.handleDeviceEvent(testDevice, DeviceEvent.AVAILABLE_CHECK_FAILED);
                    if (r.stateChanged && r.allocationState == DeviceAllocationState.Unavailable) {
                        LogUtil.CLog.w("Device %s is unresponsive, will not be available for testing", testDevice.getSerialNumber());
                    }
                }
            }
        };
        if (this.mSynchronousMode) {
            checkRunnable.run();
        } else {
            Thread checkThread = new Thread(checkRunnable, threadName);
            checkThread.setName("DeviceManager-checkRunnable");
            checkThread.setDaemon(true);
            checkThread.start();
        }
    }

    private void addNullDevices() {
        for (int i = 0; i < this.mNumNullDevicesSupported; ++i) {
            this.addAvailableDevice(new NullDevice(String.format("%s-%d", NULL_DEVICE_SERIAL_PREFIX, i)));
        }
    }

    private void addEmulators() {
        int port = 5586;
        for (int i = 0; i < this.mNumEmulatorSupported; ++i) {
            this.addAvailableDevice(new EmulatorDevice(port));
            port += 2;
        }
    }

    private void addTcpDevices() {
        for (int i = 0; i < this.mNumTcpDevicesSupported; ++i) {
            this.addAvailableDevice(new TcpDevice(String.format("%s-%d", TCP_DEVICE_SERIAL_PREFIX, i)));
        }
    }

    private void addGceDevices() {
        for (int i = 0; i < this.mNumGceDevicesSupported; ++i) {
            this.addAvailableDevice(new RemoteAvdIDevice(String.format("%s-%d", GCE_DEVICE_SERIAL_PREFIX, i)));
        }
    }

    private void addRemoteDevices() {
        for (int i = 0; i < this.mNumRemoteDevicesSupported; ++i) {
            this.addAvailableDevice(new VmRemoteDevice(String.format("%s-%s", REMOTE_DEVICE_SERIAL_PREFIX, i)));
        }
    }

    private void addNetworkDevices() {
        for (String ip : this.getGlobalConfig().getHostOptions().getKnownTcpDeviceIpPool()) {
            this.addAvailableDevice(new TcpDevice(String.format("%s-%s", TCP_DEVICE_SERIAL_PREFIX, ip), ip));
        }
        for (String ip : this.getGlobalConfig().getHostOptions().getKnownGceDeviceIpPool()) {
            this.addAvailableDevice(new RemoteAvdIDevice(String.format("%s-%s", GCE_DEVICE_SERIAL_PREFIX, ip), ip));
        }
        HashMap preconfigureHostUsers = new HashMap();
        for (String string : this.getGlobalConfig().getHostOptions().getKnownPreconfigureVirtualDevicePool()) {
            String[] parts = string.split(":", 2);
            preconfigureHostUsers.putIfAbsent(parts[0], new ArrayList());
            ((List)preconfigureHostUsers.get(parts[0])).add(parts.length > 1 ? parts[1] : null);
        }
        for (Map.Entry entry : preconfigureHostUsers.entrySet()) {
            for (int i = 0; i < ((List)entry.getValue()).size(); ++i) {
                String user = (String)((List)entry.getValue()).get(i);
                String serial = String.format("%s-%s-%d", GCE_DEVICE_SERIAL_PREFIX, entry.getKey(), i);
                if (user != null) {
                    serial = serial + "-" + user;
                }
                this.addAvailableDevice(new RemoteAvdIDevice(serial, (String)entry.getKey(), user, i));
            }
        }
        for (String string : this.getGlobalConfig().getHostOptions().getKnownRemoteDeviceIpPool()) {
            this.addAvailableDevice(new VmRemoteDevice(String.format("%s-%s", REMOTE_DEVICE_SERIAL_PREFIX, string), string));
        }
    }

    private void addLocalVirtualDevices() {
        for (int i = 0; i < this.mNumLocalVirtualDevicesSupported; ++i) {
            this.addAvailableDevice(new StubLocalAndroidVirtualDevice(String.format("%s-%s", LOCAL_VIRTUAL_DEVICE_SERIAL_PREFIX, i), i));
        }
    }

    public void addFastbootDevice(FastbootDevice fastbootDevice) {
        IManagedTestDevice d = this.mManagedDeviceList.findOrCreateFastboot(fastbootDevice);
        if (d != null) {
            this.mManagedDeviceList.handleDeviceEvent(d, DeviceEvent.FASTBOOT_DETECTED);
        } else {
            LogUtil.CLog.e("Could not create stub device");
        }
    }

    public void addAvailableDevice(IDevice stubDevice) {
        IManagedTestDevice d = this.mManagedDeviceList.findOrCreate(stubDevice);
        if (d != null) {
            this.mManagedDeviceList.handleDeviceEvent(d, DeviceEvent.FORCE_AVAILABLE);
        } else {
            LogUtil.CLog.e("Could not create stub device");
        }
    }

    IDeviceStateMonitor createStateMonitor(IDevice device) {
        return new DeviceStateMonitor(this, device, this.mFastbootEnabled);
    }

    @Override
    public ITestDevice allocateDevice() {
        return this.allocateDevice(ANY_DEVICE_OPTIONS, false);
    }

    @Override
    public ITestDevice allocateDevice(IDeviceSelection options) {
        return this.allocateDevice(options, false);
    }

    @Override
    public ITestDevice allocateDevice(IDeviceSelection options, boolean isTemporary) {
        this.checkInit();
        if (isTemporary) {
            String rand = UUID.randomUUID().toString();
            String serial = String.format("%s%s", "null-device-temp-", rand);
            this.addAvailableDevice(new NullDevice(serial, true));
            options.setSerial(serial);
        }
        return this.mManagedDeviceList.allocate(options);
    }

    @Override
    public ITestDevice forceAllocateDevice(String serial) {
        this.checkInit();
        IManagedTestDevice d = this.mManagedDeviceList.forceAllocate(serial);
        if (d != null) {
            IManagedTestDevice.DeviceEventResponse r = d.handleAllocationEvent(DeviceEvent.FORCE_ALLOCATE_REQUEST);
            if (r.stateChanged && r.allocationState == DeviceAllocationState.Allocated) {
                d.getMonitor().waitForDeviceBootloaderStateUpdate();
                return d;
            }
        }
        return null;
    }

    synchronized IAndroidDebugBridge createAdbBridge() {
        return new AndroidDebugBridgeWrapper();
    }

    @Override
    public void freeDevice(ITestDevice device, FreeDeviceState deviceState) {
        IManagedTestDevice.DeviceEventResponse r;
        NullDevice nullDevice;
        this.checkInit();
        IManagedTestDevice managedDevice = (IManagedTestDevice)device;
        managedDevice.setFastbootPath(this.getFastbootPath());
        managedDevice.stopLogcat();
        IDevice ideviceToReturn = device.getIDevice();
        if (ideviceToReturn instanceof NullDevice && (nullDevice = (NullDevice)ideviceToReturn).isTemporary()) {
            IManagedTestDevice.DeviceEventResponse r2 = this.mManagedDeviceList.handleDeviceEvent(managedDevice, DeviceEvent.FREE_UNKNOWN);
            LogUtil.CLog.d("Temporary device '%s' final allocation state: '%s'", device.getSerialNumber(), r2.allocationState.toString());
            return;
        }
        if (ideviceToReturn.isEmulator() && managedDevice.getEmulatorProcess() != null) {
            try {
                this.killEmulator(device);
                device.stopEmulatorOutput();
                ideviceToReturn = device.getIDevice();
                deviceState = FreeDeviceState.AVAILABLE;
            }
            catch (DeviceNotAvailableException e) {
                LogUtil.CLog.e(e);
                deviceState = FreeDeviceState.UNAVAILABLE;
            }
        }
        if (ideviceToReturn instanceof TcpDevice || ideviceToReturn instanceof VmRemoteDevice || ideviceToReturn instanceof StubLocalAndroidVirtualDevice) {
            managedDevice.setDeviceState(TestDeviceState.NOT_AVAILABLE);
        }
        if ((r = this.mManagedDeviceList.handleDeviceEvent(managedDevice, this.getEventFromFree(managedDevice, deviceState))) != null && !r.stateChanged) {
            LogUtil.CLog.e("Device %s was in unexpected state %s when freeing", device.getSerialNumber(), r.allocationState.toString());
        }
    }

    private DeviceEvent getEventFromFree(IManagedTestDevice managedDevice, FreeDeviceState deviceState) {
        switch (deviceState) {
            case UNRESPONSIVE: {
                return DeviceEvent.FREE_UNRESPONSIVE;
            }
            case AVAILABLE: {
                return DeviceEvent.FREE_AVAILABLE;
            }
            case UNAVAILABLE: {
                if (TestDeviceState.NOT_AVAILABLE.equals((Object)managedDevice.getDeviceState())) {
                    String devices = this.executeGlobalAdbCommand("devices");
                    Pattern p = Pattern.compile(String.format(DEVICE_LIST_PATTERN, managedDevice.getSerialNumber()));
                    if (devices == null || !p.matcher(devices).find()) {
                        return DeviceEvent.FREE_UNKNOWN;
                    }
                }
                return DeviceEvent.FREE_UNAVAILABLE;
            }
            case IGNORE: {
                return DeviceEvent.FREE_UNKNOWN;
            }
        }
        throw new IllegalStateException("unknown FreeDeviceState");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CommandResult executeCmdOnAvailableDevice(String serial, String command, long timeout, TimeUnit timeUnit) {
        if (timeUnit.toMillis(timeout) > 1000L) {
            CommandResult result = new CommandResult(CommandStatus.FAILED);
            result.setStderr("The maximum timeout value is 1000 ms, but got " + timeUnit.toMillis(timeout) + " ms.");
            return result;
        }
        IManagedTestDevice device = this.mManagedDeviceList.find(serial);
        if (device == null) {
            CommandResult result = new CommandResult(CommandStatus.FAILED);
            result.setStderr("Can not find the device with serial " + serial);
            return result;
        }
        IManagedTestDevice iManagedTestDevice = device;
        synchronized (iManagedTestDevice) {
            if (!device.getAllocationState().equals(DeviceAllocationState.Available)) {
                CommandResult result = new CommandResult(CommandStatus.FAILED);
                result.setStderr(String.format("The device '%s' is not available to execute the command", serial));
                return result;
            }
            if (!TestDeviceState.ONLINE.equals((Object)device.getDeviceState())) {
                CommandResult result = new CommandResult(CommandStatus.FAILED);
                result.setStderr(String.format("The device '%s' is not online to execute the command", serial));
                return result;
            }
            try {
                return device.executeShellV2Command(command, timeout, timeUnit);
            }
            catch (DeviceNotAvailableException e) {
                CommandResult result = new CommandResult(CommandStatus.FAILED);
                result.setStderr(e.getMessage());
                return result;
            }
        }
    }

    @Override
    public void launchEmulator(ITestDevice device, long bootTimeout, IRunUtil runUtil, List<String> emulatorArgs) throws DeviceNotAvailableException {
        if (!(device.getIDevice() instanceof EmulatorDevice)) {
            throw new IllegalStateException(String.format("Device %s is not stub emulator device", device.getSerialNumber()));
        }
        if (!device.getDeviceState().equals((Object)TestDeviceState.NOT_AVAILABLE)) {
            throw new IllegalStateException(String.format("Emulator device %s is in state %s. Expected: %s", new Object[]{device.getSerialNumber(), device.getDeviceState(), TestDeviceState.NOT_AVAILABLE}));
        }
        ArrayList<String> fullArgs = new ArrayList<String>(emulatorArgs);
        EmulatorDevice emulatorDevice = (EmulatorDevice)device.getIDevice();
        fullArgs.add("-port");
        fullArgs.add(Integer.toString(emulatorDevice.mPort));
        try {
            LogUtil.CLog.i("launching emulator with %s", ((Object)fullArgs).toString());
            SizeLimitedOutputStream emulatorOutput = new SizeLimitedOutputStream(0x1400000L, EMULATOR_OUTPUT, ".txt");
            Process p = runUtil.runCmdInBackground(fullArgs, emulatorOutput);
            this.getRunUtil().sleep(500L);
            this.assertEmulatorProcessAlive(p, device);
            TestDevice testDevice = (TestDevice)device;
            testDevice.setEmulatorProcess(p);
            testDevice.setEmulatorOutputStream(emulatorOutput);
        }
        catch (IOException e) {
            throw new DeviceNotAvailableException("Failed to start emulator process", (Throwable)e, device.getSerialNumber());
        }
        device.waitForDeviceAvailable(bootTimeout);
    }

    private void assertEmulatorProcessAlive(Process p, ITestDevice device) throws DeviceNotAvailableException {
        if (!p.isAlive()) {
            try {
                LogUtil.CLog.e("Emulator process has died . stdout: '%s', stderr: '%s'", StreamUtil.getStringFromStream(p.getInputStream()), StreamUtil.getStringFromStream(p.getErrorStream()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new DeviceNotAvailableException("emulator died after launch", device.getSerialNumber());
        }
    }

    @Override
    public void killEmulator(ITestDevice device) throws DeviceNotAvailableException {
        try {
            device.executeAdbCommand("emu", "kill");
            device.waitForDeviceNotAvailable(10000L);
            Process emulatorProcess = ((IManagedTestDevice)device).getEmulatorProcess();
            if (emulatorProcess != null) {
                emulatorProcess.destroy();
                if (emulatorProcess.isAlive()) {
                    LogUtil.CLog.w("Emulator process still running after destroy for %s", device.getSerialNumber());
                    this.forceKillProcess(emulatorProcess, device.getSerialNumber());
                }
            }
            if (!device.waitForDeviceNotAvailable(20000L)) {
                throw new DeviceNotAvailableException(String.format("Failed to kill emulator %s", device.getSerialNumber()), device.getSerialNumber());
            }
        }
        finally {
            ((IManagedTestDevice)device).setIDevice(new EmulatorDevice(device.getSerialNumber()));
        }
    }

    private void forceKillProcess(Process emulatorProcess, String emulatorSerial) {
        if (emulatorProcess.getClass().getName().equals("java.lang.UNIXProcess")) {
            try {
                LogUtil.CLog.i("Attempting to force kill emulator process for %s", emulatorSerial);
                Field f = emulatorProcess.getClass().getDeclaredField("pid");
                f.setAccessible(true);
                Integer pid = (Integer)f.get(emulatorProcess);
                if (pid != null) {
                    RunUtil.getDefault().runTimedCmd(5000L, "kill", "-9", pid.toString());
                }
            }
            catch (NoSuchFieldException e) {
                LogUtil.CLog.d("got NoSuchFieldException when attempting to read process pid");
            }
            catch (IllegalAccessException e) {
                LogUtil.CLog.d("got IllegalAccessException when attempting to read process pid");
            }
        }
    }

    @Override
    public ITestDevice connectToTcpDevice(String ipAndPort) {
        IManagedTestDevice tcpDevice = this.mManagedDeviceList.findOrCreate(new StubDevice(ipAndPort));
        if (tcpDevice == null) {
            return null;
        }
        IManagedTestDevice.DeviceEventResponse r = tcpDevice.handleAllocationEvent(DeviceEvent.FORCE_ALLOCATE_REQUEST);
        if (!r.stateChanged || r.allocationState != DeviceAllocationState.Allocated) {
            return null;
        }
        tcpDevice.getMonitor().waitForDeviceBootloaderStateUpdate();
        if (this.doAdbConnect(ipAndPort)) {
            try {
                tcpDevice.setRecovery(new WaitDeviceRecovery());
                tcpDevice.waitForDeviceOnline();
                return tcpDevice;
            }
            catch (DeviceNotAvailableException e) {
                LogUtil.CLog.w("Device with tcp serial %s did not come online", ipAndPort);
            }
        }
        this.freeDevice(tcpDevice, FreeDeviceState.IGNORE);
        return null;
    }

    @Override
    public ITestDevice reconnectDeviceToTcp(ITestDevice usbDevice) throws DeviceNotAvailableException {
        LogUtil.CLog.i("Reconnecting device %s to adb over tcpip", usbDevice.getSerialNumber());
        ITestDevice tcpDevice = null;
        if (usbDevice instanceof IManagedTestDevice) {
            IManagedTestDevice managedUsbDevice = (IManagedTestDevice)usbDevice;
            String ipAndPort = managedUsbDevice.switchToAdbTcp();
            if (ipAndPort != null) {
                LogUtil.CLog.d("Device %s was switched to adb tcp on %s", usbDevice.getSerialNumber(), ipAndPort);
                tcpDevice = this.connectToTcpDevice(ipAndPort);
                if (tcpDevice == null) {
                    managedUsbDevice.recoverDevice();
                }
            }
        } else {
            LogUtil.CLog.e("reconnectDeviceToTcp: unrecognized device type.");
        }
        return tcpDevice;
    }

    @Override
    public boolean disconnectFromTcpDevice(ITestDevice tcpDevice) {
        LogUtil.CLog.i("Disconnecting and freeing tcp device %s", tcpDevice.getSerialNumber());
        boolean result = false;
        try {
            result = tcpDevice.switchToAdbUsb();
        }
        catch (DeviceNotAvailableException e) {
            LogUtil.CLog.w("Failed to switch device %s to usb mode: %s", tcpDevice.getSerialNumber(), e.getMessage());
        }
        this.freeDevice(tcpDevice, FreeDeviceState.IGNORE);
        return result;
    }

    private boolean doAdbConnect(String ipAndPort) {
        String resultSuccess = String.format("connected to %s", ipAndPort);
        for (int i = 1; i <= 3; ++i) {
            String adbConnectResult = this.executeGlobalAdbCommand("connect", ipAndPort);
            if (adbConnectResult != null && adbConnectResult.startsWith(resultSuccess)) {
                return true;
            }
            LogUtil.CLog.w("Failed to connect to device on %s, attempt %d of 3. Response: %s.", ipAndPort, i, adbConnectResult);
            this.getRunUtil().sleep(5000L);
        }
        return false;
    }

    public String executeGlobalAdbCommand(String ... cmdArgs) {
        String[] fullCmd = ArrayUtil.buildArray({this.getAdbPath()}, cmdArgs);
        CommandResult result = this.getRunUtil().runTimedCmd(60000L, fullCmd);
        if (CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
            return result.getStdout();
        }
        LogUtil.CLog.w("adb %s failed", cmdArgs[0]);
        return null;
    }

    @Override
    public synchronized void terminate() {
        this.checkInit();
        if (!this.mIsTerminated) {
            this.mIsTerminated = true;
            this.stopAdbBridgeAndDependentServices();
            if (this.mGlobalHostMonitors != null) {
                for (IHostMonitor hm : this.mGlobalHostMonitors) {
                    hm.terminate();
                }
            }
        }
        FileUtil.recursiveDelete(this.mUnpackedFastbootDir);
    }

    private synchronized void stopAdbBridgeAndDependentServices() {
        this.terminateDeviceRecovery();
        this.mAdbBridge.removeDeviceChangeListener(this.mManagedDeviceListener);
        this.mAdbBridge.terminate();
    }

    @Override
    public synchronized void stopAdbBridge() {
        this.stopAdbBridgeAndDependentServices();
        this.mAdbBridgeNeedRestart = true;
    }

    @Override
    public synchronized void terminateDeviceRecovery() {
        if (this.mDeviceRecoverer != null) {
            this.mDeviceRecoverer.terminate();
        }
    }

    @Override
    public synchronized void terminateDeviceMonitor() {
        this.mDvcMon.stop();
        this.mDvcMonRunning = false;
    }

    @Override
    public synchronized void terminateHard() {
        this.terminateHard("No reason given.");
    }

    @Override
    public void terminateHard(String reason) {
        this.checkInit();
        if (!this.mIsTerminated) {
            for (IManagedTestDevice device : this.mManagedDeviceList) {
                device.setRecovery(new AbortRecovery(reason));
            }
            this.mAdbBridge.disconnectBridge();
            this.terminate();
        }
    }

    @Override
    public List<DeviceDescriptor> listAllDevices(boolean shortDescriptor) {
        ArrayList<DeviceDescriptor> serialStates = new ArrayList<DeviceDescriptor>();
        if (this.mAdbBridgeNeedRestart) {
            return serialStates;
        }
        for (IManagedTestDevice d : this.mManagedDeviceList) {
            DeviceDescriptor desc;
            if (d == null || (desc = d.getCachedDeviceDescriptor(shortDescriptor)) == null) continue;
            serialStates.add(desc);
        }
        return serialStates;
    }

    @Override
    public List<DeviceDescriptor> listAllDevices() {
        return this.listAllDevices(false);
    }

    @Override
    public DeviceDescriptor getDeviceDescriptor(String serial) {
        IManagedTestDevice device = this.mManagedDeviceList.find(serial);
        if (device == null) {
            return null;
        }
        return device.getDeviceDescriptor(false);
    }

    @Override
    public void displayDevicesInfo(PrintWriter stream, boolean includeStub) {
        ArrayList<List<String>> displayRows = new ArrayList<List<String>>();
        ArrayList<String> headers = new ArrayList<String>(Arrays.asList("Serial", "State", "Allocation", "Product", "Variant", "Build", "Battery"));
        if (includeStub) {
            headers.add("class");
            headers.add("TestDeviceState");
        }
        displayRows.add(headers);
        List<DeviceDescriptor> deviceList = this.listAllDevices();
        DeviceManager.sortDeviceList(deviceList);
        this.addDevicesInfo(displayRows, deviceList, includeStub);
        new TableFormatter().displayTable(displayRows, stream);
    }

    @VisibleForTesting
    static List<DeviceDescriptor> sortDeviceList(List<DeviceDescriptor> deviceList) {
        Comparator<DeviceDescriptor> c = new Comparator<DeviceDescriptor>(){

            @Override
            public int compare(DeviceDescriptor o1, DeviceDescriptor o2) {
                if (o1.getState() != o2.getState()) {
                    return o1.getState().toString().compareTo(o2.getState().toString());
                }
                return o1.getSerial().compareTo(o2.getSerial());
            }
        };
        Collections.sort(deviceList, c);
        return deviceList;
    }

    IDeviceSelection getDeviceSelectionOptions() {
        if (this.mDeviceSelectionOptions == null) {
            this.mDeviceSelectionOptions = new DeviceSelectionOptions();
        }
        return this.mDeviceSelectionOptions;
    }

    private void addDevicesInfo(List<List<String>> displayRows, List<DeviceDescriptor> sortedDeviceList, boolean includeStub) {
        for (DeviceDescriptor desc : sortedDeviceList) {
            if (!includeStub && desc.isStubDevice() && desc.getState() != DeviceAllocationState.Allocated) continue;
            String serial = desc.getSerial();
            if (desc.getDisplaySerial() != null) {
                serial = desc.getDisplaySerial();
            }
            ArrayList<String> infos = new ArrayList<String>(Arrays.asList(serial, desc.getDeviceState().toString(), desc.getState().toString(), desc.getProduct(), desc.getProductVariant(), desc.getBuildId(), desc.getBatteryLevel()));
            if (includeStub) {
                infos.add(desc.getDeviceClass());
                infos.add(desc.getTestDeviceState().toString());
            }
            displayRows.add(infos);
        }
    }

    @VisibleForTesting
    void logDeviceEvent(ILogRegistry.EventType event, String serial) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("serial", serial);
        LogRegistry.getLogRegistry().logEvent(Log.LogLevel.DEBUG, event, args);
    }

    @Override
    public boolean waitForFirstDeviceAdded(long timeout) {
        try {
            return this.mFirstDeviceAdded.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addFastbootListener(IDeviceManager.IFastbootListener listener) {
        this.checkInit();
        if (!this.mFastbootEnabled) {
            throw new UnsupportedOperationException("fastboot is not enabled");
        }
        this.mFastbootListeners.add(listener);
    }

    @Override
    public void removeFastbootListener(IDeviceManager.IFastbootListener listener) {
        this.checkInit();
        if (this.mFastbootEnabled) {
            this.mFastbootListeners.remove(listener);
        }
    }

    @VisibleForTesting
    List<IManagedTestDevice> getDeviceList() {
        return this.mManagedDeviceList.getCopy();
    }

    @VisibleForTesting
    void setMaxEmulators(int numEmulators) {
        this.mNumEmulatorSupported = numEmulators;
    }

    @VisibleForTesting
    void setMaxNullDevices(int nullDevices) {
        this.mNumNullDevicesSupported = nullDevices;
    }

    @VisibleForTesting
    void setMaxTcpDevices(int tcpDevices) {
        this.mNumTcpDevicesSupported = tcpDevices;
    }

    @VisibleForTesting
    void setMaxGceDevices(int gceDevices) {
        this.mNumGceDevicesSupported = gceDevices;
    }

    @VisibleForTesting
    void setMaxRemoteDevices(int remoteDevices) {
        this.mNumRemoteDevicesSupported = remoteDevices;
    }

    @Override
    public boolean isNullDevice(String serial) {
        return serial.startsWith(NULL_DEVICE_SERIAL_PREFIX);
    }

    @Override
    public boolean isEmulator(String serial) {
        return serial.startsWith(EMULATOR_SERIAL_PREFIX);
    }

    @Override
    public void addDeviceMonitor(IDeviceMonitor mon) {
        this.mDvcMon.addMonitor(mon);
    }

    @Override
    public void removeDeviceMonitor(IDeviceMonitor mon) {
        this.mDvcMon.removeMonitor(mon);
    }

    @Override
    public String getAdbPath() {
        return this.mAdbPath;
    }

    @Override
    public String getFastbootPath() {
        if (this.mUnpackedFastboot != null) {
            return this.mUnpackedFastboot.getAbsolutePath();
        }
        if (new File("fastboot").equals(this.mFastbootFile)) {
            return "fastboot";
        }
        return this.mFastbootFile.getAbsolutePath();
    }

    @Override
    public String getAdbVersion() {
        return this.mAdbBridge.getAdbVersion(this.mAdbPath);
    }

    @Override
    public void addMonitoringTcpFastbootDevice(String serial, String fastboot_serial) {
        this.mMonitoringTcpFastbootDevices.put(serial, fastboot_serial);
    }

    @Override
    public boolean isFileSystemMountCheckEnabled() {
        return this.mMountFileSystemCheckEnabled;
    }

    private class FastbootMonitor
    extends Thread {
        private boolean mQuit;

        FastbootMonitor() {
            super("FastbootMonitor");
            this.mQuit = false;
            this.setDaemon(true);
        }

        @Override
        public void interrupt() {
            this.mQuit = true;
            super.interrupt();
        }

        @Override
        public void run() {
            FastbootHelper fastboot = new FastbootHelper(DeviceManager.this.getRunUtil(), DeviceManager.this.getFastbootPath());
            while (!this.mQuit) {
                Map<String, Boolean> serialAndMode = fastboot.getBootloaderAndFastbootdDevices();
                serialAndMode.putAll(fastboot.getBootloaderAndFastbootdTcpDevices(DeviceManager.this.mMonitoringTcpFastbootDevices));
                if (serialAndMode != null) {
                    HashSet<String> bootloader = new HashSet<String>();
                    HashSet<String> fastbootd = new HashSet<String>();
                    for (Map.Entry<String, Boolean> entry : serialAndMode.entrySet()) {
                        if (entry.getValue().booleanValue() && DeviceManager.this.getHostOptions().isFastbootdEnable()) {
                            fastbootd.add(entry.getKey());
                            continue;
                        }
                        bootloader.add(entry.getKey());
                    }
                    DeviceManager.this.mManagedDeviceList.updateFastbootStates(bootloader, false);
                    if (!fastbootd.isEmpty()) {
                        DeviceManager.this.mManagedDeviceList.updateFastbootStates(fastbootd, true);
                    }
                    for (String serial : serialAndMode.keySet()) {
                        FastbootDevice d = new FastbootDevice(serial);
                        if (fastbootd.contains(serial)) {
                            d.setFastbootd(true);
                        }
                        if (DeviceManager.this.mGlobalDeviceFilter == null || !DeviceManager.this.mGlobalDeviceFilter.matches(d)) continue;
                        DeviceManager.this.addFastbootDevice(d);
                    }
                }
                if (!DeviceManager.this.mFastbootListeners.isEmpty()) {
                    ArrayList<IDeviceManager.IFastbootListener> listenersCopy = new ArrayList<IDeviceManager.IFastbootListener>(DeviceManager.this.mFastbootListeners.size());
                    listenersCopy.addAll(DeviceManager.this.mFastbootListeners);
                    for (IDeviceManager.IFastbootListener listener : listenersCopy) {
                        listener.stateUpdated();
                    }
                }
                DeviceManager.this.getRunUtil().sleep(5000L);
            }
        }
    }

    private class ManagedDeviceListener
    implements AndroidDebugBridge.IDeviceChangeListener {
        private ManagedDeviceListener() {
        }

        @Override
        public void deviceChanged(IDevice idevice, int changeMask) {
            if ((changeMask & 1) != 0) {
                IManagedTestDevice testDevice = DeviceManager.this.mManagedDeviceList.findOrCreate(idevice);
                if (testDevice == null) {
                    return;
                }
                TestDeviceState newState = TestDeviceState.getStateByDdms(idevice.getState());
                testDevice.setDeviceState(newState);
                if (newState == TestDeviceState.ONLINE) {
                    IManagedTestDevice.DeviceEventResponse r = DeviceManager.this.mManagedDeviceList.handleDeviceEvent(testDevice, DeviceEvent.STATE_CHANGE_ONLINE);
                    if (r.stateChanged && r.allocationState == DeviceAllocationState.Checking_Availability) {
                        DeviceManager.this.checkAndAddAvailableDevice(testDevice);
                    }
                } else if (IDevice.DeviceState.OFFLINE.equals((Object)idevice.getState()) || IDevice.DeviceState.UNAUTHORIZED.equals((Object)idevice.getState())) {
                    DeviceManager.this.mManagedDeviceList.handleDeviceEvent(testDevice, DeviceEvent.STATE_CHANGE_OFFLINE);
                }
            }
        }

        @Override
        public void deviceConnected(final IDevice idevice) {
            LogUtil.CLog.d("Detected device connect %s, id %d", idevice.getSerialNumber(), idevice.hashCode());
            String threadName = String.format("Connected device %s", idevice.getSerialNumber());
            Runnable connectedRunnable = new Runnable(){

                @Override
                public void run() {
                    IManagedTestDevice testDevice = DeviceManager.this.mManagedDeviceList.findOrCreate(idevice);
                    if (testDevice == null) {
                        return;
                    }
                    LogUtil.CLog.d("Updating IDevice for device %s", idevice.getSerialNumber());
                    testDevice.setIDevice(idevice);
                    TestDeviceState newState = TestDeviceState.getStateByDdms(idevice.getState());
                    testDevice.setDeviceState(newState);
                    if (newState == TestDeviceState.ONLINE) {
                        IManagedTestDevice.DeviceEventResponse r = DeviceManager.this.mManagedDeviceList.handleDeviceEvent(testDevice, DeviceEvent.CONNECTED_ONLINE);
                        if (r.stateChanged && r.allocationState == DeviceAllocationState.Checking_Availability) {
                            DeviceManager.this.checkAndAddAvailableDevice(testDevice);
                        }
                        DeviceManager.this.logDeviceEvent(ILogRegistry.EventType.DEVICE_CONNECTED, testDevice.getSerialNumber());
                    } else if (IDevice.DeviceState.OFFLINE.equals((Object)idevice.getState()) || IDevice.DeviceState.UNAUTHORIZED.equals((Object)idevice.getState())) {
                        DeviceManager.this.mManagedDeviceList.handleDeviceEvent(testDevice, DeviceEvent.CONNECTED_OFFLINE);
                        DeviceManager.this.logDeviceEvent(ILogRegistry.EventType.DEVICE_CONNECTED_OFFLINE, testDevice.getSerialNumber());
                    }
                    DeviceManager.this.mFirstDeviceAdded.countDown();
                }
            };
            if (DeviceManager.this.mSynchronousMode) {
                connectedRunnable.run();
            } else {
                Thread checkThread = new Thread(connectedRunnable, threadName);
                checkThread.setDaemon(true);
                checkThread.start();
            }
        }

        @Override
        public void deviceDisconnected(IDevice disconnectedDevice) {
            IManagedTestDevice d = DeviceManager.this.mManagedDeviceList.find(disconnectedDevice.getSerialNumber());
            if (d != null) {
                DeviceManager.this.mManagedDeviceList.handleDeviceEvent(d, DeviceEvent.DISCONNECTED);
                d.setDeviceState(TestDeviceState.NOT_AVAILABLE);
                DeviceManager.this.logDeviceEvent(ILogRegistry.EventType.DEVICE_DISCONNECTED, disconnectedDevice.getSerialNumber());
            }
        }
    }

    private class DeviceRecoverer
    extends Thread {
        private boolean mQuit;
        private List<IMultiDeviceRecovery> mMultiDeviceRecoverers;

        public DeviceRecoverer(List<IMultiDeviceRecovery> multiDeviceRecoverers) {
            super("DeviceRecoverer");
            this.mQuit = false;
            this.mMultiDeviceRecoverers = multiDeviceRecoverers;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (!this.mQuit) {
                DeviceManager.this.getRunUtil().sleep(DeviceManager.this.mDeviceRecoveryInterval);
                if (this.mQuit) {
                    return;
                }
                LogUtil.CLog.d("Running DeviceRecoverer ...");
                if (this.mMultiDeviceRecoverers == null || this.mMultiDeviceRecoverers.isEmpty()) continue;
                for (IMultiDeviceRecovery m : this.mMultiDeviceRecoverers) {
                    LogUtil.CLog.d("Triggering IMultiDeviceRecovery class %s ...", m.getClass().getSimpleName());
                    try {
                        m.recoverDevices(DeviceManager.this.getDeviceList());
                    }
                    catch (RuntimeException e) {
                        LogUtil.CLog.e("Exception during %s recovery:", m.getClass().getSimpleName());
                        LogUtil.CLog.e(e);
                    }
                }
            }
        }

        public void terminate() {
            this.mQuit = true;
            this.interrupt();
        }
    }

    private static class EmulatorDevice
    extends StubDevice {
        private final int mPort;

        public EmulatorDevice(int port) {
            super(String.format("emulator-%d", port), true);
            this.mPort = port;
        }

        public EmulatorDevice(String serial) {
            super(serial, true);
            this.mPort = Integer.valueOf(serial.substring("emulator-".length()));
        }
    }

    public static class FastbootDevice
    extends StubDevice {
        private boolean mIsFastbootd = false;

        public FastbootDevice(String serial) {
            super(serial, false);
        }

        public void setFastbootd(boolean isFastbootd) {
            this.mIsFastbootd = isFastbootd;
        }

        public boolean isFastbootD() {
            return this.mIsFastbootd;
        }
    }

    private static class AbortRecovery
    implements IDeviceRecovery {
        private String mMessage;

        AbortRecovery(String reason) {
            this.mMessage = "aborted test session: " + reason;
        }

        @Override
        public void recoverDevice(IDeviceStateMonitor monitor, boolean recoverUntilOnline) throws DeviceNotAvailableException {
            throw new DeviceNotAvailableException(this.mMessage, monitor.getSerialNumber(), (ErrorIdentifier)InfraErrorIdentifier.INVOCATION_CANCELLED);
        }

        @Override
        public void recoverDeviceBootloader(IDeviceStateMonitor monitor) throws DeviceNotAvailableException {
            throw new DeviceNotAvailableException(this.mMessage, monitor.getSerialNumber(), (ErrorIdentifier)InfraErrorIdentifier.INVOCATION_CANCELLED);
        }

        @Override
        public void recoverDeviceRecovery(IDeviceStateMonitor monitor) throws DeviceNotAvailableException {
            throw new DeviceNotAvailableException(this.mMessage, monitor.getSerialNumber(), (ErrorIdentifier)InfraErrorIdentifier.INVOCATION_CANCELLED);
        }

        @Override
        public void recoverDeviceFastbootd(IDeviceStateMonitor monitor) throws DeviceNotAvailableException {
            throw new DeviceNotAvailableException(this.mMessage, monitor.getSerialNumber(), (ErrorIdentifier)InfraErrorIdentifier.INVOCATION_CANCELLED);
        }
    }
}

