/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.tradefed.device.DeviceAllocationState;
import com.android.tradefed.device.IDeviceMonitor;
import com.android.tradefed.log.LogUtil;
import java.util.LinkedList;
import java.util.List;

public class DeviceMonitorMultiplexer
implements IDeviceMonitor {
    private final List<IDeviceMonitor> mDeviceMonitors = new LinkedList<IDeviceMonitor>();

    @Override
    public synchronized void run() {
        for (IDeviceMonitor monitor : this.mDeviceMonitors) {
            monitor.run();
        }
    }

    @Override
    public synchronized void setDeviceLister(IDeviceMonitor.DeviceLister lister) {
        for (IDeviceMonitor monitor : this.mDeviceMonitors) {
            monitor.setDeviceLister(lister);
        }
    }

    @Override
    public synchronized void notifyDeviceStateChange(String serial, DeviceAllocationState oldState, DeviceAllocationState newState) {
        for (IDeviceMonitor monitor : this.mDeviceMonitors) {
            monitor.notifyDeviceStateChange(serial, oldState, newState);
        }
    }

    public synchronized void addMonitors(List<IDeviceMonitor> globalDeviceMonitors) {
        this.mDeviceMonitors.addAll(globalDeviceMonitors);
    }

    public synchronized void addMonitor(IDeviceMonitor globalDeviceMonitor) {
        this.mDeviceMonitors.add(globalDeviceMonitor);
    }

    public synchronized void removeMonitor(IDeviceMonitor mon) {
        this.mDeviceMonitors.remove(mon);
    }

    @Override
    public synchronized void stop() {
        for (IDeviceMonitor monitor : this.mDeviceMonitors) {
            try {
                monitor.stop();
            }
            catch (RuntimeException e) {
                LogUtil.CLog.e(e);
            }
        }
    }
}

