/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.IDevice;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionUpdateRule;
import com.android.tradefed.device.BatteryTemperature;
import com.android.tradefed.device.DeviceManager;
import com.android.tradefed.device.IDeviceSelection;
import com.android.tradefed.device.NullDevice;
import com.android.tradefed.device.RemoteAndroidDevice;
import com.android.tradefed.device.RemoteAvdIDevice;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.device.StubLocalAndroidVirtualDevice;
import com.android.tradefed.device.TcpDevice;
import com.android.tradefed.device.cloud.VmRemoteDevice;
import com.android.tradefed.log.LogUtil;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class DeviceSelectionOptions
implements IDeviceSelection {
    @Option(name="serial", shortName=115, description="run this test on a specific device with given serial number(s).")
    private Collection<String> mSerials = new ArrayList<String>();
    @Option(name="exclude-serial", description="run this test on any device except those with this serial number(s).")
    private Collection<String> mExcludeSerials = new ArrayList<String>();
    @Option(name="product-type", description="run this test on device with this product type(s).  May also filter by variant using product:variant.")
    private Collection<String> mProductTypes = new ArrayList<String>();
    @Option(name="property", description="run this test on device with this property value. Expected format --property <propertyname> <propertyvalue>.")
    private Map<String, String> mPropertyMap = new HashMap<String, String>();
    @Option(name="emulator", shortName=101, description="force this test to run on emulator.")
    private boolean mEmulatorRequested = false;
    @Option(name="device", shortName=100, description="force this test to run on a physical device, not an emulator.")
    private boolean mDeviceRequested = false;
    @Option(name="new-emulator", description="allocate a placeholder emulator. Should be used when config intends to launch an emulator")
    private boolean mStubEmulatorRequested = false;
    @Option(name="null-device", shortName=110, description="do not allocate a device for this test.")
    private boolean mNullDeviceRequested = false;
    @Option(name="tcp-device", description="start a placeholder for a tcp device that will be connected later.")
    private boolean mTcpDeviceRequested = false;
    @Option(name="gce-device", description="start a placeholder for a gce device that will be connected later.")
    private boolean mGceDeviceRequested = false;
    @Option(name="device-type", description="The type of the device requested to be allocated.")
    private DeviceRequestedType mRequestedType = null;
    @Option(name="base-device-type-request", description="Explicitly request a device type which will use device-type for connection.")
    private IDeviceSelection.BaseDeviceType mBaseDeviceType = null;
    @Option(name="min-battery", description="only run this test on a device whose battery level is at least the given amount. Scale: 0-100", updateRule=OptionUpdateRule.GREATEST)
    private Integer mMinBattery = null;
    @Option(name="max-battery", description="only run this test on a device whose battery level is strictly less than the given amount. Scale: 0-100", updateRule=OptionUpdateRule.LEAST)
    private Integer mMaxBattery = null;
    @Option(name="max-battery-temperature", description="only run this test on a device whose battery temperature is strictly less than the given amount. Scale: Degrees celsius")
    private Integer mMaxBatteryTemperature = null;
    @Option(name="require-battery-check", description="_If_ --min-battery and/or --max-battery is specified, enforce the check. If require-battery-check=false, then no battery check will occur.")
    private boolean mRequireBatteryCheck = true;
    @Option(name="require-battery-temp-check", description="_If_ --max-battery-temperature is specified, enforce the battery checking. If require-battery-temp-check=false, then no temperature check will occur.")
    private boolean mRequireBatteryTemperatureCheck = true;
    @Option(name="min-sdk-level", description="Only run this test on devices that support this Android SDK/API level")
    private Integer mMinSdk = null;
    @Option(name="max-sdk-level", description="Only run this test on devices that are running this or lower Android SDK/API level")
    private Integer mMaxSdk = null;
    private boolean mFetchedEnvVariable = false;
    private Map<String, String> mNoMatchReason = new LinkedHashMap<String, String>();
    private boolean mSerialMatch = false;
    private static final String VARIANT_SEPARATOR = ":";

    public void addSerial(String serialNumber) {
        this.mSerials.add(serialNumber);
    }

    @Override
    public void setSerial(String ... serialNumber) {
        this.mSerials.clear();
        this.mSerials.addAll(Arrays.asList(serialNumber));
    }

    @Override
    public List<String> getSerials() {
        return new ArrayList<String>(this.mSerials);
    }

    @Override
    public Collection<String> getSerials(IDevice device) {
        if (this.mSerials.isEmpty() && !this.mFetchedEnvVariable) {
            String env_serial = this.fetchEnvironmentVariable("ANDROID_SERIAL");
            if (env_serial != null && (!(device instanceof StubDevice) || device instanceof DeviceManager.FastbootDevice)) {
                this.mSerials.add(env_serial);
            }
            this.mFetchedEnvVariable = true;
        }
        return this.copyCollection(this.mSerials);
    }

    public void addExcludeSerial(String serialNumber) {
        this.mExcludeSerials.add(serialNumber);
    }

    public void addProductType(String productType) {
        this.mProductTypes.add(productType);
    }

    public void addProperty(String propertyKey, String propValue) {
        this.mPropertyMap.put(propertyKey, propValue);
    }

    @Override
    public Collection<String> getExcludeSerials() {
        return this.copyCollection(this.mExcludeSerials);
    }

    @Override
    public Collection<String> getProductTypes() {
        return this.copyCollection(this.mProductTypes);
    }

    @Override
    public boolean deviceRequested() {
        return this.mDeviceRequested;
    }

    @Override
    public boolean emulatorRequested() {
        if (this.mRequestedType != null) {
            return this.mRequestedType.equals((Object)DeviceRequestedType.LOCAL_EMULATOR);
        }
        return this.mEmulatorRequested;
    }

    @Override
    public boolean stubEmulatorRequested() {
        if (this.mRequestedType != null) {
            return this.mRequestedType.equals((Object)DeviceRequestedType.LOCAL_EMULATOR);
        }
        return this.mStubEmulatorRequested;
    }

    @Override
    public boolean nullDeviceRequested() {
        if (this.mRequestedType != null) {
            return this.mRequestedType.equals((Object)DeviceRequestedType.NULL_DEVICE);
        }
        return this.mNullDeviceRequested;
    }

    @Override
    public boolean tcpDeviceRequested() {
        if (this.mRequestedType != null) {
            return this.mRequestedType.equals((Object)DeviceRequestedType.TCP_DEVICE);
        }
        return this.mTcpDeviceRequested;
    }

    @Override
    public boolean gceDeviceRequested() {
        if (this.mRequestedType != null) {
            return this.mRequestedType.equals((Object)DeviceRequestedType.GCE_DEVICE);
        }
        return this.mGceDeviceRequested;
    }

    public void setGceDeviceRequested(boolean gceDeviceRequested) {
        this.mGceDeviceRequested = gceDeviceRequested;
    }

    public boolean remoteDeviceRequested() {
        return DeviceRequestedType.REMOTE_DEVICE.equals((Object)this.mRequestedType);
    }

    public boolean localVirtualDeviceRequested() {
        return DeviceRequestedType.LOCAL_VIRTUAL_DEVICE.equals((Object)this.mRequestedType);
    }

    public void setEmulatorRequested(boolean emulatorRequested) {
        this.mEmulatorRequested = emulatorRequested;
    }

    public void setStubEmulatorRequested(boolean stubEmulatorRequested) {
        this.mStubEmulatorRequested = stubEmulatorRequested;
    }

    public void setDeviceRequested(boolean deviceRequested) {
        this.mDeviceRequested = deviceRequested;
    }

    public void setNullDeviceRequested(boolean nullDeviceRequested) {
        this.mNullDeviceRequested = nullDeviceRequested;
    }

    public void setTcpDeviceRequested(boolean tcpDeviceRequested) {
        this.mTcpDeviceRequested = tcpDeviceRequested;
    }

    public void setDeviceTypeRequested(DeviceRequestedType requestedType) {
        this.mRequestedType = requestedType;
    }

    public DeviceRequestedType getDeviceTypeRequested() {
        return this.mRequestedType;
    }

    @Override
    public IDeviceSelection.BaseDeviceType getBaseDeviceTypeRequested() {
        return this.mBaseDeviceType;
    }

    @Override
    public void setBaseDeviceTypeRequested(IDeviceSelection.BaseDeviceType type) {
        this.mBaseDeviceType = type;
    }

    public void setMinBatteryLevel(Integer minBattery) {
        this.mMinBattery = minBattery;
    }

    public Integer getMinBatteryLevel() {
        return this.mMinBattery;
    }

    public void setMaxBatteryLevel(Integer maxBattery) {
        this.mMaxBattery = maxBattery;
    }

    public Integer getMaxBatteryLevel() {
        return this.mMaxBattery;
    }

    public void setMaxBatteryTemperature(Integer maxBatteryTemperature) {
        this.mMaxBatteryTemperature = maxBatteryTemperature;
    }

    public Integer getMaxBatteryTemperature() {
        return this.mMaxBatteryTemperature;
    }

    @Override
    public void setRequireBatteryCheck(boolean requireCheck) {
        this.mRequireBatteryCheck = requireCheck;
    }

    public boolean getRequireBatteryCheck() {
        return this.mRequireBatteryCheck;
    }

    public void setRequireBatteryTemperatureCheck(boolean requireCheckTemprature) {
        this.mRequireBatteryTemperatureCheck = requireCheckTemprature;
    }

    public boolean getRequireBatteryTemperatureCheck() {
        return this.mRequireBatteryTemperatureCheck;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.mPropertyMap;
    }

    private Collection<String> copyCollection(Collection<String> original) {
        ArrayList<String> listCopy = new ArrayList<String>(original.size());
        listCopy.addAll(original);
        return listCopy;
    }

    public String fetchEnvironmentVariable(String name) {
        return System.getenv(name);
    }

    @Override
    public boolean matches(IDevice device) {
        String deviceSerial = device.getSerialNumber();
        Collection<String> serials = this.getSerials(device);
        Collection<String> excludeSerials = this.getExcludeSerials();
        Map<String, Collection<String>> productVariants = this.splitOnVariant(this.getProductTypes());
        Set<String> productTypes = productVariants.keySet();
        Map<String, String> properties = this.getProperties();
        if (!serials.isEmpty() && !serials.contains(device.getSerialNumber())) {
            return false;
        }
        this.mSerialMatch = true;
        if (excludeSerials.contains(device.getSerialNumber())) {
            this.addNoMatchReason(deviceSerial, String.format("device serial was part of excluded serials(%s)", excludeSerials));
            return false;
        }
        if (!productTypes.isEmpty()) {
            String productType = this.getDeviceProductType(device);
            if (productTypes.contains(productType)) {
                String string = this.getDeviceProductVariant(device);
                Collection<String> variants = productVariants.get(productType);
                if (variants != null && !variants.contains(string)) {
                    this.addNoMatchReason(deviceSerial, String.format("device variant (%s) does not match requested variants(%s)", string, variants));
                    return false;
                }
            } else {
                this.addNoMatchReason(deviceSerial, String.format("device product type (%s) does not match requested product types(%s)", productType, productTypes));
                return false;
            }
        }
        for (Map.Entry entry : properties.entrySet()) {
            String deviceProperty = device.getProperty((String)entry.getKey());
            if (((String)entry.getValue()).equals(deviceProperty)) continue;
            this.addNoMatchReason(deviceSerial, String.format("device property (%s) value(%s) does not match requested value(%s)", entry.getKey(), deviceProperty, entry.getValue()));
            return false;
        }
        if (!this.checkDeviceTypeRequested(device)) {
            return false;
        }
        if (this.mMinSdk != null || this.mMaxSdk != null) {
            int deviceSdkLevel = this.getDeviceSdkLevel(device);
            if (deviceSdkLevel < 0) {
                this.addNoMatchReason(deviceSerial, String.format("device returned unexpected sdk level (%s)", deviceSdkLevel));
                return false;
            }
            if (this.mMinSdk != null && deviceSdkLevel < this.mMinSdk) {
                this.addNoMatchReason(deviceSerial, String.format("device sdk (%s) is below the requested min sdk (%s)", deviceSdkLevel, this.mMinSdk));
                return false;
            }
            if (this.mMaxSdk != null && this.mMaxSdk < deviceSdkLevel) {
                this.addNoMatchReason(deviceSerial, String.format("device sdk (%s) is above the requested max sdk (%s)", deviceSdkLevel, this.mMaxSdk));
                return false;
            }
        }
        if (this.mRequireBatteryCheck && (this.mMinBattery != null || this.mMaxBattery != null)) {
            if (device instanceof StubDevice || device instanceof DeviceManager.FastbootDevice) {
                this.addNoMatchReason(deviceSerial, String.format("device type is (%s) which cannot have a battery required.", device.getClass()));
                return false;
            }
            Integer deviceBattery = this.getBatteryLevel(device);
            if (deviceBattery == null) {
                this.addNoMatchReason(deviceSerial, "device failed to return a battery reading.");
                return false;
            }
            if (DeviceSelectionOptions.isLessAndNotNull(deviceBattery, this.mMinBattery)) {
                this.addNoMatchReason(deviceSerial, String.format("device battery (%s) is below the requested min battery (%s)", deviceBattery, this.mMinBattery));
                return false;
            }
            if (DeviceSelectionOptions.isLessEqAndNotNull(this.mMaxBattery, deviceBattery)) {
                this.addNoMatchReason(deviceSerial, String.format("device battery (%s) is above the requested max battery (%s)", deviceBattery, this.mMaxBattery));
                return false;
            }
        }
        if (this.mRequireBatteryTemperatureCheck && this.mMaxBatteryTemperature != null && (!(device instanceof StubDevice) || device instanceof DeviceManager.FastbootDevice)) {
            if (device instanceof DeviceManager.FastbootDevice) {
                return false;
            }
            BatteryTemperature temp = new BatteryTemperature();
            Integer n = temp.getBatteryTemperature(device);
            if (n <= 0) {
                return false;
            }
            if (DeviceSelectionOptions.isLessEqAndNotNull(this.mMaxBatteryTemperature, n)) {
                return false;
            }
        }
        return true;
    }

    private boolean checkDeviceTypeRequested(IDevice device) {
        if ((this.emulatorRequested() || this.stubEmulatorRequested()) && !device.isEmulator()) {
            return false;
        }
        String deviceSerial = device.getSerialNumber();
        if (this.deviceRequested() && (device.isEmulator() || RemoteAndroidDevice.checkSerialFormatValid(device.getSerialNumber()))) {
            this.addNoMatchReason(deviceSerial, "device is not a physical device");
            return false;
        }
        if (this.mRequestedType != null) {
            Class<?> classNeeded = this.mRequestedType.getRequiredClass();
            if (!DeviceRequestedType.EXISTING_DEVICE.equals((Object)this.mRequestedType) && !device.getClass().equals(classNeeded)) {
                this.addNoMatchReason(deviceSerial, String.format("device is type (%s) while requested type was (%s)", device.getClass(), classNeeded));
                return false;
            }
        } else {
            if (device.isEmulator() && device instanceof StubDevice && !this.stubEmulatorRequested()) {
                this.addNoMatchReason(deviceSerial, "device is emulator while requested type was not");
                return false;
            }
            if (this.nullDeviceRequested() != device instanceof NullDevice) {
                this.addNoMatchReason(deviceSerial, "device is null-device while requested type was not");
                return false;
            }
            if (this.tcpDeviceRequested() != TcpDevice.class.equals(device.getClass())) {
                this.addNoMatchReason(deviceSerial, "device is tcp-device while requested type was not");
                return false;
            }
            if (this.gceDeviceRequested() != RemoteAvdIDevice.class.equals(device.getClass())) {
                this.addNoMatchReason(deviceSerial, "device is gce-device while requested type was not");
                return false;
            }
            if (this.remoteDeviceRequested() != VmRemoteDevice.class.equals(device.getClass())) {
                this.addNoMatchReason(deviceSerial, "device is remote-device while requested type was not");
                return false;
            }
            if (this.localVirtualDeviceRequested() != StubLocalAndroidVirtualDevice.class.equals(device.getClass())) {
                this.addNoMatchReason(deviceSerial, "device is local-virtual while requested type was not");
                return false;
            }
        }
        return true;
    }

    private static boolean isLessAndNotNull(Integer x, Integer y) {
        if (x == null || y == null) {
            return false;
        }
        return x < y;
    }

    private static boolean isLessEqAndNotNull(Integer x, Integer y) {
        if (x == null || y == null) {
            return false;
        }
        return x <= y;
    }

    private Map<String, Collection<String>> splitOnVariant(Collection<String> products) {
        HashMap<String, Collection<String>> splitProducts = new HashMap<String, Collection<String>>(products.size());
        for (String prod : products) {
            String[] parts = prod.split(VARIANT_SEPARATOR);
            if (parts.length == 1) {
                splitProducts.put(parts[0], null);
                continue;
            }
            if (parts.length == 2) {
                HashSet<String> variants = (HashSet<String>)splitProducts.get(parts[0]);
                if (variants == null) {
                    variants = new HashSet<String>();
                    splitProducts.put(parts[0], variants);
                }
                variants.add(parts[1]);
                continue;
            }
            throw new IllegalArgumentException(String.format("The product type filter \"%s\" is invalid.  It must contain 0 or 1 '%s' characters, not %d.", prod, VARIANT_SEPARATOR, parts.length));
        }
        return splitProducts;
    }

    @Override
    public String getDeviceProductType(IDevice device) {
        String prop = this.getProperty(device, "ro.product.board");
        if (Strings.isNullOrEmpty(prop)) {
            prop = this.getProperty(device, "ro.hardware");
        }
        if (prop != null) {
            prop = prop.toLowerCase();
        }
        return prop;
    }

    private String getProperty(IDevice device, String propName) {
        return device.getProperty(propName);
    }

    @Override
    public String getDeviceProductVariant(IDevice device) {
        String prop = this.getProperty(device, "ro.product.vendor.device");
        if (prop == null) {
            prop = this.getProperty(device, "ro.vendor.product.device");
        }
        if (prop == null) {
            prop = this.getProperty(device, "ro.product.device");
        }
        if (prop != null) {
            prop = prop.toLowerCase();
        }
        return prop;
    }

    @Override
    public Integer getBatteryLevel(IDevice device) {
        try {
            Future<Integer> batteryFuture = device.getBattery();
            return batteryFuture.get(500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LogUtil.CLog.w("Failed to query battery level for %s: %s", device.getSerialNumber(), e.toString());
            return null;
        }
    }

    private int getDeviceSdkLevel(IDevice device) {
        int apiLevel = -1;
        String prop = this.getProperty(device, "ro.build.version.sdk");
        try {
            apiLevel = Integer.parseInt(prop);
        }
        catch (NumberFormatException nfe) {
            LogUtil.CLog.w("Failed to parse sdk level %s for device %s", prop, device.getSerialNumber());
        }
        return apiLevel;
    }

    private void addNoMatchReason(String device, String reason) {
        this.mNoMatchReason.put(device, reason);
    }

    @Override
    public Map<String, String> getNoMatchReason() {
        if (!this.mSerialMatch) {
            this.mNoMatchReason.put("no_match", String.format("Need serial (%s) but couldn't match it.", this.getSerials()));
        }
        this.mSerialMatch = false;
        return this.mNoMatchReason;
    }

    public static IDeviceSelection createForSerial(String serial) {
        DeviceSelectionOptions o = new DeviceSelectionOptions();
        o.setSerial(serial);
        return o;
    }

    public static enum DeviceRequestedType {
        NULL_DEVICE(NullDevice.class),
        LOCAL_EMULATOR(StubDevice.class),
        TCP_DEVICE(TcpDevice.class),
        GCE_DEVICE(RemoteAvdIDevice.class),
        REMOTE_DEVICE(VmRemoteDevice.class),
        LOCAL_VIRTUAL_DEVICE(StubLocalAndroidVirtualDevice.class),
        EXISTING_DEVICE(IDevice.class);

        private Class<?> mRequiredIDeviceClass;

        private DeviceRequestedType(Class<?> requiredIDeviceClass) {
            this.mRequiredIDeviceClass = requiredIDeviceClass;
        }

        public Class<?> getRequiredClass() {
            return this.mRequiredIDeviceClass;
        }
    }
}

