/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.IDeviceManager;
import com.android.tradefed.device.NativeDeviceStateMonitor;
import com.android.tradefed.log.LogUtil;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class DeviceStateMonitor
extends NativeDeviceStateMonitor {
    public DeviceStateMonitor(IDeviceManager mgr, IDevice device, boolean fastbootEnabled) {
        super(mgr, device, fastbootEnabled);
    }

    protected boolean waitForPmResponsive(long waitTime) {
        LogUtil.CLog.i("Waiting %d ms for device %s package manager", waitTime, this.getSerialNumber());
        long startTime = System.currentTimeMillis();
        int counter = 1;
        while (System.currentTimeMillis() - startTime < waitTime) {
            CollectingOutputReceiver receiver = this.createOutputReceiver();
            String cmd = "pm path android";
            try {
                this.getIDevice().executeShellCommand("pm path android", receiver, 10000L, TimeUnit.MILLISECONDS);
                String output = receiver.getOutput();
                LogUtil.CLog.v("%s returned %s", "pm path android", output);
                if (output.contains("package:")) {
                    return true;
                }
            }
            catch (TimeoutException e) {
                LogUtil.CLog.i("%s on device %s failed: timeout", "pm path android", this.getSerialNumber());
            }
            catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | IOException e) {
                LogUtil.CLog.i("%s on device %s failed: %s(message: %s)", "pm path android", this.getSerialNumber(), e.getClass().getSimpleName(), e.getMessage());
            }
            this.getRunUtil().sleep(Math.min(this.getCheckPollTime() * (long)counter, 10000L));
            ++counter;
        }
        LogUtil.CLog.w("Device %s package manager is unresponsive", this.getSerialNumber());
        return false;
    }

    @Override
    protected boolean postOnlineCheck(long waitTime) throws DeviceNotAvailableException {
        long startTime = System.currentTimeMillis();
        if (!this.waitForPmResponsive(waitTime)) {
            return false;
        }
        long elapsedTime = System.currentTimeMillis() - startTime;
        if (!this.waitForStoreMount(waitTime - elapsedTime)) {
            return false;
        }
        return super.postOnlineCheck(waitTime - elapsedTime);
    }
}

