/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.MultiLineReceiver;
import com.android.tradefed.device.PackageInfo;
import com.android.tradefed.log.LogUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class DumpsysPackageReceiver
extends MultiLineReceiver {
    private static final String HIDDEN_SYSTEM_PACKAGES_PREFIX = "Hidden system packages:";
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("Package\\s\\[([\\w\\.]+)\\]");
    private static final Pattern USER_PATTERN = Pattern.compile("User\\s(\\d+):");
    private Map<String, PackageInfo> mPkgInfoMap = new HashMap<String, PackageInfo>();
    private ParserState mCurrentState = new PackagesParserState();
    private boolean mCancelled = false;

    DumpsysPackageReceiver() {
    }

    void addPackage(String name, PackageInfo pkgInfo) {
        this.mPkgInfoMap.put(name, pkgInfo);
    }

    public Map<String, PackageInfo> getPackages() {
        return this.mPkgInfoMap;
    }

    @Override
    public boolean isCancelled() {
        return this.mCancelled;
    }

    @Override
    public void processNewLines(String[] lines) {
        try {
            for (String line : lines) {
                this.mCurrentState = this.mCurrentState.parse(line);
            }
        }
        catch (ParseException e) {
            LogUtil.CLog.e(e);
            this.mCancelled = true;
        }
    }

    private class PackagesParserState
    implements ParserState {
        private PackagesParserState() {
        }

        @Override
        public ParserState parse(String line) throws ParseException {
            Matcher matcher = PACKAGE_PATTERN.matcher(line);
            if (matcher.find()) {
                String name = matcher.group(1);
                return new PackageParserState(name);
            }
            return this;
        }
    }

    private static interface ParserState {
        public ParserState parse(String var1) throws ParseException;
    }

    static class ParseException
    extends IOException {
        private static final long serialVersionUID = 1L;

        ParseException(String msg) {
            super(msg);
        }

        ParseException(String msg, Throwable t) {
            super(msg, t);
        }
    }

    private class PerUserPackageParserState
    implements ParserState {
        private final PackageInfo mPkgInfo;
        private final int mUserId;

        public PerUserPackageParserState(String name, int userId) throws ParseException {
            this.mPkgInfo = DumpsysPackageReceiver.this.mPkgInfoMap.get(name);
            if (this.mPkgInfo == null) {
                throw new ParseException(String.format("could not find package for hidden package %s", name));
            }
            this.mUserId = userId;
        }

        @Override
        public ParserState parse(String line) throws ParseException {
            Matcher matcher = PACKAGE_PATTERN.matcher(line);
            if (matcher.find()) {
                String name = matcher.group(1);
                return new PackageParserState(name);
            }
            Matcher userStateMatcher = USER_PATTERN.matcher(line);
            if (userStateMatcher.find()) {
                int userId = Integer.parseInt(userStateMatcher.group(1));
                return new PerUserPackageParserState(this.mPkgInfo.getPackageName(), userId);
            }
            this.parseAttributes(line);
            return this;
        }

        private void parseAttributes(String line) {
            String[] prop = line.split("=");
            if (prop.length == 2) {
                this.mPkgInfo.addPerUserAttribute(this.mUserId, prop[0], prop[1]);
            }
        }
    }

    private class HiddenPackageParserState
    implements ParserState {
        private PackageInfo mPkgInfo;

        public HiddenPackageParserState(String name) throws ParseException {
            this.mPkgInfo = DumpsysPackageReceiver.this.mPkgInfoMap.get(name);
            if (this.mPkgInfo == null) {
                throw new ParseException(String.format("could not find package for hidden package %s", name));
            }
            this.mPkgInfo.setIsUpdatedSystemApp(true);
        }

        @Override
        public ParserState parse(String line) throws ParseException {
            Matcher matcher = PACKAGE_PATTERN.matcher(line);
            if (matcher.find()) {
                String name = matcher.group(1);
                return new HiddenPackageParserState(name);
            }
            return this;
        }
    }

    private class HiddenPackagesParserState
    implements ParserState {
        private HiddenPackagesParserState() {
        }

        @Override
        public ParserState parse(String line) throws ParseException {
            Matcher matcher = PACKAGE_PATTERN.matcher(line);
            if (matcher.find()) {
                String name = matcher.group(1);
                return new HiddenPackageParserState(name);
            }
            return this;
        }
    }

    private class PackageParserState
    implements ParserState {
        private PackageInfo mPkgInfo;

        public PackageParserState(String name) {
            this.mPkgInfo = new PackageInfo(name);
            DumpsysPackageReceiver.this.addPackage(name, this.mPkgInfo);
        }

        @Override
        public ParserState parse(String line) throws ParseException {
            Matcher matcher = PACKAGE_PATTERN.matcher(line);
            if (matcher.find()) {
                String name = matcher.group(1);
                return new PackageParserState(name);
            }
            if (line.startsWith(DumpsysPackageReceiver.HIDDEN_SYSTEM_PACKAGES_PREFIX)) {
                return new HiddenPackagesParserState();
            }
            Matcher userStateMatcher = USER_PATTERN.matcher(line);
            if (userStateMatcher.find()) {
                int userId = Integer.parseInt(userStateMatcher.group(1));
                return new PerUserPackageParserState(this.mPkgInfo.getPackageName(), userId);
            }
            this.parseAttributes(line);
            return this;
        }

        private void parseAttributes(String line) {
            String[] prop = line.split("=");
            if (prop.length == 2) {
                this.mPkgInfo.addAttribute(prop[0], prop[1]);
            } else if (prop.length > 2) {
                String[] vn = line.split(" |=");
                if (vn.length % 2 != 0) {
                    return;
                }
                for (int i = 0; i < vn.length; i += 2) {
                    this.mPkgInfo.addAttribute(vn[i], vn[i + 1]);
                }
            }
        }
    }
}

