/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.Log;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.IRunUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FastbootHelper {
    private static final long FASTBOOT_CMD_TIMEOUT = 60000L;
    private IRunUtil mRunUtil;
    private String mFastbootPath = "fastboot";

    public FastbootHelper(IRunUtil runUtil, String fastbootPath) {
        if (runUtil == null) {
            throw new IllegalArgumentException("runUtil cannot be null");
        }
        if (fastbootPath == null || fastbootPath.isEmpty()) {
            throw new IllegalArgumentException("fastboot cannot be null or empty");
        }
        this.mRunUtil = runUtil;
        this.mFastbootPath = fastbootPath;
    }

    public boolean isFastbootAvailable() {
        CommandResult fastbootResult = this.mRunUtil.runTimedCmdSilently(15000L, this.mFastbootPath, "help");
        if (CommandStatus.SUCCESS.equals((Object)fastbootResult.getStatus())) {
            return true;
        }
        if (fastbootResult.getStderr() != null && fastbootResult.getStderr().indexOf("usage: fastboot") >= 0) {
            LogUtil.CLog.logAndDisplay(Log.LogLevel.WARN, "You are running an older version of fastboot, please update it.");
            return true;
        }
        LogUtil.CLog.d("fastboot not available. stdout: %s, stderr: %s", fastbootResult.getStdout(), fastbootResult.getStderr());
        return false;
    }

    public Set<String> getDevices() {
        CommandResult fastbootResult = this.mRunUtil.runTimedCmdSilently(60000L, this.mFastbootPath, "devices");
        if (fastbootResult.getStatus().equals((Object)CommandStatus.SUCCESS)) {
            LogUtil.CLog.v("fastboot devices returned\n %s", fastbootResult.getStdout());
            return this.parseDevices(fastbootResult.getStdout(), false);
        }
        LogUtil.CLog.w("'fastboot devices' failed. Result: %s, stderr: %s", new Object[]{fastbootResult.getStatus(), fastbootResult.getStderr()});
        return new HashSet<String>();
    }

    public Map<String, Boolean> getBootloaderAndFastbootdDevices() {
        CommandResult fastbootResult = this.mRunUtil.runTimedCmdSilently(60000L, this.mFastbootPath, "devices");
        if (fastbootResult.getStatus().equals((Object)CommandStatus.SUCCESS)) {
            LogUtil.CLog.v("fastboot devices returned\n %s", fastbootResult.getStdout());
            Set<String> fastboot = this.parseDevices(fastbootResult.getStdout(), false);
            Set<String> fastbootd = this.parseDevices(fastbootResult.getStdout(), true);
            LinkedHashMap<String, Boolean> devices = new LinkedHashMap<String, Boolean>();
            for (String f : fastboot) {
                devices.put(f, false);
            }
            for (String f : fastbootd) {
                devices.put(f, true);
            }
            return devices;
        }
        LogUtil.CLog.w("'fastboot devices' failed. Result: %s, stderr: %s", new Object[]{fastbootResult.getStatus(), fastbootResult.getStderr()});
        return new HashMap<String, Boolean>();
    }

    public Map<String, Boolean> getBootloaderAndFastbootdTcpDevices(Map<String, String> serials) {
        LinkedHashMap<String, Boolean> devices = new LinkedHashMap<String, Boolean>();
        long TIMEOUT = 1500L;
        for (Map.Entry<String, String> entry : serials.entrySet()) {
            LogUtil.CLog.v("Run 'fastboot -s %s getvar is-userspace' command", entry.getValue());
            CommandResult fastbootResult = this.mRunUtil.runTimedCmdSilently(TIMEOUT, this.mFastbootPath, "-s", entry.getValue(), "getvar", "is-userspace");
            if (!fastbootResult.getStatus().equals((Object)CommandStatus.SUCCESS)) continue;
            if (fastbootResult.getStderr().contains("yes")) {
                devices.put(entry.getKey(), true);
                continue;
            }
            devices.put(entry.getKey(), false);
        }
        return devices;
    }

    Set<String> parseDevices(String fastbootOutput, boolean fastbootd) {
        HashSet<String> serials = new HashSet<String>();
        Pattern fastbootPattern = null;
        fastbootPattern = fastbootd ? Pattern.compile("([\\w\\d-]+)\\s+fastbootd\\s*") : Pattern.compile("([\\w\\d-]+)\\s+fastboot\\s*");
        Matcher fastbootMatcher = fastbootPattern.matcher(fastbootOutput);
        while (fastbootMatcher.find()) {
            serials.add(fastbootMatcher.group(1));
        }
        return serials;
    }

    public String executeCommand(String serial, String command) {
        CommandResult fastbootResult = this.mRunUtil.runTimedCmd(60000L, this.mFastbootPath, "-s", serial, command);
        if (fastbootResult.getStatus() != CommandStatus.SUCCESS) {
            LogUtil.CLog.w("'fastboot -s %s %s' failed. Result: %s, stderr: %s", new Object[]{serial, command, fastbootResult.getStatus(), fastbootResult.getStderr()});
            return null;
        }
        return fastbootResult.getStdout();
    }

    public boolean isFastbootd(String serial) {
        CommandResult fastbootResult = this.mRunUtil.runTimedCmd(60000L, this.mFastbootPath, "-s", serial, "getvar", "is-userspace");
        return fastbootResult.getStderr().contains("is-userspace: yes");
    }
}

