/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.FileListingService;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.IFileEntry;
import com.android.tradefed.device.NativeDevice;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class FileEntryWrapper
implements IFileEntry {
    private final NativeDevice mTestDevice;
    private final FileListingService.FileEntry mFileEntry;
    private Map<String, IFileEntry> mChildMap = null;

    FileEntryWrapper(NativeDevice testDevice, FileListingService.FileEntry entry) {
        this.mTestDevice = testDevice;
        this.mFileEntry = entry;
    }

    @Override
    public String getFullEscapedPath() {
        return this.mFileEntry.getFullEscapedPath();
    }

    @Override
    public String getFullPath() {
        return this.mFileEntry.getFullPath();
    }

    @Override
    public IFileEntry findChild(String name) throws DeviceNotAvailableException {
        if (this.mChildMap == null || !this.mChildMap.containsKey(name)) {
            this.mChildMap = this.buildChildrenMap();
        }
        return this.mChildMap.get(name);
    }

    @Override
    public boolean isDirectory() {
        return this.mFileEntry.isDirectory();
    }

    @Override
    public boolean isAppFileName() {
        return this.mFileEntry.isAppFileName();
    }

    @Override
    public String getName() {
        return this.mFileEntry.getName();
    }

    @Override
    public Collection<IFileEntry> getChildren(boolean useCache) throws DeviceNotAvailableException {
        if (!useCache || this.mChildMap == null) {
            this.mChildMap = this.buildChildrenMap();
        }
        return this.mChildMap.values();
    }

    private Map<String, IFileEntry> buildChildrenMap() throws DeviceNotAvailableException {
        FileListingService.FileEntry[] childEntrys = this.mTestDevice.getFileChildren(this.mFileEntry);
        HashMap<String, IFileEntry> childMap = new HashMap<String, IFileEntry>(childEntrys.length);
        for (FileListingService.FileEntry entry : childEntrys) {
            childMap.put(entry.getName(), new FileEntryWrapper(this.mTestDevice, entry));
        }
        return childMap;
    }

    static IFileEntry getDescendant(IFileEntry fileEntry, List<String> childSegments) throws DeviceNotAvailableException {
        IFileEntry child = fileEntry;
        for (String childName : childSegments) {
            if (childName.length() <= 0 || (child = child.findChild(childName)) != null) continue;
            return null;
        }
        return child;
    }

    @Override
    public FileListingService.FileEntry getFileEntry() {
        return this.mFileEntry;
    }

    @Override
    public String getTime() {
        return this.mFileEntry.getTime();
    }

    @Override
    public String getDate() {
        return this.mFileEntry.getDate();
    }

    @Override
    public String getPermissions() {
        return this.mFileEntry.getPermissions();
    }
}

