/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.tradefed.device.DeviceFoldableState;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.IDeviceActionReceiver;
import com.android.tradefed.device.INativeDevice;
import com.android.tradefed.device.PackageInfo;
import com.android.tradefed.device.TestDeviceOptions;
import com.android.tradefed.device.UserInfo;
import com.android.tradefed.log.ITestLogger;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.util.Bugreport;
import com.android.tradefed.util.KeyguardControllerState;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface ITestDevice
extends INativeDevice {
    public String installPackage(File var1, boolean var2, String ... var3) throws DeviceNotAvailableException;

    public String installPackage(File var1, boolean var2, boolean var3, String ... var4) throws DeviceNotAvailableException;

    public String installPackageForUser(File var1, boolean var2, int var3, String ... var4) throws DeviceNotAvailableException;

    public String installPackageForUser(File var1, boolean var2, boolean var3, int var4, String ... var5) throws DeviceNotAvailableException;

    public String uninstallPackage(String var1) throws DeviceNotAvailableException;

    public String uninstallPackageForUser(String var1, int var2) throws DeviceNotAvailableException;

    default public String installPackages(List<File> packageFiles, boolean reinstall, String ... extraArgs) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for Package Manager's features");
    }

    default public String installPackages(List<File> packageFiles, boolean reinstall, boolean grantPermissions, String ... extraArgs) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for Package Manager's features");
    }

    default public String installPackagesForUser(List<File> packageFiles, boolean reinstall, int userId, String ... extraArgs) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for Package Manager's features");
    }

    default public String installPackagesForUser(List<File> packageFiles, boolean reinstall, boolean grantPermissions, int userId, String ... extraArgs) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for Package Manager's features");
    }

    default public String installRemotePackages(List<String> remoteApkPaths, boolean reinstall, boolean grantPermissions, String ... extraArgs) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for Package Manager's features");
    }

    default public String installRemotePackages(List<String> remoteApkPaths, boolean reinstall, String ... extraArgs) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for Package Manager's features");
    }

    public InputStreamSource getScreenshot() throws DeviceNotAvailableException;

    public InputStreamSource getScreenshot(String var1) throws DeviceNotAvailableException;

    public InputStreamSource getScreenshot(String var1, boolean var2) throws DeviceNotAvailableException;

    public InputStreamSource getScreenshot(long var1) throws DeviceNotAvailableException;

    public void clearLastConnectedWifiNetwork();

    public boolean connectToWifiNetwork(String var1, String var2) throws DeviceNotAvailableException;

    public boolean connectToWifiNetwork(String var1, String var2, boolean var3) throws DeviceNotAvailableException;

    public boolean connectToWifiNetwork(Map<String, String> var1) throws DeviceNotAvailableException;

    public boolean connectToWifiNetwork(Map<String, String> var1, boolean var2) throws DeviceNotAvailableException;

    public boolean connectToWifiNetworkIfNeeded(String var1, String var2) throws DeviceNotAvailableException;

    public boolean connectToWifiNetworkIfNeeded(String var1, String var2, boolean var3) throws DeviceNotAvailableException;

    public boolean disconnectFromWifi() throws DeviceNotAvailableException;

    public boolean isWifiEnabled() throws DeviceNotAvailableException;

    public String getIpAddress() throws DeviceNotAvailableException;

    public boolean enableNetworkMonitor() throws DeviceNotAvailableException;

    public boolean disableNetworkMonitor() throws DeviceNotAvailableException;

    public boolean checkConnectivity() throws DeviceNotAvailableException;

    public boolean clearErrorDialogs() throws DeviceNotAvailableException;

    public KeyguardControllerState getKeyguardState() throws DeviceNotAvailableException;

    public TestDeviceOptions getOptions();

    public Set<String> getInstalledPackageNames() throws DeviceNotAvailableException;

    public boolean isPackageInstalled(String var1) throws DeviceNotAvailableException;

    public boolean isPackageInstalled(String var1, String var2) throws DeviceNotAvailableException;

    public Set<ApexInfo> getActiveApexes() throws DeviceNotAvailableException;

    public Set<String> getMainlineModuleInfo() throws DeviceNotAvailableException;

    public Set<String> getUninstallablePackageNames() throws DeviceNotAvailableException;

    public PackageInfo getAppPackageInfo(String var1) throws DeviceNotAvailableException;

    public List<PackageInfo> getAppPackageInfos() throws DeviceNotAvailableException;

    public boolean isMultiUserSupported() throws DeviceNotAvailableException;

    public boolean isHeadlessSystemUserMode() throws DeviceNotAvailableException;

    public boolean canSwitchToHeadlessSystemUser() throws DeviceNotAvailableException;

    public boolean isMainUserPermanentAdmin() throws DeviceNotAvailableException;

    public int createUser(String var1) throws DeviceNotAvailableException, IllegalStateException;

    public int createUser(String var1, boolean var2, boolean var3) throws DeviceNotAvailableException, IllegalStateException;

    public int createUser(String var1, boolean var2, boolean var3, boolean var4) throws DeviceNotAvailableException, IllegalStateException;

    public int createUserNoThrow(String var1) throws DeviceNotAvailableException;

    public boolean removeUser(int var1) throws DeviceNotAvailableException;

    public ArrayList<Integer> listUsers() throws DeviceNotAvailableException;

    public Map<Integer, UserInfo> getUserInfos() throws DeviceNotAvailableException;

    public int getMaxNumberOfUsersSupported() throws DeviceNotAvailableException;

    public int getMaxNumberOfRunningUsersSupported() throws DeviceNotAvailableException;

    public boolean startUser(int var1) throws DeviceNotAvailableException;

    public boolean startUser(int var1, boolean var2) throws DeviceNotAvailableException;

    public boolean startVisibleBackgroundUser(int var1, int var2, boolean var3) throws DeviceNotAvailableException;

    public boolean stopUser(int var1) throws DeviceNotAvailableException;

    public boolean stopUser(int var1, boolean var2, boolean var3) throws DeviceNotAvailableException;

    public boolean isVisibleBackgroundUsersSupported() throws DeviceNotAvailableException;

    public boolean isVisibleBackgroundUsersOnDefaultDisplaySupported() throws DeviceNotAvailableException;

    public Integer getPrimaryUserId() throws DeviceNotAvailableException;

    public Integer getMainUserId() throws DeviceNotAvailableException;

    public int getCurrentUser() throws DeviceNotAvailableException;

    public boolean isUserVisible(int var1) throws DeviceNotAvailableException;

    public boolean isUserVisibleOnDisplay(int var1, int var2) throws DeviceNotAvailableException;

    public int getUserFlags(int var1) throws DeviceNotAvailableException;

    public boolean isUserSecondary(int var1) throws DeviceNotAvailableException;

    public int getUserSerialNumber(int var1) throws DeviceNotAvailableException;

    public boolean switchUser(int var1) throws DeviceNotAvailableException;

    public boolean switchUser(int var1, long var2) throws DeviceNotAvailableException;

    public boolean isUserRunning(int var1) throws DeviceNotAvailableException;

    public boolean hasFeature(String var1) throws DeviceNotAvailableException;

    public String getSetting(String var1, String var2) throws DeviceNotAvailableException;

    public String getSetting(int var1, String var2, String var3) throws DeviceNotAvailableException;

    public Map<String, String> getAllSettings(String var1) throws DeviceNotAvailableException;

    public void setSetting(String var1, String var2, String var3) throws DeviceNotAvailableException;

    public void setSetting(int var1, String var2, String var3, String var4) throws DeviceNotAvailableException;

    public String getAndroidId(int var1) throws DeviceNotAvailableException;

    public Map<Integer, String> getAndroidIds() throws DeviceNotAvailableException;

    public boolean setDeviceOwner(String var1, int var2) throws DeviceNotAvailableException;

    public boolean removeAdmin(String var1, int var2) throws DeviceNotAvailableException;

    public void removeOwners() throws DeviceNotAvailableException;

    public void disableKeyguard() throws DeviceNotAvailableException;

    public File dumpHeap(String var1, String var2) throws DeviceNotAvailableException;

    public Set<Long> listDisplayIds() throws DeviceNotAvailableException;

    public Set<Integer> listDisplayIdsForStartingVisibleBackgroundUsers() throws DeviceNotAvailableException;

    public Set<DeviceFoldableState> getFoldableStates() throws DeviceNotAvailableException;

    public DeviceFoldableState getCurrentFoldableState() throws DeviceNotAvailableException;

    public boolean doesFileExist(String var1, int var2) throws DeviceNotAvailableException;

    public void registerDeviceActionReceiver(IDeviceActionReceiver var1);

    public void deregisterDeviceActionReceiver(IDeviceActionReceiver var1);

    public InputStreamSource getBugreport();

    public InputStreamSource getBugreportz();

    public boolean logBugreport(String var1, ITestLogger var2);

    public Bugreport takeBugreport();

    public static class ApexInfo {
        public final String name;
        public final long versionCode;
        public final String sourceDir;

        public ApexInfo(String name, long versionCode, String sourceDir) {
            this.name = name;
            this.versionCode = versionCode;
            this.sourceDir = sourceDir;
        }

        public ApexInfo(String name, long versionCode) {
            this(name, versionCode, "");
        }

        public boolean equals(Object other) {
            if (other != null && other instanceof ApexInfo) {
                ApexInfo ai = (ApexInfo)other;
                return this.name.equals(ai.name) && this.versionCode == ai.versionCode;
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return "packageName: " + this.name + ", versionCode: " + this.versionCode + ", sourceDir: " + this.sourceDir;
        }
    }

    public static class MountPointInfo {
        public String filesystem;
        public String mountpoint;
        public String type;
        public List<String> options;

        public MountPointInfo() {
        }

        public MountPointInfo(String filesystem, String mountpoint, String type, List<String> options) {
            this.filesystem = filesystem;
            this.mountpoint = mountpoint;
            this.type = type;
            this.options = options;
        }

        public MountPointInfo(String filesystem, String mountpoint, String type, String optString) {
            this(filesystem, mountpoint, type, MountPointInfo.splitMountOptions(optString));
        }

        public static List<String> splitMountOptions(String options) {
            List<String> list2 = Arrays.asList(options.split(","));
            return list2;
        }

        public String toString() {
            return String.format("%s %s %s %s", this.filesystem, this.mountpoint, this.type, this.options);
        }
    }

    public static enum RecoveryMode {
        NONE,
        ONLINE,
        AVAILABLE;

    }
}

