/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.tradefed.build.BuildInfoKey;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.IDeviceMonitor;
import com.android.tradefed.device.IDeviceStateMonitor;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.RemoteAndroidDevice;
import com.android.tradefed.device.StubLocalAndroidVirtualDevice;
import com.android.tradefed.device.TestDeviceOptions;
import com.android.tradefed.device.cloud.GceAvdInfo;
import com.android.tradefed.device.connection.AdbTcpConnection;
import com.android.tradefed.device.connection.DefaultConnection;
import com.android.tradefed.log.ITestLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ITestLoggerReceiver;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.MultiMap;
import com.android.tradefed.util.TarUtil;
import com.android.tradefed.util.ZipUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.net.HostAndPort;
import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class LocalAndroidVirtualDevice
extends RemoteAndroidDevice
implements ITestLoggerReceiver {
    private static final int INVALID_PORT = 0;
    private static final String ANDROID_SOONG_HOST_OUT = "ANDROID_SOONG_HOST_OUT";
    private static final String TMPDIR = "TMPDIR";
    private static final String CVD_HOST_PACKAGE_NAME = "cvd-host_package.tar.gz";
    private static final String BOOT_IMAGE_ZIP_NAME = "boot-img.zip";
    private static final String SYSTEM_IMAGE_ZIP_NAME = "system-img.zip";
    private static final String OTA_TOOLS_ZIP_NAME = "otatools.zip";
    private static final String ACLOUD_LOCAL_TOOL_OPTION = "local-tool";
    private static final String ACLOUD_LOCAL_IMAGE_OPTION = "local-image";
    private ITestLogger mTestLogger = null;
    private File mImageDir = null;
    private File mInstanceDir = null;
    private File mHostPackageDir = null;
    private File mBootImageDir = null;
    private File mSystemImageDir = null;
    private File mOtaToolsDir = null;
    private List<File> mTempDirs = new ArrayList<File>();
    private GceAvdInfo mGceAvdInfo = null;
    private boolean mCanShutdown = false;

    public LocalAndroidVirtualDevice(IDevice device, IDeviceStateMonitor stateMonitor, IDeviceMonitor allocationMonitor) {
        super(device, stateMonitor, allocationMonitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void preInvocationSetup(IBuildInfo info, MultiMap<String, String> attributes) throws TargetSetupError, DeviceNotAvailableException {
        this.resetAttributes();
        super.preInvocationSetup(info, attributes);
        this.prepareToolsAndImages(info);
        CommandResult result = null;
        File report = null;
        try {
            report = FileUtil.createTempFile("report", ".json");
            result = this.acloudCreate(report, this.getOptions());
            this.loadAvdInfo(report);
        }
        catch (IOException ex) {
            throw new TargetSetupError("Cannot create acloud report file.", (Throwable)ex, this.getDeviceDescriptor(), InfraErrorIdentifier.FAIL_TO_CREATE_FILE);
        }
        finally {
            FileUtil.deleteFile(report);
        }
        if (!CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
            throw new TargetSetupError(String.format("Cannot execute acloud command. stderr:\n%s", result.getStderr()), this.getDeviceDescriptor(), (ErrorIdentifier)InfraErrorIdentifier.ACLOUD_UNDETERMINED);
        }
        HostAndPort hostAndPort = this.mGceAvdInfo.hostAndPort();
        this.replaceStubDevice(hostAndPort.toString());
        ITestDevice.RecoveryMode previousMode = this.getRecoveryMode();
        try {
            this.setRecoveryMode(ITestDevice.RecoveryMode.NONE);
            if (!this.adbTcpConnect(hostAndPort.getHost(), Integer.toString(hostAndPort.getPort()))) {
                throw new TargetSetupError(String.format("Cannot connect to %s.", hostAndPort), this.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.FAILED_TO_CONNECT_TO_GCE);
            }
            this.waitForDeviceAvailable();
        }
        finally {
            this.setRecoveryMode(previousMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void postInvocationTearDown(Throwable exception) {
        String instanceName;
        HostAndPort hostAndPort;
        block4: {
            TestDeviceOptions options = this.getOptions();
            hostAndPort = this.getHostAndPortFromAvdInfo();
            instanceName = this.mGceAvdInfo != null ? this.mGceAvdInfo.instanceName() : null;
            try {
                this.shutdown();
                this.reportInstanceLogs();
                this.restoreStubDevice();
                if (options.shouldSkipTearDown()) break block4;
                this.deleteTempDirs();
            }
            catch (Throwable throwable) {
                this.restoreStubDevice();
                if (!options.shouldSkipTearDown()) {
                    this.deleteTempDirs();
                } else {
                    LogUtil.CLog.i("Skip deleting the temporary directories.\nAddress: %s\nName: %s\nHost package: %s\nImage: %s\nInstance: %s\nBoot image: %s\nSystem image: %s\nOTA tools: %s", hostAndPort, instanceName, this.mHostPackageDir, this.mImageDir, this.mInstanceDir, this.mBootImageDir, this.mSystemImageDir, this.mOtaToolsDir);
                }
                this.resetAttributes();
                super.postInvocationTearDown(exception);
                throw throwable;
            }
        }
        LogUtil.CLog.i("Skip deleting the temporary directories.\nAddress: %s\nName: %s\nHost package: %s\nImage: %s\nInstance: %s\nBoot image: %s\nSystem image: %s\nOTA tools: %s", hostAndPort, instanceName, this.mHostPackageDir, this.mImageDir, this.mInstanceDir, this.mBootImageDir, this.mSystemImageDir, this.mOtaToolsDir);
        this.resetAttributes();
        super.postInvocationTearDown(exception);
    }

    @Override
    public void setTestLogger(ITestLogger testLogger) {
        this.mTestLogger = testLogger;
        super.setTestLogger(testLogger);
    }

    private File extractArchive(File file2) throws IOException {
        if (file2.isDirectory()) {
            return file2;
        }
        if (TarUtil.isGzip(file2)) {
            file2 = TarUtil.extractTarGzipToTemp(file2, file2.getName());
            this.mTempDirs.add(file2);
        } else if (ZipUtil.isZipFileValid(file2, false)) {
            file2 = ZipUtil.extractZipToTemp(file2, file2.getName());
            this.mTempDirs.add(file2);
        } else {
            LogUtil.CLog.w("Cannot extract %s.", file2);
        }
        return file2;
    }

    private File findAndExtractFile(IBuildInfo buildInfo, String fileKey) throws TargetSetupError {
        File file2 = buildInfo.getFile(fileKey);
        try {
            return file2 != null ? this.extractArchive(file2) : null;
        }
        catch (IOException ex) {
            throw new TargetSetupError(String.format("Cannot extract %s.", fileKey), (Throwable)ex, this.getDeviceDescriptor(), InfraErrorIdentifier.FAIL_TO_CREATE_FILE);
        }
    }

    private File findAndExtractFile(IBuildInfo buildInfo, String fileKey, String envVar) throws TargetSetupError {
        File dir = this.findAndExtractFile(buildInfo, fileKey);
        if (dir != null) {
            return dir;
        }
        String envDir = System.getenv(envVar);
        if (!Strings.isNullOrEmpty(envDir)) {
            dir = new File(envDir);
            if (dir.isDirectory()) {
                LogUtil.CLog.i("Use the files in %s as the build info does not provide %s.", envVar, fileKey);
                return dir;
            }
            LogUtil.CLog.w("Cannot use the files in %s as it is not a directory.", envVar);
        }
        return null;
    }

    private File createTempDir() throws TargetSetupError {
        try {
            File tempDir = FileUtil.createTempDir("LocalVirtualDevice");
            this.mTempDirs.add(tempDir);
            return tempDir;
        }
        catch (IOException ex) {
            throw new TargetSetupError("Cannot create temporary directory.", (Throwable)ex, this.getDeviceDescriptor(), InfraErrorIdentifier.FAIL_TO_CREATE_FILE);
        }
    }

    private void prepareToolsAndImages(IBuildInfo info) throws TargetSetupError {
        MultiMap<String, File> fileMap = this.getOptions().getGceDriverFileParams();
        try {
            this.mHostPackageDir = this.findAndExtractFile(info, CVD_HOST_PACKAGE_NAME, ANDROID_SOONG_HOST_OUT);
            if (this.mHostPackageDir == null && !fileMap.containsKey(ACLOUD_LOCAL_TOOL_OPTION)) {
                throw new TargetSetupError(String.format("Cannot find %s in build info and %s.", CVD_HOST_PACKAGE_NAME, ANDROID_SOONG_HOST_OUT), this.getDeviceDescriptor(), (ErrorIdentifier)InfraErrorIdentifier.CONFIGURED_ARTIFACT_NOT_FOUND);
            }
            this.mImageDir = this.findAndExtractFile(info, BuildInfoKey.BuildInfoFileKey.DEVICE_IMAGE.getFileKey());
            if (this.mImageDir == null && !fileMap.containsKey(ACLOUD_LOCAL_IMAGE_OPTION)) {
                throw new TargetSetupError("Cannot find image zip in build info.", this.getDeviceDescriptor(), (ErrorIdentifier)InfraErrorIdentifier.CONFIGURED_ARTIFACT_NOT_FOUND);
            }
            this.mBootImageDir = this.findAndExtractFile(info, BOOT_IMAGE_ZIP_NAME);
            this.mSystemImageDir = this.findAndExtractFile(info, SYSTEM_IMAGE_ZIP_NAME);
            this.mOtaToolsDir = this.findAndExtractFile(info, OTA_TOOLS_ZIP_NAME);
            this.mInstanceDir = this.createTempDir();
        }
        catch (TargetSetupError ex) {
            this.deleteTempDirs();
            throw ex;
        }
        if (this.mOtaToolsDir != null) {
            FileUtil.chmodRWXRecursively(new File(this.mOtaToolsDir, "bin"));
        }
        if (this.mHostPackageDir != null) {
            FileUtil.chmodRWXRecursively(new File(this.mHostPackageDir, "bin"));
        }
        if (fileMap.containsKey(ACLOUD_LOCAL_TOOL_OPTION)) {
            for (File toolDir : fileMap.get(ACLOUD_LOCAL_TOOL_OPTION)) {
                FileUtil.chmodRWXRecursively(new File(toolDir, "bin"));
            }
        }
    }

    private void resetAttributes() {
        this.mTempDirs.clear();
        this.mImageDir = null;
        this.mInstanceDir = null;
        this.mHostPackageDir = null;
        this.mBootImageDir = null;
        this.mSystemImageDir = null;
        this.mOtaToolsDir = null;
        this.mGceAvdInfo = null;
        this.mCanShutdown = false;
    }

    @VisibleForTesting
    void deleteTempDirs() {
        for (File tempDir : this.mTempDirs) {
            FileUtil.recursiveDelete(tempDir);
        }
        this.mTempDirs.clear();
    }

    private void replaceStubDevice(String newSerialNumber) throws TargetSetupError {
        IDevice device = this.getIDevice();
        if (!StubLocalAndroidVirtualDevice.class.equals(device.getClass())) {
            throw new TargetSetupError("Unexpected device type: " + device.getClass(), this.getDeviceDescriptor(), (ErrorIdentifier)InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
        }
        this.setIDevice(new StubLocalAndroidVirtualDevice(newSerialNumber, ((DefaultConnection)this.getConnection()).getInitialDeviceNumOffset()));
        this.setFastbootEnabled(false);
    }

    private void restoreStubDevice() {
        this.setIDevice(new StubLocalAndroidVirtualDevice(((DefaultConnection)this.getConnection()).getInitialSerial(), ((DefaultConnection)this.getConnection()).getInitialDeviceNumOffset()));
        this.setFastbootEnabled(false);
    }

    private List<String> getAcloudFileArgs(MultiMap<String, File> fileMap) {
        ArrayList<String> args = new ArrayList<String>();
        if (this.mImageDir != null) {
            args.add("--local-image");
            args.add(this.mImageDir.getAbsolutePath());
        }
        if (this.mHostPackageDir != null) {
            args.add("--local-tool");
            args.add(this.mHostPackageDir.getAbsolutePath());
        }
        if (this.mBootImageDir != null) {
            args.add("--local-boot-image");
            args.add(this.mBootImageDir.getAbsolutePath());
        }
        if (this.mSystemImageDir != null) {
            args.add("--local-system-image");
            args.add(this.mSystemImageDir.getAbsolutePath());
        }
        if (this.mOtaToolsDir != null) {
            args.add("--local-tool");
            args.add(this.mOtaToolsDir.getAbsolutePath());
        }
        for (Map.Entry<String, File> entry : fileMap.entries()) {
            args.add("--" + entry.getKey());
            args.add(entry.getValue().getAbsolutePath());
        }
        return args;
    }

    private static void addLogLevelToAcloudCommand(List<String> command, Log.LogLevel logLevel) {
        if (Log.LogLevel.VERBOSE.equals((Object)logLevel)) {
            command.add("-v");
        } else if (Log.LogLevel.DEBUG.equals((Object)logLevel)) {
            command.add("-vv");
        }
    }

    private CommandResult acloudCreate(File report, TestDeviceOptions options) {
        CommandResult result = null;
        File acloud = options.getAvdDriverBinary();
        if (acloud == null || !acloud.isFile()) {
            LogUtil.CLog.e("Specified AVD driver binary is not a file.");
            result = new CommandResult(CommandStatus.EXCEPTION);
            result.setStderr("Specified AVD driver binary is not a file.");
            return result;
        }
        acloud.setExecutable(true);
        for (int attempt = 0; attempt < options.getGceMaxAttempt() && !CommandStatus.SUCCESS.equals((Object)(result = this.acloudCreate(options.getGceCmdTimeout(), acloud, report, options.getGceDriverLogLevel(), options.getGceDriverFileParams(), options.getGceDriverParams())).getStatus()); ++attempt) {
            LogUtil.CLog.w("Failed to start local virtual instance with attempt: %d; command status: %s", new Object[]{attempt, result.getStatus()});
        }
        return result;
    }

    private CommandResult acloudCreate(long timeout, File acloud, File report, Log.LogLevel logLevel, MultiMap<String, File> fileMap, List<String> args) {
        IRunUtil runUtil = this.createRunUtil();
        runUtil.setEnvVariable(TMPDIR, new File(System.getProperty("java.io.tmpdir")).getAbsolutePath());
        ArrayList<String> command = new ArrayList<String>(Arrays.asList(acloud.getAbsolutePath(), "create", "--local-instance", Integer.toString(((DefaultConnection)this.getConnection()).getInitialDeviceNumOffset() + 1), "--local-instance-dir", this.mInstanceDir.getAbsolutePath(), "--report_file", report.getAbsolutePath(), "--no-autoconnect", "--yes", "--skip-pre-run-check"));
        LocalAndroidVirtualDevice.addLogLevelToAcloudCommand(command, logLevel);
        command.addAll(this.getAcloudFileArgs(fileMap));
        command.addAll(args);
        this.mCanShutdown = true;
        CommandResult result = runUtil.runTimedCmd(timeout, command.toArray(new String[0]));
        LogUtil.CLog.i("acloud create stdout:\n%s", result.getStdout());
        LogUtil.CLog.i("acloud create stderr:\n%s", result.getStderr());
        return result;
    }

    private HostAndPort getHostAndPortFromAvdInfo() {
        if (this.mGceAvdInfo == null) {
            return null;
        }
        HostAndPort hostAndPort = this.mGceAvdInfo.hostAndPort();
        if (hostAndPort == null || !hostAndPort.hasPort() || hostAndPort.getPort() == 0) {
            return null;
        }
        return hostAndPort;
    }

    private void loadAvdInfo(File report) throws TargetSetupError {
        this.mGceAvdInfo = GceAvdInfo.parseGceInfoFromFile(report, this.getDeviceDescriptor(), 0);
        if (this.mGceAvdInfo == null) {
            throw new TargetSetupError("Cannot read acloud report file.", this.getDeviceDescriptor(), (ErrorIdentifier)InfraErrorIdentifier.NO_ACLOUD_REPORT);
        }
        if (!GceAvdInfo.GceStatus.SUCCESS.equals((Object)this.mGceAvdInfo.getStatus())) {
            throw new TargetSetupError("Cannot launch virtual device: " + this.mGceAvdInfo.getErrors(), this.getDeviceDescriptor(), this.mGceAvdInfo.getErrorType());
        }
        if (Strings.isNullOrEmpty(this.mGceAvdInfo.instanceName())) {
            throw new TargetSetupError("No instance name in acloud report.", this.getDeviceDescriptor(), (ErrorIdentifier)InfraErrorIdentifier.NO_ACLOUD_REPORT);
        }
        if (this.getHostAndPortFromAvdInfo() == null) {
            throw new TargetSetupError("No port in acloud report.", this.getDeviceDescriptor(), (ErrorIdentifier)InfraErrorIdentifier.NO_ACLOUD_REPORT);
        }
    }

    public synchronized void shutdown() {
        String instanceName;
        TestDeviceOptions options = this.getOptions();
        if (!this.mCanShutdown || options.shouldSkipTearDown()) {
            LogUtil.CLog.i("Skip shutting down the virtual device.");
            return;
        }
        this.mCanShutdown = false;
        HostAndPort hostAndPort = this.getHostAndPortFromAvdInfo();
        String string = instanceName = this.mGceAvdInfo != null ? this.mGceAvdInfo.instanceName() : null;
        if (hostAndPort != null) {
            if (!this.adbTcpDisconnect(hostAndPort.getHost(), Integer.toString(hostAndPort.getPort()))) {
                LogUtil.CLog.e("Cannot disconnect from %s", hostAndPort.toString());
            }
        } else {
            LogUtil.CLog.i("Skip disconnecting.");
        }
        if (instanceName != null) {
            CommandResult result = this.acloudDelete(instanceName, options);
            if (!CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
                LogUtil.CLog.e("Cannot stop the virtual device.");
            }
        } else {
            LogUtil.CLog.i("Skip acloud delete.");
        }
    }

    private CommandResult acloudDelete(String instanceName, TestDeviceOptions options) {
        File acloud = options.getAvdDriverBinary();
        if (acloud == null || !acloud.isFile()) {
            LogUtil.CLog.e("Specified AVD driver binary is not a file.");
            return new CommandResult(CommandStatus.EXCEPTION);
        }
        acloud.setExecutable(true);
        IRunUtil runUtil = this.createRunUtil();
        runUtil.setEnvVariable(TMPDIR, new File(System.getProperty("java.io.tmpdir")).getAbsolutePath());
        ArrayList<String> command = new ArrayList<String>(Arrays.asList(acloud.getAbsolutePath(), "delete", "--local-only", "--instance-names", instanceName));
        LocalAndroidVirtualDevice.addLogLevelToAcloudCommand(command, options.getGceDriverLogLevel());
        CommandResult result = runUtil.runTimedCmd(options.getGceCmdTimeout(), command.toArray(new String[0]));
        LogUtil.CLog.i("acloud delete stdout:\n%s", result.getStdout());
        LogUtil.CLog.i("acloud delete stderr:\n%s", result.getStderr());
        return result;
    }

    private void reportInstanceLogs() {
        if (this.mTestLogger == null || this.mInstanceDir == null || this.mGceAvdInfo == null) {
            return;
        }
        Path realInstanceDir = null;
        try {
            realInstanceDir = this.mInstanceDir.toPath().toRealPath(new LinkOption[0]);
        }
        catch (IOException ex) {
            LogUtil.CLog.e(ex);
            return;
        }
        for (GceAvdInfo.LogFileEntry log : this.mGceAvdInfo.getLogs()) {
            File file2 = new File(log.path);
            if (file2.exists()) {
                try (FileInputStreamSource source = new FileInputStreamSource(file2);){
                    if (file2.toPath().toRealPath(new LinkOption[0]).startsWith(realInstanceDir)) {
                        this.mTestLogger.testLog(Strings.isNullOrEmpty(log.name) ? file2.getName() : log.name, log.type, source);
                        continue;
                    }
                    LogUtil.CLog.w("%s is not in instance directory.", file2.getAbsolutePath());
                }
                catch (IOException ex) {
                    LogUtil.CLog.e(ex);
                }
                continue;
            }
            LogUtil.CLog.w("%s doesn't exist.", file2.getAbsolutePath());
        }
    }

    public boolean adbTcpConnect(String host, String port) {
        AdbTcpConnection conn = new AdbTcpConnection(new DefaultConnection.ConnectionBuilder(this.getRunUtil(), this, null, this.mTestLogger));
        return conn.adbTcpConnect(host, port);
    }

    public boolean adbTcpDisconnect(String host, String port) {
        AdbTcpConnection conn = new AdbTcpConnection(new DefaultConnection.ConnectionBuilder(this.getRunUtil(), this, null, this.mTestLogger));
        return conn.adbTcpDisconnect(host, port);
    }
}

