/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.tradefed.device.BackgroundDeviceAction;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ILogcatReceiver;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.LargeOutputReceiver;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.util.SystemUtil;
import com.google.errorprone.annotations.MustBeClosed;

public class LogcatReceiver
implements ILogcatReceiver {
    private BackgroundDeviceAction mDeviceAction;
    private LargeOutputReceiver mReceiver;
    private static final String LOGCAT_DESC = "logcat";

    public LogcatReceiver(ITestDevice device, String logcatCmd, long maxFileSize, int logStartDelay) {
        this.mReceiver = new LargeOutputReceiver(LOGCAT_DESC, device.getSerialNumber(), maxFileSize);
        this.mDeviceAction = new BackgroundDeviceAction(logcatCmd, LOGCAT_DESC, device, this.mReceiver, logStartDelay);
    }

    public LogcatReceiver(ITestDevice device, long maxFileSize, int logStartDelay) {
        this(device, LogcatReceiver.getDefaultLogcatCmd(device), maxFileSize, logStartDelay);
    }

    @Override
    public void start() {
        this.mDeviceAction.start();
    }

    @Override
    public void stop() {
        this.mDeviceAction.cancel();
        this.mReceiver.cancel();
        this.mReceiver.delete();
    }

    @Override
    @MustBeClosed
    public InputStreamSource getLogcatData() {
        return this.mReceiver.getData();
    }

    @Override
    @MustBeClosed
    public InputStreamSource getLogcatData(int maxBytes) {
        return this.mReceiver.getData(maxBytes);
    }

    @Override
    public InputStreamSource getLogcatData(int maxBytes, int offset) {
        return this.mReceiver.getData(maxBytes, offset);
    }

    @Override
    public void clear() {
        this.mReceiver.clear();
    }

    public static String getDefaultLogcatCmd(ITestDevice device) {
        String logcatCmd = "logcat -v threadtime";
        try {
            if (SystemUtil.isLocalMode() || device.getApiLevel() >= 24) {
                logcatCmd = logcatCmd + ",uid";
            }
        }
        catch (DeviceNotAvailableException e) {
            LogUtil.CLog.e("Use logcat command without UID format due to: ");
            LogUtil.CLog.e(e);
        }
        return logcatCmd;
    }
}

