/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.IDevice;
import com.android.tradefed.device.DeviceAllocationState;
import com.android.tradefed.device.DeviceEvent;
import com.android.tradefed.device.DeviceManager;
import com.android.tradefed.device.IDeviceSelection;
import com.android.tradefed.device.IManagedTestDevice;
import com.android.tradefed.device.IManagedTestDeviceFactory;
import com.android.tradefed.device.NullDevice;
import com.android.tradefed.device.TestDeviceState;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.ConditionPriorityBlockingQueue;
import com.google.api.client.util.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.GuardedBy;

class ManagedDeviceList
implements Iterable<IManagedTestDevice> {
    private static final Pattern IP_PATTERN = Pattern.compile("((^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5]))|(localhost)){1}");
    private static final Set<String> RESERVED_IP = ImmutableSet.of("127.0.0.1", "0.0.0.0", "localhost");
    private final ReentrantLock mListLock = new ReentrantLock(true);
    @GuardedBy(value="mListLock")
    private List<IManagedTestDevice> mList = new LinkedList<IManagedTestDevice>();
    private final IManagedTestDeviceFactory mDeviceFactory;

    public ManagedDeviceList(IManagedTestDeviceFactory d) {
        this.mDeviceFactory = d;
    }

    @Override
    public Iterator<IManagedTestDevice> iterator() {
        return this.getCopy().iterator();
    }

    List<IManagedTestDevice> getCopy() {
        this.mListLock.lock();
        try {
            ArrayList<IManagedTestDevice> l = new ArrayList<IManagedTestDevice>(this.size());
            l.addAll(this.mList);
            ArrayList<IManagedTestDevice> arrayList = l;
            return arrayList;
        }
        finally {
            this.mListLock.unlock();
        }
    }

    public int size() {
        this.mListLock.lock();
        try {
            int n = this.mList.size();
            return n;
        }
        finally {
            this.mListLock.unlock();
        }
    }

    public IManagedTestDevice find(final String serialNumber) {
        return this.find(new ConditionPriorityBlockingQueue.IMatcher<IManagedTestDevice>(){

            @Override
            public boolean matches(IManagedTestDevice element) {
                return serialNumber.equals(element.getSerialNumber());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IManagedTestDevice find(ConditionPriorityBlockingQueue.IMatcher<IManagedTestDevice> m) {
        this.mListLock.lock();
        try {
            for (IManagedTestDevice d : this.mList) {
                if (!m.matches(d)) continue;
                IManagedTestDevice iManagedTestDevice = d;
                return iManagedTestDevice;
            }
        }
        finally {
            this.mListLock.unlock();
        }
        return null;
    }

    private boolean isValidDeviceSerial(String serial) {
        return serial.length() > 1 && !serial.contains("?");
    }

    private boolean isTcpDeviceSerial(String serialString) {
        String[] serial = serialString.split(":");
        if (serial.length == 2) {
            if (RESERVED_IP.contains(serial[0])) {
                return false;
            }
            Matcher match = IP_PATTERN.matcher(serial[0]);
            if (!match.find()) {
                return false;
            }
            try {
                Integer.parseInt(serial[1]);
                return true;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFastbootStates(Set<String> serials, boolean isFastbootD) {
        ArrayList<IManagedTestDevice> toRemove = new ArrayList<IManagedTestDevice>();
        this.mListLock.lock();
        try {
            TestDeviceState state = TestDeviceState.FASTBOOT;
            if (isFastbootD) {
                state = TestDeviceState.FASTBOOTD;
            }
            for (IManagedTestDevice d : this.mList) {
                String serial = d.getSerialNumber();
                if (serials.contains(serial)) {
                    d.setDeviceState(state);
                    continue;
                }
                if (!state.equals((Object)d.getDeviceState())) continue;
                d.setDeviceState(TestDeviceState.NOT_AVAILABLE);
                LogUtil.CLog.d("Device %s was in %s and not found anymore", new Object[]{serial, state});
                toRemove.add(d);
            }
        }
        finally {
            this.mListLock.unlock();
        }
        for (IManagedTestDevice d : toRemove) {
            this.handleDeviceEvent(d, DeviceEvent.DISCONNECTED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IManagedTestDevice allocate(IDeviceSelection options) {
        AllocationMatcher m = new AllocationMatcher(options);
        this.mListLock.lock();
        try {
            if (options.getBaseDeviceTypeRequested() != null) {
                String rand = UUID.randomUUID().toString();
                String serial = String.format("%s%s", "base-request-null-device-", rand);
                IManagedTestDevice specificDevice = this.mDeviceFactory.createRequestedDevice(new NullDevice(serial, true), options);
                this.handleDeviceEvent(specificDevice, DeviceEvent.FORCE_AVAILABLE);
                specificDevice.handleAllocationEvent(DeviceEvent.FORCE_ALLOCATE_REQUEST);
                this.mList.add(specificDevice);
                IManagedTestDevice iManagedTestDevice = specificDevice;
                return iManagedTestDevice;
            }
            Iterator<IManagedTestDevice> iterator2 = this.mList.iterator();
            while (iterator2.hasNext()) {
                IManagedTestDevice d = iterator2.next();
                if (!m.matches(d)) continue;
                iterator2.remove();
                this.mList.add(d);
                IManagedTestDevice iManagedTestDevice = d;
                return iManagedTestDevice;
            }
        }
        finally {
            this.mListLock.unlock();
        }
        return null;
    }

    void clear() {
        this.mListLock.lock();
        try {
            this.mList.clear();
        }
        finally {
            this.mListLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IManagedTestDevice findOrCreate(IDevice idevice) {
        String serial = idevice.getSerialNumber();
        if (!this.isValidDeviceSerial(serial)) {
            return null;
        }
        if (this.isTcpDeviceSerial(serial)) {
            try {
                String realSerial = idevice.getProperty("ro.serialno");
                if (!Strings.isNullOrEmpty(realSerial)) {
                    serial = realSerial.trim();
                }
            }
            catch (RuntimeException e) {
                LogUtil.CLog.e(e);
            }
        }
        this.mListLock.lock();
        try {
            IManagedTestDevice d = this.find(serial);
            if (d == null || DeviceAllocationState.Unavailable.equals(d.getAllocationState())) {
                this.mList.remove(d);
                d = this.mDeviceFactory.createDevice(idevice);
                this.mList.add(d);
            }
            IManagedTestDevice iManagedTestDevice = d;
            return iManagedTestDevice;
        }
        finally {
            this.mListLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IManagedTestDevice findOrCreateFastboot(DeviceManager.FastbootDevice fastboot) {
        if (!this.isValidDeviceSerial(fastboot.getSerialNumber())) {
            return null;
        }
        this.mListLock.lock();
        try {
            IManagedTestDevice d = this.find(fastboot.getSerialNumber());
            if (d == null) {
                this.mList.remove(d);
                d = this.mDeviceFactory.createDevice(fastboot);
                this.mList.add(d);
            }
            IManagedTestDevice iManagedTestDevice = d;
            return iManagedTestDevice;
        }
        finally {
            this.mListLock.unlock();
        }
    }

    public IManagedTestDevice forceAllocate(String serial) {
        if (!this.isValidDeviceSerial(serial)) {
            return null;
        }
        this.mListLock.lock();
        try {
            IManagedTestDevice iManagedTestDevice = this.find(serial);
            return iManagedTestDevice;
        }
        finally {
            this.mListLock.unlock();
        }
    }

    void add(IManagedTestDevice device) {
        this.mListLock.lock();
        try {
            this.mList.add(device);
        }
        finally {
            this.mListLock.unlock();
        }
    }

    public IManagedTestDevice.DeviceEventResponse handleDeviceEvent(IManagedTestDevice d, DeviceEvent event) {
        IManagedTestDevice.DeviceEventResponse r = d.handleAllocationEvent(event);
        if (r != null && r.allocationState == DeviceAllocationState.Unknown) {
            this.remove(d);
        }
        return r;
    }

    private void remove(IManagedTestDevice d) {
        this.mListLock.lock();
        try {
            this.mList.remove(d);
        }
        finally {
            this.mListLock.unlock();
        }
    }

    private static class AllocationMatcher
    implements ConditionPriorityBlockingQueue.IMatcher<IManagedTestDevice> {
        private IDeviceSelection mDeviceSelectionMatcher;

        AllocationMatcher(IDeviceSelection options) {
            this.mDeviceSelectionMatcher = options;
        }

        @Override
        public boolean matches(IManagedTestDevice element) {
            if (this.mDeviceSelectionMatcher.matches(element.getIDevice())) {
                boolean res;
                DeviceEvent event = DeviceEvent.ALLOCATE_REQUEST;
                if (!this.mDeviceSelectionMatcher.getSerials().isEmpty()) {
                    event = DeviceEvent.EXPLICIT_ALLOCATE_REQUEST;
                }
                IManagedTestDevice.DeviceEventResponse r = element.handleAllocationEvent(event);
                boolean bl = res = r.stateChanged && r.allocationState == DeviceAllocationState.Allocated;
                if (!res) {
                    this.mDeviceSelectionMatcher.getNoMatchReason().put("already_allocated", String.format("Device %s is matching but already allocated.", element.getIDevice().getSerialNumber()));
                }
                return res;
            }
            return false;
        }
    }
}

