/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.IDevice;
import com.android.tradefed.device.CollectingOutputReceiver;
import com.android.tradefed.device.DeviceManager;
import com.android.tradefed.device.DeviceStateMonitor;
import com.android.tradefed.device.IDeviceManager;
import com.android.tradefed.device.IDeviceMonitor;
import com.android.tradefed.device.IDeviceSelection;
import com.android.tradefed.device.IManagedTestDevice;
import com.android.tradefed.device.IManagedTestDeviceFactory;
import com.android.tradefed.device.LocalAndroidVirtualDevice;
import com.android.tradefed.device.NativeDevice;
import com.android.tradefed.device.NativeDeviceStateMonitor;
import com.android.tradefed.device.RemoteAndroidDevice;
import com.android.tradefed.device.RemoteAvdIDevice;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.device.StubLocalAndroidVirtualDevice;
import com.android.tradefed.device.TcpDevice;
import com.android.tradefed.device.TestDevice;
import com.android.tradefed.device.TestDeviceState;
import com.android.tradefed.device.cloud.ManagedRemoteDevice;
import com.android.tradefed.device.cloud.NestedDeviceStateMonitor;
import com.android.tradefed.device.cloud.NestedRemoteDevice;
import com.android.tradefed.device.cloud.RemoteAndroidVirtualDevice;
import com.android.tradefed.device.cloud.VmRemoteDevice;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.SystemUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ManagedTestDeviceFactory
implements IManagedTestDeviceFactory {
    public static final String NOTIFY_AS_NATIVE = "NOTIFY_AS_NATIVE";
    public static final String IPADDRESS_PATTERN = "((^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5]))|(localhost)){1}";
    protected boolean mFastbootEnabled;
    protected IDeviceManager mDeviceManager;
    protected IDeviceMonitor mAllocationMonitor;
    protected static final String CHECK_PM_CMD = "ls %s";
    protected static final String EXPECTED_RES = "/system/bin/pm";
    protected static final String EXPECTED_ERROR = "No such file or directory";
    protected static final long FRAMEWORK_CHECK_SLEEP_MS = 500L;
    protected static final int FRAMEWORK_CHECK_MAX_RETRY = 3;

    public ManagedTestDeviceFactory(boolean fastbootEnabled, IDeviceManager deviceManager, IDeviceMonitor allocationMonitor) {
        this.mFastbootEnabled = fastbootEnabled;
        this.mDeviceManager = deviceManager;
        this.mAllocationMonitor = allocationMonitor;
    }

    @Override
    public IManagedTestDevice createRequestedDevice(IDevice idevice, IDeviceSelection options) {
        NativeDevice testDevice = null;
        if (IDeviceSelection.BaseDeviceType.NATIVE_DEVICE.equals((Object)options.getBaseDeviceTypeRequested())) {
            testDevice = new NativeDevice(idevice, new NativeDeviceStateMonitor(this.mDeviceManager, idevice, this.mFastbootEnabled), this.mAllocationMonitor);
            testDevice.setDeviceState(TestDeviceState.NOT_AVAILABLE);
        } else {
            testDevice = new TestDevice(idevice, new DeviceStateMonitor(this.mDeviceManager, idevice, this.mFastbootEnabled), this.mAllocationMonitor);
            testDevice.setDeviceState(TestDeviceState.NOT_AVAILABLE);
        }
        return testDevice;
    }

    @Override
    public IManagedTestDevice createDevice(IDevice idevice) {
        NativeDevice testDevice = null;
        if (idevice instanceof VmRemoteDevice) {
            testDevice = new ManagedRemoteDevice(idevice, new DeviceStateMonitor(this.mDeviceManager, idevice, this.mFastbootEnabled), this.mAllocationMonitor);
            testDevice.setDeviceState(TestDeviceState.NOT_AVAILABLE);
        } else if (idevice instanceof RemoteAvdIDevice) {
            testDevice = new RemoteAndroidVirtualDevice(idevice, new DeviceStateMonitor(this.mDeviceManager, idevice, this.mFastbootEnabled), this.mAllocationMonitor);
            testDevice.setDeviceState(TestDeviceState.NOT_AVAILABLE);
        } else if (idevice instanceof StubLocalAndroidVirtualDevice) {
            testDevice = new LocalAndroidVirtualDevice(idevice, new DeviceStateMonitor(this.mDeviceManager, idevice, this.mFastbootEnabled), this.mAllocationMonitor);
        } else if (idevice instanceof TcpDevice) {
            testDevice = new RemoteAndroidDevice(idevice, new DeviceStateMonitor(this.mDeviceManager, idevice, this.mFastbootEnabled), this.mAllocationMonitor);
            testDevice.setDeviceState(TestDeviceState.NOT_AVAILABLE);
        } else if (ManagedTestDeviceFactory.isTcpDeviceSerial(idevice.getSerialNumber())) {
            if (this.isRemoteEnvironment()) {
                testDevice = new NestedRemoteDevice(idevice, new NestedDeviceStateMonitor(this.mDeviceManager, idevice, this.mFastbootEnabled), this.mAllocationMonitor);
            } else {
                HashSet<String> nativeSerials = new HashSet<String>();
                if (System.getenv(NOTIFY_AS_NATIVE) != null) {
                    nativeSerials.addAll(Arrays.asList(System.getenv(NOTIFY_AS_NATIVE).split(",")));
                }
                if (nativeSerials.contains(idevice.getSerialNumber())) {
                    testDevice = new NativeDevice(idevice, new NativeDeviceStateMonitor(this.mDeviceManager, idevice, this.mFastbootEnabled), this.mAllocationMonitor);
                } else {
                    testDevice = new RemoteAndroidDevice(idevice, new DeviceStateMonitor(this.mDeviceManager, idevice, this.mFastbootEnabled), this.mAllocationMonitor);
                    testDevice.setDeviceState(TestDeviceState.NOT_AVAILABLE);
                }
            }
        } else {
            testDevice = new TestDevice(idevice, new DeviceStateMonitor(this.mDeviceManager, idevice, this.mFastbootEnabled), this.mAllocationMonitor);
        }
        if (idevice instanceof DeviceManager.FastbootDevice) {
            if (((DeviceManager.FastbootDevice)idevice).isFastbootD()) {
                testDevice.setDeviceState(TestDeviceState.FASTBOOTD);
            } else {
                testDevice.setDeviceState(TestDeviceState.FASTBOOT);
            }
        } else if (idevice instanceof StubDevice) {
            testDevice.setDeviceState(TestDeviceState.NOT_AVAILABLE);
        }
        testDevice.setFastbootEnabled(this.mFastbootEnabled);
        testDevice.setFastbootPath(this.mDeviceManager.getFastbootPath());
        return testDevice;
    }

    protected IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }

    protected boolean isRemoteEnvironment() {
        return SystemUtil.isRemoteEnvironment();
    }

    protected CollectingOutputReceiver createOutputReceiver() {
        return new CollectingOutputReceiver();
    }

    @Override
    public void setFastbootEnabled(boolean enable) {
        this.mFastbootEnabled = enable;
    }

    public static boolean isTcpDeviceSerial(String serial) {
        String remotePattern = "((^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5]))|(localhost)){1}(:)([0-9]{2,5})(\\b)";
        Pattern pattern = Pattern.compile("((^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5]))|(localhost)){1}(:)([0-9]{2,5})(\\b)");
        Matcher match = pattern.matcher(serial.trim());
        return match.find();
    }
}

