/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.device.DeviceRuntimeException;
import com.android.tradefed.device.IDeviceManager;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import java.util.Arrays;
import javax.annotation.Nonnull;

class MicrodroidHelper {
    MicrodroidHelper() {
    }

    public String runOnMicrodroid(@Nonnull String microdroidSerial, String ... cmd) {
        long timeout = 30000L;
        IDeviceManager deviceManager = GlobalConfiguration.getDeviceManagerInstance();
        CommandResult result = this.getRunUtil().runTimedCmd(30000L, deviceManager.getAdbPath(), "-s", microdroidSerial, "shell", MicrodroidHelper.join(cmd));
        if (result.getStatus() != CommandStatus.SUCCESS) {
            throw new DeviceRuntimeException(MicrodroidHelper.join(cmd) + " has failed: " + result, DeviceErrorIdentifier.SHELL_COMMAND_ERROR);
        }
        return result.getStdout().trim();
    }

    public String tryRunOnMicrodroid(@Nonnull String microdroidSerial, String ... cmd) {
        long timeout = 30000L;
        IDeviceManager deviceManager = GlobalConfiguration.getDeviceManagerInstance();
        CommandResult result = this.getRunUtil().runTimedCmd(30000L, deviceManager.getAdbPath(), "-s", microdroidSerial, "shell", MicrodroidHelper.join(cmd));
        if (result.getStatus() == CommandStatus.SUCCESS) {
            return result.getStdout().trim();
        }
        LogUtil.CLog.d(MicrodroidHelper.join(cmd) + " has failed (but ok): " + result);
        return null;
    }

    private IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }

    private static String join(String ... strs) {
        return String.join((CharSequence)" ", Arrays.asList(strs));
    }
}

