/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.FileListingService;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.InstallException;
import com.android.ddmlib.Log;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.SyncService;
import com.android.ddmlib.testrunner.IRemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.RemoteAndroidTestRunner;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.command.remote.DeviceDescriptor;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.device.CollectingOutputReceiver;
import com.android.tradefed.device.DeviceAllocationState;
import com.android.tradefed.device.DeviceEvent;
import com.android.tradefed.device.DeviceFoldableState;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.DeviceRuntimeException;
import com.android.tradefed.device.DeviceSelectionOptions;
import com.android.tradefed.device.DeviceUnresponsiveException;
import com.android.tradefed.device.FileEntryWrapper;
import com.android.tradefed.device.IDeviceActionReceiver;
import com.android.tradefed.device.IDeviceMonitor;
import com.android.tradefed.device.IDeviceRecovery;
import com.android.tradefed.device.IDeviceStateMonitor;
import com.android.tradefed.device.IFileEntry;
import com.android.tradefed.device.IManagedTestDevice;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.IWifiHelper;
import com.android.tradefed.device.LargeOutputReceiver;
import com.android.tradefed.device.LogcatReceiver;
import com.android.tradefed.device.NetworkNotAvailableException;
import com.android.tradefed.device.NullDevice;
import com.android.tradefed.device.PackageInfo;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.device.TestDeviceOptions;
import com.android.tradefed.device.TestDeviceState;
import com.android.tradefed.device.UserInfo;
import com.android.tradefed.device.WaitDeviceRecovery;
import com.android.tradefed.device.cloud.GceAvdInfo;
import com.android.tradefed.device.connection.AbstractConnection;
import com.android.tradefed.device.connection.DefaultConnection;
import com.android.tradefed.device.contentprovider.ContentProviderHandler;
import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.host.IHostOptions;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.log.ITestLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ByteArrayInputStreamSource;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ITestLifeCycleReceiver;
import com.android.tradefed.result.ITestLoggerReceiver;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.SnapshotInputStreamSource;
import com.android.tradefed.result.StubTestRunListener;
import com.android.tradefed.result.ddmlib.TestRunToTestInvocationForwarder;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.testtype.coverage.CoverageOptions;
import com.android.tradefed.util.ArrayUtil;
import com.android.tradefed.util.Bugreport;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.KeyguardControllerState;
import com.android.tradefed.util.MultiMap;
import com.android.tradefed.util.ProcessInfo;
import com.android.tradefed.util.QuotationAwareTokenizer;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.SizeLimitedOutputStream;
import com.android.tradefed.util.StringEscapeUtils;
import com.android.tradefed.util.SystemUtil;
import com.android.tradefed.util.TimeUtil;
import com.android.tradefed.util.ZipUtil2;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.FormatMethod;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Inet6Address;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class NativeDevice
implements IManagedTestDevice,
IConfigurationReceiver,
ITestLoggerReceiver {
    protected static final String SD_CARD = "/sdcard/";
    protected static final String STORAGE_EMULATED = "/storage/emulated/";
    private static final String ANRS_PATH = "/data/anr";
    private static final int LOGCAT_DUMP_TIMEOUT = 120000;
    protected static final int MAX_RETRY_ATTEMPTS = 2;
    public static final int INVALID_USER_ID = -10000;
    static final Pattern INPUT_DISPATCH_STATE_REGEX = Pattern.compile("DispatchEnabled:\\s?([01])");
    private static final Pattern KEYS_PATTERN = Pattern.compile("^.*-keys$");
    private static final Pattern DF_PATTERN = Pattern.compile("^/(\\S+)\\s+\\d+\\s+\\d+\\s+(\\d+)\\s+\\d+%\\s+/\\S*$", 8);
    protected static final long MAX_HOST_DEVICE_TIME_OFFSET = 5000L;
    private static final String ENCRYPTION_PASSWORD = "android";
    private static final int MAX_SYSTEM_SERVER_DELAY_AFTER_BOOT_UP_SEC = 25;
    private int mLogStartDelay = 5000;
    private static final int DEFAULT_UNAVAILABLE_TIMEOUT = 20000;
    private static final String SIM_STATE_PROP = "gsm.sim.state";
    private static final String SIM_OPERATOR_PROP = "gsm.operator.alpha";
    static final String MAC_ADDRESS_PATTERN = "([0-9a-fA-F]{2}:){5}[0-9a-fA-F]{2}";
    static final String MAC_ADDRESS_COMMAND = "su root cat /sys/class/net/wlan0/address";
    static final String ETHERNET_MAC_ADDRESS_COMMAND = "cat /sys/class/net/eth0/address";
    static final int ETHER_ADDR_LEN = 6;
    private static final int NETWORK_MONITOR_INTERVAL = 10000;
    private static final int WIFI_RECONNECT_CHECK_INTERVAL = 1000;
    private static final int WIFI_RECONNECT_TIMEOUT = 60000;
    private static final Pattern EXE_FILE = Pattern.compile("^[-l]r.x.+");
    private static final String TOMBSTONE_PATH = "/data/tombstones/";
    private static final long PROPERTY_GET_TIMEOUT = 45000L;
    private long mLongCmdTimeout = 1500000L;
    private static final String EXIT_STATUS_DELIMITER = "x";
    private IConfiguration mConfiguration;
    private IDevice mIDevice;
    private IDeviceRecovery mRecovery = new WaitDeviceRecovery();
    protected final IDeviceStateMonitor mStateMonitor;
    private TestDeviceState mState = TestDeviceState.ONLINE;
    private final ReentrantLock mFastbootLock = new ReentrantLock();
    private LogcatReceiver mLogcatReceiver;
    private boolean mFastbootEnabled = true;
    private String mFastbootPath = "fastboot";
    protected TestDeviceOptions mOptions = new TestDeviceOptions();
    private Process mEmulatorProcess;
    private SizeLimitedOutputStream mEmulatorOutput;
    private Clock mClock = Clock.systemUTC();
    private ITestDevice.RecoveryMode mRecoveryMode = ITestDevice.RecoveryMode.AVAILABLE;
    private Boolean mIsEncryptionSupported = null;
    private ReentrantLock mAllocationStateLock = new ReentrantLock(true);
    @GuardedBy(value="mAllocationStateLock")
    private DeviceAllocationState mAllocationState = DeviceAllocationState.Unknown;
    private IDeviceMonitor mAllocationMonitor = null;
    private String mLastConnectedWifiSsid = null;
    private String mLastConnectedWifiPsk = null;
    private boolean mNetworkMonitorEnabled = false;
    private ContentProviderHandler mContentProvider = null;
    private boolean mShouldSkipContentProviderSetup = false;
    private long mLastTradefedRebootTime = 0L;
    private File mExecuteShellCommandLogs = null;
    private DeviceDescriptor mCachedDeviceDescriptor = null;
    private final Object mCacheLock = new Object();
    private String mFastbootSerialNumber = null;
    private File mUnpackedFastbootDir = null;
    private AbstractConnection mConnection;
    private GceAvdInfo mConnectionAvd;
    private ITestLogger mTestLogger;
    private List<IDeviceActionReceiver> mDeviceActionReceivers = new LinkedList<IDeviceActionReceiver>();
    private boolean inRebootCallback = false;
    private Process mMicrodroidProcess = null;
    private final LoadingCache<String, String> mPropertiesCache;
    private final Set<String> propsToPrefetch = ImmutableSet.of("ro.build.version.sdk", "ro.build.version.codename", "ro.build.id");
    private static final Set<String> NEVER_CACHE_PROPERTIES = ImmutableSet.of("vendor.debug", "ro.boot");
    private static final List<String> TRUE_VALUES = Arrays.asList("1", "y", "yes", "on", "true");
    private static final List<String> FALSE_VALUES = Arrays.asList("0", "n", "no", "off", "false");

    public NativeDevice(IDevice device, IDeviceStateMonitor stateMonitor, IDeviceMonitor allocationMonitor) {
        this.throwIfNull(device);
        this.throwIfNull(stateMonitor);
        this.mIDevice = device;
        this.mStateMonitor = stateMonitor;
        this.mAllocationMonitor = allocationMonitor;
        this.mPropertiesCache = CacheBuilder.newBuilder().maximumSize(50L).expireAfterAccess(2L, TimeUnit.MINUTES).build(new CacheLoader<String, String>(){

            @Override
            public String load(String key) {
                throw new IllegalStateException("Should never be called");
            }
        });
    }

    @VisibleForTesting
    protected IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }

    protected IRunUtil createRunUtil() {
        return new RunUtil();
    }

    @VisibleForTesting
    protected void setClock(Clock clock) {
        this.mClock = clock;
    }

    @Override
    public void setOptions(TestDeviceOptions options) {
        this.throwIfNull(options);
        this.mOptions = options;
        if (this.mOptions.getFastbootBinary() != null) {
            if (".zip".equals(FileUtil.getExtension(this.mOptions.getFastbootBinary().getName()))) {
                try {
                    this.mUnpackedFastbootDir = ZipUtil2.extractZipToTemp(this.mOptions.getFastbootBinary(), "unpacked-fastboot");
                    File unpackedFastboot = FileUtil.findFile(this.mUnpackedFastbootDir, "fastboot");
                    if (unpackedFastboot == null) {
                        throw new HarnessRuntimeException(String.format("device-fastboot-binary was set, but didn't contain a fastboot binary.", new Object[0]), InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
                    }
                    this.setFastbootPath(unpackedFastboot.getAbsolutePath());
                }
                catch (IOException e) {
                    LogUtil.CLog.e("Failed to unpacked zipped fastboot.");
                    LogUtil.CLog.e(e);
                    FileUtil.recursiveDelete(this.mUnpackedFastbootDir);
                    this.mUnpackedFastbootDir = null;
                }
            } else {
                this.setFastbootPath(this.mOptions.getFastbootBinary().getAbsolutePath());
            }
        }
        this.mStateMonitor.setDefaultOnlineTimeout(options.getOnlineTimeout());
        this.mStateMonitor.setDefaultAvailableTimeout(options.getAvailableTimeout());
    }

    void setTmpLogcatSize(long size) {
        this.mOptions.setMaxLogcatDataSize(size);
    }

    public void setLogStartDelay(int delay) {
        this.mLogStartDelay = delay;
    }

    @Override
    public void setConfiguration(IConfiguration configuration) {
        this.mConfiguration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDevice getIDevice() {
        IDevice iDevice = this.mIDevice;
        synchronized (iDevice) {
            return this.mIDevice;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIDevice(IDevice newDevice) {
        this.throwIfNull(newDevice);
        IDevice currentDevice = this.mIDevice;
        if (!this.getIDevice().equals(newDevice)) {
            IDevice iDevice = currentDevice;
            synchronized (iDevice) {
                this.mIDevice = newDevice;
            }
            this.mStateMonitor.setIDevice(this.mIDevice);
        }
    }

    @Override
    public String getSerialNumber() {
        return this.getIDevice().getSerialNumber();
    }

    protected String internalGetProperty(String propName, String fastbootVar, String description) throws DeviceNotAvailableException, UnsupportedOperationException {
        if (this.isStateBootloaderOrFastbootd() && fastbootVar != null) {
            LogUtil.CLog.i("Device %s is in fastboot mode, re-querying with '%s' for %s", this.getSerialNumber(), fastbootVar, description);
            return this.getFastbootVariable(fastbootVar);
        }
        String propValue = this.getProperty(propName);
        if (propValue != null) {
            return propValue;
        }
        LogUtil.CLog.d("property collection '%s' for device %s is null.", description, this.getSerialNumber());
        return null;
    }

    @Override
    public String getProperty(String name) throws DeviceNotAvailableException {
        return this.getPropertyWithRecovery(name, false);
    }

    private String getPropertyWithRecovery(String name, boolean recovery) throws DeviceNotAvailableException {
        if (this.getIDevice() instanceof StubDevice) {
            return null;
        }
        String property = (String)this.mPropertiesCache.getIfPresent(name);
        if (property != null) {
            LogUtil.CLog.d("Using property %s=%s from cache.", name, property);
            return property;
        }
        try (CloseableTraceScope getProp = new CloseableTraceScope("get_property:" + name);){
            String cmd;
            CommandResult result;
            TestDeviceState state = this.getDeviceState();
            if (!TestDeviceState.ONLINE.equals((Object)state) && !TestDeviceState.RECOVERY.equals((Object)state)) {
                if (recovery) {
                    this.recoverDevice();
                } else if (this.mStateMonitor.waitForDeviceOnline() == null) {
                    LogUtil.CLog.w("Waited for device %s to be online but it is in state '%s', cannot get property %s.", new Object[]{this.getSerialNumber(), this.getDeviceState(), name});
                    LogUtil.CLog.w(new RuntimeException("This is not an actual exception but to help debugging. If this happens deterministically,  it means the caller has wrong assumption of  device state and is wasting time in waiting."));
                    String string = null;
                    return string;
                }
            }
            if (!CommandStatus.SUCCESS.equals((Object)(result = this.executeShellV2Command(cmd = String.format("getprop %s", name), 45000L, TimeUnit.MILLISECONDS, 0)).getStatus())) {
                LogUtil.CLog.e("Failed to run '%s' returning null. stdout: %s\nstderr: %s\nexit code: %s", cmd, result.getStdout(), result.getStderr(), result.getExitCode());
                if (result.getStderr().contains("device offline")) {
                    if (recovery) {
                        this.recoverDevice();
                        String string = this.getPropertyWithRecovery(name, false);
                        return string;
                    }
                    throw new DeviceNotAvailableException(String.format("Device went offline when querying property: %s", name), this.getSerialNumber(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNAVAILABLE);
                }
                String string = null;
                return string;
            }
            if (result.getStdout() == null || result.getStdout().trim().isEmpty()) {
                String string = null;
                return string;
            }
            property = result.getStdout().trim();
            if (property != null && !NEVER_CACHE_PROPERTIES.stream().anyMatch(p -> name.startsWith((String)p))) {
                this.mPropertiesCache.put(name, property);
            }
            String string = property;
            return string;
        }
    }

    public void batchPrefetchStartupBuildProps() {
        CommandResult result;
        CloseableTraceScope ignored;
        block12: {
            String cmd;
            block11: {
                cmd = "getprop";
                ignored = new CloseableTraceScope("batchPrefetchProp");
                int propsAlreadyPresent = 0;
                for (String propName : this.propsToPrefetch) {
                    if (this.mPropertiesCache.getIfPresent(propName) == null) break;
                    ++propsAlreadyPresent;
                }
                if (propsAlreadyPresent != this.propsToPrefetch.size()) break block11;
                ignored.close();
                return;
            }
            result = this.executeShellV2Command(cmd, 45000L, TimeUnit.MILLISECONDS, 0);
            if (CommandStatus.SUCCESS.equals((Object)result.getStatus())) break block12;
            LogUtil.CLog.w("Failed to run '%s' returning null. stdout: %s\nstderr: %s\nexit code: %s", cmd, result.getStdout(), result.getStderr(), result.getExitCode());
            if (result.getStdout() != null && !result.getStdout().trim().isEmpty()) break block12;
            ignored.close();
            return;
        }
        try {
            try {
                for (String line : result.getStdout().split("\n")) {
                    String[] parts = line.trim().split("]: \\[");
                    if (parts.length != 2) continue;
                    String propName = parts[0].substring(1).trim();
                    String propValue = parts[1].substring(0, parts[1].length() - 1).trim();
                    if (propValue == null || !this.propsToPrefetch.contains(propName)) continue;
                    this.mPropertiesCache.put(propName, propValue);
                }
            }
            catch (DeviceNotAvailableException deviceNotAvailableException) {
                // empty catch block
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            ignored.close();
        }
    }

    @Override
    public long getIntProperty(String name, long defaultValue) throws DeviceNotAvailableException {
        String value = this.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public boolean getBooleanProperty(String name, boolean defaultValue) throws DeviceNotAvailableException {
        String value = this.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        if (TRUE_VALUES.contains(value)) {
            return true;
        }
        if (FALSE_VALUES.contains(value)) {
            return false;
        }
        return defaultValue;
    }

    @Override
    public boolean setProperty(String propKey, String propValue) throws DeviceNotAvailableException {
        if (propKey == null || propValue == null) {
            throw new IllegalArgumentException("set property key or value cannot be null.");
        }
        String setPropCmd = String.format("\"setprop %s '%s'\"", propKey, propValue);
        CommandResult result = this.executeShellV2Command(setPropCmd);
        if (CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
            this.mPropertiesCache.invalidate(propKey);
            return true;
        }
        LogUtil.CLog.e("Something went wrong went setting property %s (command: %s): %s", propKey, setPropCmd, result.getStderr());
        return false;
    }

    @Override
    public String getBootloaderVersion() throws UnsupportedOperationException, DeviceNotAvailableException {
        return this.internalGetProperty("ro.bootloader", "version-bootloader", "Bootloader");
    }

    @Override
    public String getBasebandVersion() throws DeviceNotAvailableException {
        return this.internalGetProperty("gsm.version.baseband", "version-baseband", "Baseband");
    }

    @Override
    public String getProductType() throws DeviceNotAvailableException {
        return this.internalGetProductType(2);
    }

    private String internalGetProductType(int retryAttempts) throws DeviceNotAvailableException {
        String productType = this.internalGetProperty("ro.product.board", "product", "Product type");
        if (Strings.isNullOrEmpty(productType)) {
            productType = this.internalGetProperty("ro.hardware", "product", "Product type");
        }
        if (Strings.isNullOrEmpty(productType)) {
            if (retryAttempts > 0) {
                this.recoverDevice();
                productType = this.internalGetProductType(retryAttempts - 1);
            }
            if (Strings.isNullOrEmpty(productType)) {
                throw new DeviceNotAvailableException(String.format("Could not determine product type for device %s.", this.getSerialNumber()), this.getSerialNumber(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
            }
        }
        return productType.toLowerCase();
    }

    @Override
    public String getFastbootProductType() throws DeviceNotAvailableException, UnsupportedOperationException {
        String prop = this.getFastbootVariable("product");
        if (prop != null) {
            prop = prop.toLowerCase();
        }
        return prop;
    }

    @Override
    public String getProductVariant() throws DeviceNotAvailableException {
        String prop = this.internalGetProperty("ro.product.vendor.device", "variant", "Product variant");
        if (prop == null) {
            prop = this.internalGetProperty("ro.vendor.product.device", "variant", "Product variant");
        }
        if (prop == null) {
            prop = this.internalGetProperty("ro.product.device", "variant", "Product variant");
        }
        if (prop != null) {
            prop = prop.toLowerCase();
        }
        return prop;
    }

    @Override
    public String getFastbootProductVariant() throws DeviceNotAvailableException, UnsupportedOperationException {
        String prop = this.getFastbootVariable("variant");
        if (prop != null) {
            prop = prop.toLowerCase();
        }
        return prop;
    }

    @Override
    public String getFastbootVariable(String variableName) throws DeviceNotAvailableException, UnsupportedOperationException {
        CommandResult result = this.executeFastbootCommand("getvar", variableName);
        LogUtil.CLog.d("(getvar %s) output:\nstdout%s\nstderr:%s", variableName, result.getStdout(), result.getStderr());
        if (result.getStatus() == CommandStatus.SUCCESS) {
            Matcher matcher;
            Pattern fastbootProductPattern = Pattern.compile(variableName + ":\\s(.*)\\s");
            String resultText = result.getStdout();
            if (resultText == null || resultText.length() < 1) {
                resultText = result.getStderr();
            }
            if ((matcher = fastbootProductPattern.matcher(resultText)).find()) {
                return matcher.group(1);
            }
        }
        return null;
    }

    @Override
    public String getBuildAlias() throws DeviceNotAvailableException {
        String alias = this.getProperty("ro.build.id");
        if (alias == null || alias.isEmpty()) {
            return this.getBuildId();
        }
        return alias;
    }

    @Override
    public String getBuildId() throws DeviceNotAvailableException {
        String bid = this.getProperty("ro.build.version.incremental");
        if (bid == null) {
            LogUtil.CLog.w("Could not get device %s build id.", this.getSerialNumber());
            return "-1";
        }
        return bid;
    }

    @Override
    public String getBuildFlavor() throws DeviceNotAvailableException {
        String buildFlavor = this.getProperty("ro.build.flavor");
        if (buildFlavor != null && !buildFlavor.isEmpty()) {
            return buildFlavor;
        }
        String productName = this.getProperty("ro.product.name");
        String buildType = this.getProperty("ro.build.type");
        if (productName == null || buildType == null) {
            LogUtil.CLog.w("Could not get device %s build flavor.", this.getSerialNumber());
            return null;
        }
        return String.format("%s-%s", productName, buildType);
    }

    @Override
    public void executeShellCommand(final String command, final IShellOutputReceiver receiver) throws DeviceNotAvailableException {
        DeviceAction action = new DeviceAction(){

            @Override
            public boolean run() throws com.android.ddmlib.TimeoutException, IOException, AdbCommandRejectedException, ShellCommandUnresponsiveException {
                NativeDevice.this.getIDevice().executeShellCommand(command, receiver, NativeDevice.this.getCommandTimeout(), TimeUnit.MILLISECONDS);
                return true;
            }
        };
        this.performDeviceAction(String.format("shell %s", command), action, 2);
    }

    @Override
    public void executeShellCommand(final String command, final IShellOutputReceiver receiver, final long maxTimeToOutputShellResponse, final TimeUnit timeUnit, int retryAttempts) throws DeviceNotAvailableException {
        DeviceAction action = new DeviceAction(){

            @Override
            public boolean run() throws com.android.ddmlib.TimeoutException, IOException, AdbCommandRejectedException, ShellCommandUnresponsiveException {
                NativeDevice.this.getIDevice().executeShellCommand(command, receiver, maxTimeToOutputShellResponse, timeUnit);
                return true;
            }
        };
        this.performDeviceAction(String.format("shell %s", command), action, retryAttempts);
    }

    @Override
    public void executeShellCommand(final String command, final IShellOutputReceiver receiver, final long maxTimeoutForCommand, final long maxTimeToOutputShellResponse, final TimeUnit timeUnit, int retryAttempts) throws DeviceNotAvailableException {
        DeviceAction action = new DeviceAction(){

            @Override
            public boolean run() throws com.android.ddmlib.TimeoutException, IOException, AdbCommandRejectedException, ShellCommandUnresponsiveException {
                NativeDevice.this.getIDevice().executeShellCommand(command, receiver, maxTimeoutForCommand, maxTimeToOutputShellResponse, timeUnit);
                return true;
            }
        };
        this.performDeviceAction(String.format("shell %s", command), action, retryAttempts);
    }

    @Override
    public String executeShellCommand(String command) throws DeviceNotAvailableException {
        CollectingOutputReceiver receiver = new CollectingOutputReceiver();
        this.executeShellCommand(command, receiver);
        String output = receiver.getOutput();
        if (this.mExecuteShellCommandLogs != null) {
            String formatted = LogUtil.getLogFormatString(Log.LogLevel.VERBOSE, "NativeDevice", String.format("%s on %s returned %s\n==== END OF OUTPUT ====\n", command, this.getSerialNumber(), output));
            try {
                FileUtil.writeToFile(formatted, this.mExecuteShellCommandLogs, true);
            }
            catch (IOException e) {
                LogUtil.CLog.e("Failed to log to executeShellCommand log: %s", e.getMessage());
            }
        }
        if (output.length() > 80) {
            LogUtil.CLog.v("%s on %s returned %s <truncated - See executeShellCommand log for full trace>", command, this.getSerialNumber(), output.substring(0, 80));
        } else {
            LogUtil.CLog.v("%s on %s returned %s", command, this.getSerialNumber(), output);
        }
        return output;
    }

    @Override
    public CommandResult executeShellV2Command(String cmd) throws DeviceNotAvailableException {
        return this.executeShellV2Command(cmd, this.getCommandTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public CommandResult executeShellV2Command(String cmd, File pipeAsInput) throws DeviceNotAvailableException {
        return this.executeShellV2Command(cmd, pipeAsInput, null, this.getCommandTimeout(), TimeUnit.MILLISECONDS, 2);
    }

    @Override
    public CommandResult executeShellV2Command(String cmd, OutputStream pipeToOutput) throws DeviceNotAvailableException {
        return this.executeShellV2Command(cmd, null, pipeToOutput, this.getCommandTimeout(), TimeUnit.MILLISECONDS, 2);
    }

    @Override
    public CommandResult executeShellV2Command(String cmd, long maxTimeoutForCommand, TimeUnit timeUnit) throws DeviceNotAvailableException {
        return this.executeShellV2Command(cmd, null, null, maxTimeoutForCommand, timeUnit, 2);
    }

    @Override
    public CommandResult executeShellV2Command(String cmd, long maxTimeoutForCommand, TimeUnit timeUnit, int retryAttempts) throws DeviceNotAvailableException {
        return this.executeShellV2Command(cmd, null, null, maxTimeoutForCommand, timeUnit, retryAttempts);
    }

    @Override
    public CommandResult executeShellV2Command(String cmd, File pipeAsInput, OutputStream pipeToOutput, long maxTimeoutForCommand, TimeUnit timeUnit, int retryAttempts) throws DeviceNotAvailableException {
        return this.executeShellV2Command(cmd, pipeAsInput, pipeToOutput, null, maxTimeoutForCommand, timeUnit, retryAttempts);
    }

    @Override
    public CommandResult executeShellV2Command(String cmd, File pipeAsInput, OutputStream pipeToOutput, OutputStream pipeToError, long maxTimeoutForCommand, TimeUnit timeUnit, int retryAttempts) throws DeviceNotAvailableException {
        boolean parseExitStatus = !this.getIDevice().supportsFeature(IDevice.Feature.SHELL_V2) && this.getOptions().useExitStatusWorkaround();
        String[] fullCmd = this.buildAdbShellCommand(cmd, parseExitStatus);
        AdbShellAction adbActionV2 = new AdbShellAction(fullCmd, pipeAsInput, pipeToOutput, pipeToError, timeUnit.toMillis(maxTimeoutForCommand));
        this.performDeviceAction(String.format("adb %s", fullCmd[4]), adbActionV2, retryAttempts);
        if (parseExitStatus) {
            this.postProcessExitStatus(adbActionV2.mResult);
        }
        return adbActionV2.mResult;
    }

    private void postProcessExitStatus(@Nonnull CommandResult result) {
        String stdout = result.getStdout();
        int delimiterIndex = stdout.lastIndexOf(EXIT_STATUS_DELIMITER);
        if (delimiterIndex < 0) {
            result.setStatus(CommandStatus.FAILED);
            return;
        }
        String actualStdout = stdout.substring(0, delimiterIndex);
        String exitStatusText = stdout.substring(delimiterIndex + 1);
        result.setExitCode(Integer.parseUnsignedInt(exitStatusText.trim()));
        result.setStdout(actualStdout);
        if (result.getStatus() == CommandStatus.SUCCESS && result.getExitCode() != 0) {
            result.setStatus(CommandStatus.FAILED);
        }
    }

    @Override
    public boolean runInstrumentationTests(final IRemoteAndroidTestRunner runner, Collection<ITestLifeCycleReceiver> listeners) throws DeviceNotAvailableException {
        RunFailureListener failureListener = new RunFailureListener();
        final ArrayList<ITestRunListener> runListeners = new ArrayList<ITestRunListener>();
        runListeners.add(failureListener);
        runListeners.add(new TestRunToTestInvocationForwarder(listeners));
        if (this.mConfiguration != null && this.mConfiguration.getCoverageOptions().isCoverageEnabled() && this.mConfiguration.getCoverageOptions().getCoverageToolchains().contains((Object)CoverageOptions.Toolchain.JACOCO)) {
            runner.setCoverage(true);
        }
        DeviceAction runTestsAction = new DeviceAction(){

            @Override
            public boolean run() throws IOException, com.android.ddmlib.TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, InstallException, SyncException {
                runner.run(runListeners);
                return true;
            }
        };
        boolean result = this.performDeviceAction(String.format("run %s instrumentation tests", runner.getPackageName()), runTestsAction, 0);
        if (failureListener.isRunFailure()) {
            this.waitForDeviceAvailable();
        }
        return result;
    }

    @Override
    public boolean runInstrumentationTests(IRemoteAndroidTestRunner runner, ITestLifeCycleReceiver ... listeners) throws DeviceNotAvailableException {
        ArrayList<ITestLifeCycleReceiver> listenerList = new ArrayList<ITestLifeCycleReceiver>();
        listenerList.addAll(Arrays.asList(listeners));
        return this.runInstrumentationTests(runner, listenerList);
    }

    @Override
    public boolean runInstrumentationTestsAsUser(IRemoteAndroidTestRunner runner, int userId, Collection<ITestLifeCycleReceiver> listeners) throws DeviceNotAvailableException {
        String oldRunTimeOptions = this.appendUserRunTimeOptionToRunner(runner, userId);
        boolean result = this.runInstrumentationTests(runner, listeners);
        this.resetUserRunTimeOptionToRunner(runner, oldRunTimeOptions);
        return result;
    }

    @Override
    public boolean runInstrumentationTestsAsUser(IRemoteAndroidTestRunner runner, int userId, ITestLifeCycleReceiver ... listeners) throws DeviceNotAvailableException {
        String oldRunTimeOptions = this.appendUserRunTimeOptionToRunner(runner, userId);
        boolean result = this.runInstrumentationTests(runner, listeners);
        this.resetUserRunTimeOptionToRunner(runner, oldRunTimeOptions);
        return result;
    }

    private String appendUserRunTimeOptionToRunner(IRemoteAndroidTestRunner runner, int userId) {
        if (runner instanceof RemoteAndroidTestRunner) {
            String original = ((RemoteAndroidTestRunner)runner).getRunOptions();
            String userRunTimeOption = String.format("--user %s", Integer.toString(userId));
            String updated = original != null ? original + " " + userRunTimeOption : userRunTimeOption;
            ((RemoteAndroidTestRunner)runner).setRunOptions(updated);
            return original;
        }
        throw new IllegalStateException(String.format("%s runner does not support multi-user", runner.getClass().getName()));
    }

    private void resetUserRunTimeOptionToRunner(IRemoteAndroidTestRunner runner, String oldRunTimeOptions) {
        if (runner instanceof RemoteAndroidTestRunner) {
            if (oldRunTimeOptions != null) {
                ((RemoteAndroidTestRunner)runner).setRunOptions(oldRunTimeOptions);
            }
        } else {
            throw new IllegalStateException(String.format("%s runner does not support multi-user", runner.getClass().getName()));
        }
    }

    @Override
    public boolean isRuntimePermissionSupported() throws DeviceNotAvailableException {
        boolean condition2;
        int apiLevel = this.getApiLevel();
        boolean bl = condition2 = apiLevel > 22;
        if (!condition2) {
            LogUtil.CLog.w("isRuntimePermissionSupported requires api level above 22, device reported '%s'", apiLevel);
        }
        return condition2;
    }

    @Override
    public boolean isAppEnumerationSupported() throws DeviceNotAvailableException {
        return false;
    }

    @Override
    public boolean isBypassLowTargetSdkBlockSupported() throws DeviceNotAvailableException {
        return this.checkApiLevelAgainstNextRelease(34);
    }

    protected void ensureRuntimePermissionSupported() throws DeviceNotAvailableException {
        boolean runtimePermissionSupported = this.isRuntimePermissionSupported();
        if (!runtimePermissionSupported) {
            throw new UnsupportedOperationException("platform on device does not support runtime permission granting!");
        }
    }

    @Override
    public String installPackage(File packageFile, boolean reinstall, String ... extraArgs) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for Package Manager's features");
    }

    @Override
    public String installPackage(File packageFile, boolean reinstall, boolean grantPermissions, String ... extraArgs) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for Package Manager's features");
    }

    @Override
    public String installPackageForUser(File packageFile, boolean reinstall, int userId, String ... extraArgs) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for Package Manager's features");
    }

    @Override
    public String installPackageForUser(File packageFile, boolean reinstall, boolean grantPermissions, int userId, String ... extraArgs) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for Package Manager's features");
    }

    @Override
    public String uninstallPackage(String packageName) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for Package Manager's features");
    }

    @Override
    public String uninstallPackageForUser(String packageName, int userId) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for Package Manager's features");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean pullFile(String remoteFilePath, File localFile, int userId) throws DeviceNotAvailableException {
        long startTime = System.currentTimeMillis();
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.PULL_FILE_COUNT, 1L);
        try {
            ContentProviderHandler handler;
            if (this.isSdcardOrEmulated(remoteFilePath) && userId != 0 && (handler = this.getContentProvider()) != null) {
                boolean bl = handler.pullFile(remoteFilePath, localFile);
                return bl;
            }
            boolean bl = this.pullFileInternal(remoteFilePath, localFile);
            return bl;
        }
        finally {
            long totalTime = System.currentTimeMillis() - startTime;
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.PULL_FILE_TIME, totalTime);
        }
    }

    @Override
    public boolean pullFile(String remoteFilePath, File localFile) throws DeviceNotAvailableException {
        return this.pullFile(remoteFilePath, localFile, this.getCurrentUserCompatible());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File pullFile(String remoteFilePath, int userId) throws DeviceNotAvailableException {
        File localFile = null;
        boolean success = false;
        try {
            localFile = FileUtil.createTempFileForRemote(remoteFilePath, null);
            if (this.pullFile(remoteFilePath, localFile, userId)) {
                success = true;
                File file2 = localFile;
                return file2;
            }
        }
        catch (IOException e) {
            LogUtil.CLog.w("Encountered IOException while trying to pull '%s':", remoteFilePath);
            LogUtil.CLog.e(e);
        }
        finally {
            if (!success) {
                FileUtil.deleteFile(localFile);
            }
        }
        return null;
    }

    @Override
    public File pullFile(String remoteFilePath) throws DeviceNotAvailableException {
        return this.pullFile(remoteFilePath, this.getCurrentUserCompatible());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String pullFileContents(String remoteFilePath) throws DeviceNotAvailableException {
        File temp = this.pullFile(remoteFilePath);
        if (temp != null) {
            try {
                String string = FileUtil.readStringFromFile(temp);
                return string;
            }
            catch (IOException e) {
                LogUtil.CLog.e(String.format("Could not pull file: %s", remoteFilePath));
            }
            finally {
                FileUtil.deleteFile(temp);
            }
        }
        return null;
    }

    @Override
    public File pullFileFromExternal(String remoteFilePath) throws DeviceNotAvailableException {
        String externalPath = this.getMountPoint("EXTERNAL_STORAGE");
        String fullPath = new File(externalPath, remoteFilePath).getPath();
        return this.pullFile(fullPath);
    }

    protected boolean pullFileInternal(final String remoteFilePath, final File localFile) throws DeviceNotAvailableException {
        DeviceAction pullAction = new DeviceAction(){

            @Override
            public boolean run() throws com.android.ddmlib.TimeoutException, IOException, AdbCommandRejectedException, SyncException {
                boolean status = false;
                try (SyncService syncService = null;){
                    syncService = NativeDevice.this.getIDevice().getSyncService();
                    syncService.pullFile(NativeDevice.this.interpolatePathVariables(remoteFilePath), localFile.getAbsolutePath(), SyncService.getNullProgressMonitor());
                    status = true;
                }
                return status;
            }
        };
        return this.performDeviceAction(String.format("pull %s to %s", remoteFilePath, localFile.getAbsolutePath()), pullAction, 2);
    }

    String interpolatePathVariables(String path) {
        String esString = "${EXTERNAL_STORAGE}";
        if (path.contains("${EXTERNAL_STORAGE}")) {
            String esPath = this.getMountPoint("EXTERNAL_STORAGE");
            path = path.replace("${EXTERNAL_STORAGE}", esPath);
        }
        return path;
    }

    @Override
    public boolean pushFile(File localFile, String remoteFilePath) throws DeviceNotAvailableException {
        return this.pushFileInternal(localFile, remoteFilePath, false);
    }

    @Override
    public boolean pushFile(File localFile, String remoteFilePath, boolean evaluateContentProviderNeeded) throws DeviceNotAvailableException {
        boolean skipContentProvider = false;
        if (evaluateContentProviderNeeded) {
            skipContentProvider = this.getCurrentUserCompatible() == 0;
        }
        return this.pushFileInternal(localFile, remoteFilePath, skipContentProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean pushFileInternal(final File localFile, final String remoteFilePath, boolean skipContentProvider) throws DeviceNotAvailableException {
        long startTime = System.currentTimeMillis();
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.PUSH_FILE_COUNT, 1L);
        try {
            ContentProviderHandler handler;
            if (!skipContentProvider && this.isSdcardOrEmulated(remoteFilePath) && (handler = this.getContentProvider()) != null) {
                boolean bl = handler.pushFile(localFile, remoteFilePath);
                return bl;
            }
            DeviceAction pushAction = new DeviceAction(){

                @Override
                public boolean run() throws com.android.ddmlib.TimeoutException, IOException, AdbCommandRejectedException, SyncException {
                    boolean status = false;
                    try (SyncService syncService = null;){
                        syncService = NativeDevice.this.getIDevice().getSyncService();
                        if (syncService == null) {
                            throw new IOException("SyncService returned null.");
                        }
                        syncService.pushFile(localFile.getAbsolutePath(), NativeDevice.this.interpolatePathVariables(remoteFilePath), SyncService.getNullProgressMonitor());
                        status = true;
                    }
                    return status;
                }
            };
            boolean bl = this.performDeviceAction(String.format("push %s to %s", localFile.getAbsolutePath(), remoteFilePath), pushAction, 2);
            return bl;
        }
        finally {
            long totalTime = System.currentTimeMillis() - startTime;
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.PUSH_FILE_TIME, totalTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean pushString(String contents, String remoteFilePath) throws DeviceNotAvailableException {
        File tmpFile = null;
        try {
            tmpFile = FileUtil.createTempFile("temp", ".txt");
            FileUtil.writeToFile(contents, tmpFile);
            boolean bl = this.pushFile(tmpFile, remoteFilePath);
            return bl;
        }
        catch (IOException e) {
            LogUtil.CLog.e(e);
            boolean bl = false;
            return bl;
        }
        finally {
            FileUtil.deleteFile(tmpFile);
        }
    }

    @Override
    public boolean doesFileExist(String deviceFilePath) throws DeviceNotAvailableException {
        return this.doesFileExist(deviceFilePath, this.getCurrentUserCompatible());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doesFileExist(String deviceFilePath, int userId) throws DeviceNotAvailableException {
        long startTime = System.currentTimeMillis();
        try {
            ContentProviderHandler handler;
            if (this.isSdcardOrEmulated(deviceFilePath) && userId != 0 && (handler = this.getContentProvider()) != null) {
                LogUtil.CLog.d("Delegating check to ContentProvider doesFileExist(%s)", deviceFilePath);
                boolean bl = handler.doesFileExist(deviceFilePath);
                return bl;
            }
            LogUtil.CLog.d("Using 'ls' to check doesFileExist(%s)", deviceFilePath);
            String lsGrep = this.executeShellCommand(String.format("ls \"%s\"", deviceFilePath));
            boolean bl = !lsGrep.contains("No such file or directory");
            return bl;
        }
        finally {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.DOES_FILE_EXISTS_TIME, System.currentTimeMillis() - startTime);
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.DOES_FILE_EXISTS_COUNT, 1L);
        }
    }

    @Override
    public void registerDeviceActionReceiver(IDeviceActionReceiver deviceActionReceiver) {
        this.mDeviceActionReceivers.add(deviceActionReceiver);
    }

    @Override
    public void deregisterDeviceActionReceiver(IDeviceActionReceiver deviceActionReceiver) {
        this.mDeviceActionReceivers.remove(deviceActionReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFile(String deviceFilePath) throws DeviceNotAvailableException {
        long startTime = System.currentTimeMillis();
        try {
            ContentProviderHandler handler;
            int currentUser;
            if (this.isSdcardOrEmulated(deviceFilePath) && (currentUser = this.getCurrentUserCompatible()) != 0 && (handler = this.getContentProvider()) != null && handler.deleteFile(deviceFilePath)) {
                return;
            }
            String path = StringEscapeUtils.escapeShell(deviceFilePath);
            path = path.replaceAll(" ", "\\ ");
            this.executeShellCommand(String.format("rm -rf %s", StringEscapeUtils.escapeShell(path)));
        }
        finally {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.DELETE_DEVICE_FILE_TIME, System.currentTimeMillis() - startTime);
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.DELETE_DEVICE_FILE_COUNT, 1L);
        }
    }

    @Override
    public long getExternalStoreFreeSpace() throws DeviceNotAvailableException {
        String externalStorePath = this.getMountPoint("EXTERNAL_STORAGE");
        return this.getPartitionFreeSpace(externalStorePath);
    }

    @Override
    public long getPartitionFreeSpace(String partition) throws DeviceNotAvailableException {
        LogUtil.CLog.i("Checking free space for %s on partition %s", this.getSerialNumber(), partition);
        String output = this.getDfOutput(partition);
        Long available = this.parseFreeSpaceFromModernOutput(output);
        if (available != null) {
            return available;
        }
        available = this.parseFreeSpaceFromAvailable(output);
        if (available != null) {
            return available;
        }
        available = this.parseFreeSpaceFromFree(partition, output);
        if (available != null) {
            return available;
        }
        LogUtil.CLog.e("free space command output \"%s\" did not match expected patterns", output);
        return 0L;
    }

    private String getDfOutput(String externalStorePath) throws DeviceNotAvailableException {
        for (int i = 0; i < 2; ++i) {
            String output = this.executeShellCommand(String.format("df %s", externalStorePath));
            if (output.trim().length() <= 0) continue;
            return output;
        }
        throw new DeviceUnresponsiveException(String.format("Device %s not returning output from df command after %d attempts", this.getSerialNumber(), 2), this.getSerialNumber());
    }

    private Long parseFreeSpaceFromAvailable(String dfOutput) {
        Pattern freeSpacePattern = Pattern.compile("(\\d+)K available");
        Matcher patternMatcher = freeSpacePattern.matcher(dfOutput);
        if (patternMatcher.find()) {
            String freeSpaceString = patternMatcher.group(1);
            try {
                return Long.parseLong(freeSpaceString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    Long parseFreeSpaceFromFree(String externalStorePath, String dfOutput) {
        Long freeSpace = null;
        Pattern freeSpaceTablePattern = Pattern.compile(String.format("%s\\s+[\\w\\d\\.]+\\s+[\\w\\d\\.]+\\s+([\\d\\.]+)(\\w)", externalStorePath));
        Matcher tablePatternMatcher = freeSpaceTablePattern.matcher(dfOutput);
        if (tablePatternMatcher.find()) {
            String numericValueString = tablePatternMatcher.group(1);
            String unitType = tablePatternMatcher.group(2);
            try {
                float freeSpaceFloat = Float.parseFloat(numericValueString);
                if (unitType.equals("M")) {
                    freeSpaceFloat *= 1024.0f;
                } else if (unitType.equals("G")) {
                    freeSpaceFloat = freeSpaceFloat * 1024.0f * 1024.0f;
                }
                freeSpace = (long)freeSpaceFloat;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return freeSpace;
    }

    Long parseFreeSpaceFromModernOutput(String dfOutput) {
        Matcher matcher = DF_PATTERN.matcher(dfOutput);
        if (matcher.find()) {
            try {
                return Long.parseLong(matcher.group(2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getMountPoint(String mountName) {
        try {
            return this.mStateMonitor.getMountPoint(mountName);
        }
        catch (DeviceNotAvailableException e) {
            LogUtil.CLog.e(e);
            return null;
        }
    }

    @Override
    public List<ITestDevice.MountPointInfo> getMountPointInfo() throws DeviceNotAvailableException {
        String mountInfo = this.executeShellCommand("cat /proc/mounts");
        String[] mountInfoLines = mountInfo.split("\r?\n");
        ArrayList<ITestDevice.MountPointInfo> list2 = new ArrayList<ITestDevice.MountPointInfo>(mountInfoLines.length);
        for (String line : mountInfoLines) {
            String[] parts = line.split("\\s+", 5);
            list2.add(new ITestDevice.MountPointInfo(parts[0], parts[1], parts[2], parts[3]));
        }
        return list2;
    }

    @Override
    public ITestDevice.MountPointInfo getMountPointInfo(String mountpoint) throws DeviceNotAvailableException {
        List<ITestDevice.MountPointInfo> mountpoints = this.getMountPointInfo();
        for (ITestDevice.MountPointInfo info : mountpoints) {
            if (!mountpoint.equals(info.mountpoint)) continue;
            return info;
        }
        return null;
    }

    @Override
    public IFileEntry getFileEntry(String path) throws DeviceNotAvailableException {
        path = this.interpolatePathVariables(path);
        String[] pathComponents = path.split("/");
        FileListingService service = this.getFileListingService();
        FileEntryWrapper rootFile = new FileEntryWrapper(this, service.getRoot());
        return FileEntryWrapper.getDescendant(rootFile, Arrays.asList(pathComponents));
    }

    public IFileEntry getFileEntry(FileListingService.FileEntry entry) throws DeviceNotAvailableException {
        return new FileEntryWrapper(this, entry);
    }

    @Override
    public boolean isExecutable(String fullPath) throws DeviceNotAvailableException {
        String fileMode = this.executeShellCommand(String.format("ls -l %s", fullPath));
        if (fileMode != null) {
            return EXE_FILE.matcher(fileMode).find();
        }
        return false;
    }

    @Override
    public boolean isDirectory(String path) throws DeviceNotAvailableException {
        return this.executeShellCommand(String.format("ls -ld %s", path)).charAt(0) == 'd';
    }

    @Override
    public String[] getChildren(String path) throws DeviceNotAvailableException {
        String lsOutput = this.executeShellCommand(String.format("ls -A1 %s", path));
        if (lsOutput.trim().isEmpty()) {
            return new String[0];
        }
        return lsOutput.split("\r?\n");
    }

    private FileListingService getFileListingService() throws DeviceNotAvailableException {
        final FileListingService[] service = new FileListingService[1];
        DeviceAction serviceAction = new DeviceAction(){

            @Override
            public boolean run() throws IOException, com.android.ddmlib.TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, InstallException, SyncException {
                service[0] = NativeDevice.this.getIDevice().getFileListingService();
                if (service[0] == null) {
                    throw new IOException("Could not get file listing service");
                }
                return true;
            }
        };
        this.performDeviceAction("getFileListingService", serviceAction, 2);
        return service[0];
    }

    @Override
    public boolean pushDir(File localFileDir, String deviceFilePath) throws DeviceNotAvailableException {
        return this.pushDir(localFileDir, deviceFilePath, new HashSet<String>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean pushDir(File localFileDir, String deviceFilePath, Set<String> excludedDirectories) throws DeviceNotAvailableException {
        long startTime = System.currentTimeMillis();
        try {
            if (this.isSdcardOrEmulated(deviceFilePath)) {
                Integer currentUser = this.getCurrentUserCompatible();
                if (currentUser != 0) {
                    ContentProviderHandler handler = this.getContentProvider();
                    if (handler != null) {
                        boolean bl = handler.pushDir(localFileDir, deviceFilePath, excludedDirectories);
                        return bl;
                    }
                } else {
                    LogUtil.CLog.d("Push without content provider for user '%s'", currentUser);
                }
            }
            boolean bl = this.pushDirInternal(localFileDir, deviceFilePath, excludedDirectories);
            return bl;
        }
        finally {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.PUSH_DIR_TIME, System.currentTimeMillis() - startTime);
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.PUSH_DIR_COUNT, 1L);
        }
    }

    private boolean pushDirInternal(File localFileDir, String deviceFilePath, Set<String> excludedDirectories) throws DeviceNotAvailableException {
        if (!localFileDir.isDirectory()) {
            LogUtil.CLog.e("file %s is not a directory", localFileDir.getAbsolutePath());
            return false;
        }
        File[] childFiles = localFileDir.listFiles();
        if (childFiles == null) {
            LogUtil.CLog.e("Could not read files in %s", localFileDir.getAbsolutePath());
            return false;
        }
        for (File childFile : childFiles) {
            String remotePath = String.format("%s/%s", deviceFilePath, childFile.getName());
            if (childFile.isDirectory()) {
                if (excludedDirectories.contains(childFile.getName())) {
                    LogUtil.CLog.d("%s directory was not pushed because it was filtered.", childFile.getAbsolutePath());
                    continue;
                }
                this.executeShellCommand(String.format("mkdir -p \"%s\"", remotePath));
                if (this.pushDirInternal(childFile, remotePath, excludedDirectories)) continue;
                return false;
            }
            if (!childFile.isFile() || this.pushFileInternal(childFile, remotePath, true)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean pullDir(String deviceFilePath, File localDir) throws DeviceNotAvailableException {
        long startTime = System.currentTimeMillis();
        try {
            ContentProviderHandler handler;
            int currentUser = this.getCurrentUserCompatible();
            if (this.isSdcardOrEmulated(deviceFilePath) && currentUser != 0 && (handler = this.getContentProvider()) != null) {
                boolean bl = handler.pullDir(deviceFilePath, localDir);
                return bl;
            }
            boolean bl = this.pullDirInternal(deviceFilePath, localDir, currentUser);
            return bl;
        }
        finally {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.PULL_DIR_TIME, System.currentTimeMillis() - startTime);
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.PULL_DIR_COUNT, 1L);
        }
    }

    private boolean pullDirInternal(String deviceFilePath, File localDir, int userId) throws DeviceNotAvailableException {
        if (!localDir.isDirectory()) {
            LogUtil.CLog.e("Local path %s is not a directory", localDir.getAbsolutePath());
            return false;
        }
        if (!this.doesFileExist(deviceFilePath, userId)) {
            LogUtil.CLog.e("Device path %s does not exist to be pulled.", deviceFilePath);
            return false;
        }
        if (!this.isDirectory(deviceFilePath)) {
            LogUtil.CLog.e("Device path %s is not a directory", deviceFilePath);
            return false;
        }
        FileListingService.FileEntry entryRoot = new FileListingService.FileEntry(null, deviceFilePath, 1, false);
        IFileEntry entry = this.getFileEntry(entryRoot);
        Collection<IFileEntry> children = entry.getChildren(false);
        if (children.isEmpty()) {
            LogUtil.CLog.i("Device path is empty, nothing to do.");
            return true;
        }
        for (IFileEntry item : children) {
            if (item.isDirectory()) {
                File subDir = new File(localDir, item.getName());
                if (!subDir.mkdir()) {
                    LogUtil.CLog.w("Failed to create sub directory %s, aborting.", subDir.getAbsolutePath());
                    return false;
                }
                String deviceSubDir = item.getFullPath();
                if (this.pullDirInternal(deviceSubDir, subDir, userId)) continue;
                LogUtil.CLog.w("Failed to pull sub directory %s from device, aborting", deviceSubDir);
                return false;
            }
            File localFile = new File(localDir, item.getName());
            String fullPath = item.getFullPath();
            if (this.pullFileInternal(fullPath, localFile)) continue;
            LogUtil.CLog.w("Failed to pull file %s from device, aborting", fullPath);
            return false;
        }
        return true;
    }

    private boolean isSdcardOrEmulated(String path) {
        return path.startsWith(SD_CARD) || path.startsWith(STORAGE_EMULATED);
    }

    @Override
    public boolean syncFiles(File localFileDir, String deviceFilePath) throws DeviceNotAvailableException {
        IFileEntry remoteFileEntry;
        if (localFileDir == null || deviceFilePath == null) {
            throw new IllegalArgumentException("syncFiles does not take null arguments");
        }
        LogUtil.CLog.i("Syncing %s to %s on device %s", localFileDir.getAbsolutePath(), deviceFilePath, this.getSerialNumber());
        if (!localFileDir.isDirectory()) {
            LogUtil.CLog.e("file %s is not a directory", localFileDir.getAbsolutePath());
            return false;
        }
        if (!this.doesFileExist(deviceFilePath = String.format("%s/%s", this.interpolatePathVariables(deviceFilePath), localFileDir.getName()))) {
            this.executeShellCommand(String.format("mkdir -p \"%s\"", deviceFilePath));
        }
        if ((remoteFileEntry = this.getFileEntry(deviceFilePath)) == null) {
            LogUtil.CLog.e("Could not find remote file entry %s ", deviceFilePath);
            return false;
        }
        return this.syncFiles(localFileDir, remoteFileEntry);
    }

    private boolean syncFiles(File localFileDir, final IFileEntry remoteFileEntry) throws DeviceNotAvailableException {
        LogUtil.CLog.d("Syncing %s to %s on %s", localFileDir.getAbsolutePath(), remoteFileEntry.getFullPath(), this.getSerialNumber());
        File[] localFiles = localFileDir.listFiles(new NoHiddenFilesFilter());
        ArrayList<String> filePathsToSync = new ArrayList<String>();
        for (File localFile : localFiles) {
            IFileEntry entry = remoteFileEntry.findChild(localFile.getName());
            if (entry == null) {
                LogUtil.CLog.d("Detected missing file path %s", localFile.getAbsolutePath());
                filePathsToSync.add(localFile.getAbsolutePath());
                continue;
            }
            if (localFile.isDirectory()) {
                if (this.syncFiles(localFile, entry)) continue;
                return false;
            }
            if (!this.isNewer(localFile, entry)) continue;
            LogUtil.CLog.d("Detected newer file %s", localFile.getAbsolutePath());
            filePathsToSync.add(localFile.getAbsolutePath());
        }
        if (filePathsToSync.size() == 0) {
            LogUtil.CLog.d("No files to sync");
            return true;
        }
        final String[] files = filePathsToSync.toArray(new String[filePathsToSync.size()]);
        DeviceAction syncAction = new DeviceAction(){

            @Override
            public boolean run() throws com.android.ddmlib.TimeoutException, IOException, AdbCommandRejectedException, SyncException {
                boolean status = false;
                try (SyncService syncService = null;){
                    syncService = NativeDevice.this.getIDevice().getSyncService();
                    syncService.push(files, remoteFileEntry.getFileEntry(), SyncService.getNullProgressMonitor());
                    status = true;
                }
                return status;
            }
        };
        return this.performDeviceAction(String.format("sync files %s", remoteFileEntry.getFullPath()), syncAction, 2);
    }

    FileListingService.FileEntry[] getFileChildren(FileListingService.FileEntry remoteFileEntry) throws DeviceNotAvailableException {
        FileQueryAction action = new FileQueryAction(remoteFileEntry, this.getIDevice().getFileListingService());
        this.performDeviceAction("buildFileCache", action, 1);
        return action.mFileContents;
    }

    private String getDeviceTimezone() {
        try {
            String timezone = this.getProperty("persist.sys.timezone");
            if (timezone != null) {
                return timezone.trim();
            }
        }
        catch (DeviceNotAvailableException deviceNotAvailableException) {
            // empty catch block
        }
        return "GMT";
    }

    @VisibleForTesting
    protected boolean isNewer(File localFile, IFileEntry entry) {
        String entryTimeString = String.format("%s %s", entry.getDate(), entry.getTime());
        try {
            String timezone = this.getDeviceTimezone();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            format.setTimeZone(TimeZone.getTimeZone(timezone));
            Date remoteDate = format.parse(entryTimeString);
            long offset = 0L;
            try {
                offset = this.getDeviceTimeOffset(null);
            }
            catch (DeviceNotAvailableException e) {
                offset = 0L;
            }
            LogUtil.CLog.i("Device offset time: %s", offset);
            return localFile.lastModified() > remoteDate.getTime() - 60000L + offset;
        }
        catch (ParseException e) {
            LogUtil.CLog.e("Error converting remote time stamp %s for %s on device %s", entryTimeString, entry.getFullPath(), this.getSerialNumber());
            return true;
        }
    }

    @Override
    public String executeAdbCommand(String ... cmdArgs) throws DeviceNotAvailableException {
        return this.executeAdbCommand(this.getCommandTimeout(), cmdArgs);
    }

    @Override
    public String executeAdbCommand(long timeout, String ... cmdArgs) throws DeviceNotAvailableException {
        return this.executeAdbCommand(this.getCommandTimeout(), new HashMap<String, String>(), cmdArgs);
    }

    @Override
    public String executeAdbCommand(long timeout, Map<String, String> envMap, String ... cmdArgs) throws DeviceNotAvailableException {
        String[] fullCmd = this.buildAdbCommand(cmdArgs);
        AdbAction adbAction = new AdbAction(timeout, fullCmd, "shell".equals(cmdArgs[0]), envMap);
        this.performDeviceAction(String.format("adb %s", cmdArgs[0]), adbAction, 2);
        return adbAction.mOutput;
    }

    @Override
    public CommandResult executeFastbootCommand(String ... cmdArgs) throws DeviceNotAvailableException, UnsupportedOperationException {
        return this.doFastbootCommand(this.getCommandTimeout(), cmdArgs);
    }

    @Override
    public CommandResult executeFastbootCommand(long timeout, String ... cmdArgs) throws DeviceNotAvailableException, UnsupportedOperationException {
        return this.doFastbootCommand(timeout, cmdArgs);
    }

    @Override
    public CommandResult executeLongFastbootCommand(String ... cmdArgs) throws DeviceNotAvailableException, UnsupportedOperationException {
        return this.executeLongFastbootCommand(new HashMap<String, String>(), cmdArgs);
    }

    @Override
    public CommandResult executeLongFastbootCommand(Map<String, String> envVarMap, String ... cmdArgs) throws DeviceNotAvailableException, UnsupportedOperationException {
        return this.doFastbootCommand(this.getLongCommandTimeout(), envVarMap, cmdArgs);
    }

    private CommandResult doFastbootCommand(long timeout, Map<String, String> envVarMap, String ... cmdArgs) throws DeviceNotAvailableException, UnsupportedOperationException {
        if (!this.mFastbootEnabled) {
            throw new UnsupportedOperationException(String.format("Attempted to fastboot on device %s , but fastboot is not available. Aborting.", this.getSerialNumber()));
        }
        File fastbootTmpDir = this.getHostOptions().getFastbootTmpDir();
        if (fastbootTmpDir != null) {
            envVarMap.put("TMPDIR", fastbootTmpDir.getAbsolutePath());
        }
        String[] fullCmd = this.buildFastbootCommand(cmdArgs);
        for (int i = 0; i < 2; ++i) {
            try (CloseableTraceScope ignored = new CloseableTraceScope("fastboot " + cmdArgs[0]);){
                CommandResult result = this.simpleFastbootCommand(timeout, envVarMap, fullCmd);
                if (!this.isRecoveryNeeded(result)) {
                    CommandResult commandResult = result;
                    return commandResult;
                }
                LogUtil.CLog.w("Recovery needed after executing fastboot command");
                if (result != null) {
                    LogUtil.CLog.v("fastboot command output:\nstdout: %s\nstderr:%s", result.getStdout(), result.getStderr());
                }
                this.recoverDeviceFromBootloader();
                continue;
            }
        }
        throw new DeviceUnresponsiveException(String.format("Attempted fastboot %s multiple times on device %s without communication success. Aborting.", cmdArgs[0], this.getSerialNumber()), this.getSerialNumber());
    }

    private CommandResult doFastbootCommand(long timeout, String ... cmdArgs) throws DeviceNotAvailableException, UnsupportedOperationException {
        return this.doFastbootCommand(timeout, new HashMap<String, String>(), cmdArgs);
    }

    @Override
    public boolean getUseFastbootErase() {
        return this.mOptions.getUseFastbootErase();
    }

    @Override
    public void setUseFastbootErase(boolean useFastbootErase) {
        this.mOptions.setUseFastbootErase(useFastbootErase);
    }

    @Override
    public CommandResult fastbootWipePartition(String partition) throws DeviceNotAvailableException {
        if (this.mOptions.getUseFastbootErase()) {
            return this.executeLongFastbootCommand("erase", partition);
        }
        return this.executeLongFastbootCommand("format", partition);
    }

    private boolean isRecoveryNeeded(CommandResult fastbootResult) {
        if (fastbootResult.getStatus().equals((Object)CommandStatus.TIMED_OUT)) {
            return true;
        }
        if (fastbootResult.getStderr() == null || fastbootResult.getStderr().contains("data transfer failure (Protocol error)") || fastbootResult.getStderr().contains("status read failed (No such device)")) {
            LogUtil.CLog.w("Bad fastboot response from device %s. stderr: %s. Entering recovery", this.getSerialNumber(), fastbootResult.getStderr());
            return true;
        }
        return false;
    }

    long getCommandTimeout() {
        return this.mOptions.getAdbCommandTimeout();
    }

    void setLongCommandTimeout(long timeout) {
        this.mLongCmdTimeout = timeout;
    }

    long getLongCommandTimeout() {
        return this.mLongCmdTimeout;
    }

    void setCommandTimeout(long timeout) {
        this.mOptions.setAdbCommandTimeout(timeout);
    }

    private String[] buildAdbCommand(String ... commandArgs) {
        return ArrayUtil.buildArray({"adb", "-s", this.getSerialNumber()}, commandArgs);
    }

    protected String[] buildAdbShellCommand(String command, boolean forceExitStatusDetection) {
        String[] commandArgs = QuotationAwareTokenizer.tokenizeLine(command, false);
        String[] exitStatusProbe = forceExitStatusDetection ? new String[]{";", "echo", "x$?"} : new String[]{};
        return ArrayUtil.buildArray({"adb", "-s", this.getSerialNumber(), "shell"}, commandArgs, exitStatusProbe);
    }

    private String[] buildFastbootCommand(String ... commandArgs) {
        return ArrayUtil.buildArray({this.getFastbootPath(), "-s", this.getFastbootSerialNumber()}, commandArgs);
    }

    /*
     * Exception decompiling
     */
    protected boolean performDeviceAction(String actionDescription, DeviceAction action, int retryAttempts) throws DeviceNotAvailableException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void logDeviceActionException(String actionDescription, Exception e, boolean logFullTrace) {
        LogUtil.CLog.w("%s (%s) when attempting %s on device %s", e.getClass().getSimpleName(), this.getExceptionMessage(e), actionDescription, this.getSerialNumber());
        if (logFullTrace) {
            LogUtil.CLog.w(e);
        }
    }

    private String getExceptionMessage(Exception e) {
        StringBuilder msgBuilder = new StringBuilder();
        if (e.getMessage() != null) {
            msgBuilder.append(e.getMessage());
        }
        if (e.getCause() != null) {
            msgBuilder.append(" cause: ");
            msgBuilder.append(e.getCause().getClass().getSimpleName());
            if (e.getCause().getMessage() != null) {
                msgBuilder.append(" (");
                msgBuilder.append(e.getCause().getMessage());
                msgBuilder.append(")");
            }
        }
        return msgBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean recoverDevice() throws DeviceNotAvailableException {
        this.getConnection().reconnectForRecovery(this.getSerialNumber());
        if (this.mRecoveryMode.equals((Object)ITestDevice.RecoveryMode.NONE)) {
            LogUtil.CLog.i("Skipping recovery on %s", this.getSerialNumber());
            return false;
        }
        LogUtil.CLog.i("Attempting recovery on %s", this.getSerialNumber());
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.RECOVERY_ROUTINE_COUNT, 1L);
        long startTime = System.currentTimeMillis();
        try {
            try {
                this.mRecovery.recoverDevice(this.mStateMonitor, this.mRecoveryMode.equals((Object)ITestDevice.RecoveryMode.ONLINE));
            }
            catch (DeviceUnresponsiveException due) {
                ITestDevice.RecoveryMode previousRecoveryMode;
                block12: {
                    previousRecoveryMode = this.mRecoveryMode;
                    this.mRecoveryMode = ITestDevice.RecoveryMode.NONE;
                    try {
                        boolean enabled = this.enableAdbRoot();
                        LogUtil.CLog.d("Device Unresponsive during recovery, is root still enabled: %s", enabled);
                    }
                    catch (DeviceUnresponsiveException e) {
                        AdbCommandRejectedException adbException;
                        LogUtil.CLog.e("Exception occurred during recovery adb root:");
                        LogUtil.CLog.e(e);
                        Throwable cause = e.getCause();
                        if (cause == null || !(cause instanceof AdbCommandRejectedException) || !(adbException = (AdbCommandRejectedException)cause).isDeviceOffline() && !adbException.wasErrorDuringDeviceSelection()) break block12;
                        throw new DeviceNotAvailableException(cause.getMessage(), (Throwable)adbException, this.getSerialNumber(), DeviceErrorIdentifier.DEVICE_UNAVAILABLE);
                    }
                }
                this.mRecoveryMode = previousRecoveryMode;
                throw due;
            }
            if (this.mRecoveryMode.equals((Object)ITestDevice.RecoveryMode.AVAILABLE)) {
                this.mRecoveryMode = ITestDevice.RecoveryMode.NONE;
                if (this.isEncryptionSupported() && this.isDeviceEncrypted()) {
                    this.unlockDevice();
                }
                this.postBootSetup();
                this.mRecoveryMode = ITestDevice.RecoveryMode.AVAILABLE;
            } else if (this.mRecoveryMode.equals((Object)ITestDevice.RecoveryMode.ONLINE)) {
                this.mRecoveryMode = ITestDevice.RecoveryMode.NONE;
                this.enableAdbRoot();
                this.mRecoveryMode = ITestDevice.RecoveryMode.ONLINE;
            }
        }
        finally {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.RECOVERY_TIME, System.currentTimeMillis() - startTime);
        }
        LogUtil.CLog.i("Recovery successful for %s", this.getSerialNumber());
        return true;
    }

    private void recoverDeviceFromBootloader() throws DeviceNotAvailableException {
        LogUtil.CLog.i("Attempting recovery on %s in bootloader", this.getSerialNumber());
        this.mRecovery.recoverDeviceBootloader(this.mStateMonitor);
        LogUtil.CLog.i("Bootloader recovery successful for %s", this.getSerialNumber());
    }

    private void recoverDeviceFromFastbootd() throws DeviceNotAvailableException {
        LogUtil.CLog.i("Attempting recovery on %s in fastbootd", this.getSerialNumber());
        this.mRecovery.recoverDeviceFastbootd(this.mStateMonitor);
        LogUtil.CLog.i("Fastbootd recovery successful for %s", this.getSerialNumber());
    }

    private void recoverDeviceInRecovery() throws DeviceNotAvailableException {
        LogUtil.CLog.i("Attempting recovery on %s in recovery", this.getSerialNumber());
        this.mRecovery.recoverDeviceRecovery(this.mStateMonitor);
        LogUtil.CLog.i("Recovery mode recovery successful for %s", this.getSerialNumber());
    }

    @Override
    public void startLogcat() {
        if (this.mLogcatReceiver != null) {
            LogUtil.CLog.d("Already capturing logcat for %s, ignoring", this.getSerialNumber());
            return;
        }
        this.mLogcatReceiver = this.createLogcatReceiver();
        this.mLogcatReceiver.start();
    }

    @Override
    public void clearLogcat() {
        if (this.mLogcatReceiver != null) {
            this.mLogcatReceiver.clear();
        }
    }

    @Override
    public InputStreamSource getLogcat() {
        if (this.mLogcatReceiver == null) {
            if (!(this.getIDevice() instanceof StubDevice)) {
                TestDeviceState state = this.getDeviceState();
                if (!TestDeviceState.ONLINE.equals((Object)state)) {
                    LogUtil.CLog.w("Skipping logcat capture, no buffer and device state is '%s'", new Object[]{state});
                } else {
                    LogUtil.CLog.w("Not capturing logcat for %s in background, returning a logcat dump", this.getSerialNumber());
                    return this.getLogcatDump();
                }
            }
            return new ByteArrayInputStreamSource(new byte[0]);
        }
        return this.mLogcatReceiver.getLogcatData();
    }

    @Override
    public InputStreamSource getLogcat(int maxBytes) {
        if (this.mLogcatReceiver == null) {
            LogUtil.CLog.w("Not capturing logcat for %s in background, returning a logcat dump ignoring size", this.getSerialNumber());
            return this.getLogcatDump();
        }
        return this.mLogcatReceiver.getLogcatData(maxBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStreamSource getLogcatSince(long date) {
        String dateFormatted;
        int deviceApiLevel;
        try {
            deviceApiLevel = this.getApiLevel();
            if (deviceApiLevel <= 22) {
                LogUtil.CLog.i("Api level too low to use logcat -t 'time' reverting to dump");
                return this.getLogcatDump();
            }
        }
        catch (DeviceNotAvailableException e) {
            LogUtil.CLog.e(e);
            return this.getLogcatDump();
        }
        if (deviceApiLevel >= 24) {
            dateFormatted = String.format(Locale.US, "%d.%03d", date / 1000L, date % 1000L);
        } else {
            SimpleDateFormat format = new SimpleDateFormat("MM-dd HH:mm:ss.SSS");
            dateFormatted = format.format(new Date(date));
        }
        LargeOutputReceiver largeReceiver = null;
        try {
            largeReceiver = new LargeOutputReceiver("getLogcatSince", this.getSerialNumber(), this.getOptions().getMaxLogcatDataSize());
            String command = String.format("%s -t '%s'", LogcatReceiver.getDefaultLogcatCmd(this), dateFormatted);
            this.getIDevice().executeShellCommand(command, largeReceiver);
            InputStreamSource inputStreamSource = largeReceiver.getData();
            return inputStreamSource;
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | com.android.ddmlib.TimeoutException | IOException e) {
            LogUtil.CLog.w("Failed to get logcat dump from %s: %s", this.getSerialNumber(), e.getMessage());
            LogUtil.CLog.e(e);
        }
        finally {
            if (largeReceiver != null) {
                largeReceiver.cancel();
                largeReceiver.delete();
            }
        }
        return new ByteArrayInputStreamSource(new byte[0]);
    }

    /*
     * Exception decompiling
     */
    @Override
    public InputStreamSource getLogcatDump() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void stopLogcat() {
        if (this.mLogcatReceiver != null) {
            this.mLogcatReceiver.stop();
            this.mLogcatReceiver = null;
        } else {
            LogUtil.CLog.w("Attempting to stop logcat when not capturing for %s", this.getSerialNumber());
        }
    }

    @VisibleForTesting
    LogcatReceiver createLogcatReceiver() {
        String logcatOptions = this.mOptions.getLogcatOptions();
        if (SystemUtil.isLocalMode()) {
            this.mLogStartDelay = 0;
        }
        if (logcatOptions == null) {
            return new LogcatReceiver(this, this.mOptions.getMaxLogcatDataSize(), this.mLogStartDelay);
        }
        return new LogcatReceiver(this, String.format("%s %s", LogcatReceiver.getDefaultLogcatCmd(this), logcatOptions), this.mOptions.getMaxLogcatDataSize(), this.mLogStartDelay);
    }

    @Override
    public InputStreamSource getBugreport() {
        return null;
    }

    @Override
    public boolean logBugreport(String dataName, ITestLogger listener) {
        return true;
    }

    @Override
    public Bugreport takeBugreport() {
        return null;
    }

    @Override
    public InputStreamSource getBugreportz() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean logAnrs(ITestLogger logger) throws DeviceNotAvailableException {
        if (!this.doesFileExist(ANRS_PATH)) {
            LogUtil.CLog.d("No ANRs at %s", ANRS_PATH);
            return true;
        }
        boolean root = this.enableAdbRoot();
        if (!root) {
            LogUtil.CLog.d("Skipping logAnrs, need to be root.");
        }
        File localDir = null;
        long startTime = System.currentTimeMillis();
        try {
            localDir = FileUtil.createTempDir("pulled-anrs");
            boolean success = this.pullDir(ANRS_PATH, localDir);
            if (!success) {
                LogUtil.CLog.w("Failed to pull %s", ANRS_PATH);
                boolean bl = false;
                return bl;
            }
            if (localDir.listFiles().length == 0) {
                boolean bl = true;
                return bl;
            }
            for (File f : localDir.listFiles()) {
                try (FileInputStreamSource source = new FileInputStreamSource(f);){
                    String name = f.getName();
                    LogDataType type = LogDataType.ANRS;
                    if (name.startsWith("dumptrace")) {
                        type = LogDataType.DUMPTRACE;
                    }
                    logger.testLog(name, type, source);
                }
            }
        }
        catch (IOException e) {
            LogUtil.CLog.e(e);
            boolean bl = false;
            return bl;
        }
        finally {
            FileUtil.recursiveDelete(localDir);
        }
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.ANR_TIME, System.currentTimeMillis() - startTime);
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.ANR_COUNT, 1L);
        return true;
    }

    @Override
    public InputStreamSource getScreenshot() throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for Screenshot");
    }

    @Override
    public InputStreamSource getScreenshot(String format) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for Screenshot");
    }

    @Override
    public InputStreamSource getScreenshot(String format, boolean rescale) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for Screenshot");
    }

    @Override
    public InputStreamSource getScreenshot(long displayId) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for Screenshot");
    }

    @Override
    public void clearLastConnectedWifiNetwork() {
        this.mLastConnectedWifiSsid = null;
        this.mLastConnectedWifiPsk = null;
    }

    @Override
    public boolean connectToWifiNetwork(String wifiSsid, String wifiPsk) throws DeviceNotAvailableException {
        return this.connectToWifiNetwork(wifiSsid, wifiPsk, false);
    }

    @Override
    public boolean connectToWifiNetwork(String wifiSsid, String wifiPsk, boolean scanSsid) throws DeviceNotAvailableException {
        LinkedHashMap<String, String> ssidToPsk = new LinkedHashMap<String, String>();
        ssidToPsk.put(wifiSsid, wifiPsk);
        return this.connectToWifiNetwork(ssidToPsk, scanSsid);
    }

    @Override
    public boolean connectToWifiNetwork(Map<String, String> wifiSsidToPsk) throws DeviceNotAvailableException {
        return this.connectToWifiNetwork(wifiSsidToPsk, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean connectToWifiNetwork(Map<String, String> wifiSsidToPsk, boolean scanSsid) throws DeviceNotAvailableException {
        this.mLastConnectedWifiSsid = null;
        this.mLastConnectedWifiPsk = null;
        Random rnd = new Random();
        int backoffSlotCount = 2;
        int slotTime = this.mOptions.getWifiRetryWaitTime();
        int waitTime = 0;
        IWifiHelper wifi = this.createWifiHelper();
        long startTime = this.mClock.millis();
        try (CloseableTraceScope ignored = new CloseableTraceScope("connectToWifiNetwork");){
            int i = 1;
            while (i <= this.mOptions.getWifiAttempts()) {
                boolean failedToEnableWifi = false;
                for (Map.Entry<String, String> ssidToPsk : wifiSsidToPsk.entrySet()) {
                    String wifiSsid = ssidToPsk.getKey();
                    String wifiPsk = Strings.emptyToNull(ssidToPsk.getValue());
                    InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.WIFI_CONNECT_RETRY_COUNT, i);
                    LogUtil.CLog.i("Connecting to wifi network %s on %s", wifiSsid, this.getSerialNumber());
                    IWifiHelper.WifiConnectionResult result = wifi.connectToNetwork(wifiSsid, wifiPsk, this.mOptions.getConnCheckUrl(), scanSsid);
                    Map<String, String> wifiInfo = wifi.getWifiInfo();
                    if (IWifiHelper.WifiConnectionResult.SUCCESS.equals((Object)result)) {
                        LogUtil.CLog.i("Successfully connected to wifi network %s(%s) on %s", wifiSsid, wifiInfo.get("bssid"), this.getSerialNumber());
                        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.WIFI_AP_NAME, wifiSsid);
                        this.mLastConnectedWifiSsid = wifiSsid;
                        this.mLastConnectedWifiPsk = wifiPsk;
                        boolean bl = true;
                        return bl;
                    }
                    if (IWifiHelper.WifiConnectionResult.FAILED_TO_ENABLE.equals((Object)result)) {
                        LogUtil.CLog.w("Failed to enable wifi");
                        failedToEnableWifi = true;
                        continue;
                    }
                    failedToEnableWifi = false;
                    LogUtil.CLog.w("Failed to connect to wifi network %s(%s) on %s on attempt %d of %d", wifiSsid, wifiInfo.get("bssid"), this.getSerialNumber(), i, this.mOptions.getWifiAttempts());
                }
                if (this.mClock.millis() - startTime >= this.mOptions.getMaxWifiConnectTime()) {
                    LogUtil.CLog.e("Failed to connect to wifi after %d ms. Aborting.", this.mOptions.getMaxWifiConnectTime());
                    return false;
                }
                if (i < this.mOptions.getWifiAttempts() && !failedToEnableWifi) {
                    if (this.mOptions.isWifiExpoRetryEnabled()) {
                        waitTime = rnd.nextInt(backoffSlotCount) * slotTime;
                        backoffSlotCount *= 2;
                    }
                    LogUtil.CLog.e("Waiting for %d ms before reconnecting to %s...", waitTime, wifiSsidToPsk.keySet().toString());
                    this.getRunUtil().sleep(waitTime);
                }
                ++i;
            }
            return false;
        }
        finally {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.WIFI_CONNECT_TIME, this.mClock.millis() - startTime);
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.WIFI_CONNECT_COUNT, 1L);
        }
    }

    @Override
    public boolean checkConnectivity() throws DeviceNotAvailableException {
        IWifiHelper wifi = this.createWifiHelper();
        return wifi.checkConnectivity(this.mOptions.getConnCheckUrl());
    }

    @Override
    public boolean connectToWifiNetworkIfNeeded(String wifiSsid, String wifiPsk) throws DeviceNotAvailableException {
        return this.connectToWifiNetworkIfNeeded(wifiSsid, wifiPsk, false);
    }

    @Override
    public boolean connectToWifiNetworkIfNeeded(String wifiSsid, String wifiPsk, boolean scanSsid) throws DeviceNotAvailableException {
        if (!this.checkConnectivity()) {
            return this.connectToWifiNetwork(wifiSsid, wifiPsk, scanSsid);
        }
        return true;
    }

    @Override
    public boolean isWifiEnabled() throws DeviceNotAvailableException {
        IWifiHelper wifi = this.createWifiHelper();
        try {
            return wifi.isWifiEnabled();
        }
        catch (RuntimeException e) {
            LogUtil.CLog.w("Failed to create WifiHelper: %s", e.getMessage());
            return false;
        }
    }

    boolean checkWifiConnection(String wifiSSID) throws DeviceNotAvailableException {
        LogUtil.CLog.i("Checking connection with wifi network %s on %s", wifiSSID, this.getSerialNumber());
        IWifiHelper wifi = this.createWifiHelper();
        String quotedSSID = String.format("\"%s\"", wifiSSID);
        boolean test = wifi.isWifiEnabled();
        LogUtil.CLog.v("%s: wifi enabled? %b", this.getSerialNumber(), test);
        if (test) {
            String actualSSID = wifi.getSSID();
            test = quotedSSID.equals(actualSSID);
            LogUtil.CLog.v("%s: SSID match (%s, %s, %b)", this.getSerialNumber(), quotedSSID, actualSSID, test);
        }
        if (test) {
            test = wifi.hasValidIp();
            LogUtil.CLog.v("%s: validIP? %b", this.getSerialNumber(), test);
        }
        if (test) {
            test = this.checkConnectivity();
            LogUtil.CLog.v("%s: checkConnectivity returned %b", this.getSerialNumber(), test);
        }
        return test;
    }

    @Override
    public boolean disconnectFromWifi() throws DeviceNotAvailableException {
        LogUtil.CLog.i("Disconnecting from wifi on %s", this.getSerialNumber());
        this.mLastConnectedWifiSsid = null;
        this.mLastConnectedWifiPsk = null;
        IWifiHelper wifi = this.createWifiHelper();
        return wifi.disconnectFromNetwork();
    }

    @Override
    public String getIpAddress() throws DeviceNotAvailableException {
        IWifiHelper wifi = this.createWifiHelper();
        return wifi.getIpAddress();
    }

    @Override
    public boolean enableNetworkMonitor() throws DeviceNotAvailableException {
        this.mNetworkMonitorEnabled = false;
        IWifiHelper wifi = this.createWifiHelper();
        wifi.stopMonitor();
        if (wifi.startMonitor(10000L, this.mOptions.getConnCheckUrl())) {
            this.mNetworkMonitorEnabled = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean disableNetworkMonitor() throws DeviceNotAvailableException {
        this.mNetworkMonitorEnabled = false;
        IWifiHelper wifi = this.createWifiHelper();
        List<Long> samples = wifi.stopMonitor();
        if (!samples.isEmpty()) {
            int failures = 0;
            long totalLatency = 0L;
            for (Long sample : samples) {
                if (sample < 0L) {
                    ++failures;
                    continue;
                }
                totalLatency += sample.longValue();
            }
            double failureRate = (double)failures * 100.0 / (double)samples.size();
            double avgLatency = 0.0;
            if (failures < samples.size()) {
                avgLatency = totalLatency / (long)(samples.size() - failures);
            }
            LogUtil.CLog.d("[metric] url=%s, window=%ss, failure_rate=%.2f%%, latency_avg=%.2f", this.mOptions.getConnCheckUrl(), samples.size() * 10000 / 1000, failureRate, avgLatency);
        }
        return true;
    }

    @VisibleForTesting
    IWifiHelper createWifiHelper() throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("Wifi helper is not supported.");
    }

    @Override
    public boolean clearErrorDialogs() throws DeviceNotAvailableException {
        LogUtil.CLog.e("No support for Screen's features");
        return false;
    }

    @Override
    public KeyguardControllerState getKeyguardState() throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for keyguard querying.");
    }

    IDeviceStateMonitor getDeviceStateMonitor() {
        return this.mStateMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postBootSetup() throws DeviceNotAvailableException {
        if (this.getOptions().shouldDisableReboot()) {
            return;
        }
        this.getConnection().reconnect(this.getSerialNumber());
        LogUtil.CLog.d("postBootSetup started");
        long startTime = System.currentTimeMillis();
        try (CloseableTraceScope ignored = new CloseableTraceScope("postBootSetup");){
            this.enableAdbRoot();
            this.prePostBootSetup();
            for (String command : this.mOptions.getPostBootCommands()) {
                long start = System.currentTimeMillis();
                try (CloseableTraceScope cmdTrace = new CloseableTraceScope(command);){
                    this.executeShellCommand(command);
                }
                if (!command.startsWith("sleep")) continue;
                InvocationMetricLogger.addInvocationPairMetrics(InvocationMetricLogger.InvocationMetricKey.host_sleep, start, System.currentTimeMillis());
            }
        }
        catch (Throwable throwable) {
            long elapsed = System.currentTimeMillis() - startTime;
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.POSTBOOT_SETUP_TIME, elapsed);
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.POSTBOOT_SETUP_COUNT, 1L);
            LogUtil.CLog.d("postBootSetup done: %s", TimeUtil.formatElapsedTime(elapsed));
            throw throwable;
        }
        long elapsed = System.currentTimeMillis() - startTime;
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.POSTBOOT_SETUP_TIME, elapsed);
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.POSTBOOT_SETUP_COUNT, 1L);
        LogUtil.CLog.d("postBootSetup done: %s", TimeUtil.formatElapsedTime(elapsed));
    }

    protected void prePostBootSetup() throws DeviceNotAvailableException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postBootWifiSetup() throws DeviceNotAvailableException {
        LogUtil.CLog.d("postBootWifiSetup started");
        long startTime = System.currentTimeMillis();
        try (CloseableTraceScope ignored = new CloseableTraceScope("postBootWifiSetup");){
            if (this.mLastConnectedWifiSsid != null) {
                this.reconnectToWifiNetwork();
            }
            if (this.mNetworkMonitorEnabled && !this.enableNetworkMonitor()) {
                LogUtil.CLog.w("Failed to enable network monitor on %s after reboot", this.getSerialNumber());
            }
        }
        catch (Throwable throwable) {
            long elapsed = System.currentTimeMillis() - startTime;
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.POSTBOOT_WIFI_SETUP_TIME, elapsed);
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.POSTBOOT_WIFI_SETUP_COUNT, 1L);
            LogUtil.CLog.d("postBootWifiSetup done: %s", TimeUtil.formatElapsedTime(elapsed));
            throw throwable;
        }
        long elapsed = System.currentTimeMillis() - startTime;
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.POSTBOOT_WIFI_SETUP_TIME, elapsed);
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.POSTBOOT_WIFI_SETUP_COUNT, 1L);
        LogUtil.CLog.d("postBootWifiSetup done: %s", TimeUtil.formatElapsedTime(elapsed));
    }

    void reconnectToWifiNetwork() throws DeviceNotAvailableException {
        long startTime = System.currentTimeMillis();
        boolean isConnected = this.checkConnectivity();
        while (!isConnected && System.currentTimeMillis() - startTime < 60000L) {
            this.getRunUtil().sleep(1000L);
            isConnected = this.checkConnectivity();
        }
        if (isConnected) {
            return;
        }
        String wifiSsid = this.mLastConnectedWifiSsid;
        if (!this.connectToWifiNetworkIfNeeded(this.mLastConnectedWifiSsid, this.mLastConnectedWifiPsk)) {
            throw new NetworkNotAvailableException(String.format("Failed to connect to wifi network %s on %s after reboot", wifiSsid, this.getSerialNumber()));
        }
    }

    @Override
    public void rebootIntoBootloader() throws DeviceNotAvailableException, UnsupportedOperationException {
        if (this.isInRebootCallback()) {
            LogUtil.CLog.d("'%s' action is disabled during reboot callback. Ignoring.", "Reboot into Bootloader");
            return;
        }
        this.rebootIntoFastbootInternal(true);
    }

    @Override
    public void rebootIntoFastbootd() throws DeviceNotAvailableException, UnsupportedOperationException {
        if (this.isInRebootCallback()) {
            LogUtil.CLog.d("'%s' action is disabled during reboot callback. Ignoring.", "Reboot into Fastbootd");
            return;
        }
        this.rebootIntoFastbootInternal(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebootIntoFastbootInternal(boolean isBootloader) throws DeviceNotAvailableException {
        RebootMode mode;
        this.invalidatePropertyCache();
        RebootMode rebootMode = mode = isBootloader ? RebootMode.REBOOT_INTO_BOOTLOADER : RebootMode.REBOOT_INTO_FASTBOOTD;
        if (!this.mFastbootEnabled) {
            throw new UnsupportedOperationException(String.format("Fastboot is not available and cannot reboot into %s", new Object[]{mode}));
        }
        long startTime = System.currentTimeMillis();
        try (CloseableTraceScope ignored = new CloseableTraceScope("reboot_in_" + mode.toString());){
            this.mStateMonitor.setFastbootSerialNumber(this.getFastbootSerialNumber());
            this.mShouldSkipContentProviderSetup = false;
            LogUtil.CLog.i("Rebooting device %s in state %s into %s", new Object[]{this.getSerialNumber(), this.getDeviceState(), mode});
            if (this.isStateBootloaderOrFastbootd()) {
                LogUtil.CLog.i("device %s already in %s. Rebooting anyway", new Object[]{this.getSerialNumber(), this.getDeviceState()});
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.BOOTLOADER_SAME_STATE_REBOOT, 1L);
                this.executeFastbootCommand(String.format("reboot-%s", new Object[]{mode}));
            } else {
                LogUtil.CLog.i("Booting device %s into %s", new Object[]{this.getSerialNumber(), mode});
                this.doAdbReboot(mode, null);
            }
            this.getRunUtil().sleep(1500L);
            if (RebootMode.REBOOT_INTO_FASTBOOTD.equals((Object)mode) && this.getHostOptions().isFastbootdEnable()) {
                if (!this.mStateMonitor.waitForDeviceFastbootd(this.getFastbootPath(), this.mOptions.getFastbootTimeout())) {
                    this.recoverDeviceFromFastbootd();
                }
            } else {
                this.waitForDeviceBootloader();
            }
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - startTime;
            if (RebootMode.REBOOT_INTO_FASTBOOTD.equals((Object)mode)) {
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.FASTBOOTD_REBOOT_TIME, elapsedTime);
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.FASTBOOTD_REBOOT_COUNT, 1L);
            } else {
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.BOOTLOADER_REBOOT_TIME, elapsedTime);
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.BOOTLOADER_REBOOT_COUNT, 1L);
            }
        }
    }

    @Override
    public boolean isStateBootloaderOrFastbootd() {
        return TestDeviceState.FASTBOOT.equals((Object)this.getDeviceState()) || TestDeviceState.FASTBOOTD.equals((Object)this.getDeviceState());
    }

    @Override
    public void reboot() throws DeviceNotAvailableException {
        this.reboot(null);
    }

    @Override
    public void reboot(@Nullable String reason) throws DeviceNotAvailableException {
        if (this.isInRebootCallback()) {
            LogUtil.CLog.d("'%s' action is disabled during reboot callback. Ignoring.", "Reboot");
            return;
        }
        this.internalRebootUntilOnline(reason);
        ITestDevice.RecoveryMode cachedRecoveryMode = this.getRecoveryMode();
        this.setRecoveryMode(ITestDevice.RecoveryMode.ONLINE);
        if (this.isEncryptionSupported() && this.isDeviceEncrypted()) {
            this.unlockDevice();
        }
        this.setRecoveryMode(cachedRecoveryMode);
        try (CloseableTraceScope ignored = new CloseableTraceScope("reboot_waitForDeviceAvailable");){
            this.waitForDeviceAvailable(this.mOptions.getRebootTimeout());
        }
        this.postBootSetup();
        this.postBootWifiSetup();
        this.notifyRebootEnded();
    }

    @Override
    public void rebootUserspace() throws DeviceNotAvailableException {
        if (this.isInRebootCallback()) {
            LogUtil.CLog.d("'%s' action is disabled during reboot callback. Ignoring.", "Reboot Userspace");
            return;
        }
        this.rebootUserspaceUntilOnline();
        ITestDevice.RecoveryMode cachedRecoveryMode = this.getRecoveryMode();
        this.setRecoveryMode(ITestDevice.RecoveryMode.ONLINE);
        if (this.isEncryptionSupported() && this.isDeviceEncrypted()) {
            LogUtil.CLog.e("Device is encrypted after userspace reboot!");
            this.unlockDevice();
        }
        this.setRecoveryMode(cachedRecoveryMode);
        this.waitForDeviceAvailable(this.mOptions.getRebootTimeout());
        this.postBootSetup();
        this.postBootWifiSetup();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void rebootUntilOnline() throws DeviceNotAvailableException {
        if (this.isInRebootCallback()) {
            LogUtil.CLog.d("'%s' action is disabled during reboot callback. Ignoring.", "Reboot Until Online");
            return;
        }
        try {
            this.internalRebootUntilOnline(null);
            if (this.mDeviceActionReceivers.isEmpty()) return;
        }
        catch (Throwable throwable) {
            if (this.mDeviceActionReceivers.isEmpty()) throw throwable;
            LogUtil.CLog.d("DeviceActionReceivers were not notified after rebootUntilOnline on %s.", this.getSerialNumber());
            throw throwable;
        }
        LogUtil.CLog.d("DeviceActionReceivers were not notified after rebootUntilOnline on %s.", this.getSerialNumber());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void rebootUntilOnline(@Nullable String reason) throws DeviceNotAvailableException {
        if (this.isInRebootCallback()) {
            LogUtil.CLog.d("'%s' action is disabled during reboot callback. Ignoring.", "Reboot Until Online");
            return;
        }
        try {
            this.internalRebootUntilOnline(reason);
            if (this.mDeviceActionReceivers.isEmpty()) return;
        }
        catch (Throwable throwable) {
            if (this.mDeviceActionReceivers.isEmpty()) throw throwable;
            LogUtil.CLog.d("DeviceActionReceivers were not notified after rebootUntilOnline on %s.", this.getSerialNumber());
            throw throwable;
        }
        LogUtil.CLog.d("DeviceActionReceivers were not notified after rebootUntilOnline on %s.", this.getSerialNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalRebootUntilOnline(@Nullable String reason) throws DeviceNotAvailableException {
        long rebootStart = System.currentTimeMillis();
        try (CloseableTraceScope ignored = new CloseableTraceScope("rebootUntilOnline");){
            this.mPropertiesCache.invalidateAll();
            this.doReboot(RebootMode.REBOOT_FULL, reason);
            ITestDevice.RecoveryMode cachedRecoveryMode = this.getRecoveryMode();
            this.setRecoveryMode(ITestDevice.RecoveryMode.ONLINE);
            this.waitForDeviceOnline();
            this.enableAdbRoot();
            this.setRecoveryMode(cachedRecoveryMode);
        }
        finally {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.ADB_REBOOT_TIME, System.currentTimeMillis() - rebootStart);
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.ADB_REBOOT_ROUTINE_COUNT, 1L);
        }
    }

    @Override
    public void rebootUserspaceUntilOnline() throws DeviceNotAvailableException {
        if (this.isInRebootCallback()) {
            LogUtil.CLog.d("'%s' action is disabled during reboot callback. Ignoring.", "Reboot Userspace Until Online");
            return;
        }
        this.doReboot(RebootMode.REBOOT_USERSPACE, null);
        ITestDevice.RecoveryMode cachedRecoveryMode = this.getRecoveryMode();
        this.setRecoveryMode(ITestDevice.RecoveryMode.ONLINE);
        this.waitForDeviceOnline();
        this.enableAdbRoot();
        this.setRecoveryMode(cachedRecoveryMode);
    }

    @Override
    public void rebootIntoRecovery() throws DeviceNotAvailableException {
        if (this.isInRebootCallback()) {
            LogUtil.CLog.d("'%s' action is disabled during reboot callback. Ignoring.", "Reboot into Recovery");
            return;
        }
        if (this.isStateBootloaderOrFastbootd()) {
            LogUtil.CLog.w("device %s in fastboot when requesting boot to recovery. Rebooting to userspace first.", this.getSerialNumber());
            this.internalRebootUntilOnline(null);
        }
        this.doAdbReboot(RebootMode.REBOOT_INTO_RECOVERY, null);
        if (!this.waitForDeviceInRecovery(this.mOptions.getAdbRecoveryTimeout())) {
            this.recoverDeviceInRecovery();
        }
    }

    @Override
    public void rebootIntoSideload() throws DeviceNotAvailableException {
        this.rebootIntoSideload(false);
    }

    @Override
    public void rebootIntoSideload(boolean autoReboot) throws DeviceNotAvailableException {
        if (this.isInRebootCallback()) {
            LogUtil.CLog.d("'%s' action is disabled during reboot callback. Ignoring.", "Reboot into Sideload");
            return;
        }
        if (this.isStateBootloaderOrFastbootd()) {
            LogUtil.CLog.w("device %s in fastboot when requesting boot to sideload. Rebooting to userspace first.", this.getSerialNumber());
            this.internalRebootUntilOnline(null);
        }
        RebootMode rebootMode = autoReboot ? RebootMode.REBOOT_INTO_SIDELOAD_AUTO_REBOOT : RebootMode.REBOOT_INTO_SIDELOAD;
        this.doAdbReboot(rebootMode, null);
        if (!this.waitForDeviceInSideload(this.mOptions.getAdbRecoveryTimeout())) {
            this.recoverDeviceInRecovery();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void nonBlockingReboot() throws DeviceNotAvailableException {
        if (this.isInRebootCallback()) {
            LogUtil.CLog.d("'%s' action is disabled during reboot callback. Ignoring.", "Non Blocking Reboot");
            return;
        }
        try {
            this.doReboot(RebootMode.REBOOT_FULL, null);
            if (this.mDeviceActionReceivers.isEmpty()) return;
        }
        catch (Throwable throwable) {
            if (this.mDeviceActionReceivers.isEmpty()) throw throwable;
            LogUtil.CLog.d("DeviceActionReceivers were not notified after nonBlockingReboot on %s.", this.getSerialNumber());
            throw throwable;
        }
        LogUtil.CLog.d("DeviceActionReceivers were not notified after nonBlockingReboot on %s.", this.getSerialNumber());
    }

    @VisibleForTesting
    void doReboot(RebootMode rebootMode, @Nullable String reason) throws DeviceNotAvailableException, UnsupportedOperationException {
        this.mLastTradefedRebootTime = System.currentTimeMillis();
        if (this.isStateBootloaderOrFastbootd()) {
            LogUtil.CLog.i("device %s in %s. Rebooting to userspace.", new Object[]{this.getSerialNumber(), this.getDeviceState()});
            this.executeFastbootCommand("reboot");
        } else {
            if (this.mOptions.shouldDisableReboot()) {
                LogUtil.CLog.i("Device reboot disabled by options, skipped.");
                return;
            }
            if (reason == null) {
                LogUtil.CLog.i("Rebooting device %s mode: %s", this.getSerialNumber(), rebootMode.name());
            } else {
                LogUtil.CLog.i("Rebooting device %s mode: %s reason: %s", this.getSerialNumber(), rebootMode.name(), reason);
            }
            this.doAdbReboot(rebootMode, reason);
            this.postAdbReboot();
        }
    }

    protected void postAdbReboot() throws DeviceNotAvailableException {
        boolean notAvailable = this.waitForDeviceNotAvailable(20000L);
        if (!notAvailable) {
            LogUtil.CLog.w("Did not detect device %s becoming unavailable after reboot", this.getSerialNumber());
        }
        this.getConnection().reconnect(this.getSerialNumber());
    }

    protected void doAdbReboot(RebootMode rebootMode, @Nullable String reason) throws DeviceNotAvailableException {
        this.getConnection().notifyAdbRebootCalled();
        RebootDeviceAction rebootAction = this.createRebootDeviceAction(rebootMode, reason);
        this.performDeviceAction("reboot", rebootAction, 2);
    }

    protected RebootDeviceAction createRebootDeviceAction(RebootMode rebootMode, @Nullable String reason) {
        return new RebootDeviceAction(rebootMode, reason);
    }

    protected boolean waitForDeviceNotAvailable(String operationDesc, long time) {
        if (!this.mStateMonitor.waitForDeviceNotAvailable(time)) {
            LogUtil.CLog.w("Did not detect device %s becoming unavailable after %s", this.getSerialNumber(), operationDesc);
            return false;
        }
        return true;
    }

    @Override
    public boolean waitForDeviceNotAvailable(long waitTime) {
        return this.mStateMonitor.waitForDeviceNotAvailable(waitTime);
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean enableAdbRoot() throws DeviceNotAvailableException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[FORLOOP]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean disableAdbRoot() throws DeviceNotAvailableException {
        if (!this.isAdbRoot()) {
            LogUtil.CLog.i("adb is already unroot on %s", this.getSerialNumber());
            return true;
        }
        LogUtil.CLog.i("adb unroot on device %s", this.getSerialNumber());
        int attempts = 3;
        for (int i = 1; i <= attempts; ++i) {
            String output = this.executeAdbCommand("unroot");
            this.waitForDeviceNotAvailable("unroot", 5000L);
            this.postAdbUnrootAction();
            this.waitForDeviceOnline();
            if (!this.isAdbRoot()) {
                return true;
            }
            LogUtil.CLog.w("'adb unroot' on %s unsuccessful on attempt %d of %d. Output: '%s'", this.getSerialNumber(), i, attempts, output);
        }
        return false;
    }

    public void postAdbRootAction() throws DeviceNotAvailableException {
        this.getConnection().reconnect(this.getSerialNumber());
    }

    public void postAdbUnrootAction() throws DeviceNotAvailableException {
        this.getConnection().reconnect(this.getSerialNumber());
    }

    @Override
    public boolean isAdbRoot() throws DeviceNotAvailableException {
        String output = this.executeShellCommand("id");
        return output.contains("uid=0(root)");
    }

    @Override
    public boolean unlockDevice() throws DeviceNotAvailableException, UnsupportedOperationException {
        String output;
        if (!this.isEncryptionSupported()) {
            throw new UnsupportedOperationException(String.format("Can't unlock device %s: encryption not supported", this.getSerialNumber()));
        }
        if (!this.isDeviceEncrypted()) {
            LogUtil.CLog.d("Device %s is not encrypted, skipping", this.getSerialNumber());
            return true;
        }
        String encryptionType = this.getProperty("ro.crypto.type");
        if (!"block".equals(encryptionType)) {
            LogUtil.CLog.d("Skipping unlockDevice since it's not encrypted. ro.crypto.type=%s", encryptionType);
            return true;
        }
        LogUtil.CLog.i("Unlocking device %s", this.getSerialNumber());
        this.enableAdbRoot();
        int i = 0;
        do {
            if ((output = this.executeShellCommand(String.format("vdc cryptfs checkpw \"%s\"", ENCRYPTION_PASSWORD)).trim()).startsWith("200 ") && output.endsWith(" -1")) {
                return true;
            }
            if (!(output.isEmpty() || output.startsWith("200 ") && output.endsWith(" 0"))) {
                LogUtil.CLog.e("checkpw gave output '%s' while trying to unlock device %s", output, this.getSerialNumber());
                return false;
            }
            this.getRunUtil().sleep(500L);
        } while (output.isEmpty() && ++i < 3);
        if (output.isEmpty()) {
            LogUtil.CLog.e("checkpw gave no output while trying to unlock device %s");
        }
        if (!(output = this.executeShellCommand("vdc cryptfs restart").trim()).startsWith("200 ") || !output.endsWith(" 0")) {
            LogUtil.CLog.e("restart gave output '%s' while trying to unlock device %s", output, this.getSerialNumber());
            return false;
        }
        this.waitForDeviceAvailable();
        return true;
    }

    @Override
    public boolean isDeviceEncrypted() throws DeviceNotAvailableException {
        String output = this.getProperty("ro.crypto.state");
        if (output == null && this.isEncryptionSupported()) {
            LogUtil.CLog.w("Property ro.crypto.state is null on device %s", this.getSerialNumber());
        }
        if (output == null) {
            return false;
        }
        return "encrypted".equals(output.trim());
    }

    @Override
    public boolean isEncryptionSupported() throws DeviceNotAvailableException {
        if (!this.isEnableAdbRoot()) {
            LogUtil.CLog.i("root is required for encryption");
            this.mIsEncryptionSupported = false;
            return this.mIsEncryptionSupported;
        }
        if (this.mIsEncryptionSupported != null) {
            return this.mIsEncryptionSupported;
        }
        this.enableAdbRoot();
        String output = this.getProperty("ro.crypto.state");
        if (output == null || "unsupported".equals(output.trim())) {
            this.mIsEncryptionSupported = false;
            return this.mIsEncryptionSupported;
        }
        this.mIsEncryptionSupported = true;
        return this.mIsEncryptionSupported;
    }

    @Override
    public void waitForDeviceOnline(long waitTime) throws DeviceNotAvailableException {
        if (this.mStateMonitor.waitForDeviceOnline(waitTime) == null) {
            this.recoverDevice();
        }
    }

    @Override
    public void waitForDeviceOnline() throws DeviceNotAvailableException {
        if (this.mStateMonitor.waitForDeviceOnline() == null) {
            this.recoverDevice();
        }
    }

    @Override
    public boolean waitForDeviceAvailable(long waitTime) throws DeviceNotAvailableException {
        if (this.mStateMonitor.waitForDeviceAvailable(waitTime) == null) {
            return this.recoverDevice();
        }
        return true;
    }

    @Override
    public boolean waitForDeviceAvailable() throws DeviceNotAvailableException {
        if (this.mStateMonitor.waitForDeviceAvailable() == null) {
            return this.recoverDevice();
        }
        return true;
    }

    @Override
    public boolean waitForDeviceAvailableInRecoverPath(long waitTime) throws DeviceNotAvailableException {
        return this.mStateMonitor.waitForDeviceAvailableInRecoverPath(waitTime) != null;
    }

    @Override
    public boolean waitForDeviceInRecovery(long waitTime) {
        return this.mStateMonitor.waitForDeviceInRecovery(waitTime);
    }

    @Override
    public void waitForDeviceBootloader() throws DeviceNotAvailableException {
        if (this.mOptions.useUpdatedBootloaderStatus()) {
            CommandResult commandResult = this.simpleFastbootCommand(this.mOptions.getFastbootTimeout(), this.buildFastbootCommand("getvar", "product"));
            if (!CommandStatus.SUCCESS.equals((Object)commandResult.getStatus())) {
                LogUtil.CLog.e("Waiting for device in bootloader. Status: %s.\nstdout:%s\nstderr:%s", new Object[]{commandResult.getStatus(), commandResult.getStdout(), commandResult.getStderr()});
                this.recoverDeviceFromBootloader();
            } else {
                this.setDeviceState(TestDeviceState.FASTBOOT);
            }
        } else if (!this.mStateMonitor.waitForDeviceBootloader(this.mOptions.getFastbootTimeout())) {
            this.recoverDeviceFromBootloader();
        }
    }

    @Override
    public boolean waitForDeviceInSideload(long waitTime) {
        return this.mStateMonitor.waitForDeviceInSideload(waitTime);
    }

    private void throwIfNull(Object obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
    }

    @VisibleForTesting
    IDeviceRecovery getRecovery() {
        return this.mRecovery;
    }

    @Override
    public void setRecovery(IDeviceRecovery recovery) {
        this.throwIfNull(recovery);
        this.mRecovery = recovery;
    }

    @Override
    public void setRecoveryMode(ITestDevice.RecoveryMode mode) {
        this.throwIfNull((Object)this.mRecoveryMode);
        this.mRecoveryMode = mode;
    }

    @Override
    public ITestDevice.RecoveryMode getRecoveryMode() {
        return this.mRecoveryMode;
    }

    @Override
    public void setFastbootEnabled(boolean fastbootEnabled) {
        this.mFastbootEnabled = fastbootEnabled;
    }

    @Override
    public boolean isFastbootEnabled() {
        return this.mFastbootEnabled;
    }

    @Override
    public void setFastbootPath(String fastbootPath) {
        this.mFastbootPath = fastbootPath;
        this.mRecovery.setFastbootPath(fastbootPath);
    }

    @Override
    public String getFastbootPath() {
        return this.mFastbootPath;
    }

    @Override
    public String getFastbootVersion() {
        try {
            CommandResult res = this.executeFastbootCommand("--version");
            return res.getStdout().trim();
        }
        catch (DeviceNotAvailableException deviceNotAvailableException) {
            return null;
        }
    }

    @Override
    public String getFastbootSerialNumber() {
        byte[] macEui48Bytes;
        if (this.mFastbootSerialNumber != null) {
            return this.mFastbootSerialNumber;
        }
        if (!this.isAdbTcp()) {
            this.mFastbootSerialNumber = this.getSerialNumber();
            LogUtil.CLog.i("Device %s's fastboot serial number is %s", this.getSerialNumber(), this.mFastbootSerialNumber);
            return this.mFastbootSerialNumber;
        }
        this.mFastbootSerialNumber = this.getSerialNumber();
        try {
            boolean adbRoot = this.isAdbRoot();
            if (!adbRoot) {
                this.enableAdbRoot();
            }
            macEui48Bytes = this.getEUI48MacAddressInBytes(ETHERNET_MAC_ADDRESS_COMMAND);
            if (!adbRoot) {
                this.disableAdbRoot();
            }
        }
        catch (DeviceNotAvailableException e) {
            LogUtil.CLog.e("Device %s isn't available when get fastboot serial number", this.getSerialNumber());
            LogUtil.CLog.e(e);
            return this.getSerialNumber();
        }
        String net_interface = this.getHostOptions().getNetworkInterface();
        if (net_interface == null || macEui48Bytes == null) {
            LogUtil.CLog.i("Device %s's fastboot serial number is %s", this.getSerialNumber(), this.mFastbootSerialNumber);
            return this.mFastbootSerialNumber;
        }
        byte[] addr = new byte[16];
        addr[0] = -2;
        addr[1] = -128;
        addr[8] = (byte)(macEui48Bytes[0] ^ 2);
        addr[9] = macEui48Bytes[1];
        addr[10] = macEui48Bytes[2];
        addr[11] = -1;
        addr[12] = -2;
        addr[13] = macEui48Bytes[3];
        addr[14] = macEui48Bytes[4];
        addr[15] = macEui48Bytes[5];
        try {
            String host_addr = Inet6Address.getByAddress(null, addr, 0).getHostAddress();
            this.mFastbootSerialNumber = "tcp:" + host_addr.split("%")[0] + "%" + net_interface;
        }
        catch (UnknownHostException e) {
            LogUtil.CLog.w("Failed to get %s's IPv6 link-local address", this.getSerialNumber());
            LogUtil.CLog.w(e);
        }
        LogUtil.CLog.i("Device %s's fastboot serial number is %s", this.getSerialNumber(), this.mFastbootSerialNumber);
        return this.mFastbootSerialNumber;
    }

    @Override
    public void setDeviceState(TestDeviceState deviceState) {
        if (!deviceState.equals((Object)this.getDeviceState())) {
            if (this.isStateBootloaderOrFastbootd() && this.mFastbootLock.isLocked()) {
                return;
            }
            this.mState = deviceState;
            if (!(this.getIDevice() instanceof StubDevice)) {
                LogUtil.CLog.logAndDisplay(Log.LogLevel.DEBUG, "Device %s state is now %s", new Object[]{this.getSerialNumber(), deviceState});
            }
            this.mStateMonitor.setState(deviceState);
        }
    }

    @Override
    public TestDeviceState getDeviceState() {
        return this.mState;
    }

    @Override
    public boolean isAdbTcp() {
        return this.mStateMonitor.isAdbTcp();
    }

    @Override
    public String switchToAdbTcp() throws DeviceNotAvailableException {
        String ipAddress = this.getIpAddress();
        if (ipAddress == null) {
            LogUtil.CLog.e("connectToTcp failed: Device %s doesn't have an IP", this.getSerialNumber());
            return null;
        }
        String port = "5555";
        this.executeAdbCommand("tcpip", port);
        return String.format("%s:%s", ipAddress, port);
    }

    @Override
    public boolean switchToAdbUsb() throws DeviceNotAvailableException {
        this.executeAdbCommand("usb");
        return true;
    }

    @Override
    public void setEmulatorProcess(Process p) {
        this.mEmulatorProcess = p;
    }

    public void setEmulatorOutputStream(SizeLimitedOutputStream output) {
        this.mEmulatorOutput = output;
    }

    @Override
    public void stopEmulatorOutput() {
        if (this.mEmulatorOutput != null) {
            this.mEmulatorOutput.delete();
            this.mEmulatorOutput = null;
        }
    }

    @Override
    public InputStreamSource getEmulatorOutput() {
        if (this.getIDevice().isEmulator()) {
            if (this.mEmulatorOutput == null) {
                LogUtil.CLog.w("Emulator output for %s was not captured in background", this.getSerialNumber());
            } else {
                try {
                    return new SnapshotInputStreamSource("getEmulatorOutput", this.mEmulatorOutput.getData());
                }
                catch (IOException e) {
                    LogUtil.CLog.e("Failed to get %s data.", this.getSerialNumber());
                    LogUtil.CLog.e(e);
                }
            }
        }
        return new ByteArrayInputStreamSource(new byte[0]);
    }

    @Override
    public Process getEmulatorProcess() {
        return this.mEmulatorProcess;
    }

    public boolean isEnableAdbRoot() {
        return this.mOptions.isEnableAdbRoot();
    }

    @Override
    public Set<String> getInstalledPackageNames() throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for Package's feature");
    }

    @Override
    public boolean isPackageInstalled(String packageName) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for Package's feature");
    }

    @Override
    public boolean isPackageInstalled(String packageName, String userId) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for Package's feature");
    }

    @Override
    public Set<ITestDevice.ApexInfo> getActiveApexes() throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for Package's feature");
    }

    @Override
    public List<PackageInfo> getAppPackageInfos() throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for Package's feature");
    }

    @Override
    public Set<String> getMainlineModuleInfo() throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for Package's feature");
    }

    @Override
    public Set<String> getUninstallablePackageNames() throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for Package's feature");
    }

    @Override
    public PackageInfo getAppPackageInfo(String packageName) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for Package's feature");
    }

    @Override
    public TestDeviceOptions getOptions() {
        return this.mOptions;
    }

    @Override
    public int getApiLevel() throws DeviceNotAvailableException {
        int apiLevel = -1;
        try {
            String prop = this.getProperty("ro.build.version.sdk");
            apiLevel = Integer.parseInt(prop);
        }
        catch (NumberFormatException nfe) {
            LogUtil.CLog.w("Unable to get API level from ro.build.version.sdk, falling back to UNKNOWN.", nfe);
        }
        return apiLevel;
    }

    @Override
    public boolean checkApiLevelAgainstNextRelease(int strictMinLevel) throws DeviceNotAvailableException {
        int apiLevel = this.getApiLevel();
        if (apiLevel > strictMinLevel) {
            return true;
        }
        String codeName = this.getPropertyWithRecovery("ro.build.version.codename", true);
        if (codeName == null) {
            throw new DeviceRuntimeException(String.format("Failed to query property '%s'. device returned null.", "ro.build.version.codename"), DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
        }
        return strictMinLevel <= (apiLevel += "REL".equals(codeName = codeName.trim()) ? 0 : 1);
    }

    protected int getApiLevelSafe() {
        try {
            return this.getApiLevel();
        }
        catch (DeviceNotAvailableException e) {
            LogUtil.CLog.e(e);
            return -1;
        }
    }

    @Override
    public int getLaunchApiLevel() throws DeviceNotAvailableException {
        try {
            String prop = this.getProperty("ro.product.first_api_level");
            return Integer.parseInt(prop);
        }
        catch (NumberFormatException nfe) {
            LogUtil.CLog.w("Unable to get first launch API level from ro.product.first_api_level, falling back to getApiLevel().", nfe);
            return this.getApiLevel();
        }
    }

    @Override
    public IDeviceStateMonitor getMonitor() {
        return this.mStateMonitor;
    }

    @Override
    public boolean waitForDeviceShell(long waitTime) {
        return this.mStateMonitor.waitForDeviceShell(waitTime);
    }

    @Override
    public DeviceAllocationState getAllocationState() {
        return this.mAllocationState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IManagedTestDevice.DeviceEventResponse handleAllocationEvent(DeviceEvent event) {
        DeviceAllocationState newState;
        boolean stateChanged = false;
        DeviceAllocationState oldState = this.mAllocationState;
        this.mAllocationStateLock.lock();
        try {
            oldState = this.mAllocationState;
            newState = this.mAllocationState.handleDeviceEvent(event);
            if (oldState != newState) {
                stateChanged = true;
                this.mAllocationState = newState;
            }
        }
        finally {
            this.mAllocationStateLock.unlock();
        }
        if (stateChanged && this.mAllocationMonitor != null) {
            this.mAllocationMonitor.notifyDeviceStateChange(this.getSerialNumber(), oldState, newState);
        }
        return new IManagedTestDevice.DeviceEventResponse(newState, stateChanged);
    }

    @Override
    public long getDeviceTimeOffset(Date date) throws DeviceNotAvailableException {
        long deviceTime = this.getDeviceDate();
        if (date == null) {
            date = new Date();
        }
        long offset = date.getTime() - deviceTime;
        LogUtil.CLog.d("Time offset = %d ms", offset);
        return offset;
    }

    @Override
    public void setDate(Date date) throws DeviceNotAvailableException {
        long timeOffset;
        if (date == null) {
            date = new Date();
        }
        if (Math.abs(timeOffset = this.getDeviceTimeOffset(date)) <= 5000L) {
            return;
        }
        String dateString = null;
        if (this.getApiLevel() < 23) {
            dateString = Long.toString(date.getTime() / 1000L);
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat("MMddHHmmyyyy.ss");
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            dateString = sdf.format(date);
        }
        this.executeShellCommand("TZ=UTC date -u " + dateString);
    }

    @Override
    public long getDeviceDate() throws DeviceNotAvailableException {
        String deviceTimeString = this.executeShellCommand("date +%s");
        Long deviceTime = null;
        try {
            deviceTime = Long.valueOf(deviceTimeString.trim());
        }
        catch (NumberFormatException nfe) {
            LogUtil.CLog.i("Invalid device time: \"%s\", ignored.", nfe);
            return 0L;
        }
        return deviceTime * 1000L;
    }

    @Override
    public boolean waitForBootComplete(long timeOut) throws DeviceNotAvailableException {
        return this.mStateMonitor.waitForBootComplete(timeOut);
    }

    @Override
    public ArrayList<Integer> listUsers() throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for user's feature.");
    }

    @Override
    public Map<Integer, UserInfo> getUserInfos() throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for user's feature.");
    }

    @Override
    public int getMaxNumberOfUsersSupported() throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for user's feature.");
    }

    @Override
    public int getMaxNumberOfRunningUsersSupported() throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for user's feature.");
    }

    @Override
    public boolean isMultiUserSupported() throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for user's feature.");
    }

    @Override
    public boolean isHeadlessSystemUserMode() throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for user's feature.");
    }

    @Override
    public boolean canSwitchToHeadlessSystemUser() throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for user's feature.");
    }

    @Override
    public boolean isMainUserPermanentAdmin() throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for user's feature.");
    }

    @Override
    public int createUserNoThrow(String name) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for user's feature.");
    }

    @Override
    public int createUser(String name) throws DeviceNotAvailableException, IllegalStateException {
        throw new UnsupportedOperationException("No support for user's feature.");
    }

    @Override
    public int createUser(String name, boolean guest, boolean ephemeral) throws DeviceNotAvailableException, IllegalStateException {
        throw new UnsupportedOperationException("No support for user's feature.");
    }

    @Override
    public int createUser(String name, boolean guest, boolean ephemeral, boolean forTesting) throws DeviceNotAvailableException, IllegalStateException {
        throw new UnsupportedOperationException("No support for user's feature.");
    }

    @Override
    public boolean removeUser(int userId) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for user's feature.");
    }

    @Override
    public boolean startUser(int userId) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for user's feature.");
    }

    @Override
    public boolean startUser(int userId, boolean waitFlag) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for user's feature.");
    }

    @Override
    public boolean startVisibleBackgroundUser(int userId, int displayId, boolean waitFlag) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for user's feature.");
    }

    @Override
    public boolean stopUser(int userId) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for user's feature.");
    }

    @Override
    public boolean stopUser(int userId, boolean waitFlag, boolean forceFlag) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for user's feature.");
    }

    @Override
    public boolean isVisibleBackgroundUsersSupported() throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for user's feature.");
    }

    @Override
    public boolean isVisibleBackgroundUsersOnDefaultDisplaySupported() throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for user's feature.");
    }

    @Override
    public void remountSystemWritable() throws DeviceNotAvailableException {
        String verity = this.getProperty("partition.system.verified");
        if (verity != null && !verity.isEmpty()) {
            this.executeAdbCommand("disable-verity");
            this.mPropertiesCache.invalidate("partition.system.verified");
            this.reboot();
        }
        this.enableAdbRoot();
        this.executeAdbCommand("remount");
        this.waitForDeviceAvailable();
    }

    @Override
    public void remountVendorWritable() throws DeviceNotAvailableException {
        String verity = this.getProperty("partition.vendor.verified");
        if (verity != null && !verity.isEmpty()) {
            this.executeAdbCommand("disable-verity");
            this.mPropertiesCache.invalidate("partition.vendor.verified");
            this.reboot();
        }
        this.enableAdbRoot();
        this.executeAdbCommand("remount");
        this.waitForDeviceAvailable();
    }

    @Override
    public void remountSystemReadOnly() throws DeviceNotAvailableException {
        String verity = this.getProperty("partition.system.verified");
        if (verity == null || verity.isEmpty()) {
            this.executeAdbCommand("enable-verity");
            this.reboot();
        }
    }

    @Override
    public void remountVendorReadOnly() throws DeviceNotAvailableException {
        String verity = this.getProperty("partition.vendor.verified");
        if (verity == null || verity.isEmpty()) {
            this.executeAdbCommand("enable-verity");
            this.reboot();
        }
    }

    @Override
    public Integer getPrimaryUserId() throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for user's feature.");
    }

    @Override
    public Integer getMainUserId() throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for user's feature.");
    }

    private int getCurrentUserCompatible() throws DeviceNotAvailableException {
        try {
            return this.getCurrentUser();
        }
        catch (RuntimeException e) {
            return 0;
        }
    }

    @Override
    public int getCurrentUser() throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for user's feature.");
    }

    @Override
    public boolean isUserVisible(int userId) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for user's feature.");
    }

    @Override
    public boolean isUserVisibleOnDisplay(int userId, int displayId) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for user's feature.");
    }

    @Override
    public boolean isUserSecondary(int userId) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for user's feature.");
    }

    @Override
    public int getUserFlags(int userId) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for user's feature.");
    }

    @Override
    public int getUserSerialNumber(int userId) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for user's feature.");
    }

    @Override
    public boolean switchUser(int userId) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for user's feature.");
    }

    @Override
    public boolean switchUser(int userId, long timeout) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for user's feature.");
    }

    @Override
    public boolean isUserRunning(int userId) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for user's feature.");
    }

    @Override
    public boolean hasFeature(String feature) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support pm's features.");
    }

    @Override
    public String getSetting(String namespace, String key) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for setting's feature.");
    }

    @Override
    public String getSetting(int userId, String namespace, String key) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for setting's feature.");
    }

    @Override
    public Map<String, String> getAllSettings(String namespace) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for setting's feature.");
    }

    @Override
    public void setSetting(String namespace, String key, String value) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for setting's feature.");
    }

    @Override
    public void setSetting(int userId, String namespace, String key, String value) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for setting's feature.");
    }

    @Override
    public String getBuildSigningKeys() throws DeviceNotAvailableException {
        String buildTags = this.getProperty("ro.build.tags");
        if (buildTags != null) {
            String[] tags;
            for (String tag : tags = buildTags.split(",")) {
                Matcher m = KEYS_PATTERN.matcher(tag);
                if (!m.matches()) continue;
                return tag;
            }
        }
        return null;
    }

    @Override
    public String getAndroidId(int userId) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for user's feature.");
    }

    @Override
    public Map<Integer, String> getAndroidIds() throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for user's feature.");
    }

    @Override
    public boolean setDeviceOwner(String componentName, int userId) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for user's feature.");
    }

    @Override
    public boolean removeAdmin(String componentName, int userId) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for user's feature.");
    }

    @Override
    public void removeOwners() throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for user's feature.");
    }

    @Override
    public void disableKeyguard() throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for Window Manager's features");
    }

    @Override
    public String getDeviceClass() {
        IDevice device = this.getIDevice();
        if (device == null) {
            LogUtil.CLog.w("No IDevice instance, cannot determine device class.");
            return "";
        }
        return device.getClass().getSimpleName();
    }

    @Override
    public void preInvocationSetup(IBuildInfo info, MultiMap<String, String> attributes) throws TargetSetupError, DeviceNotAvailableException {
        this.mContentProvider = null;
        this.mShouldSkipContentProviderSetup = false;
        try {
            this.mExecuteShellCommandLogs = FileUtil.createTempFile("TestDevice_ExecuteShellCommands", ".txt");
        }
        catch (IOException e) {
            throw new TargetSetupError("Failed to create the executeShellCommand log file.", (Throwable)e, this.getDeviceDescriptor(), InfraErrorIdentifier.FAIL_TO_CREATE_FILE);
        }
        this.initializeConnection(info, attributes);
    }

    protected void initializeConnection(IBuildInfo info, MultiMap<String, String> attributes) throws DeviceNotAvailableException, TargetSetupError {
        try (CloseableTraceScope ignored = new CloseableTraceScope("initializeConnection");){
            DefaultConnection.ConnectionBuilder builder = new DefaultConnection.ConnectionBuilder(this.getRunUtil(), this, info, this.getLogger());
            if (attributes != null) {
                builder.addAttributes(attributes);
            }
            this.addExtraConnectionBuilderArgs(builder);
            this.mConnection = DefaultConnection.createConnection(builder);
            LogUtil.CLog.d("Using connection: %s (%s)", this.mConnection, this.getIDevice());
            this.mConnection.initializeConnection();
        }
    }

    protected void addExtraConnectionBuilderArgs(DefaultConnection.ConnectionBuilder builder) {
        if (this.mConnectionAvd != null) {
            builder.setExistingAvdInfo(this.mConnectionAvd);
        }
    }

    public final void setConnectionAvdInfo(GceAvdInfo avdInfo) {
        this.mConnectionAvd = avdInfo;
    }

    @Override
    public void postInvocationTearDown(Throwable exception) {
        this.invalidatePropertyCache();
        this.mConfiguration = null;
        this.mIsEncryptionSupported = null;
        FileUtil.deleteFile(this.mExecuteShellCommandLogs);
        this.mExecuteShellCommandLogs = null;
        FileUtil.recursiveDelete(this.mUnpackedFastbootDir);
        this.getConnection().tearDownConnection();
        this.mConnectionAvd = null;
        this.mDeviceActionReceivers.clear();
        if (this.getIDevice() instanceof StubDevice) {
            return;
        }
        this.mShouldSkipContentProviderSetup = false;
        try {
            if (this.mContentProvider == null) {
                return;
            }
            if (exception instanceof DeviceNotAvailableException) {
                LogUtil.CLog.e("Skip Tradefed Content Provider teardown due to DeviceNotAvailableException.");
                return;
            }
            if (TestDeviceState.ONLINE.equals((Object)this.getDeviceState())) {
                this.mContentProvider.tearDown();
            }
        }
        catch (DeviceNotAvailableException e) {
            LogUtil.CLog.e(e);
        }
    }

    @Override
    public boolean isHeadless() throws DeviceNotAvailableException {
        return this.getProperty("ro.build.headless") != null;
    }

    protected void checkApiLevelAgainst(String feature, int strictMinLevel) {
        try {
            if (this.getApiLevel() < strictMinLevel) {
                throw new HarnessRuntimeException(String.format("%s not supported on %s. Must be API %d.", feature, this.getSerialNumber(), strictMinLevel), DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
            }
        }
        catch (DeviceNotAvailableException e) {
            throw new HarnessRuntimeException("Device became unavailable while checking API level", e, DeviceErrorIdentifier.DEVICE_UNAVAILABLE);
        }
    }

    @Override
    public DeviceDescriptor getCachedDeviceDescriptor() {
        return this.getCachedDeviceDescriptor(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceDescriptor getCachedDeviceDescriptor(boolean shortDescriptor) {
        Object object = this.mCacheLock;
        synchronized (object) {
            if (DeviceAllocationState.Allocated.equals(this.getAllocationState())) {
                if (this.mCachedDeviceDescriptor == null) {
                    this.mCachedDeviceDescriptor = this.getDeviceDescriptor(false);
                    return this.mCachedDeviceDescriptor;
                }
                return this.mCachedDeviceDescriptor;
            }
            this.mCachedDeviceDescriptor = null;
            return this.getDeviceDescriptor(shortDescriptor);
        }
    }

    @Override
    public DeviceDescriptor getDeviceDescriptor() {
        return this.getDeviceDescriptor(false);
    }

    @Override
    public DeviceDescriptor getDeviceDescriptor(boolean shortDescriptor) {
        DeviceSelectionOptions selector = new DeviceSelectionOptions();
        IDevice idevice = this.getIDevice();
        try {
            boolean isTemporary = false;
            if (idevice instanceof NullDevice) {
                isTemporary = ((NullDevice)idevice).isTemporary();
            }
            if (shortDescriptor) {
                return new DeviceDescriptor(idevice.getSerialNumber(), null, idevice instanceof StubDevice, idevice.getState(), this.getAllocationState(), this.getDeviceState(), null, null, null, null, null, null, this.getDeviceClass(), null, null, null, isTemporary, null, null, idevice);
            }
            String sdkVersion = null;
            String buildAlias = null;
            String hardwareRev = null;
            if (TestDeviceState.ONLINE.equals((Object)this.getDeviceState())) {
                sdkVersion = this.getPropertyWithRecovery("ro.build.version.sdk", false);
                buildAlias = this.getPropertyWithRecovery("ro.build.id", false);
                hardwareRev = this.getPropertyWithRecovery("ro.revision", false);
            }
            return new DeviceDescriptor(idevice.getSerialNumber(), null, idevice instanceof StubDevice, idevice.getState(), this.getAllocationState(), this.getDeviceState(), this.getDisplayString(selector.getDeviceProductType(idevice)), this.getDisplayString(selector.getDeviceProductVariant(idevice)), this.getDisplayString(sdkVersion), this.getDisplayString(buildAlias), this.getDisplayString(hardwareRev), this.getDisplayString(this.getBattery()), this.getDeviceClass(), this.getDisplayString(this.getMacAddress()), this.getDisplayString(this.getSimState()), this.getDisplayString(this.getSimOperator()), isTemporary, null, null, idevice);
        }
        catch (DeviceNotAvailableException | RuntimeException e) {
            LogUtil.CLog.e("Exception while building device '%s' description:", this.getSerialNumber());
            LogUtil.CLog.e(e);
            return null;
        }
    }

    private String getDisplayString(Object o) {
        return o == null ? "unknown" : o.toString();
    }

    @Override
    public ProcessInfo getProcessByName(String processName) throws DeviceNotAvailableException {
        String pidString = this.getProcessPid(processName);
        if (pidString == null) {
            return null;
        }
        long startTime = this.getProcessStartTimeByPid(pidString);
        if (startTime == -1L) {
            return null;
        }
        return new ProcessInfo(this.getProcessUserByPid(pidString), Integer.parseInt(pidString), processName, startTime);
    }

    private long getProcessStartTimeByPid(String pidString) throws DeviceNotAvailableException {
        String output = this.executeShellCommand(String.format("ps -p %s -o stime=", pidString));
        if (output != null && !output.trim().isEmpty()) {
            output = output.trim();
            String dateInSeconds = this.getApiLevel() <= 28 ? this.executeShellCommand("date -d \"$(date +%Y:%m:%e):" + output + "\" +%s -D \"%Y:%m:%e:%H:%M:%S\"") : this.executeShellCommand("date -d\"" + output + "\" +%s");
            if (Strings.isNullOrEmpty(dateInSeconds)) {
                return -1L;
            }
            try {
                return Long.parseLong(dateInSeconds.trim());
            }
            catch (NumberFormatException e) {
                LogUtil.CLog.e("Failed to parse the start time for process:");
                LogUtil.CLog.e(e);
                return -1L;
            }
        }
        return -1L;
    }

    private String getProcessUserByPid(String pidString) throws DeviceNotAvailableException {
        String output = this.executeShellCommand("stat -c%U /proc/" + pidString);
        if (output != null && !output.trim().isEmpty()) {
            try {
                return output.trim();
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public Map<Long, String> getBootHistory() throws DeviceNotAvailableException {
        String output = this.getProperty("persist.sys.boot.reason.history");
        LinkedHashMap<Long, String> bootHistory = new LinkedHashMap<Long, String>();
        if (Strings.isNullOrEmpty(output)) {
            return bootHistory;
        }
        for (String line : output.split("\\n")) {
            String[] infoStr = line.split(",");
            String startStr = infoStr[infoStr.length - 1];
            try {
                long startTime = Long.parseLong(startStr.trim());
                bootHistory.put(startTime, infoStr[0].trim());
            }
            catch (NumberFormatException e) {
                LogUtil.CLog.e("Fail to parse boot time from line %s", line);
            }
        }
        return bootHistory;
    }

    @Override
    public Map<Long, String> getBootHistorySince(long utcEpochTime, TimeUnit timeUnit) throws DeviceNotAvailableException {
        long utcEpochTimeSec = TimeUnit.SECONDS.convert(utcEpochTime, timeUnit);
        LinkedHashMap<Long, String> bootHistory = new LinkedHashMap<Long, String>();
        for (Map.Entry<Long, String> entry : this.getBootHistory().entrySet()) {
            if (entry.getKey() < utcEpochTimeSec) continue;
            bootHistory.put(entry.getKey(), entry.getValue());
        }
        return bootHistory;
    }

    private boolean hasNormalRebootSince(long utcEpochTime, TimeUnit timeUnit) throws DeviceNotAvailableException {
        Map<Long, String> bootHistory = this.getBootHistorySince(utcEpochTime, timeUnit);
        if (bootHistory.isEmpty()) {
            LogUtil.CLog.w("There is no reboot history since %s", utcEpochTime);
            return false;
        }
        LogUtil.CLog.i("There are new boot history since %d. NewBootHistory = %s", utcEpochTime, bootHistory);
        for (Map.Entry<Long, String> entry : bootHistory.entrySet()) {
            if ("reboot".equals(entry.getValue())) continue;
            throw new HarnessRuntimeException(String.format("Device %s has abnormal reboot reason %s at %d", this.getSerialNumber(), entry.getValue(), entry.getKey()), DeviceErrorIdentifier.UNEXPECTED_REBOOT);
        }
        return true;
    }

    private boolean checkSystemProcessRestartedAfterLastReboot(ProcessInfo systemServerProcess) throws DeviceNotAvailableException {
        if (!this.hasNormalRebootSince(systemServerProcess.getStartTime() - 25L, TimeUnit.SECONDS)) {
            LogUtil.CLog.i("Device last reboot is more than %s seconds away from current system_server process start time. The system_server process restarted after last boot up", 25);
            return true;
        }
        return false;
    }

    @Override
    public boolean deviceSoftRestartedSince(long utcEpochTime, TimeUnit timeUnit) throws DeviceNotAvailableException {
        ProcessInfo currSystemServerProcess = this.getProcessByName("system_server");
        if (currSystemServerProcess == null) {
            LogUtil.CLog.i("The system_server process is not available on the device.");
            return true;
        }
        if (Math.abs(currSystemServerProcess.getStartTime() - TimeUnit.SECONDS.convert(utcEpochTime, timeUnit)) <= 1L) {
            return false;
        }
        if (!this.hasNormalRebootSince(utcEpochTime, timeUnit)) {
            return true;
        }
        return this.checkSystemProcessRestartedAfterLastReboot(currSystemServerProcess);
    }

    @Override
    public boolean deviceSoftRestarted(ProcessInfo prevSystemServerProcess) throws DeviceNotAvailableException {
        if (prevSystemServerProcess == null) {
            LogUtil.CLog.i("The given system_server process is null. Abort deviceSoftRestarted check.");
            return false;
        }
        ProcessInfo currSystemServerProcess = this.getProcessByName("system_server");
        if (currSystemServerProcess == null) {
            LogUtil.CLog.i("The system_server process is not available on the device.");
            return true;
        }
        if (currSystemServerProcess.getPid() == prevSystemServerProcess.getPid() && Math.abs(currSystemServerProcess.getStartTime() - prevSystemServerProcess.getStartTime()) <= 1L) {
            return false;
        }
        LogUtil.CLog.v("current system_server: %s; prev system_server: %s", currSystemServerProcess, prevSystemServerProcess);
        if (!this.hasNormalRebootSince(prevSystemServerProcess.getStartTime(), TimeUnit.SECONDS)) {
            return true;
        }
        return this.checkSystemProcessRestartedAfterLastReboot(currSystemServerProcess);
    }

    boolean isMacAddress(String address) {
        Pattern macPattern = Pattern.compile(MAC_ADDRESS_PATTERN);
        Matcher macMatcher = macPattern.matcher(address);
        return macMatcher.find();
    }

    private String getMacAddress(String command) {
        if (this.getIDevice() instanceof StubDevice) {
            return null;
        }
        if (!TestDeviceState.ONLINE.equals((Object)this.mState)) {
            return null;
        }
        CollectingOutputReceiver receiver = new CollectingOutputReceiver();
        try {
            this.mIDevice.executeShellCommand(command, receiver);
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | com.android.ddmlib.TimeoutException | IOException e) {
            LogUtil.CLog.w("Failed to query MAC address for %s by '%s'", this.mIDevice.getSerialNumber(), command);
            LogUtil.CLog.w(e);
        }
        String output = receiver.getOutput().trim();
        if (this.isMacAddress(output)) {
            return output;
        }
        LogUtil.CLog.d("No valid MAC address queried from device %s by '%s'", this.mIDevice.getSerialNumber(), command);
        return null;
    }

    @Override
    public String getMacAddress() {
        return this.getMacAddress(MAC_ADDRESS_COMMAND);
    }

    long getEUI48MacAddressInLong(String command) {
        String addr = this.getMacAddress(command);
        if (addr == null) {
            return 0L;
        }
        String[] parts = addr.split(":");
        if (parts.length != 6) {
            throw new IllegalArgumentException(addr + " was not a valid MAC address");
        }
        long longAddr = 0L;
        for (int i = 0; i < parts.length; ++i) {
            int x = Integer.valueOf(parts[i], 16);
            if (x < 0 || 255 < x) {
                throw new IllegalArgumentException(addr + "was not a valid MAC address");
            }
            longAddr = (long)x + (longAddr << 8);
        }
        return longAddr;
    }

    byte[] getEUI48MacAddressInBytes(String command) {
        long addr = this.getEUI48MacAddressInLong(command);
        if (addr == 0L) {
            return null;
        }
        byte[] bytes = new byte[6];
        int index = 6;
        while (index-- > 0) {
            bytes[index] = (byte)addr;
            addr >>= 8;
        }
        return bytes;
    }

    @Override
    public String getSimState() {
        if (this.getIDevice() instanceof StubDevice) {
            return null;
        }
        if (!TestDeviceState.ONLINE.equals((Object)this.mState)) {
            return null;
        }
        try {
            return this.getPropertyWithRecovery(SIM_STATE_PROP, false);
        }
        catch (DeviceNotAvailableException dnae) {
            LogUtil.CLog.w("DeviceNotAvailableException while fetching SIM state");
            return null;
        }
    }

    @Override
    public String getSimOperator() {
        if (this.getIDevice() instanceof StubDevice) {
            return null;
        }
        if (!TestDeviceState.ONLINE.equals((Object)this.mState)) {
            return null;
        }
        try {
            return this.getPropertyWithRecovery(SIM_OPERATOR_PROP, false);
        }
        catch (DeviceNotAvailableException dnae) {
            LogUtil.CLog.w("DeviceNotAvailableException while fetching SIM operator");
            return null;
        }
    }

    @Override
    public File dumpHeap(String process, String devicePath) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("dumpHeap is not supported.");
    }

    @Override
    public String getProcessPid(String process) throws DeviceNotAvailableException {
        String output = this.executeShellCommand(String.format("pidof %s", process)).trim();
        if (this.checkValidPid(output)) {
            return output;
        }
        LogUtil.CLog.e("Failed to find a valid pid for process '%s'.", process);
        return null;
    }

    @Override
    @FormatMethod
    public void logOnDevice(String tag, Log.LogLevel level, String format, Object ... args) {
        String message2 = String.format(format, args);
        try {
            String levelLetter = this.logLevelToLogcatLevel(level);
            String command = String.format("log -t %s -p %s '%s'", tag, levelLetter, message2);
            this.executeShellCommand(command);
        }
        catch (DeviceNotAvailableException e) {
            LogUtil.CLog.e("Device went not available when attempting to log '%s'", message2);
            LogUtil.CLog.e(e);
        }
    }

    private String logLevelToLogcatLevel(Log.LogLevel level) {
        switch (level) {
            case DEBUG: {
                return "d";
            }
            case ERROR: {
                return "e";
            }
            case INFO: {
                return "i";
            }
            case VERBOSE: {
                return "v";
            }
            case WARN: {
                return "w";
            }
        }
        return "i";
    }

    @Override
    public long getTotalMemory() {
        long totalMemory = 0L;
        String output = null;
        try {
            output = this.executeShellCommand("cat /proc/meminfo | grep MemTotal");
        }
        catch (DeviceNotAvailableException e) {
            LogUtil.CLog.e(e);
            return -1L;
        }
        if (output.isEmpty()) {
            return -1L;
        }
        String[] results = output.split("\\s+");
        try {
            totalMemory = Long.parseLong(results[1].replaceAll("\\D+", ""));
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            LogUtil.CLog.e(e);
            return -1L;
        }
        return totalMemory * 1024L;
    }

    @Override
    public Integer getBattery() {
        if (this.getIDevice() instanceof StubDevice) {
            return null;
        }
        if (this.isStateBootloaderOrFastbootd()) {
            return null;
        }
        try {
            Future<Integer> batteryFuture = this.getIDevice().getBattery();
            return batteryFuture.get(500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LogUtil.CLog.w("Failed to query battery level for %s: %s", this.getIDevice().getSerialNumber(), e.toString());
            return null;
        }
    }

    @Override
    public Set<Long> listDisplayIds() throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("dumpsys SurfaceFlinger is not supported.");
    }

    @Override
    public Set<Integer> listDisplayIdsForStartingVisibleBackgroundUsers() throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for user's feature.");
    }

    @Override
    public long getLastExpectedRebootTimeMillis() {
        return this.mLastTradefedRebootTime;
    }

    @Override
    public List<File> getTombstones() throws DeviceNotAvailableException {
        ArrayList<File> tombstones = new ArrayList<File>();
        if (!this.isAdbRoot()) {
            LogUtil.CLog.w("Device was not root, cannot collect tombstones.");
            return tombstones;
        }
        for (String tombName : this.getChildren(TOMBSTONE_PATH)) {
            File tombFile = this.pullFile(TOMBSTONE_PATH + tombName);
            if (tombFile == null) continue;
            tombstones.add(tombFile);
        }
        return tombstones;
    }

    @Override
    public Set<DeviceFoldableState> getFoldableStates() throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for foldable states.");
    }

    @Override
    public DeviceFoldableState getCurrentFoldableState() throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("No support for foldable states.");
    }

    private boolean checkValidPid(String output) {
        if (output.isEmpty()) {
            return false;
        }
        try {
            Integer.parseInt(output);
        }
        catch (NumberFormatException e) {
            LogUtil.CLog.e(e);
            return false;
        }
        return true;
    }

    @VisibleForTesting
    IHostOptions getHostOptions() {
        return GlobalConfiguration.getInstance().getHostOptions();
    }

    @VisibleForTesting
    ContentProviderHandler getContentProvider() throws DeviceNotAvailableException {
        if (!this.getOptions().shouldUseContentProvider()) {
            return null;
        }
        if (this.getApiLevel() < 28) {
            return null;
        }
        if (this.mContentProvider == null) {
            this.mContentProvider = new ContentProviderHandler(this);
        }
        if (this.mContentProvider.contentProviderNotFound()) {
            this.mShouldSkipContentProviderSetup = false;
        }
        if (!this.mShouldSkipContentProviderSetup) {
            boolean res = this.mContentProvider.setUp();
            if (!res) {
                return null;
            }
            this.mShouldSkipContentProviderSetup = true;
        }
        return this.mContentProvider;
    }

    public void resetContentProviderSetup() {
        this.mShouldSkipContentProviderSetup = false;
    }

    public final File getExecuteShellCommandLog() {
        return this.mExecuteShellCommandLogs;
    }

    @VisibleForTesting
    protected CommandResult simpleFastbootCommand(long timeout, String[] fullCmd) throws UnsupportedOperationException {
        return this.simpleFastbootCommand(timeout, new HashMap<String, String>(), fullCmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected CommandResult simpleFastbootCommand(long timeout, Map<String, String> envVarMap, String[] fullCmd) throws UnsupportedOperationException {
        if (!this.mFastbootEnabled) {
            throw new UnsupportedOperationException(String.format("Attempted to fastboot on device %s , but fastboot is disabled. Aborting.", this.getSerialNumber()));
        }
        IRunUtil runUtil = !envVarMap.isEmpty() ? new RunUtil() : this.getRunUtil();
        for (Map.Entry<String, String> entry : envVarMap.entrySet()) {
            LogUtil.CLog.v(String.format("Set environment variable %s to %s", entry.getKey(), entry.getValue()));
            runUtil.setEnvVariable(entry.getKey(), entry.getValue());
        }
        CommandResult result = new CommandResult(CommandStatus.EXCEPTION);
        this.mFastbootLock.lock();
        try {
            result = runUtil.runTimedCmd(timeout, fullCmd);
        }
        finally {
            this.mFastbootLock.unlock();
        }
        return result;
    }

    @Override
    public AbstractConnection getConnection() {
        if (this.mConnection == null) {
            this.mConnection = DefaultConnection.createInopConnection(new DefaultConnection.ConnectionBuilder(this.getRunUtil(), this, null, this.getLogger()));
        }
        return this.mConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyRebootStarted() throws DeviceNotAvailableException {
        try (CloseableTraceScope ignored = new CloseableTraceScope("rebootStartedCallbacks");){
            for (IDeviceActionReceiver dar : this.mDeviceActionReceivers) {
                try {
                    this.inRebootCallback = true;
                    dar.rebootStarted(this);
                }
                catch (DeviceNotAvailableException dnae) {
                    throw dnae;
                }
                catch (Exception e) {
                    this.logDeviceActionException("notifyRebootStarted", e, true);
                }
                finally {
                    this.inRebootCallback = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyRebootEnded() throws DeviceNotAvailableException {
        try (CloseableTraceScope ignored = new CloseableTraceScope("rebootEndedCallbacks");){
            for (IDeviceActionReceiver dar : this.mDeviceActionReceivers) {
                try {
                    this.inRebootCallback = true;
                    dar.rebootEnded(this);
                }
                catch (DeviceNotAvailableException dnae) {
                    throw dnae;
                }
                catch (Exception e) {
                    this.logDeviceActionException("notifyRebootEnded", e, true);
                }
                finally {
                    this.inRebootCallback = false;
                }
            }
        }
    }

    protected boolean isInRebootCallback() {
        return this.inRebootCallback;
    }

    @Override
    public void setTestLogger(ITestLogger testLogger) {
        this.mTestLogger = testLogger;
    }

    protected ITestLogger getLogger() {
        return this.mTestLogger;
    }

    protected void setMicrodroidProcess(Process process) {
        this.mMicrodroidProcess = process;
    }

    public Process getMicrodroidProcess() {
        return this.mMicrodroidProcess;
    }

    protected void setTestDeviceOptions(Map<String, String> deviceOptions) {
        try {
            OptionSetter setter = new OptionSetter(this.getOptions());
            for (Map.Entry<String, String> optionsKeyValue : deviceOptions.entrySet()) {
                setter.setOptionValue(optionsKeyValue.getKey(), optionsKeyValue.getValue());
            }
        }
        catch (ConfigurationException e) {
            LogUtil.CLog.w(e);
        }
    }

    public void invalidatePropertyCache() {
        this.mPropertiesCache.invalidateAll();
    }

    static interface DeviceAction {
        public boolean run() throws IOException, com.android.ddmlib.TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, InstallException, SyncException, DeviceNotAvailableException;
    }

    protected class AdbShellAction
    implements DeviceAction {
        CommandResult mResult = null;
        private String[] mCmd;
        private long mTimeout;
        private File mPipeAsInput;
        private OutputStream mPipeToOutput;
        private OutputStream mPipeToError;

        AdbShellAction(String[] cmd, File pipeAsInput, OutputStream pipeToOutput, OutputStream pipeToError, long timeout) {
            this.mCmd = cmd;
            this.mPipeAsInput = pipeAsInput;
            this.mPipeToOutput = pipeToOutput;
            this.mPipeToError = pipeToError;
            this.mTimeout = timeout;
        }

        @Override
        public boolean run() throws com.android.ddmlib.TimeoutException, IOException {
            this.mResult = this.mPipeAsInput != null ? NativeDevice.this.getRunUtil().runTimedCmdWithInputRedirect(this.mTimeout, this.mPipeAsInput, this.mCmd) : NativeDevice.this.getRunUtil().runTimedCmd(this.mTimeout, this.mPipeToOutput, this.mPipeToError, this.mCmd);
            if (this.mResult.getStatus() == CommandStatus.EXCEPTION) {
                throw new IOException(this.mResult.getStderr());
            }
            if (this.mResult.getStatus() == CommandStatus.TIMED_OUT) {
                throw new com.android.ddmlib.TimeoutException(this.mResult.getStderr());
            }
            String stdErr = this.mResult.getStderr();
            if (stdErr != null && (stdErr = stdErr.trim()).contains("device offline")) {
                throw new IOException(stdErr);
            }
            return true;
        }
    }

    private static class RunFailureListener
    extends StubTestRunListener {
        private boolean mIsRunFailure = false;

        private RunFailureListener() {
        }

        @Override
        public void testRunFailed(String message2) {
            this.mIsRunFailure = true;
        }

        public boolean isRunFailure() {
            return this.mIsRunFailure;
        }
    }

    private static class NoHiddenFilesFilter
    implements FilenameFilter {
        private NoHiddenFilesFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return !name.startsWith(".");
        }
    }

    private class FileQueryAction
    implements DeviceAction {
        FileListingService.FileEntry[] mFileContents = null;
        private final FileListingService.FileEntry mRemoteFileEntry;
        private final FileListingService mService;

        FileQueryAction(FileListingService.FileEntry remoteFileEntry, FileListingService service) {
            NativeDevice.this.throwIfNull(remoteFileEntry);
            NativeDevice.this.throwIfNull(service);
            this.mRemoteFileEntry = remoteFileEntry;
            this.mService = service;
        }

        @Override
        public boolean run() throws com.android.ddmlib.TimeoutException, IOException, AdbCommandRejectedException, ShellCommandUnresponsiveException {
            this.mFileContents = this.mService.getChildrenSync(this.mRemoteFileEntry);
            return true;
        }
    }

    protected class AdbAction
    implements DeviceAction {
        String mOutput = null;
        private String[] mCmd;
        private long mTimeout;
        private boolean mIsShellCommand;
        private Map<String, String> mEnvMap;

        AdbAction(long timeout, String[] cmd, boolean isShell, Map<String, String> envMap) {
            this.mTimeout = timeout;
            this.mCmd = cmd;
            this.mIsShellCommand = isShell;
            this.mEnvMap = envMap;
        }

        private void logExceptionAndOutput(CommandResult result) {
            LogUtil.CLog.w("Command exited with status: %s", result.getStatus().toString());
            LogUtil.CLog.w("Command stdout:\n%s\n", result.getStdout());
            LogUtil.CLog.w("Command stderr:\n%s\n", result.getStderr());
        }

        @Override
        public boolean run() throws com.android.ddmlib.TimeoutException, IOException {
            IRunUtil runUtil = NativeDevice.this.getRunUtil();
            if (!this.mEnvMap.isEmpty()) {
                runUtil = NativeDevice.this.createRunUtil();
            }
            for (String key : this.mEnvMap.keySet()) {
                runUtil.setEnvVariable(key, this.mEnvMap.get(key));
            }
            CommandResult result = runUtil.runTimedCmd(this.mTimeout, this.mCmd);
            if (result.getStatus() == CommandStatus.EXCEPTION) {
                this.logExceptionAndOutput(result);
                throw new IOException("CommandStatus was EXCEPTION, details in host log");
            }
            if (result.getStatus() == CommandStatus.TIMED_OUT) {
                this.logExceptionAndOutput(result);
                throw new com.android.ddmlib.TimeoutException("CommandStatus was TIMED_OUT, details in host log");
            }
            if (result.getStatus() == CommandStatus.FAILED) {
                this.logExceptionAndOutput(result);
                if (this.mIsShellCommand) {
                    throw new IOException("CommandStatus was FAILED, details in host log");
                }
                this.mOutput = result.getStdout();
                return false;
            }
            this.mOutput = result.getStdout();
            return true;
        }
    }

    protected class RebootDeviceAction
    implements DeviceAction {
        private final RebootMode mRebootMode;
        @Nullable
        private final String mReason;

        RebootDeviceAction(@Nullable RebootMode rebootMode, String reason) {
            this.mRebootMode = rebootMode;
            this.mReason = reason;
        }

        public boolean isFastbootOrBootloader() {
            return this.mRebootMode == RebootMode.REBOOT_INTO_BOOTLOADER || this.mRebootMode == RebootMode.REBOOT_INTO_FASTBOOTD;
        }

        @Override
        public boolean run() throws com.android.ddmlib.TimeoutException, IOException, AdbCommandRejectedException, DeviceNotAvailableException {
            NativeDevice.this.notifyRebootStarted();
            NativeDevice.this.getIDevice().reboot(this.mRebootMode.formatRebootCommand(this.mReason));
            return true;
        }
    }

    @VisibleForTesting
    protected static enum RebootMode {
        REBOOT_FULL(""),
        REBOOT_USERSPACE("userspace"),
        REBOOT_INTO_FASTBOOTD("fastboot"),
        REBOOT_INTO_BOOTLOADER("bootloader"),
        REBOOT_INTO_SIDELOAD("sideload"),
        REBOOT_INTO_SIDELOAD_AUTO_REBOOT("sideload-auto-reboot"),
        REBOOT_INTO_RECOVERY("recovery");

        private final String mRebootTarget;

        private RebootMode(String rebootTarget) {
            this.mRebootTarget = rebootTarget;
        }

        @Nullable
        String formatRebootCommand(@Nullable String reason) {
            if (this == REBOOT_FULL) {
                return Strings.isNullOrEmpty(reason) ? null : reason;
            }
            return Strings.isNullOrEmpty(reason) ? this.mRebootTarget : this.mRebootTarget + "," + reason;
        }

        public String toString() {
            return this.mRebootTarget;
        }
    }
}

