/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.IDeviceManager;
import com.android.tradefed.device.IDeviceStateMonitor;
import com.android.tradefed.device.TestDeviceState;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunInterruptedException;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.TimeUtil;
import com.google.common.base.Strings;
import com.google.common.primitives.Longs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class NativeDeviceStateMonitor
implements IDeviceStateMonitor {
    static final String BOOTCOMPLETE_PROP = "dev.bootcomplete";
    private IDevice mDevice;
    private TestDeviceState mDeviceState;
    private static final long CHECK_POLL_TIME = 1000L;
    protected static final long MAX_CHECK_POLL_TIME = 10000L;
    protected static final int MAX_OP_TIME = 10000;
    private static final Set<String> TMPFS_MAGIC = new HashSet<String>(Arrays.asList("1021994", "01021994"));
    private long mDefaultOnlineTimeout = 60000L;
    private long mDefaultAvailableTimeout = 360000L;
    private String mFastbootSerialNumber = null;
    private List<DeviceStateListener> mStateListeners;
    private IDeviceManager mMgr;
    private final boolean mFastbootEnabled;
    private boolean mMountFileSystemCheckEnabled = false;
    protected static final String PERM_DENIED_ERROR_PATTERN = "Permission denied";

    public NativeDeviceStateMonitor(IDeviceManager mgr, IDevice device, boolean fastbootEnabled) {
        this.mMgr = mgr;
        this.mDevice = device;
        this.mStateListeners = new ArrayList<DeviceStateListener>();
        this.mDeviceState = TestDeviceState.getStateByDdms(device.getState());
        this.mFastbootEnabled = fastbootEnabled;
        this.mMountFileSystemCheckEnabled = this.mMgr.isFileSystemMountCheckEnabled();
    }

    IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }

    @Override
    public void setDefaultOnlineTimeout(long timeoutMs) {
        this.mDefaultOnlineTimeout = timeoutMs;
    }

    @Override
    public void setDefaultAvailableTimeout(long timeoutMs) {
        this.mDefaultAvailableTimeout = timeoutMs;
    }

    @Override
    public void setFastbootSerialNumber(String serial) {
        this.mFastbootSerialNumber = serial;
        if (this.mFastbootSerialNumber != null && !this.mFastbootSerialNumber.equals(this.getSerialNumber())) {
            this.mMgr.addMonitoringTcpFastbootDevice(this.getSerialNumber(), this.mFastbootSerialNumber);
        }
    }

    @Override
    public IDevice waitForDeviceOnline(long waitTime) {
        if (this.waitForDeviceState(TestDeviceState.ONLINE, waitTime)) {
            return this.getIDevice();
        }
        return null;
    }

    @Override
    public IDevice waitForDeviceOnline() {
        return this.waitForDeviceOnline(this.mDefaultOnlineTimeout);
    }

    @Override
    public IDevice waitForDeviceInRecovery() {
        if (this.waitForDeviceState(TestDeviceState.RECOVERY, this.mDefaultOnlineTimeout)) {
            return this.getIDevice();
        }
        return null;
    }

    @Override
    public boolean waitForDeviceInRecovery(long waitTime) {
        return this.waitForDeviceState(TestDeviceState.RECOVERY, waitTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IDevice getIDevice() {
        IDevice iDevice = this.mDevice;
        synchronized (iDevice) {
            return this.mDevice;
        }
    }

    @Override
    public String getSerialNumber() {
        return this.getIDevice().getSerialNumber();
    }

    @Override
    public String getFastbootSerialNumber() {
        if (this.mFastbootSerialNumber == null) {
            this.mFastbootSerialNumber = this.getSerialNumber();
        }
        return this.mFastbootSerialNumber;
    }

    @Override
    public boolean waitForDeviceNotAvailable(long waitTime) {
        StubFastbootListener listener = new StubFastbootListener();
        if (this.mFastbootEnabled) {
            this.mMgr.addFastbootListener(listener);
        }
        boolean result = this.waitForDeviceState(TestDeviceState.NOT_AVAILABLE, waitTime);
        if (this.mFastbootEnabled) {
            this.mMgr.removeFastbootListener(listener);
        }
        return result;
    }

    @Override
    public boolean waitForDeviceInSideload(long waitTime) {
        return this.waitForDeviceState(TestDeviceState.SIDELOAD, waitTime);
    }

    @Override
    public boolean waitForDeviceShell(long waitTime) {
        LogUtil.CLog.i("Waiting %d ms for device %s shell to be responsive", waitTime, this.getSerialNumber());
        Callable<BUSY_WAIT_STATUS> bootComplete = () -> {
            CollectingOutputReceiver receiver = this.createOutputReceiver();
            String cmd = "id";
            try {
                this.getIDevice().executeShellCommand("id", receiver, 10000L, TimeUnit.MILLISECONDS);
                String output = receiver.getOutput();
                if (output.contains("uid=")) {
                    LogUtil.CLog.i("shell ready. id output: %s", output);
                    return BUSY_WAIT_STATUS.SUCCESS;
                }
            }
            catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | IOException e) {
                LogUtil.CLog.e("%s failed on: %s", "id", this.getSerialNumber());
                LogUtil.CLog.e(e);
            }
            catch (TimeoutException e) {
                LogUtil.CLog.e("%s failed on %s: timeout", "id", this.getSerialNumber());
                LogUtil.CLog.e(e);
            }
            return BUSY_WAIT_STATUS.CONTINUE_WAITING;
        };
        boolean result = this.busyWaitFunction(bootComplete, waitTime);
        if (!result) {
            LogUtil.CLog.w("Device %s shell is unresponsive", this.getSerialNumber());
        }
        return result;
    }

    @Override
    public IDevice waitForDeviceAvailable(long waitTime) {
        try {
            return this.internalWaitForDeviceAvailable(waitTime);
        }
        catch (DeviceNotAvailableException e) {
            return null;
        }
    }

    @Override
    public IDevice waitForDeviceAvailable() {
        return this.waitForDeviceAvailable(this.mDefaultAvailableTimeout);
    }

    @Override
    public IDevice waitForDeviceAvailableInRecoverPath(long waitTime) throws DeviceNotAvailableException {
        return this.internalWaitForDeviceAvailable(waitTime);
    }

    private IDevice internalWaitForDeviceAvailable(long waitTime) throws DeviceNotAvailableException {
        long startTime = System.currentTimeMillis();
        IDevice device = this.waitForDeviceOnline(waitTime);
        if (device == null) {
            return null;
        }
        long elapsedTime = System.currentTimeMillis() - startTime;
        if (!this.waitForBootComplete(waitTime - elapsedTime)) {
            return null;
        }
        elapsedTime = System.currentTimeMillis() - startTime;
        if (!this.postOnlineCheck(waitTime - elapsedTime)) {
            return null;
        }
        return device;
    }

    @Override
    public boolean waitForBootComplete(long waitTime) {
        LogUtil.CLog.i("Waiting %d ms for device %s boot complete", waitTime, this.getSerialNumber());
        Callable<BUSY_WAIT_STATUS> bootComplete = () -> {
            block6: {
                String cmd = "getprop dev.bootcomplete";
                try {
                    CollectingOutputReceiver receiver = new CollectingOutputReceiver();
                    this.getIDevice().executeShellCommand("getprop dev.bootcomplete", receiver, 60000L, TimeUnit.MILLISECONDS);
                    String bootFlag = receiver.getOutput();
                    if (bootFlag != null) {
                        bootFlag = bootFlag.lines().reduce((a, b) -> b).orElse(null);
                    }
                    if (bootFlag != null && "1".equals(bootFlag.trim())) {
                        return BUSY_WAIT_STATUS.SUCCESS;
                    }
                }
                catch (ShellCommandUnresponsiveException | IOException e) {
                    LogUtil.CLog.e("%s failed on: %s", "getprop dev.bootcomplete", this.getSerialNumber());
                    LogUtil.CLog.e(e);
                }
                catch (TimeoutException e) {
                    LogUtil.CLog.e("%s failed on %s: timeout", "getprop dev.bootcomplete", this.getSerialNumber());
                    LogUtil.CLog.e(e);
                }
                catch (AdbCommandRejectedException e) {
                    LogUtil.CLog.e("%s failed on: %s", "getprop dev.bootcomplete", this.getSerialNumber());
                    LogUtil.CLog.e(e);
                    if (!e.isDeviceOffline() && !e.wasErrorDuringDeviceSelection()) break block6;
                    return BUSY_WAIT_STATUS.ABORT;
                }
            }
            return BUSY_WAIT_STATUS.CONTINUE_WAITING;
        };
        boolean result = this.busyWaitFunction(bootComplete, waitTime);
        if (!result) {
            LogUtil.CLog.w("Device %s did not boot after %d ms", this.getSerialNumber(), waitTime);
        }
        return result;
    }

    protected boolean postOnlineCheck(long waitTime) throws DeviceNotAvailableException {
        return true;
    }

    protected boolean waitForStoreMount(long waitTime) throws DeviceNotAvailableException {
        LogUtil.CLog.i("Waiting %d ms for device %s external store", waitTime, this.getSerialNumber());
        long startTime = System.currentTimeMillis();
        int counter = 0;
        int retryOnPermissionDenied = 1;
        while (System.currentTimeMillis() - startTime < waitTime) {
            if (counter > 0) {
                this.getRunUtil().sleep(Math.min(this.getCheckPollTime() * (long)counter, 10000L));
            }
            ++counter;
            CollectingOutputReceiver receiver = this.createOutputReceiver();
            CollectingOutputReceiver bitBucket = new CollectingOutputReceiver();
            long number = this.getCurrentTime();
            String externalStore = this.getMountPoint("EXTERNAL_STORAGE");
            if (externalStore == null) {
                LogUtil.CLog.w("Failed to get external store mount point for %s", this.getSerialNumber());
                continue;
            }
            if (this.mMountFileSystemCheckEnabled) {
                String fileSystem = this.getFileSystem(externalStore);
                if (Strings.isNullOrEmpty(fileSystem)) {
                    LogUtil.CLog.w("Failed to get the fileSystem of '%s'", externalStore);
                    continue;
                }
                if (TMPFS_MAGIC.contains(fileSystem)) {
                    LogUtil.CLog.w("External storage fileSystem is '%s', waiting for it to be mounted.", fileSystem);
                    continue;
                }
            }
            String testFile = String.format("'%s/%d'", externalStore, number);
            String testString = String.format("number %d one", number);
            String writeCmd = String.format("echo '%s' > %s", testString, testFile);
            String checkCmd = String.format("cat %s", testFile);
            String cleanupCmd = String.format("rm %s", testFile);
            String cmd = null;
            try {
                cmd = writeCmd;
                this.getIDevice().executeShellCommand(writeCmd, bitBucket, 10000L, TimeUnit.MILLISECONDS);
                cmd = checkCmd;
                this.getIDevice().executeShellCommand(checkCmd, receiver, 10000L, TimeUnit.MILLISECONDS);
                cmd = cleanupCmd;
                this.getIDevice().executeShellCommand(cleanupCmd, bitBucket, 10000L, TimeUnit.MILLISECONDS);
                String output = receiver.getOutput();
                LogUtil.CLog.v("%s returned %s", checkCmd, output);
                if (output.contains(testString)) {
                    return true;
                }
                if (!output.contains(PERM_DENIED_ERROR_PATTERN) || --retryOnPermissionDenied >= 0) continue;
                LogUtil.CLog.w("Device %s mount check returned Permission Denied, issue with mounting.", this.getSerialNumber());
                return false;
            }
            catch (ShellCommandUnresponsiveException | IOException e) {
                LogUtil.CLog.i("%s on device %s failed:", cmd, this.getSerialNumber());
                LogUtil.CLog.e(e);
            }
            catch (TimeoutException e) {
                LogUtil.CLog.i("%s on device %s failed: timeout", cmd, this.getSerialNumber());
                LogUtil.CLog.e(e);
            }
            catch (AdbCommandRejectedException e) {
                String message2 = String.format("%s on device %s was rejected:", cmd, this.getSerialNumber());
                LogUtil.CLog.i(message2);
                LogUtil.CLog.e(e);
                this.rejectToUnavailable(message2, e);
            }
        }
        LogUtil.CLog.w("Device %s external storage is not mounted after %d ms", this.getSerialNumber(), waitTime);
        return false;
    }

    @Override
    public String getMountPoint(String mountName) throws DeviceNotAvailableException {
        String mountPoint = this.getIDevice().getMountPoint(mountName);
        if (mountPoint != null) {
            return mountPoint;
        }
        CollectingOutputReceiver receiver = this.createOutputReceiver();
        String command = "echo $" + mountName;
        try {
            this.getIDevice().executeShellCommand(command, receiver);
            return receiver.getOutput().trim();
        }
        catch (IOException e) {
            return null;
        }
        catch (TimeoutException e) {
            return null;
        }
        catch (AdbCommandRejectedException e) {
            this.rejectToUnavailable(command, e);
            return null;
        }
        catch (ShellCommandUnresponsiveException e) {
            return null;
        }
    }

    @Override
    public TestDeviceState getDeviceState() {
        return this.mDeviceState;
    }

    @Override
    public boolean waitForDeviceBootloader(long time) {
        return this.waitForDeviceBootloaderOrFastbootd(time, false);
    }

    @Override
    public boolean waitForDeviceFastbootd(String fastbootPath, long time) {
        return this.waitForDeviceBootloaderOrFastbootd(time, true);
    }

    private boolean waitForDeviceBootloaderOrFastbootd(long time, boolean fastbootd) {
        if (!this.mFastbootEnabled) {
            return false;
        }
        long startTime = System.currentTimeMillis();
        this.waitForDeviceBootloaderStateUpdate();
        long elapsedTime = System.currentTimeMillis() - startTime;
        StubFastbootListener listener = new StubFastbootListener();
        this.mMgr.addFastbootListener(listener);
        long waitTime = time - elapsedTime;
        if (waitTime < 0L) {
            waitTime = 200L;
        }
        TestDeviceState mode = TestDeviceState.FASTBOOT;
        if (fastbootd) {
            mode = TestDeviceState.FASTBOOTD;
        }
        boolean result = this.waitForDeviceState(mode, waitTime);
        this.mMgr.removeFastbootListener(listener);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForDeviceBootloaderStateUpdate() {
        NotifyFastbootListener listener;
        if (!this.mFastbootEnabled) {
            return;
        }
        NotifyFastbootListener notifyFastbootListener = listener = new NotifyFastbootListener();
        synchronized (notifyFastbootListener) {
            this.mMgr.addFastbootListener(listener);
            try {
                listener.wait();
            }
            catch (InterruptedException e) {
                LogUtil.CLog.w("wait for device bootloader state update interrupted");
                LogUtil.CLog.w(e);
                throw new RunInterruptedException(e.getMessage(), e, InfraErrorIdentifier.UNDETERMINED);
            }
            finally {
                this.mMgr.removeFastbootListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForDeviceState(TestDeviceState state, long time) {
        String deviceSerial = this.getSerialNumber();
        TestDeviceState currentStatus = this.getDeviceState();
        if (currentStatus.equals((Object)state)) {
            LogUtil.CLog.i("Device %s is already %s", new Object[]{deviceSerial, state});
            return true;
        }
        LogUtil.CLog.i("Waiting for device %s to be in %s mode for '%s'; it is currently in %s mode...", new Object[]{deviceSerial, state, TimeUtil.formatElapsedTime(time), currentStatus});
        DeviceStateListener listener = new DeviceStateListener(state);
        this.addDeviceStateListener(listener);
        DeviceStateListener deviceStateListener = listener;
        synchronized (deviceStateListener) {
            try {
                listener.wait(time);
            }
            catch (InterruptedException e) {
                LogUtil.CLog.w("wait for device state interrupted");
                LogUtil.CLog.w(e);
                throw new RunInterruptedException(e.getMessage(), e, InfraErrorIdentifier.UNDETERMINED);
            }
            finally {
                this.removeDeviceStateListener(listener);
            }
        }
        return this.getDeviceState().equals((Object)state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDeviceStateListener(DeviceStateListener listener) {
        List<DeviceStateListener> list2 = this.mStateListeners;
        synchronized (list2) {
            this.mStateListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDeviceStateListener(DeviceStateListener listener) {
        List<DeviceStateListener> list2 = this.mStateListeners;
        synchronized (list2) {
            this.mStateListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setState(TestDeviceState deviceState) {
        this.mDeviceState = deviceState;
        ArrayList<DeviceStateListener> listenerCopy = new ArrayList<DeviceStateListener>(this.mStateListeners.size());
        List<DeviceStateListener> list2 = this.mStateListeners;
        synchronized (list2) {
            listenerCopy.addAll(this.mStateListeners);
        }
        for (DeviceStateListener listener : listenerCopy) {
            listener.stateChanged(deviceState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIDevice(IDevice newDevice) {
        IDevice currentDevice = this.mDevice;
        if (!this.getIDevice().equals(newDevice)) {
            IDevice iDevice = currentDevice;
            synchronized (iDevice) {
                this.mDevice = newDevice;
            }
        }
    }

    @Override
    public boolean isAdbTcp() {
        return this.mDevice.getSerialNumber().contains(":");
    }

    protected CollectingOutputReceiver createOutputReceiver() {
        return new CollectingOutputReceiver();
    }

    protected long getCheckPollTime() {
        return 1000L;
    }

    protected long getCurrentTime() {
        return System.currentTimeMillis();
    }

    private String getFileSystem(String externalStorePath) throws DeviceNotAvailableException {
        CollectingOutputReceiver receiver = new CollectingOutputReceiver();
        String statCommand = "stat -f -c \"%t\" " + externalStorePath;
        try {
            this.getIDevice().executeShellCommand(statCommand, receiver, 10000L, TimeUnit.MILLISECONDS);
        }
        catch (ShellCommandUnresponsiveException | TimeoutException | IOException e) {
            LogUtil.CLog.e("Exception while attempting to read filesystem of '%s'", externalStorePath);
            LogUtil.CLog.e(e);
            return null;
        }
        catch (AdbCommandRejectedException e) {
            this.rejectToUnavailable(String.format("Exception while attempting to read filesystem of '%s'", externalStorePath), e);
            return null;
        }
        String output = receiver.getOutput().trim();
        LogUtil.CLog.v("'%s' returned %s", statCommand, output);
        if (Longs.tryParse(output) == null && Longs.tryParse(output, 16) == null) {
            LogUtil.CLog.w("stat command return value should be a number. output: %s", output);
            return null;
        }
        return output;
    }

    private boolean busyWaitFunction(Callable<BUSY_WAIT_STATUS> callable, long maxWaitTime) {
        int counter = 0;
        long startTime = System.currentTimeMillis();
        long currentTotalWaitTime = 0L;
        while (System.currentTimeMillis() - startTime < maxWaitTime) {
            if (counter > 0) {
                long nextWaitTime = Math.min(this.getCheckPollTime() * (long)counter, 10000L);
                if (currentTotalWaitTime + nextWaitTime > maxWaitTime) {
                    nextWaitTime = maxWaitTime - currentTotalWaitTime;
                }
                this.getRunUtil().sleep(nextWaitTime);
                currentTotalWaitTime += nextWaitTime;
            }
            ++counter;
            try {
                BUSY_WAIT_STATUS res = callable.call();
                if (BUSY_WAIT_STATUS.SUCCESS.equals((Object)res)) {
                    return true;
                }
                if (!BUSY_WAIT_STATUS.ABORT.equals((Object)res)) continue;
                return false;
            }
            catch (Exception e) {
                LogUtil.CLog.e(e);
            }
        }
        return false;
    }

    private void rejectToUnavailable(String command, AdbCommandRejectedException e) throws DeviceNotAvailableException {
        if (e.isDeviceOffline() || e.wasErrorDuringDeviceSelection()) {
            throw new DeviceNotAvailableException(String.format("%s: %s", command, e.getMessage()), (Throwable)e, this.getSerialNumber(), DeviceErrorIdentifier.DEVICE_UNAVAILABLE);
        }
    }

    private static class StubFastbootListener
    implements IDeviceManager.IFastbootListener {
        private StubFastbootListener() {
        }

        @Override
        public void stateUpdated() {
        }
    }

    private static class NotifyFastbootListener
    implements IDeviceManager.IFastbootListener {
        private NotifyFastbootListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateUpdated() {
            NotifyFastbootListener notifyFastbootListener = this;
            synchronized (notifyFastbootListener) {
                this.notify();
            }
        }
    }

    private static class DeviceStateListener {
        private final TestDeviceState mExpectedState;

        public DeviceStateListener(TestDeviceState expectedState) {
            this.mExpectedState = expectedState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChanged(TestDeviceState newState) {
            if (this.mExpectedState.equals((Object)newState)) {
                DeviceStateListener deviceStateListener = this;
                synchronized (deviceStateListener) {
                    this.notify();
                }
            }
        }
    }

    private static enum BUSY_WAIT_STATUS {
        CONTINUE_WAITING,
        ABORT,
        SUCCESS;

    }
}

