/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import java.util.HashMap;
import java.util.Map;

public class PackageInfo {
    private static final int FLAG_UPDATED_SYSTEM_APP = 128;
    private static final int FLAG_SYSTEM = 1;
    public static final int FLAG_PERSISTENT = 8;
    private static final String FLAG_UPDATED_SYSTEM_APP_TEXT = " UPDATED_SYSTEM_APP ";
    private static final String FLAG_SYSTEM_TEXT = " SYSTEM ";
    private static final String FLAG_PERSISTENT_TEXT = " PERSISTENT ";
    private final String mPackageName;
    private boolean mIsSystemApp;
    private boolean mIsUpdatedSystemApp;
    private boolean mIsPersistentApp;
    private Map<String, String> mAttributes = new HashMap<String, String>();
    private Map<Integer, String> mPerUserFirstInstallTime = new HashMap<Integer, String>();

    PackageInfo(String pkgName) {
        this.mPackageName = pkgName;
    }

    public boolean isUpdatedSystemApp() {
        return this.mIsUpdatedSystemApp;
    }

    public boolean isSystemApp() {
        return this.mIsSystemApp;
    }

    public boolean isPersistentApp() {
        return this.mIsPersistentApp;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public String getVersionName() {
        return this.mAttributes.get("versionName");
    }

    public String getVersionCode() {
        return this.mAttributes.get("versionCode");
    }

    public String getCodePath() {
        return this.mAttributes.get("codePath");
    }

    void setIsUpdatedSystemApp(boolean isUpdatedSystemApp) {
        this.mIsUpdatedSystemApp = isUpdatedSystemApp;
    }

    void addAttribute(String name, String value) {
        this.mAttributes.put(name, value);
        if ((name.equals("pkgFlags") || name.equals("flags")) && !this.parseFlagsAsInt(value)) {
            this.parseFlagsAsString(value);
        }
    }

    private void parseFlagsAsString(String flagString) {
        this.mIsSystemApp = flagString.contains(FLAG_SYSTEM_TEXT);
        this.mIsUpdatedSystemApp = flagString.contains(FLAG_UPDATED_SYSTEM_APP_TEXT);
        this.mIsPersistentApp = flagString.contains(FLAG_PERSISTENT_TEXT);
    }

    private boolean parseFlagsAsInt(String value) {
        try {
            int flags = Integer.decode(value);
            this.mIsSystemApp = (flags & 1) != 0;
            this.mIsUpdatedSystemApp = (flags & 0x80) != 0;
            this.mIsPersistentApp = (flags & 8) != 0;
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public void addPerUserAttribute(int userId, String attr, String value) {
        if (!attr.equals("firstInstallTime")) {
            return;
        }
        this.mPerUserFirstInstallTime.put(userId, value);
    }

    public String getFirstInstallTime(int userId) {
        return this.mPerUserFirstInstallTime.get(userId);
    }
}

