/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.IDevice;
import com.android.tradefed.command.remote.DeviceDescriptor;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.IDeviceMonitor;
import com.android.tradefed.device.IDeviceStateMonitor;
import com.android.tradefed.device.TestDevice;
import com.android.tradefed.device.connection.DefaultConnection;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RemoteAndroidDevice
extends TestDevice {
    public static final long WAIT_FOR_ADB_CONNECT = 120000L;
    protected static final long RETRY_INTERVAL_MS = 5000L;
    protected static final int MAX_RETRIES = 5;
    protected static final long DEFAULT_SHORT_CMD_TIMEOUT = 20000L;
    private static final Pattern IP_PATTERN = Pattern.compile("((^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5]))|(localhost)){1}");

    public RemoteAndroidDevice(IDevice device, IDeviceStateMonitor stateMonitor, IDeviceMonitor allocationMonitor) {
        super(device, stateMonitor, allocationMonitor);
    }

    public static boolean checkSerialFormatValid(String serialString) {
        String[] serial = serialString.split(":");
        if (serial.length == 2) {
            Matcher match = IP_PATTERN.matcher(serial[0]);
            if (!match.find()) {
                return false;
            }
            try {
                Integer.parseInt(serial[1]);
                return true;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isEncryptionSupported() {
        return false;
    }

    @Override
    public String getMacAddress() {
        return null;
    }

    @Override
    public String getFastbootSerialNumber() {
        return "tcp:" + this.getSerialNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connectToWifiNetwork(Map<String, String> wifiSsidToPsk, boolean scanSsid) throws DeviceNotAvailableException {
        if (!this.getOptions().useCmdWifiCommands() || !this.enableAdbRoot() || this.getApiLevel() < 31) {
            return super.connectToWifiNetwork(wifiSsidToPsk, scanSsid);
        }
        long startTime = System.currentTimeMillis();
        boolean success = false;
        try {
            CommandResult enableOutput = this.executeShellV2Command(String.format("cmd -w wifi set-wifi-enabled enabled", new Object[0]));
            if (!CommandStatus.SUCCESS.equals((Object)enableOutput.getStatus())) {
                LogUtil.CLog.w("Failed to enable wifi. stdout: %s\nstderr:%s", enableOutput.getStdout(), enableOutput.getStderr());
                boolean bl = false;
                return bl;
            }
            for (Map.Entry<String, String> wifiPair : wifiSsidToPsk.entrySet()) {
                CommandResult connectOutput = this.executeShellV2Command(String.format("cmd wifi connect-network %s %s open", wifiPair.getKey(), wifiPair.getValue()));
                if (CommandStatus.SUCCESS.equals((Object)connectOutput.getStatus())) {
                    LogUtil.CLog.i("Successfully connected to wifi network %s", wifiPair.getKey());
                    InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.WIFI_AP_NAME, wifiPair.getKey());
                    success = true;
                    break;
                }
                LogUtil.CLog.w("Failed to connect to wifi wifi. stdout: %s\nstderr:%s", enableOutput.getStdout(), enableOutput.getStderr());
            }
        }
        finally {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.WIFI_CONNECT_TIME, System.currentTimeMillis() - startTime);
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.WIFI_CONNECT_COUNT, 1L);
        }
        return success;
    }

    @Override
    public DeviceDescriptor getDeviceDescriptor(boolean shortDescriptor) {
        DeviceDescriptor descriptor = super.getDeviceDescriptor(shortDescriptor);
        if (this.getConnection() instanceof DefaultConnection) {
            String initialSerial = ((DefaultConnection)this.getConnection()).getInitialSerial();
            String initialIp = ((DefaultConnection)this.getConnection()).getInitialIp();
            Integer initialOffset = ((DefaultConnection)this.getConnection()).getInitialDeviceNumOffset();
            if (initialIp != null) {
                descriptor = new DeviceDescriptor(descriptor, initialIp, initialOffset);
            }
        }
        return descriptor;
    }
}

