/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.InstallException;
import com.android.ddmlib.InstallReceiver;
import com.android.ddmlib.RawImage;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.device.CollectingByteOutputReceiver;
import com.android.tradefed.device.CollectingOutputReceiver;
import com.android.tradefed.device.DeviceFoldableState;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.DeviceRuntimeException;
import com.android.tradefed.device.DeviceSelectionOptions;
import com.android.tradefed.device.DeviceUnresponsiveException;
import com.android.tradefed.device.DumpsysPackageReceiver;
import com.android.tradefed.device.FreeDeviceState;
import com.android.tradefed.device.IDeviceManager;
import com.android.tradefed.device.IDeviceMonitor;
import com.android.tradefed.device.IDeviceSelection;
import com.android.tradefed.device.IDeviceStateMonitor;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.IWifiHelper;
import com.android.tradefed.device.MicrodroidHelper;
import com.android.tradefed.device.NativeDevice;
import com.android.tradefed.device.PackageInfo;
import com.android.tradefed.device.RemoteAvdIDevice;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.device.TestDeviceState;
import com.android.tradefed.device.UserInfo;
import com.android.tradefed.device.WifiHelper;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.log.ITestLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ByteArrayInputStreamSource;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.AaptParser;
import com.android.tradefed.util.Bugreport;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.KeyguardControllerState;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.ZipUtil2;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class TestDevice
extends NativeDevice {
    private static final int NUM_CLEAR_ATTEMPTS = 5;
    static final String DISMISS_DIALOG_CMD = "input keyevent 23";
    private static final String DISMISS_DIALOG_BROADCAST = "am broadcast -a android.intent.action.CLOSE_SYSTEM_DIALOG";
    private static final String COLLAPSE_STATUS_BAR = "cmd statusbar collapse";
    public static final String DISMISS_KEYGUARD_CMD = "input keyevent 82";
    static final String DISMISS_KEYGUARD_WM_CMD = "wm dismiss-keyguard";
    private static final long DISMISS_KEYGUARD_TIMEOUT = 3000L;
    static final String KEYGUARD_CONTROLLER_CMD = "dumpsys activity activities | grep -A3 KeyguardController:";
    private static final long INPUT_DISPATCH_READY_TIMEOUT = 5000L;
    private static final String TEST_INPUT_CMD = "dumpsys input";
    private static final long AM_COMMAND_TIMEOUT = 10000L;
    private static final long CHECK_NEW_USER = 1000L;
    static final String LIST_PACKAGES_CMD = "pm list packages -f";
    private static final Pattern PACKAGE_REGEX = Pattern.compile("package:(.*)=(.*)");
    static final String LIST_APEXES_CMD = "pm list packages --apex-only --show-versioncode -f";
    private static final Pattern APEXES_WITH_PATH_REGEX = Pattern.compile("package:(.*)=(.*) versionCode:(.*)");
    static final String GET_MODULEINFOS_CMD = "pm get-moduleinfo --all";
    private static final Pattern MODULEINFO_REGEX = Pattern.compile("ModuleInfo\\{(.*)\\} packageName: (.*)");
    private static final Pattern APEXES_WITHOUT_PATH_REGEX = Pattern.compile("package:(.*) versionCode:(.*)");
    private static final int FLAG_PRIMARY = 1;
    private static final int FLAG_MAIN = 16384;
    private static final String[] SETTINGS_NAMESPACE = new String[]{"system", "secure", "global"};
    private static final String USER_PATTERN = "(.*?\\{)(\\d+)(:)(.*)(:)(\\w+)(\\}.*)";
    private static final String DISPLAY_ID_PATTERN = "(Display )(?<id>\\d+)( color modes:)";
    private static final int API_LEVEL_GET_CURRENT_USER = 24;
    private static final long MAX_SCREENSHOT_TIMEOUT = 300000L;
    private static final String DUMPHEAP_CMD = "am dumpheap %s %s";
    private static final long DUMPHEAP_TIME = 5000L;
    static final long INSTALL_TIMEOUT_MINUTES = 4L;
    static final long INSTALL_TIMEOUT_TO_OUTPUT_MINUTES = 3L;
    private boolean mWasWifiHelperInstalled = false;
    private static final String APEX_SUFFIX = ".apex";
    private static final String APEX_ARG = "--apex";
    private Map<Process, MicrodroidTracker> mStartedMicrodroids = new HashMap<Process, MicrodroidTracker>();
    private static final String TEST_ROOT = "/data/local/tmp/virt/";
    private static final String VIRT_APEX = "/apex/com.android.virt/";
    private static final String INSTANCE_IMG = "instance.img";
    private static final long MICRODROID_MAX_LIFETIME_MINUTES = 20L;
    private static final long MICRODROID_DEFAULT_ADB_CONNECT_TIMEOUT_MINUTES = 5L;
    private static final String EARLY_REBOOT = "Too early to call shutdown() or reboot()";
    private static final int BUGREPORT_TIMEOUT = 120000;
    private static final String BUGREPORT_CMD = "bugreport";
    private static final String BUGREPORTZ_CMD = "bugreportz";
    private static final Pattern BUGREPORTZ_RESPONSE_PATTERN = Pattern.compile("(OK:)(.*)");

    public TestDevice(IDevice device, IDeviceStateMonitor stateMonitor, IDeviceMonitor allocationMonitor) {
        super(device, stateMonitor, allocationMonitor);
    }

    @Override
    public boolean isAppEnumerationSupported() throws DeviceNotAvailableException {
        if (!this.checkApiLevelAgainstNextRelease(30)) {
            return false;
        }
        return this.hasFeature("android.software.app_enumeration");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String internalInstallPackage(final File packageFile, final boolean reinstall, List<String> extraArgs) throws DeviceNotAvailableException {
        long startTime = System.currentTimeMillis();
        try {
            final ArrayList<String> args = new ArrayList<String>(extraArgs);
            if (packageFile.getName().endsWith(APEX_SUFFIX)) {
                args.add(APEX_ARG);
            }
            final String[] response = new String[1];
            NativeDevice.DeviceAction installAction = new NativeDevice.DeviceAction(){

                @Override
                public boolean run() throws InstallException {
                    try {
                        InstallReceiver receiver = TestDevice.this.createInstallReceiver();
                        TestDevice.this.getIDevice().installPackage(packageFile.getAbsolutePath(), reinstall, receiver, 4L, 3L, TimeUnit.MINUTES, args.toArray(new String[0]));
                        response[0] = TestDevice.this.handleInstallReceiver(receiver, packageFile);
                    }
                    catch (InstallException e) {
                        response[0] = TestDevice.this.handleInstallationError(e);
                    }
                    return response[0] == null;
                }
            };
            LogUtil.CLog.v("Installing package file %s with args %s on %s", packageFile.getAbsolutePath(), extraArgs.toString(), this.getSerialNumber());
            this.performDeviceAction(String.format("install %s", packageFile.getAbsolutePath()), installAction, 2);
            ArrayList<File> packageFiles = new ArrayList<File>();
            packageFiles.add(packageFile);
            this.allowLegacyStorageForApps(packageFiles);
            String string = response[0];
            return string;
        }
        finally {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.PACKAGE_INSTALL_COUNT, 1L);
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.PACKAGE_INSTALL_TIME, System.currentTimeMillis() - startTime);
        }
    }

    @VisibleForTesting
    InstallReceiver createInstallReceiver() {
        return new InstallReceiver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public InputStreamSource getBugreport() {
        long startTime;
        File bugreportzFile;
        File mainEntry;
        block12: {
            if (this.getApiLevelSafe() < 24) {
                InputStreamSource bugreport = this.getBugreportInternal();
                if (bugreport == null) {
                    return new ByteArrayInputStreamSource("".getBytes());
                }
                return bugreport;
            }
            LogUtil.CLog.d("Api level above 24, using bugreportz instead.");
            mainEntry = null;
            bugreportzFile = null;
            startTime = System.currentTimeMillis();
            bugreportzFile = this.getBugreportzInternal();
            if (bugreportzFile != null) break block12;
            ByteArrayInputStreamSource byteArrayInputStreamSource = new ByteArrayInputStreamSource("".getBytes());
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.BUGREPORT_TIME, System.currentTimeMillis() - startTime);
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.BUGREPORT_COUNT, 1L);
            FileUtil.deleteFile(bugreportzFile);
            FileUtil.deleteFile(mainEntry);
            return byteArrayInputStreamSource;
        }
        ZipFile zip = new ZipFile(bugreportzFile);
        mainEntry = ZipUtil2.extractFileFromZip(zip, "main_entry.txt");
        String bugreportName = FileUtil.readStringFromFile(mainEntry).trim();
        LogUtil.CLog.d("bugreport name: '%s'", bugreportName);
        File bugreport = ZipUtil2.extractFileFromZip(zip, bugreportName);
        FileInputStreamSource fileInputStreamSource = new FileInputStreamSource(bugreport, true);
        zip.close();
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.BUGREPORT_TIME, System.currentTimeMillis() - startTime);
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.BUGREPORT_COUNT, 1L);
        FileUtil.deleteFile(bugreportzFile);
        FileUtil.deleteFile(mainEntry);
        return fileInputStreamSource;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            zip.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        LogUtil.CLog.e("Error while unzipping bugreportz");
                        LogUtil.CLog.e(e);
                        ByteArrayInputStreamSource byteArrayInputStreamSource = new ByteArrayInputStreamSource("corrupted bugreport.".getBytes());
                        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.BUGREPORT_TIME, System.currentTimeMillis() - startTime);
                        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.BUGREPORT_COUNT, 1L);
                        FileUtil.deleteFile(bugreportzFile);
                        FileUtil.deleteFile(mainEntry);
                        return byteArrayInputStreamSource;
                    }
                }
                catch (Throwable throwable3) {
                    InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.BUGREPORT_TIME, System.currentTimeMillis() - startTime);
                    InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.BUGREPORT_COUNT, 1L);
                    FileUtil.deleteFile(bugreportzFile);
                    FileUtil.deleteFile(mainEntry);
                    throw throwable3;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean logBugreport(String dataName, ITestLogger listener) {
        InputStreamSource bugreport = null;
        LogDataType type = null;
        try {
            bugreport = this.getBugreportz();
            type = LogDataType.BUGREPORTZ;
            if (bugreport != null && bugreport.size() > 0L) {
                listener.testLog(dataName, type, bugreport);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            StreamUtil.cancel(bugreport);
        }
        LogUtil.CLog.d("logBugreport() was not successful in collecting and logging the bugreport for device %s", this.getSerialNumber());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bugreport takeBugreport() {
        File bugreportFile = null;
        int apiLevel = this.getApiLevelSafe();
        if (apiLevel == -1) {
            return null;
        }
        long startTime = System.currentTimeMillis();
        try {
            if (apiLevel >= 24) {
                LogUtil.CLog.d("Api level above 24, using bugreportz.");
                bugreportFile = this.getBugreportzInternal();
                if (bugreportFile != null) {
                    Bugreport bugreport = new Bugreport(bugreportFile, true);
                    return bugreport;
                }
                Bugreport bugreport = null;
                return bugreport;
            }
            InputStreamSource bugreport = this.getBugreportInternal();
            if (bugreport == null) {
                LogUtil.CLog.e("Error when collecting the bugreport.");
                Bugreport bugreport2 = null;
                return bugreport2;
            }
            bugreportFile = FileUtil.createTempFile(BUGREPORT_CMD, ".txt");
            FileUtil.writeToFile(bugreport.createInputStream(), bugreportFile);
            Bugreport bugreport3 = new Bugreport(bugreportFile, false);
            return bugreport3;
        }
        finally {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.BUGREPORT_TIME, System.currentTimeMillis() - startTime);
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.BUGREPORT_COUNT, 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStreamSource getBugreportz() {
        if (this.getApiLevelSafe() < 24) {
            return null;
        }
        LogUtil.CLog.d("Start getBugreportz()");
        long startTime = System.currentTimeMillis();
        try {
            File bugreportZip = this.getBugreportzInternal();
            if (bugreportZip != null) {
                FileInputStreamSource fileInputStreamSource = new FileInputStreamSource(bugreportZip, true);
                return fileInputStreamSource;
            }
            InputStreamSource inputStreamSource = null;
            return inputStreamSource;
        }
        finally {
            LogUtil.CLog.d("Done with getBugreportz()");
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.BUGREPORT_TIME, System.currentTimeMillis() - startTime);
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.BUGREPORT_COUNT, 1L);
        }
    }

    @VisibleForTesting
    protected File getBugreportzInternal() {
        CollectingOutputReceiver receiver = new CollectingOutputReceiver();
        try {
            this.executeShellCommand(BUGREPORTZ_CMD, receiver, this.getOptions().getBugreportzTimeout(), TimeUnit.MILLISECONDS, 0);
            String output = receiver.getOutput().trim();
            Matcher match = BUGREPORTZ_RESPONSE_PATTERN.matcher(output);
            if (!match.find()) {
                LogUtil.CLog.e("Something went went wrong during bugreportz collection: '%s'", output);
                return null;
            }
            String remoteFilePath = match.group(2);
            if (Strings.isNullOrEmpty(remoteFilePath)) {
                LogUtil.CLog.e("Invalid bugreportz path found from output: %s", output);
                return null;
            }
            File zipFile = null;
            try {
                if (!this.doesFileExist(remoteFilePath)) {
                    LogUtil.CLog.e("Did not find bugreportz at: '%s'", remoteFilePath);
                    return null;
                }
                zipFile = FileUtil.createTempFile(BUGREPORTZ_CMD, ".zip");
                this.pullFile(remoteFilePath, zipFile);
                String bugreportDir = remoteFilePath.substring(0, remoteFilePath.lastIndexOf(47));
                if (!bugreportDir.isEmpty()) {
                    this.deleteFile(String.format("%s/*", bugreportDir));
                }
                return zipFile;
            }
            catch (IOException e) {
                LogUtil.CLog.e("Failed to create the temporary file.");
                return null;
            }
        }
        catch (DeviceNotAvailableException e) {
            LogUtil.CLog.e("Device %s became unresponsive while retrieving bugreportz", this.getSerialNumber());
            LogUtil.CLog.e(e);
            return null;
        }
    }

    protected InputStreamSource getBugreportInternal() {
        CollectingByteOutputReceiver receiver = new CollectingByteOutputReceiver();
        try {
            this.executeShellCommand(BUGREPORT_CMD, receiver, 120000L, TimeUnit.MILLISECONDS, 0);
        }
        catch (DeviceNotAvailableException e) {
            LogUtil.CLog.e("Device %s became unresponsive while retrieving bugreport", this.getSerialNumber());
            return null;
        }
        return new ByteArrayInputStreamSource(receiver.getOutput());
    }

    @Override
    public String installPackage(File packageFile, boolean reinstall, String ... extraArgs) throws DeviceNotAvailableException {
        boolean runtimePermissionSupported = this.isRuntimePermissionSupported();
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(extraArgs));
        if (runtimePermissionSupported) {
            args.add("-g");
        }
        return this.internalInstallPackage(packageFile, reinstall, args);
    }

    @Override
    public String installPackage(File packageFile, boolean reinstall, boolean grantPermissions, String ... extraArgs) throws DeviceNotAvailableException {
        this.ensureRuntimePermissionSupported();
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(extraArgs));
        if (grantPermissions) {
            args.add("-g");
        }
        return this.internalInstallPackage(packageFile, reinstall, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String installPackage(final File packageFile, final File certFile, final boolean reinstall, final String ... extraArgs) throws DeviceNotAvailableException {
        long startTime = System.currentTimeMillis();
        try {
            final String[] response = new String[1];
            NativeDevice.DeviceAction installAction = new NativeDevice.DeviceAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean run() throws InstallException, SyncException, IOException, TimeoutException, AdbCommandRejectedException {
                    String remotePackagePath = TestDevice.this.getIDevice().syncPackageToDevice(packageFile.getAbsolutePath());
                    String remoteCertPath = TestDevice.this.getIDevice().syncPackageToDevice(certFile.getAbsolutePath());
                    String[] newExtraArgs = new String[extraArgs.length + 1];
                    System.arraycopy(extraArgs, 0, newExtraArgs, 0, extraArgs.length);
                    newExtraArgs[newExtraArgs.length - 1] = String.format("\"%s\"", remotePackagePath);
                    try {
                        InstallReceiver receiver = TestDevice.this.createInstallReceiver();
                        TestDevice.this.getIDevice().installRemotePackage(remoteCertPath, reinstall, receiver, 4L, 3L, TimeUnit.MINUTES, newExtraArgs);
                        response[0] = TestDevice.this.handleInstallReceiver(receiver, packageFile);
                    }
                    catch (InstallException e) {
                        response[0] = TestDevice.this.handleInstallationError(e);
                    }
                    finally {
                        TestDevice.this.getIDevice().removeRemotePackage(remotePackagePath);
                        TestDevice.this.getIDevice().removeRemotePackage(remoteCertPath);
                    }
                    return true;
                }
            };
            this.performDeviceAction(String.format("install %s", packageFile.getAbsolutePath()), installAction, 2);
            ArrayList<File> packageFiles = new ArrayList<File>();
            packageFiles.add(packageFile);
            this.allowLegacyStorageForApps(packageFiles);
            String string = response[0];
            return string;
        }
        finally {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.PACKAGE_INSTALL_COUNT, 1L);
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.PACKAGE_INSTALL_TIME, System.currentTimeMillis() - startTime);
        }
    }

    @Override
    public String installPackageForUser(File packageFile, boolean reinstall, int userId, String ... extraArgs) throws DeviceNotAvailableException {
        boolean runtimePermissionSupported = this.isRuntimePermissionSupported();
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(extraArgs));
        if (runtimePermissionSupported) {
            args.add("-g");
        }
        args.add("--user");
        args.add(Integer.toString(userId));
        return this.internalInstallPackage(packageFile, reinstall, args);
    }

    @Override
    public String installPackageForUser(File packageFile, boolean reinstall, boolean grantPermissions, int userId, String ... extraArgs) throws DeviceNotAvailableException {
        this.ensureRuntimePermissionSupported();
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(extraArgs));
        if (grantPermissions) {
            args.add("-g");
        }
        args.add("--user");
        args.add(Integer.toString(userId));
        return this.internalInstallPackage(packageFile, reinstall, args);
    }

    @Override
    public String uninstallPackage(String packageName) throws DeviceNotAvailableException {
        return this.uninstallPackage(packageName, null);
    }

    private String uninstallPackage(String packageName, @Nullable String extraArgs) throws DeviceNotAvailableException {
        String finalExtraArgs = extraArgs == null ? "" : extraArgs;
        String[] response = new String[1];
        NativeDevice.DeviceAction uninstallAction = () -> {
            String result;
            LogUtil.CLog.d("Uninstalling %s with extra args %s", packageName, finalExtraArgs);
            response[0] = result = this.getIDevice().uninstallApp(packageName, finalExtraArgs);
            return result == null;
        };
        this.performDeviceAction(String.format("uninstall %s with extra args %s", packageName, finalExtraArgs), uninstallAction, 2);
        return response[0];
    }

    @Override
    public String uninstallPackageForUser(String packageName, int userId) throws DeviceNotAvailableException {
        return this.uninstallPackage(packageName, "--user " + userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String internalInstallPackages(final List<File> packageFiles, final boolean reinstall, final List<String> extraArgs) throws DeviceNotAvailableException {
        long startTime = System.currentTimeMillis();
        try {
            final String[] response = new String[1];
            NativeDevice.DeviceAction installAction = new NativeDevice.DeviceAction(){

                @Override
                public boolean run() throws InstallException {
                    try {
                        TestDevice.this.getIDevice().installPackages(packageFiles, reinstall, extraArgs, 4L, TimeUnit.MINUTES);
                        response[0] = null;
                        return true;
                    }
                    catch (InstallException e) {
                        response[0] = TestDevice.this.handleInstallationError(e);
                        return false;
                    }
                }
            };
            this.performDeviceAction(String.format("install %s", packageFiles.toString()), installAction, 2);
            this.allowLegacyStorageForApps(packageFiles);
            String string = response[0];
            return string;
        }
        finally {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.PACKAGE_INSTALL_COUNT, 1L);
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.PACKAGE_INSTALL_TIME, System.currentTimeMillis() - startTime);
        }
    }

    private void allowLegacyStorageForApps(List<File> appFiles) throws DeviceNotAvailableException {
        for (File appFile : appFiles) {
            AaptParser aaptParser = this.createParser(appFile);
            if (aaptParser == null || aaptParser.getTargetSdkVersion() <= 29 || !aaptParser.isRequestingLegacyStorage()) continue;
            if (!aaptParser.isUsingPermissionManageExternalStorage()) {
                LogUtil.CLog.w("App is requesting legacy storage and targets R or above, but didn't request the MANAGE_EXTERNAL_STORAGE permission so the associated app op cannot be automatically granted and the app won't have legacy external storage access: " + aaptParser.getPackageName());
                continue;
            }
            ArrayList<Integer> userIds = this.listUsers();
            for (int userId : userIds) {
                CommandResult setFileManagerAppOpResult = this.executeShellV2Command("appops set --user " + userId + " --uid " + aaptParser.getPackageName() + " MANAGE_EXTERNAL_STORAGE 0");
                if (CommandStatus.SUCCESS.equals((Object)setFileManagerAppOpResult.getStatus())) continue;
                LogUtil.CLog.e("Failed to set MANAGE_EXTERNAL_STORAGE App Op to allow legacy external storage for: %s ; stderr: %s", aaptParser.getPackageName(), setFileManagerAppOpResult.getStderr());
            }
        }
        CommandResult persistFileManagerAppOpResult = this.executeShellV2Command("appops write-settings");
        if (!CommandStatus.SUCCESS.equals((Object)persistFileManagerAppOpResult.getStatus())) {
            LogUtil.CLog.e("Failed to persist MANAGE_EXTERNAL_STORAGE App Op over `adb reboot`: %s", persistFileManagerAppOpResult.getStderr());
        }
    }

    @VisibleForTesting
    protected AaptParser createParser(File appFile) {
        return AaptParser.parse(appFile);
    }

    @Override
    public String installPackages(List<File> packageFiles, boolean reinstall, String ... extraArgs) throws DeviceNotAvailableException {
        return this.installPackages(packageFiles, reinstall, this.isRuntimePermissionSupported(), extraArgs);
    }

    @Override
    public String installPackages(List<File> packageFiles, boolean reinstall, boolean grantPermissions, String ... extraArgs) throws DeviceNotAvailableException {
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(extraArgs));
        if (grantPermissions) {
            this.ensureRuntimePermissionSupported();
            args.add("-g");
        }
        return this.internalInstallPackages(packageFiles, reinstall, args);
    }

    @Override
    public String installPackagesForUser(List<File> packageFiles, boolean reinstall, int userId, String ... extraArgs) throws DeviceNotAvailableException {
        return this.installPackagesForUser(packageFiles, reinstall, this.isRuntimePermissionSupported(), userId, extraArgs);
    }

    @Override
    public String installPackagesForUser(List<File> packageFiles, boolean reinstall, boolean grantPermissions, int userId, String ... extraArgs) throws DeviceNotAvailableException {
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(extraArgs));
        if (grantPermissions) {
            this.ensureRuntimePermissionSupported();
            args.add("-g");
        }
        args.add("--user");
        args.add(Integer.toString(userId));
        return this.internalInstallPackages(packageFiles, reinstall, args);
    }

    private String internalInstallRemotePackages(final List<String> remoteApkPaths, final boolean reinstall, final List<String> extraArgs) throws DeviceNotAvailableException {
        final String[] response = new String[1];
        NativeDevice.DeviceAction installAction = new NativeDevice.DeviceAction(){

            @Override
            public boolean run() throws InstallException {
                try {
                    TestDevice.this.getIDevice().installRemotePackages(remoteApkPaths, reinstall, extraArgs, 4L, TimeUnit.MINUTES);
                    response[0] = null;
                    return true;
                }
                catch (InstallException e) {
                    response[0] = TestDevice.this.handleInstallationError(e);
                    return false;
                }
            }
        };
        this.performDeviceAction(String.format("install %s", remoteApkPaths.toString()), installAction, 2);
        return response[0];
    }

    @Override
    public String installRemotePackages(List<String> remoteApkPaths, boolean reinstall, String ... extraArgs) throws DeviceNotAvailableException {
        return this.installRemotePackages(remoteApkPaths, reinstall, this.isRuntimePermissionSupported(), extraArgs);
    }

    @Override
    public String installRemotePackages(List<String> remoteApkPaths, boolean reinstall, boolean grantPermissions, String ... extraArgs) throws DeviceNotAvailableException {
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(extraArgs));
        if (grantPermissions) {
            this.ensureRuntimePermissionSupported();
            args.add("-g");
        }
        return this.internalInstallRemotePackages(remoteApkPaths, reinstall, args);
    }

    @Override
    public InputStreamSource getScreenshot() throws DeviceNotAvailableException {
        return this.getScreenshot("PNG");
    }

    @Override
    public InputStreamSource getScreenshot(String format) throws DeviceNotAvailableException {
        return this.getScreenshot(format, true);
    }

    @Override
    public InputStreamSource getScreenshot(String format, boolean rescale) throws DeviceNotAvailableException {
        byte[] imageData;
        ScreenshotAction action;
        if (!format.equalsIgnoreCase("PNG") && !format.equalsIgnoreCase("JPEG")) {
            LogUtil.CLog.e("Screenshot: Format %s is not supported, defaulting to PNG.", format);
            format = "PNG";
        }
        if (this.performDeviceAction("screenshot", action = new ScreenshotAction(), 2) && (imageData = this.compressRawImage(action.mRawScreenshot, format.toUpperCase(), rescale)) != null) {
            return new ByteArrayInputStreamSource(imageData);
        }
        return new ByteArrayInputStreamSource("Error: device reported null for screenshot.".getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStreamSource getScreenshot(long displayId) throws DeviceNotAvailableException {
        String tmpDevicePath = String.format("/data/local/tmp/display_%s.png", displayId);
        CommandResult result = this.executeShellV2Command(String.format("screencap -p -d %s %s", displayId, tmpDevicePath));
        if (!CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
            LogUtil.CLog.e("Error: device reported error for screenshot:");
            LogUtil.CLog.e("stdout: %s\nstderr: %s", result.getStdout(), result.getStderr());
            return null;
        }
        try {
            File tmpScreenshot = this.pullFile(tmpDevicePath);
            if (tmpScreenshot == null) {
                InputStreamSource inputStreamSource = null;
                return inputStreamSource;
            }
            FileInputStreamSource fileInputStreamSource = new FileInputStreamSource(tmpScreenshot, true);
            return fileInputStreamSource;
        }
        finally {
            this.deleteFile(tmpDevicePath);
        }
    }

    @VisibleForTesting
    byte[] compressRawImage(RawImage rawImage, String format, boolean rescale) {
        BufferedImage image = this.rawImageToBufferedImage(rawImage, format);
        if (rescale) {
            image = this.rescaleImage(image);
        }
        return this.getImageData(image, format);
    }

    @VisibleForTesting
    BufferedImage rawImageToBufferedImage(RawImage rawImage, String format) {
        BufferedImage image = null;
        image = "JPEG".equalsIgnoreCase(format) ? new BufferedImage(rawImage.width, rawImage.height, 5) : new BufferedImage(rawImage.width, rawImage.height, 2);
        int index = 0;
        int IndexInc = rawImage.bpp >> 3;
        for (int y = 0; y < rawImage.height; ++y) {
            for (int x = 0; x < rawImage.width; ++x) {
                int value = rawImage.getARGB(index);
                index += IndexInc;
                image.setRGB(x, y, value);
            }
        }
        return image;
    }

    @VisibleForTesting
    BufferedImage rescaleImage(BufferedImage image) {
        int shortEdge = Math.min(image.getHeight(), image.getWidth());
        if (shortEdge > 720) {
            Image resized = image.getScaledInstance(image.getWidth() / 2, image.getHeight() / 2, 4);
            image = new BufferedImage(image.getWidth() / 2, image.getHeight() / 2, 8);
            image.getGraphics().drawImage(resized, 0, 0, null);
        }
        return image;
    }

    @VisibleForTesting
    byte[] getImageData(BufferedImage image, String format) {
        byte[] imageData = null;
        ByteArrayOutputStream imageOut = new ByteArrayOutputStream(131072);
        try {
            if (ImageIO.write((RenderedImage)image, format, imageOut)) {
                imageData = imageOut.toByteArray();
            } else {
                LogUtil.CLog.e("Failed to compress screenshot to png");
            }
        }
        catch (IOException e) {
            LogUtil.CLog.e("Failed to compress screenshot to png");
            LogUtil.CLog.e(e);
        }
        StreamUtil.close(imageOut);
        return imageData;
    }

    @Override
    public boolean clearErrorDialogs() throws DeviceNotAvailableException {
        this.executeShellCommand(DISMISS_DIALOG_BROADCAST);
        this.executeShellCommand(COLLAPSE_STATUS_BAR);
        for (int i = 0; i < 5; ++i) {
            int numErrorDialogs = this.getErrorDialogCount();
            if (numErrorDialogs == 0) {
                return true;
            }
            this.doClearDialogs(numErrorDialogs);
        }
        if (this.getErrorDialogCount() > 0) {
            LogUtil.CLog.e("error dialogs still exist on %s.", this.getSerialNumber());
            return false;
        }
        return true;
    }

    private int getErrorDialogCount() throws DeviceNotAvailableException {
        int errorDialogCount = 0;
        Pattern crashPattern = Pattern.compile(".*crashing=true.*AppErrorDialog.*");
        Pattern anrPattern = Pattern.compile(".*notResponding=true.*AppNotRespondingDialog.*");
        String systemStatusOutput = this.executeShellCommand("dumpsys activity processes | grep -e .*crashing=true.*AppErrorDialog.* -e .*notResponding=true.*AppNotRespondingDialog.*");
        Matcher crashMatcher = crashPattern.matcher(systemStatusOutput);
        while (crashMatcher.find()) {
            ++errorDialogCount;
        }
        Matcher anrMatcher = anrPattern.matcher(systemStatusOutput);
        while (anrMatcher.find()) {
            ++errorDialogCount;
        }
        return errorDialogCount;
    }

    private void doClearDialogs(int numDialogs) throws DeviceNotAvailableException {
        LogUtil.CLog.i("Attempted to clear %d dialogs on %s", numDialogs, this.getSerialNumber());
        for (int i = 0; i < numDialogs; ++i) {
            this.executeShellCommand(DISMISS_DIALOG_CMD);
        }
    }

    @Override
    public void disableKeyguard() throws DeviceNotAvailableException {
        Boolean ready;
        long start = System.currentTimeMillis();
        while ((ready = this.isDeviceInputReady()) != null && !ready.booleanValue()) {
            long timeSpent = System.currentTimeMillis() - start;
            if (timeSpent > 5000L) {
                LogUtil.CLog.w("Timeout after waiting %dms on enabling of input dispatch", timeSpent);
                break;
            }
            this.getRunUtil().sleep(1000L);
        }
        if (this.getApiLevel() >= 23) {
            LogUtil.CLog.i("Attempting to disable keyguard on %s using %s", this.getSerialNumber(), DISMISS_KEYGUARD_WM_CMD);
            String output = this.executeShellCommand(DISMISS_KEYGUARD_WM_CMD);
            LogUtil.CLog.i("output of %s: %s", DISMISS_KEYGUARD_WM_CMD, output);
        } else {
            LogUtil.CLog.i("Command: %s, is not supported, falling back to %s", DISMISS_KEYGUARD_WM_CMD, DISMISS_KEYGUARD_CMD);
            this.executeShellCommand(DISMISS_KEYGUARD_CMD);
        }
        this.verifyKeyguardDismissed();
    }

    private void verifyKeyguardDismissed() throws DeviceNotAvailableException {
        long start = System.currentTimeMillis();
        KeyguardControllerState state;
        while ((state = this.getKeyguardState()) != null) {
            if (!state.isKeyguardShowing()) {
                return;
            }
            long timeSpent = System.currentTimeMillis() - start;
            if (timeSpent > 3000L) {
                if (state.isKeyguardGoingAway()) {
                    LogUtil.CLog.w("Keyguard still going away %dms after being dismissed", timeSpent);
                } else {
                    LogUtil.CLog.w("No response from keyguard %dms after being dismissed", timeSpent);
                }
                return;
            }
            this.getRunUtil().sleep(500L);
        }
        return;
    }

    @Override
    public KeyguardControllerState getKeyguardState() throws DeviceNotAvailableException {
        String output = this.executeShellCommand(KEYGUARD_CONTROLLER_CMD);
        LogUtil.CLog.d("Output from KeyguardController: %s", output);
        KeyguardControllerState state = KeyguardControllerState.create(Arrays.asList(output.trim().split("\n")));
        return state;
    }

    Boolean isDeviceInputReady() throws DeviceNotAvailableException {
        CollectingOutputReceiver receiver = new CollectingOutputReceiver();
        this.executeShellCommand(TEST_INPUT_CMD, receiver);
        String output = receiver.getOutput();
        Matcher m = INPUT_DISPATCH_STATE_REGEX.matcher(output);
        if (!m.find()) {
            return null;
        }
        return "1".equals(m.group(1));
    }

    @Override
    protected void prePostBootSetup() throws DeviceNotAvailableException {
        if (this.mOptions.isDisableKeyguard()) {
            this.disableKeyguard();
        }
    }

    private boolean doAdbFrameworkReboot(NativeDevice.RebootMode rebootMode, @Nullable String reason) throws DeviceNotAvailableException {
        if (!this.isEnableAdbRoot()) {
            LogUtil.CLog.i("framework reboot is not supported; when enable root is disabled");
            return false;
        }
        boolean isRoot = this.enableAdbRoot();
        if (this.getApiLevel() >= 18 && isRoot) {
            try {
                String output = this.executeShellCommand("pm path android");
                if (output == null || !output.contains("package:")) {
                    LogUtil.CLog.v("framework reboot: can't detect framework running");
                    return false;
                }
                this.notifyRebootStarted();
                String command = "svc power reboot " + rebootMode.formatRebootCommand(reason);
                CommandResult result = this.executeShellV2Command(command);
                if (result.getStdout().contains(EARLY_REBOOT) || result.getStderr().contains(EARLY_REBOOT)) {
                    LogUtil.CLog.e("Reboot was called too early: stdout: %s.\nstderr: %s.", result.getStdout(), result.getStderr());
                    this.notifyRebootEnded();
                    return false;
                }
            }
            catch (DeviceUnresponsiveException due) {
                LogUtil.CLog.v("framework reboot: device unresponsive to shell command, using fallback");
                return false;
            }
            this.postAdbReboot();
            return true;
        }
        LogUtil.CLog.v("framework reboot: not supported");
        return false;
    }

    @Override
    protected void doAdbReboot(NativeDevice.RebootMode rebootMode, @Nullable String reason) throws DeviceNotAvailableException {
        this.getConnection().notifyAdbRebootCalled();
        if (!TestDeviceState.ONLINE.equals((Object)this.getDeviceState()) || !this.doAdbFrameworkReboot(rebootMode, reason)) {
            super.doAdbReboot(rebootMode, reason);
        }
    }

    @Override
    public Set<String> getInstalledPackageNames() throws DeviceNotAvailableException {
        return this.getInstalledPackageNames(null, null);
    }

    private Set<String> getInstalledPackageNames(String packageNameSearched, String userId) throws DeviceNotAvailableException {
        String output;
        HashSet<String> packages = new HashSet<String>();
        String command = LIST_PACKAGES_CMD;
        if (userId != null) {
            command = command + String.format(" --user %s", userId);
        }
        if (packageNameSearched != null) {
            command = command + " | grep " + packageNameSearched;
        }
        if ((output = this.executeShellCommand(command)) != null) {
            Matcher m = PACKAGE_REGEX.matcher(output);
            while (m.find()) {
                String packageName = m.group(2);
                if (packageNameSearched != null && packageName.equals(packageNameSearched)) {
                    packages.add(packageName);
                    continue;
                }
                if (packageNameSearched != null) continue;
                packages.add(packageName);
            }
        }
        return packages;
    }

    @Override
    public boolean isPackageInstalled(String packageName) throws DeviceNotAvailableException {
        return this.getInstalledPackageNames(packageName, null).contains(packageName);
    }

    @Override
    public boolean isPackageInstalled(String packageName, String userId) throws DeviceNotAvailableException {
        return this.getInstalledPackageNames(packageName, userId).contains(packageName);
    }

    @Override
    public Set<ITestDevice.ApexInfo> getActiveApexes() throws DeviceNotAvailableException {
        String output = this.executeShellCommand(LIST_APEXES_CMD);
        Set<ITestDevice.ApexInfo> ret = this.parseApexesFromOutput(output, true);
        if (ret.isEmpty()) {
            ret = this.parseApexesFromOutput(output, false);
        }
        return ret;
    }

    @Override
    public Set<String> getMainlineModuleInfo() throws DeviceNotAvailableException {
        this.checkApiLevelAgainstNextRelease(GET_MODULEINFOS_CMD, 29);
        HashSet<String> ret = new HashSet<String>();
        String output = this.executeShellCommand(GET_MODULEINFOS_CMD);
        if (output != null) {
            Matcher m = MODULEINFO_REGEX.matcher(output);
            while (m.find()) {
                String packageName = m.group(2);
                ret.add(packageName);
            }
        }
        return ret;
    }

    private Set<ITestDevice.ApexInfo> parseApexesFromOutput(String output, boolean withPath) {
        Matcher matcher;
        HashSet<ITestDevice.ApexInfo> ret = new HashSet<ITestDevice.ApexInfo>();
        Matcher matcher2 = matcher = withPath ? APEXES_WITH_PATH_REGEX.matcher(output) : APEXES_WITHOUT_PATH_REGEX.matcher(output);
        while (matcher.find()) {
            if (withPath) {
                String sourceDir = matcher.group(1);
                String name = matcher.group(2);
                long version = Long.valueOf(matcher.group(3));
                ret.add(new ITestDevice.ApexInfo(name, version, sourceDir));
                continue;
            }
            String name = matcher.group(1);
            long version = Long.valueOf(matcher.group(2));
            ret.add(new ITestDevice.ApexInfo(name, version));
        }
        return ret;
    }

    @Override
    public Set<String> getUninstallablePackageNames() throws DeviceNotAvailableException {
        DumpPkgAction action = new DumpPkgAction();
        this.performDeviceAction("dumpsys package p", action, 2);
        HashSet<String> pkgs = new HashSet<String>();
        for (PackageInfo pkgInfo : action.mPkgInfoMap.values()) {
            if (pkgInfo.isSystemApp() && !pkgInfo.isUpdatedSystemApp()) continue;
            LogUtil.CLog.d("Found uninstallable package %s", pkgInfo.getPackageName());
            pkgs.add(pkgInfo.getPackageName());
        }
        return pkgs;
    }

    @Override
    public PackageInfo getAppPackageInfo(String packageName) throws DeviceNotAvailableException {
        DumpPkgAction action = new DumpPkgAction();
        this.performDeviceAction("dumpsys package", action, 2);
        return action.mPkgInfoMap.get(packageName);
    }

    @Override
    public List<PackageInfo> getAppPackageInfos() throws DeviceNotAvailableException {
        DumpPkgAction action = new DumpPkgAction();
        this.performDeviceAction("dumpsys package", action, 2);
        return new ArrayList<PackageInfo>(action.mPkgInfoMap.values());
    }

    @Override
    public boolean doesFileExist(String deviceFilePath) throws DeviceNotAvailableException {
        int currentUser = 0;
        if (deviceFilePath.startsWith("/sdcard/") && this.getApiLevel() > 23) {
            currentUser = this.getCurrentUser();
        }
        return this.doesFileExist(deviceFilePath, currentUser);
    }

    @Override
    public boolean doesFileExist(String deviceFilePath, int userId) throws DeviceNotAvailableException {
        if (deviceFilePath.startsWith("/sdcard/")) {
            deviceFilePath = deviceFilePath.replaceFirst("/sdcard/", String.format("/storage/emulated/%s/", userId));
        }
        return super.doesFileExist(deviceFilePath, userId);
    }

    @Override
    public ArrayList<Integer> listUsers() throws DeviceNotAvailableException {
        ArrayList<String[]> users = this.tokenizeListUsers();
        ArrayList<Integer> userIds = new ArrayList<Integer>(users.size());
        for (String[] user : users) {
            userIds.add(Integer.parseInt(user[1]));
        }
        return userIds;
    }

    @Override
    public Map<Integer, UserInfo> getUserInfos() throws DeviceNotAvailableException {
        ArrayList<String[]> lines = this.tokenizeListUsers();
        HashMap<Integer, UserInfo> result = new HashMap<Integer, UserInfo>(lines.size());
        for (String[] tokens : lines) {
            UserInfo userInfo;
            if (this.getApiLevel() < 33) {
                userInfo = new UserInfo(Integer.parseInt(tokens[1]), tokens[2], Integer.parseInt(tokens[3], 16), tokens.length >= 5 ? tokens[4].contains("running") : false);
                result.put(userInfo.userId(), userInfo);
                continue;
            }
            userInfo = new UserInfo(Integer.parseInt(tokens[1]), tokens[2], Integer.parseInt(tokens[3], 16), tokens.length >= 5 ? tokens[4].contains("running") : false, tokens[5]);
            result.put(userInfo.userId(), userInfo);
        }
        return result;
    }

    private ArrayList<String[]> tokenizeListUsers() throws DeviceNotAvailableException {
        if (this.getApiLevel() < 33) {
            return this.tokenizeListUsersPreT();
        }
        return this.tokenizeListUserPostT();
    }

    private ArrayList<String[]> tokenizeListUserPostT() throws DeviceNotAvailableException {
        String command = "cmd user list -v";
        String commandOutput = this.executeShellCommand(command);
        List lines = Arrays.stream(commandOutput.split("\\r?\\n")).filter(line -> line != null && line.trim().length() != 0).collect(Collectors.toList());
        if (!((String)lines.get(0)).contains("users:")) {
            if (commandOutput.contains("cmd: Can't find service: package")) {
                throw new DeviceNotAvailableException(String.format("'%s' in not a valid output for 'user list -v'", commandOutput), this.getSerialNumber());
            }
            throw new DeviceRuntimeException(String.format("'%s' in not a valid output for 'user list -v'", commandOutput), DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
        }
        ArrayList<String[]> users = new ArrayList<String[]>(lines.size() - 1);
        String pattern = ".id=(.*), name=(.*), type=(.*), flags=(.*)";
        Pattern r = Pattern.compile(pattern);
        for (int i = 1; i < lines.size(); ++i) {
            Matcher m = r.matcher((CharSequence)lines.get(i));
            if (!m.find()) continue;
            String id = m.group(1);
            String name = m.group(2);
            String type = m.group(3);
            String flags_and_status = m.group(4);
            String flags = "";
            String status = "";
            if (flags_and_status != null) {
                String[] flagsArr = flags_and_status.split("\\|");
                String last_flag_and_status = flagsArr.length > 0 ? flagsArr[flagsArr.length - 1] : "";
                String[] arr = last_flag_and_status.split("\\s", 2);
                if (arr.length > 0) {
                    flags = Integer.toHexString(this.convertToHex(flagsArr, arr[0]));
                }
                if (arr.length > 1) {
                    status = arr[1] != null ? arr[1] : "";
                }
            }
            users.add(new String[]{"", id, name, flags, status, type});
        }
        return users;
    }

    private ArrayList<String[]> tokenizeListUsersPreT() throws DeviceNotAvailableException {
        String command = "pm list users";
        String commandOutput = this.executeShellCommand(command);
        String[] lines = commandOutput.split("\\r?\\n");
        if (!lines[0].equals("Users:")) {
            throw new DeviceRuntimeException(String.format("'%s' in not a valid output for 'pm list users'", commandOutput), DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
        }
        ArrayList<String[]> users = new ArrayList<String[]>(lines.length - 1);
        for (int i = 1; i < lines.length; ++i) {
            String[] tokens = lines[i].split("\\{|\\}|:");
            if (tokens.length != 4 && tokens.length != 5) {
                throw new DeviceRuntimeException(String.format("device output: '%s' \nline: '%s' was not in the expected format for user info.", commandOutput, lines[i]), DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
            }
            users.add(tokens);
        }
        return users;
    }

    private int convertToHex(String[] arr, String str) {
        int res = 0;
        for (int i = 0; i < arr.length - 1; ++i) {
            res |= this.getHexaDecimalValue(arr[i]);
        }
        return res |= this.getHexaDecimalValue(str);
    }

    private int getHexaDecimalValue(String flag) {
        switch (flag) {
            case "PRIMARY": {
                return 1;
            }
            case "ADMIN": {
                return 2;
            }
            case "GUEST": {
                return 4;
            }
            case "RESTRICTED": {
                return 8;
            }
            case "INITIALIZED": {
                return 16;
            }
            case "MANAGED_PROFILE": {
                return 32;
            }
            case "DISABLED": {
                return 64;
            }
            case "QUIET_MODE": {
                return 128;
            }
            case "EPHEMERAL": {
                return 256;
            }
            case "DEMO": {
                return 512;
            }
            case "FULL": {
                return 1024;
            }
            case "SYSTEM": {
                return 2048;
            }
            case "PROFILE": {
                return 4096;
            }
            case "EPHEMERAL_ON_CREATE": {
                return 8192;
            }
            case "MAIN": {
                return 16384;
            }
            case "FOR_TESTING": {
                return 32768;
            }
        }
        LogUtil.CLog.e("Flag %s not found.", flag);
        return 0;
    }

    @Override
    public int getMaxNumberOfUsersSupported() throws DeviceNotAvailableException {
        String command = "pm get-max-users";
        String commandOutput = this.executeShellCommand(command);
        try {
            return Integer.parseInt(commandOutput.substring(commandOutput.lastIndexOf(" ")).trim());
        }
        catch (NumberFormatException e) {
            LogUtil.CLog.e("Failed to parse result: %s", commandOutput);
            return 0;
        }
    }

    @Override
    public int getMaxNumberOfRunningUsersSupported() throws DeviceNotAvailableException {
        this.checkApiLevelAgainstNextRelease("get-max-running-users", 28);
        String command = "pm get-max-running-users";
        String commandOutput = this.executeShellCommand(command);
        try {
            return Integer.parseInt(commandOutput.substring(commandOutput.lastIndexOf(" ")).trim());
        }
        catch (NumberFormatException e) {
            LogUtil.CLog.e("Failed to parse result: %s", commandOutput);
            return 0;
        }
    }

    @Override
    public boolean isMultiUserSupported() throws DeviceNotAvailableException {
        this.checkApiLevelAgainstNextRelease("get-max-running-users", 28);
        int apiLevel = this.getApiLevel();
        if (apiLevel > 33) {
            String command = "pm supports-multiple-users";
            String commandOutput = this.executeShellCommand(command).trim();
            try {
                String parsedOutput = commandOutput.substring(commandOutput.lastIndexOf(" ")).trim();
                Boolean retValue = Boolean.valueOf(parsedOutput);
                return retValue;
            }
            catch (NumberFormatException e) {
                LogUtil.CLog.e("Failed to parse result: %s", commandOutput);
                return false;
            }
        }
        return this.getMaxNumberOfUsersSupported() > 1;
    }

    @Override
    public boolean isHeadlessSystemUserMode() throws DeviceNotAvailableException {
        this.checkApiLevelAgainst("isHeadlessSystemUserMode", 29);
        return this.checkApiLevelAgainstNextRelease(34) ? this.executeShellV2CommandThatReturnsBooleanSafe("cmd user is-headless-system-user-mode", new Object[0]) : this.getBooleanProperty("ro.fw.mu.headless_system_user", false);
    }

    @Override
    public boolean canSwitchToHeadlessSystemUser() throws DeviceNotAvailableException {
        this.checkApiLevelAgainst("canSwitchToHeadlessSystemUser", 34);
        return this.executeShellV2CommandThatReturnsBooleanSafe("cmd user can-switch-to-headless-system-user", new Object[0]);
    }

    @Override
    public boolean isMainUserPermanentAdmin() throws DeviceNotAvailableException {
        this.checkApiLevelAgainst("isMainUserPermanentAdmin", 34);
        return this.executeShellV2CommandThatReturnsBooleanSafe("cmd user is-main-user-permanent-admin", new Object[0]);
    }

    @Override
    public int createUser(String name) throws DeviceNotAvailableException, IllegalStateException {
        return this.createUser(name, false, false);
    }

    @Override
    public int createUser(String name, boolean guest, boolean ephemeral) throws DeviceNotAvailableException, IllegalStateException {
        return this.createUser(name, guest, ephemeral, false);
    }

    @Override
    public int createUser(String name, boolean guest, boolean ephemeral, boolean forTesting) throws DeviceNotAvailableException, IllegalStateException {
        String command = "pm create-user " + (guest ? "--guest " : "") + (ephemeral ? "--ephemeral " : "") + (forTesting && this.getApiLevel() >= 34 ? "--for-testing " : "") + name;
        String output = this.executeShellCommand(command);
        if (output.startsWith("Success")) {
            try {
                this.resetContentProviderSetup();
                return Integer.parseInt(output.substring(output.lastIndexOf(" ")).trim());
            }
            catch (NumberFormatException e) {
                LogUtil.CLog.e("Failed to parse result: %s", output);
            }
        }
        throw new IllegalStateException(String.format("Failed to create user: %s", output));
    }

    @Override
    public int createUserNoThrow(String name) throws DeviceNotAvailableException {
        try {
            return this.createUser(name);
        }
        catch (IllegalStateException e) {
            LogUtil.CLog.e("Error creating user: " + e.toString());
            return -1;
        }
    }

    @Override
    public boolean removeUser(int userId) throws DeviceNotAvailableException {
        String output = this.executeShellCommand(String.format("pm remove-user %s", userId));
        if (output.startsWith("Error")) {
            LogUtil.CLog.e("Failed to remove user %d on device %s: %s", userId, this.getSerialNumber(), output);
            return false;
        }
        return true;
    }

    @Override
    public boolean startUser(int userId) throws DeviceNotAvailableException {
        return this.startUser(userId, false);
    }

    @Override
    public boolean startUser(int userId, boolean waitFlag) throws DeviceNotAvailableException {
        String state;
        if (waitFlag) {
            this.checkApiLevelAgainstNextRelease("start-user -w", 29);
        }
        String cmd = "am start-user " + (waitFlag ? "-w " : "") + userId;
        LogUtil.CLog.d("Starting user with command: %s", cmd);
        String output = this.executeShellCommand(cmd);
        if (output.startsWith("Error")) {
            LogUtil.CLog.e("Failed to start user: %s", output);
            return false;
        }
        if (waitFlag && !(state = this.executeShellCommand("am get-started-user-state " + userId)).contains("RUNNING_UNLOCKED")) {
            LogUtil.CLog.w("User %s is not RUNNING_UNLOCKED after start-user -w. (%s).", userId, state);
            return false;
        }
        return true;
    }

    @Override
    public boolean startVisibleBackgroundUser(int userId, int displayId, boolean waitFlag) throws DeviceNotAvailableException {
        this.checkApiLevelAgainstNextRelease("startVisibleBackgroundUser", 34);
        String cmd = String.format("am start-user%s --display %d %d", waitFlag ? " -w" : "", displayId, userId);
        CommandResult res = this.executeShellV2Command(cmd);
        if (!CommandStatus.SUCCESS.equals((Object)res.getStatus())) {
            throw new DeviceRuntimeException("Command  '" + cmd + "' failed: " + res, DeviceErrorIdentifier.SHELL_COMMAND_ERROR);
        }
        return res.getStdout().trim().startsWith("Success");
    }

    @Override
    public boolean stopUser(int userId) throws DeviceNotAvailableException {
        return this.stopUser(userId, false, false);
    }

    @Override
    public boolean stopUser(int userId, boolean waitFlag, boolean forceFlag) throws DeviceNotAvailableException {
        int apiLevel = this.getApiLevel();
        if (waitFlag && apiLevel < 23) {
            throw new IllegalArgumentException("stop-user -w requires API level >= 23");
        }
        if (forceFlag && apiLevel < 24) {
            throw new IllegalArgumentException("stop-user -f requires API level >= 24");
        }
        StringBuilder cmd = new StringBuilder("am stop-user ");
        if (waitFlag) {
            cmd.append("-w ");
        }
        if (forceFlag) {
            cmd.append("-f ");
        }
        cmd.append(userId);
        LogUtil.CLog.d("stopping user with command: %s", cmd.toString());
        String output = this.executeShellCommand(cmd.toString());
        if (output.contains("Error: Can't stop system user")) {
            LogUtil.CLog.e("Cannot stop System user.");
            return false;
        }
        if (output.contains("Can't stop current user")) {
            LogUtil.CLog.e("Cannot stop current user.");
            return false;
        }
        if (this.isUserRunning(userId)) {
            LogUtil.CLog.w("User Id: %s is still running after the stop-user command.", userId);
            return false;
        }
        return true;
    }

    @Override
    public boolean isVisibleBackgroundUsersSupported() throws DeviceNotAvailableException {
        this.checkApiLevelAgainstNextRelease("isHeadlessSystemUserMode", 34);
        return this.executeShellV2CommandThatReturnsBoolean("cmd user is-visible-background-users-supported", new Object[0]);
    }

    @Override
    public boolean isVisibleBackgroundUsersOnDefaultDisplaySupported() throws DeviceNotAvailableException {
        this.checkApiLevelAgainstNextRelease("isVisibleBackgroundUsersOnDefaultDisplaySupported", 34);
        return this.executeShellV2CommandThatReturnsBoolean("cmd user is-visible-background-users-on-default-display-supported", new Object[0]);
    }

    @Override
    public Integer getPrimaryUserId() throws DeviceNotAvailableException {
        return this.getUserIdByFlag(1);
    }

    @Override
    public Integer getMainUserId() throws DeviceNotAvailableException {
        return this.getUserIdByFlag(16384);
    }

    private Integer getUserIdByFlag(int requiredFlag) throws DeviceNotAvailableException {
        ArrayList<String[]> users = this.tokenizeListUsers();
        for (String[] user : users) {
            int flag = Integer.parseInt(user[3], 16);
            if ((flag & requiredFlag) == 0) continue;
            return Integer.parseInt(user[1]);
        }
        return null;
    }

    @Override
    public int getCurrentUser() throws DeviceNotAvailableException {
        this.checkApiLevelAgainstNextRelease("get-current-user", 24);
        String output = this.executeShellCommand("am get-current-user");
        try {
            int userId = Integer.parseInt(output.trim());
            if (userId >= 0) {
                return userId;
            }
            LogUtil.CLog.e("Invalid user id '%s' was returned for get-current-user", userId);
        }
        catch (NumberFormatException e) {
            LogUtil.CLog.e("Invalid string was returned for get-current-user: %s.", output);
        }
        return -10000;
    }

    @Override
    public boolean isUserVisible(int userId) throws DeviceNotAvailableException {
        this.checkApiLevelAgainstNextRelease("isUserVisible", 34);
        return this.executeShellV2CommandThatReturnsBoolean("cmd user is-user-visible %d", userId);
    }

    @Override
    public boolean isUserVisibleOnDisplay(int userId, int displayId) throws DeviceNotAvailableException {
        this.checkApiLevelAgainstNextRelease("isUserVisibleOnDisplay", 34);
        return this.executeShellV2CommandThatReturnsBoolean("cmd user is-user-visible --display %d %d", displayId, userId);
    }

    private Matcher findUserInfo(String pmListUsersOutput) {
        Pattern pattern = Pattern.compile(USER_PATTERN);
        Matcher matcher = pattern.matcher(pmListUsersOutput);
        return matcher;
    }

    @Override
    public int getUserFlags(int userId) throws DeviceNotAvailableException {
        this.checkApiLevelAgainst("getUserFlags", 22);
        String commandOutput = this.executeShellCommand("pm list users");
        Matcher matcher = this.findUserInfo(commandOutput);
        while (matcher.find()) {
            if (Integer.parseInt(matcher.group(2)) != userId) continue;
            return Integer.parseInt(matcher.group(6), 16);
        }
        LogUtil.CLog.w("Could not find any flags for userId: %d in output: %s", userId, commandOutput);
        return -10000;
    }

    @Override
    public boolean isUserSecondary(int userId) throws DeviceNotAvailableException {
        if (userId == 0) {
            return false;
        }
        int flags = this.getUserFlags(userId);
        if (flags == -10000) {
            return false;
        }
        return (flags & 0x2D) == 0;
    }

    @Override
    public boolean isUserRunning(int userId) throws DeviceNotAvailableException {
        this.checkApiLevelAgainst("isUserIdRunning", 22);
        String commandOutput = this.executeShellCommand("pm list users");
        Matcher matcher = this.findUserInfo(commandOutput);
        while (matcher.find()) {
            if (Integer.parseInt(matcher.group(2)) != userId || !matcher.group(7).contains("running")) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getUserSerialNumber(int userId) throws DeviceNotAvailableException {
        this.checkApiLevelAgainst("getUserSerialNumber", 22);
        String commandOutput = this.executeShellCommand("dumpsys user");
        String userSerialPatter = "(.*\\{)(\\d+)(.*\\})(.*=)(\\d+)";
        Pattern pattern = Pattern.compile(userSerialPatter);
        Matcher matcher = pattern.matcher(commandOutput);
        while (matcher.find()) {
            if (Integer.parseInt(matcher.group(2)) != userId) continue;
            return Integer.parseInt(matcher.group(5));
        }
        LogUtil.CLog.w("Could not find user serial number for userId: %d, in output: %s", userId, commandOutput);
        return -10000;
    }

    @Override
    public boolean switchUser(int userId) throws DeviceNotAvailableException {
        return this.switchUser(userId, 10000L);
    }

    @Override
    public boolean switchUser(int userId, long timeout) throws DeviceNotAvailableException {
        boolean success;
        this.checkApiLevelAgainstNextRelease("switchUser", 24);
        if (userId == this.getCurrentUser()) {
            LogUtil.CLog.w("Already running as user id: %s. Nothing to be done.", userId);
            return true;
        }
        String switchCommand = this.checkApiLevelAgainstNextRelease(30) ? String.format("am switch-user -w %d", userId) : String.format("am switch-user %d", userId);
        this.resetContentProviderSetup();
        long initialTime = this.getHostCurrentTime();
        String output = this.executeShellCommand(switchCommand);
        boolean bl = success = userId == this.getCurrentUser();
        while (!success && this.getHostCurrentTime() - initialTime <= timeout) {
            RunUtil.getDefault().sleep(this.getCheckNewUserSleep());
            output = this.executeShellCommand(String.format(switchCommand, new Object[0]));
            success = userId == this.getCurrentUser();
        }
        LogUtil.CLog.d("switchUser took %d ms", this.getHostCurrentTime() - initialTime);
        if (success) {
            this.prePostBootSetup();
            return true;
        }
        LogUtil.CLog.e("User did not switch in the given %d timeout: %s", timeout, output);
        return false;
    }

    protected long getCheckNewUserSleep() {
        return 1000L;
    }

    protected long getHostCurrentTime() {
        return System.currentTimeMillis();
    }

    @Override
    public boolean hasFeature(String feature) throws DeviceNotAvailableException {
        if (!feature.startsWith("feature:")) {
            feature = "feature:" + feature;
        }
        String versionedFeature = feature + "=";
        CommandResult commandResult = this.executeShellV2Command("pm list features");
        if (!CommandStatus.SUCCESS.equals((Object)commandResult.getStatus())) {
            throw new DeviceRuntimeException(String.format("Failed to list features, command returned: stdout: %s, stderr: %s", commandResult.getStdout(), commandResult.getStderr()), DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
        }
        String commandOutput = commandResult.getStdout();
        for (String line : commandOutput.split("\\s+")) {
            if (line.equals(feature)) {
                return true;
            }
            if (!line.startsWith(versionedFeature)) continue;
            return true;
        }
        LogUtil.CLog.w("Feature: %s is not available on %s", feature, this.getSerialNumber());
        return false;
    }

    @Override
    public String getSetting(String namespace, String key) throws DeviceNotAvailableException {
        return this.getSettingInternal("", namespace.trim(), key.trim());
    }

    @Override
    public String getSetting(int userId, String namespace, String key) throws DeviceNotAvailableException {
        return this.getSettingInternal(String.format("--user %d", userId), namespace.trim(), key.trim());
    }

    private String getSettingInternal(String userFlag, String namespace, String key) throws DeviceNotAvailableException {
        namespace = namespace.toLowerCase();
        if (Arrays.asList(SETTINGS_NAMESPACE).contains(namespace)) {
            String cmd = String.format("settings %s get %s %s", userFlag, namespace, key);
            String output = this.executeShellCommand(cmd);
            if ("null".equals(output)) {
                LogUtil.CLog.w("settings returned null for command: %s. please check if the namespace:key exists", cmd);
                return null;
            }
            return output.trim();
        }
        LogUtil.CLog.e("Namespace requested: '%s' is not part of {system, secure, global}", namespace);
        return null;
    }

    @Override
    public Map<String, String> getAllSettings(String namespace) throws DeviceNotAvailableException {
        return this.getAllSettingsInternal(namespace.trim());
    }

    private Map<String, String> getAllSettingsInternal(String namespace) throws DeviceNotAvailableException {
        namespace = namespace.toLowerCase();
        if (Arrays.asList(SETTINGS_NAMESPACE).contains(namespace)) {
            HashMap<String, String> map = new HashMap<String, String>();
            String cmd = String.format("settings list %s", namespace);
            String output = this.executeShellCommand(cmd);
            for (String line : output.split("\\n")) {
                String[] pair = line.trim().split("=", -1);
                if (pair.length > 1) {
                    map.putIfAbsent(pair[0], pair[1]);
                    continue;
                }
                LogUtil.CLog.e("Unable to get setting from string: %s", line);
            }
            return map;
        }
        LogUtil.CLog.e("Namespace requested: '%s' is not part of {system, secure, global}", namespace);
        return null;
    }

    @Override
    public void setSetting(String namespace, String key, String value) throws DeviceNotAvailableException {
        this.setSettingInternal("", namespace.trim(), key.trim(), value.trim());
    }

    @Override
    public void setSetting(int userId, String namespace, String key, String value) throws DeviceNotAvailableException {
        this.setSettingInternal(String.format("--user %d", userId), namespace.trim(), key.trim(), value.trim());
    }

    private void setSettingInternal(String userFlag, String namespace, String key, String value) throws DeviceNotAvailableException {
        this.checkApiLevelAgainst("Changing settings", 22);
        if (!Arrays.asList(SETTINGS_NAMESPACE).contains(namespace.toLowerCase())) {
            throw new IllegalArgumentException("Namespace must be one of system, secure, global. You provided: " + namespace);
        }
        this.executeShellCommand(String.format("settings %s put %s %s %s", userFlag, namespace, key, value));
    }

    @Override
    public String getAndroidId(int userId) throws DeviceNotAvailableException {
        if (this.isAdbRoot()) {
            String cmd = String.format("sqlite3 /data/user/%d/*/databases/gservices.db 'select value from main where name = \"android_id\"'", userId);
            String output = this.executeShellCommand(cmd).trim();
            if (!output.contains("unable to open database")) {
                return output;
            }
            LogUtil.CLog.w("Couldn't find android-id, output: %s", output);
        } else {
            LogUtil.CLog.w("adb root is required.");
        }
        return null;
    }

    @Override
    public Map<Integer, String> getAndroidIds() throws DeviceNotAvailableException {
        ArrayList<Integer> userIds = this.listUsers();
        if (userIds == null) {
            return null;
        }
        HashMap<Integer, String> androidIds = new HashMap<Integer, String>();
        for (Integer id : userIds) {
            String androidId = this.getAndroidId(id);
            androidIds.put(id, androidId);
        }
        return androidIds;
    }

    @Override
    IWifiHelper createWifiHelper() throws DeviceNotAvailableException {
        return this.createWifiHelper(true);
    }

    @VisibleForTesting
    IWifiHelper createWifiHelper(boolean doSetup) throws DeviceNotAvailableException {
        if (doSetup) {
            this.mWasWifiHelperInstalled = true;
            this.waitForDeviceAvailable();
        }
        return new WifiHelper(this, this.mOptions.getWifiUtilAPKPath(), doSetup);
    }

    @Override
    public void postInvocationTearDown(Throwable exception) {
        super.postInvocationTearDown(exception);
        if (this.mWasWifiHelperInstalled) {
            this.mWasWifiHelperInstalled = false;
            if (this.getIDevice() instanceof StubDevice) {
                return;
            }
            if (!TestDeviceState.ONLINE.equals((Object)this.getDeviceState())) {
                return;
            }
            if (exception instanceof DeviceNotAvailableException) {
                LogUtil.CLog.e("Skip WifiHelper teardown due to DeviceNotAvailableException.");
                return;
            }
            try {
                IWifiHelper wifi = this.createWifiHelper(false);
                wifi.cleanUp();
            }
            catch (DeviceNotAvailableException e) {
                LogUtil.CLog.e("Device became unavailable while uninstalling wifi util.");
                LogUtil.CLog.e(e);
            }
        }
    }

    @Override
    public boolean setDeviceOwner(String componentName, int userId) throws DeviceNotAvailableException {
        String command = "dpm set-device-owner --user " + userId + " '" + componentName + "'";
        String commandOutput = this.executeShellCommand(command);
        return commandOutput.startsWith("Success:");
    }

    @Override
    public boolean removeAdmin(String componentName, int userId) throws DeviceNotAvailableException {
        String command = "dpm remove-active-admin --user " + userId + " '" + componentName + "'";
        String commandOutput = this.executeShellCommand(command);
        return commandOutput.startsWith("Success:");
    }

    @Override
    public void removeOwners() throws DeviceNotAvailableException {
        String command = "dumpsys device_policy";
        String commandOutput = this.executeShellCommand(command);
        String[] lines = commandOutput.split("\\r?\\n");
        for (int i = 0; i < lines.length; ++i) {
            String[] tokens;
            String line = lines[i].trim();
            if (line.contains("Profile Owner")) {
                tokens = line.split("\\(|\\)| ");
                int userId = Integer.parseInt(tokens[4]);
                i = this.moveToNextIndexMatchingRegex(".*admin=.*", lines, i);
                line = lines[i].trim();
                tokens = line.split("\\{|\\}");
                String componentName = tokens[1];
                LogUtil.CLog.d("Cleaning up profile owner " + userId + " " + componentName);
                this.removeAdmin(componentName, userId);
                continue;
            }
            if (!line.contains("Device Owner:")) continue;
            i = this.moveToNextIndexMatchingRegex(".*admin=.*", lines, i);
            line = lines[i].trim();
            tokens = line.split("\\{|\\}");
            String componentName = tokens[1];
            i = this.moveToNextIndexMatchingRegex(".*User ID:.*", lines, i);
            line = lines[i].trim();
            tokens = line.split(":");
            int userId = Integer.parseInt(tokens[1].trim());
            LogUtil.CLog.d("Cleaning up device owner " + userId + " " + componentName);
            this.removeAdmin(componentName, userId);
        }
    }

    private int moveToNextIndexMatchingRegex(String regex, String[] lines, int currentIndex) {
        while (currentIndex < lines.length && !lines[currentIndex].matches(regex)) {
            ++currentIndex;
        }
        if (currentIndex >= lines.length) {
            throw new IllegalStateException("The output of 'dumpsys device_policy' was not as expected. Owners have not been removed. This will leave the device in an unstable state and will lead to further test failures.");
        }
        return currentIndex;
    }

    private void checkApiLevelAgainstNextRelease(String feature, int strictMinLevel) throws DeviceNotAvailableException {
        if (this.checkApiLevelAgainstNextRelease(strictMinLevel)) {
            return;
        }
        throw new IllegalArgumentException(String.format("%s not supported on %s. Must be API %d.", feature, this.getSerialNumber(), strictMinLevel));
    }

    @Override
    public File dumpHeap(String process, String devicePath) throws DeviceNotAvailableException {
        if (Strings.isNullOrEmpty(devicePath) || Strings.isNullOrEmpty(process)) {
            throw new IllegalArgumentException("devicePath or process cannot be null or empty.");
        }
        String pid = this.getProcessPid(process);
        if (pid == null) {
            return null;
        }
        File dump = this.dumpAndPullHeap(pid, devicePath);
        this.deleteFile(devicePath);
        return dump;
    }

    private File dumpAndPullHeap(String pid, String devicePath) throws DeviceNotAvailableException {
        this.executeShellCommand(String.format(DUMPHEAP_CMD, pid, devicePath));
        for (int attempt = 0; !this.doesFileExist(devicePath) && attempt < 3; ++attempt) {
            this.getRunUtil().sleep(5000L);
        }
        File dumpFile = this.pullFile(devicePath);
        return dumpFile;
    }

    @Override
    public Set<Long> listDisplayIds() throws DeviceNotAvailableException {
        HashSet<Long> displays = new HashSet<Long>();
        CommandResult res = this.executeShellV2Command("dumpsys SurfaceFlinger | grep 'color modes:'");
        if (!CommandStatus.SUCCESS.equals((Object)res.getStatus())) {
            LogUtil.CLog.e("Something went wrong while listing displays: %s", res.getStderr());
            return displays;
        }
        String output = res.getStdout();
        Pattern p = Pattern.compile(DISPLAY_ID_PATTERN);
        for (String line : output.split("\n")) {
            Matcher m = p.matcher(line);
            if (!m.matches()) continue;
            displays.add(Long.parseLong(m.group("id")));
        }
        if (displays.isEmpty()) {
            displays.add(0L);
        }
        return displays;
    }

    @Override
    public Set<Integer> listDisplayIdsForStartingVisibleBackgroundUsers() throws DeviceNotAvailableException {
        this.checkApiLevelAgainstNextRelease("getDisplayIdsForStartingVisibleBackgroundUsers", 34);
        String cmd = "cmd activity list-displays-for-starting-users";
        CommandResult res = this.executeShellV2Command(cmd);
        if (!CommandStatus.SUCCESS.equals((Object)res.getStatus())) {
            throw new DeviceRuntimeException("Command  '" + cmd + "' failed: " + res, DeviceErrorIdentifier.SHELL_COMMAND_ERROR);
        }
        String output = res.getStdout().trim();
        if (output.equalsIgnoreCase("none")) {
            return Collections.emptySet();
        }
        if (!output.startsWith("[") || !output.endsWith("]")) {
            throw new DeviceRuntimeException("Invalid output for command '" + cmd + "': " + output, DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
        }
        String contents = output.substring(1, output.length() - 1);
        try {
            String[] ids = contents.split(",");
            return Arrays.asList(ids).stream().map(id -> Integer.parseInt(id.trim())).collect(Collectors.toSet());
        }
        catch (Exception e) {
            throw new DeviceRuntimeException("Invalid output for command '" + cmd + "': " + output, DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
        }
    }

    @Override
    public Set<DeviceFoldableState> getFoldableStates() throws DeviceNotAvailableException {
        if (this.getIDevice() instanceof StubDevice) {
            return new HashSet<DeviceFoldableState>();
        }
        try (CloseableTraceScope foldable = new CloseableTraceScope("getFoldableStates");){
            CommandResult result = this.executeShellV2Command("cmd device_state print-states");
            if (!CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
                HashSet<DeviceFoldableState> hashSet = new HashSet<DeviceFoldableState>();
                return hashSet;
            }
            LinkedHashSet<DeviceFoldableState> foldableStates = new LinkedHashSet<DeviceFoldableState>();
            Pattern deviceStatePattern = Pattern.compile("DeviceState\\{identifier=(\\d+), name='(\\S+)'(?:, app_accessible=)?(\\S+)?(?:, cancel_when_requester_not_on_top=)?(\\S+)?\\}\\S*");
            for (String line : result.getStdout().split("\n")) {
                Matcher m = deviceStatePattern.matcher(line.trim());
                if (!m.matches() || m.groupCount() > 2 && m.group(3) != null && !Boolean.parseBoolean(m.group(3)) || m.groupCount() > 3 && m.group(4) != null && Boolean.parseBoolean(m.group(4))) continue;
                foldableStates.add(new DeviceFoldableState(Integer.parseInt(m.group(1)), m.group(2)));
            }
            LinkedHashSet<DeviceFoldableState> linkedHashSet = foldableStates;
            return linkedHashSet;
        }
    }

    @Override
    public DeviceFoldableState getCurrentFoldableState() throws DeviceNotAvailableException {
        if (this.getIDevice() instanceof StubDevice) {
            return null;
        }
        CommandResult result = this.executeShellV2Command("cmd device_state state");
        Pattern deviceStatePattern = Pattern.compile("Committed state: DeviceState\\{identifier=(\\d+), name='(\\S+)'(?:, app_accessible=)?(\\S+)?(?:, cancel_when_requester_not_on_top=)?(\\S+)?\\}\\S*");
        for (String line : result.getStdout().split("\n")) {
            Matcher m = deviceStatePattern.matcher(line.trim());
            if (!m.matches()) continue;
            return new DeviceFoldableState(Integer.parseInt(m.group(1)), m.group(2));
        }
        return null;
    }

    public boolean supportsMicrodroid(boolean protectedVm) throws Exception {
        CommandResult result = this.executeShellV2Command("getprop ro.product.cpu.abi");
        if (result.getStatus() != CommandStatus.SUCCESS) {
            return false;
        }
        String abi = result.getStdout().trim();
        if (abi.isEmpty() || !abi.startsWith("arm64") && !abi.startsWith("x86_64")) {
            LogUtil.CLog.d("Unsupported ABI: " + abi);
            return false;
        }
        if (protectedVm) {
            boolean pVMSupported = this.getBooleanProperty("ro.boot.hypervisor.protected_vm.supported", false);
            if (!pVMSupported) {
                LogUtil.CLog.i("Device does not support protected virtual machines.");
                return false;
            }
        } else {
            boolean nonProtectedVMSupported = this.getBooleanProperty("ro.boot.hypervisor.vm.supported", false);
            if (!nonProtectedVMSupported) {
                LogUtil.CLog.i("Device does not support non protected virtual machines.");
                return false;
            }
        }
        if (!this.doesFileExist("/apex/com.android.virt")) {
            LogUtil.CLog.i("com.android.virt APEX was not pre-installed. Command Failed: 'ls /apex/com.android.virt/bin/crosvm'");
            return false;
        }
        return true;
    }

    public boolean supportsMicrodroid() throws Exception {
        return this.supportsMicrodroid(false) || this.supportsMicrodroid(true);
    }

    private void forwardFileToLog(String logPath, String tag) {
        try (CloseableTraceScope ignored = new CloseableTraceScope("forward_to_log:" + tag);){
            String logwrapperCmd = "logwrapper sh -c \"$'tail -f -n +0 " + logPath + " | sed \\'s/^/" + tag + ": /g\\''\"";
            this.getRunUtil().allowInterrupt(true);
            String[] fullCmd = this.buildAdbShellCommand(logwrapperCmd, false);
            NativeDevice.AdbShellAction adbActionV2 = new NativeDevice.AdbShellAction(fullCmd, null, null, null, TimeUnit.MINUTES.toMillis(20L));
            adbActionV2.run();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ITestDevice startMicrodroid(MicrodroidBuilder builder) throws DeviceNotAvailableException {
        String cid;
        Process process;
        IDeviceManager deviceManager = GlobalConfiguration.getDeviceManagerInstance();
        if (!this.mStartedMicrodroids.isEmpty()) {
            throw new IllegalStateException(String.format("Microdroid with cid '%s' already exists in device. Cannot create another one.", this.mStartedMicrodroids.values().iterator().next().cid));
        }
        this.executeShellV2Command("rm -rf /data/local/tmp/virt/*");
        CommandResult result = this.executeShellV2Command("mkdir -p /data/local/tmp/virt/");
        if (result.getStatus() != CommandStatus.SUCCESS) {
            throw new DeviceRuntimeException("mkdir -p /data/local/tmp/virt/ has failed: " + result, DeviceErrorIdentifier.SHELL_COMMAND_ERROR);
        }
        for (File localFile : builder.mBootFiles.keySet()) {
            String remoteFileName = builder.mBootFiles.get(localFile);
            this.pushFile(localFile, TEST_ROOT + remoteFileName);
        }
        if (builder.mApkFile != null) {
            this.pushFile(builder.mApkFile, TEST_ROOT + builder.mApkFile.getName());
            builder.mApkPath = TEST_ROOT + builder.mApkFile.getName();
        } else if (builder.mApkPath == null) {
            throw new IllegalArgumentException("apkFile and apkPath is both null. Can not start microdroid.");
        }
        String outApkIdsigPath = TEST_ROOT + (builder.mApkFile != null ? builder.mApkFile.getName() : "NULL") + ".idsig";
        String instanceImg = "/data/local/tmp/virt/instance.img";
        String consolePath = "/data/local/tmp/virt/console.txt";
        String logPath = "/data/local/tmp/virt/log.txt";
        String debugFlag = Strings.isNullOrEmpty(builder.mDebugLevel) ? "" : "--debug " + builder.mDebugLevel;
        String cpuFlag = builder.mNumCpus == null ? "" : "--cpus " + builder.mNumCpus;
        String cpuAffinityFlag = Strings.isNullOrEmpty(builder.mCpuAffinity) ? "" : "--cpu-affinity " + builder.mCpuAffinity;
        String cpuTopologyFlag = Strings.isNullOrEmpty(builder.mCpuTopology) ? "" : "--cpu-topology " + builder.mCpuTopology;
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(deviceManager.getAdbPath(), "-s", this.getSerialNumber(), "shell", "/apex/com.android.virt/bin/vm", "run-app", "--console /data/local/tmp/virt/console.txt", "--log /data/local/tmp/virt/log.txt", "--mem " + builder.mMemoryMib, debugFlag, cpuFlag, cpuAffinityFlag, cpuTopologyFlag, builder.mApkPath, outApkIdsigPath, "/data/local/tmp/virt/instance.img", "--config-path", builder.mConfigPath));
        if (builder.mProtectedVm) {
            args.add("--protected");
        }
        for (String path : builder.mExtraIdsigPaths) {
            args.add("--extra-idsig");
            args.add(path);
        }
        for (String path : builder.mAssignedDevices) {
            args.add("--devices");
            args.add(path);
        }
        try {
            PipedInputStream pipe = new PipedInputStream();
            process = this.getRunUtil().runCmdInBackground(args, new PipedOutputStream(pipe));
            BufferedReader stdout = new BufferedReader(new InputStreamReader(pipe));
            Pattern pattern = Pattern.compile("with CID (\\d+)");
            while ((cid = stdout.readLine()) != null) {
                Matcher matcher = pattern.matcher(cid);
                if (!matcher.find()) continue;
                cid = matcher.group(1);
                break;
            }
            if (cid == null) {
                throw new DeviceRuntimeException("Failed to find the CID of the VM", DeviceErrorIdentifier.SHELL_COMMAND_ERROR);
            }
        }
        catch (IOException ex) {
            throw new DeviceRuntimeException("IOException trying to start a VM", ex, DeviceErrorIdentifier.SHELL_COMMAND_ERROR);
        }
        ExecutorService executor = Executors.newFixedThreadPool(2);
        executor.execute(() -> this.forwardFileToLog("/data/local/tmp/virt/console.txt", "MicrodroidConsole"));
        executor.execute(() -> this.forwardFileToLog("/data/local/tmp/virt/log.txt", "MicrodroidLog"));
        int vmAdbPort = this.forwardMicrodroidAdbPort(cid);
        String microdroidSerial = "localhost:" + vmAdbPort;
        DeviceSelectionOptions microSelection = new DeviceSelectionOptions();
        microSelection.setSerial(microdroidSerial);
        microSelection.setBaseDeviceTypeRequested(IDeviceSelection.BaseDeviceType.NATIVE_DEVICE);
        NativeDevice microdroid = (NativeDevice)deviceManager.allocateDevice(microSelection);
        if (microdroid == null) {
            process.destroy();
            try {
                process.waitFor();
                executor.shutdownNow();
                executor.awaitTermination(2L, TimeUnit.MINUTES);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            throw new DeviceRuntimeException("Unable to force allocate the microdroid device", InfraErrorIdentifier.RUNNER_ALLOCATION_ERROR);
        }
        microdroid.getOptions().setAdbRootUnavailableTimeout(4000L);
        builder.mTestDeviceOptions.put("enable-device-connection", "true");
        builder.mTestDeviceOptions.put("instance-type", this.getOptions().getInstanceType().toString());
        microdroid.setTestDeviceOptions(builder.mTestDeviceOptions);
        microdroid.setIDevice(new RemoteAvdIDevice(microdroidSerial));
        this.adbConnectToMicrodroid(cid, microdroidSerial, vmAdbPort, builder.mAdbConnectTimeoutMs);
        microdroid.setMicrodroidProcess(process);
        try {
            microdroid.initializeConnection(null, null);
        }
        catch (DeviceNotAvailableException | TargetSetupError e) {
            LogUtil.CLog.e(e);
        }
        MicrodroidTracker tracker = new MicrodroidTracker();
        tracker.executor = executor;
        tracker.cid = cid;
        this.mStartedMicrodroids.put(process, tracker);
        return microdroid;
    }

    private int forwardMicrodroidAdbPort(String cid) {
        IDeviceManager deviceManager = GlobalConfiguration.getDeviceManagerInstance();
        boolean forwarded = false;
        for (int trial = 0; trial < 10; ++trial) {
            int vmAdbPort;
            try (ServerSocket serverSocket = new ServerSocket(0);){
                vmAdbPort = serverSocket.getLocalPort();
                String microdroidSerial = "localhost:" + vmAdbPort;
            }
            catch (IOException e) {
                throw new DeviceRuntimeException("Unable to get an unused port for Microdroid.", e, DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
            }
            String from = "tcp:" + vmAdbPort;
            String to = "vsock:" + cid + ":5555";
            CommandResult result = this.getRunUtil().runTimedCmd(10000L, deviceManager.getAdbPath(), "-s", this.getSerialNumber(), "forward", from, to);
            if (result.getStatus() == CommandStatus.SUCCESS) {
                return vmAdbPort;
            }
            if (result.getStderr().contains("Address already in use")) continue;
            throw new DeviceRuntimeException("Unable to forward vsock:" + cid + ":5555: " + result.getStderr(), DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
        }
        throw new DeviceRuntimeException("Unable to get an unused port for Microdroid.", DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
    }

    private void adbConnectToMicrodroid(String cid, String microdroidSerial, int vmAdbPort, long adbConnectTimeoutMs) {
        MicrodroidHelper microdroidHelper = new MicrodroidHelper();
        IDeviceManager deviceManager = GlobalConfiguration.getDeviceManagerInstance();
        long start = System.currentTimeMillis();
        long timeoutMillis = adbConnectTimeoutMs;
        long elapsed = 0L;
        String serial = this.getSerialNumber();
        String from = "tcp:" + vmAdbPort;
        String to = "vsock:" + cid + ":5555";
        this.getRunUtil().runTimedCmd(10000L, deviceManager.getAdbPath(), "-s", serial, "forward", from, to);
        boolean disconnected = true;
        while (disconnected) {
            elapsed = System.currentTimeMillis() - start;
            start = System.currentTimeMillis();
            CommandResult result = this.getRunUtil().runTimedCmd(timeoutMillis -= elapsed, deviceManager.getAdbPath(), "connect", microdroidSerial);
            if (result.getStatus() != CommandStatus.SUCCESS) {
                throw new DeviceRuntimeException(deviceManager.getAdbPath() + " connect " + microdroidSerial + " has failed: " + result, DeviceErrorIdentifier.SHELL_COMMAND_ERROR);
            }
            disconnected = result.getStdout().trim().equals("failed to connect to " + microdroidSerial);
            if (!disconnected) continue;
            this.getRunUtil().runTimedCmd(10000L, deviceManager.getAdbPath(), "disconnect", microdroidSerial);
        }
        elapsed = System.currentTimeMillis() - start;
        this.getRunUtil().runTimedCmd(timeoutMillis -= elapsed, deviceManager.getAdbPath(), "-s", microdroidSerial, "wait-for-device");
        boolean dataAvailable = false;
        while (!dataAvailable && timeoutMillis >= 0L) {
            elapsed = System.currentTimeMillis() - start;
            timeoutMillis -= elapsed;
            start = System.currentTimeMillis();
            String checkCmd = "if [ -d /data/local/tmp ]; then echo 1; fi";
            dataAvailable = microdroidHelper.runOnMicrodroid(microdroidSerial, "if [ -d /data/local/tmp ]; then echo 1; fi").equals("1");
        }
        if (!microdroidHelper.runOnMicrodroid(microdroidSerial, "getprop", "ro.hardware").equals("microdroid")) {
            throw new DeviceRuntimeException(String.format("Device '%s' was not booted.", microdroidSerial), DeviceErrorIdentifier.SHELL_COMMAND_ERROR);
        }
    }

    public void shutdownMicrodroid(@Nonnull ITestDevice microdroidDevice) throws DeviceNotAvailableException {
        Process process = ((NativeDevice)microdroidDevice).getMicrodroidProcess();
        if (process == null) {
            throw new IllegalArgumentException("Process is null. TestDevice is not a Microdroid. ");
        }
        if (!this.mStartedMicrodroids.containsKey(process)) {
            throw new IllegalArgumentException("Microdroid device was not started in this TestDevice.");
        }
        process.destroy();
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.getRunUtil().runTimedCmd(10000L, GlobalConfiguration.getDeviceManagerInstance().getAdbPath(), "disconnect", microdroidDevice.getSerialNumber());
        GlobalConfiguration.getDeviceManagerInstance().freeDevice(microdroidDevice, FreeDeviceState.AVAILABLE);
        MicrodroidTracker tracker = this.mStartedMicrodroids.remove(process);
        this.getRunUtil().allowInterrupt(true);
        try {
            tracker.executor.shutdownNow();
            tracker.executor.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            LogUtil.CLog.e(e);
        }
    }

    private boolean executeShellV2CommandThatReturnsBooleanSafe(String cmdFormat, Object ... cmdArgs) {
        try {
            return this.executeShellV2CommandThatReturnsBoolean(cmdFormat, cmdArgs);
        }
        catch (Exception e) {
            LogUtil.CLog.e(e);
            return false;
        }
    }

    private boolean executeShellV2CommandThatReturnsBoolean(String cmdFormat, Object ... cmdArgs) throws DeviceNotAvailableException {
        String cmd = String.format(cmdFormat, cmdArgs);
        CommandResult res = this.executeShellV2Command(cmd);
        if (!CommandStatus.SUCCESS.equals((Object)res.getStatus())) {
            throw new DeviceRuntimeException("Command  '" + cmd + "' failed: " + res, DeviceErrorIdentifier.SHELL_COMMAND_ERROR);
        }
        String output = res.getStdout();
        switch (output.trim().toLowerCase()) {
            case "true": {
                return true;
            }
            case "false": {
                return false;
            }
        }
        throw new DeviceRuntimeException("Non-boolean result for '" + cmd + "': " + output, DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
    }

    private String handleInstallationError(InstallException e) {
        String message2 = e.getMessage();
        if (message2 == null) {
            message2 = String.format("InstallException during package installation. cause: %s", StreamUtil.getStackTrace(e));
        }
        return message2;
    }

    private String handleInstallReceiver(InstallReceiver receiver, File packageFile) {
        if (receiver.isSuccessfullyCompleted()) {
            return null;
        }
        if (receiver.getErrorMessage() == null) {
            return String.format("Installation of %s timed out", packageFile.getAbsolutePath());
        }
        String error = receiver.getErrorMessage();
        if (error.contains("cmd: Failure calling service package") || error.contains("Can't find service: package")) {
            String message2 = String.format("Failed to install '%s'. Device might have crashed, it returned: %s", packageFile.getName(), error);
            throw new DeviceRuntimeException(message2, DeviceErrorIdentifier.DEVICE_CRASHED);
        }
        return error;
    }

    private class ScreenshotAction
    implements NativeDevice.DeviceAction {
        RawImage mRawScreenshot;

        private ScreenshotAction() {
        }

        @Override
        public boolean run() throws IOException, TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, InstallException, SyncException {
            this.mRawScreenshot = TestDevice.this.getIDevice().getScreenshot(300000L, TimeUnit.MILLISECONDS);
            return this.mRawScreenshot != null;
        }
    }

    private class DumpPkgAction
    implements NativeDevice.DeviceAction {
        Map<String, PackageInfo> mPkgInfoMap;

        DumpPkgAction() {
        }

        @Override
        public boolean run() throws IOException, TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, InstallException, SyncException {
            DumpsysPackageReceiver receiver = new DumpsysPackageReceiver();
            TestDevice.this.getIDevice().executeShellCommand("dumpsys package p", receiver);
            this.mPkgInfoMap = receiver.getPackages();
            if (this.mPkgInfoMap.size() == 0) {
                LogUtil.CLog.w("no packages found from dumpsys package p.");
                throw new IOException();
            }
            return true;
        }
    }

    private class MicrodroidTracker {
        ExecutorService executor;
        String cid;

        private MicrodroidTracker() {
        }
    }

    public static class MicrodroidBuilder {
        private File mApkFile;
        private String mApkPath;
        private String mConfigPath;
        private String mDebugLevel;
        private int mMemoryMib;
        private Integer mNumCpus;
        private String mCpuAffinity;
        private String mCpuTopology;
        private List<String> mExtraIdsigPaths;
        private boolean mProtectedVm;
        private Map<String, String> mTestDeviceOptions;
        private Map<File, String> mBootFiles;
        private long mAdbConnectTimeoutMs;
        private List<String> mAssignedDevices;

        private MicrodroidBuilder(File apkFile, String apkPath, @Nonnull String configPath) {
            this.mApkFile = apkFile;
            this.mApkPath = apkPath;
            this.mConfigPath = configPath;
            this.mDebugLevel = null;
            this.mMemoryMib = 0;
            this.mNumCpus = null;
            this.mCpuAffinity = null;
            this.mExtraIdsigPaths = new ArrayList<String>();
            this.mProtectedVm = false;
            this.mTestDeviceOptions = new LinkedHashMap<String, String>();
            this.mBootFiles = new LinkedHashMap<File, String>();
            this.mAdbConnectTimeoutMs = 300000L;
            this.mAssignedDevices = new ArrayList<String>();
        }

        public static MicrodroidBuilder fromFile(@Nonnull File apkFile, @Nonnull String configPath) {
            return new MicrodroidBuilder(apkFile, null, configPath);
        }

        public static MicrodroidBuilder fromDevicePath(@Nonnull String apkPath, @Nonnull String configPath) {
            return new MicrodroidBuilder(null, apkPath, configPath);
        }

        public MicrodroidBuilder debugLevel(String debugLevel) {
            this.mDebugLevel = debugLevel;
            return this;
        }

        public MicrodroidBuilder memoryMib(int memoryMib) {
            this.mMemoryMib = memoryMib;
            return this;
        }

        public MicrodroidBuilder numCpus(int num) {
            this.mNumCpus = num;
            return this;
        }

        public MicrodroidBuilder cpuAffinity(String affinity) {
            this.mCpuAffinity = affinity;
            return this;
        }

        public MicrodroidBuilder cpuTopology(String cpuTopology) {
            this.mCpuTopology = cpuTopology;
            return this;
        }

        public MicrodroidBuilder protectedVm(boolean isProtectedVm) {
            this.mProtectedVm = isProtectedVm;
            return this;
        }

        public MicrodroidBuilder addExtraIdsigPath(String extraIdsigPath) {
            if (!Strings.isNullOrEmpty(extraIdsigPath)) {
                this.mExtraIdsigPaths.add(extraIdsigPath);
            }
            return this;
        }

        public MicrodroidBuilder addTestDeviceOption(String optionName, String valueText) {
            this.mTestDeviceOptions.put(optionName, valueText);
            return this;
        }

        public MicrodroidBuilder addBootFile(File localFile, String remoteFileName) {
            this.mBootFiles.put(localFile, remoteFileName);
            return this;
        }

        public MicrodroidBuilder addAssignableDevice(String sysfsNode) {
            this.mAssignedDevices.add(sysfsNode);
            return this;
        }

        public MicrodroidBuilder setAdbConnectTimeoutMs(long timeoutMs) {
            this.mAdbConnectTimeoutMs = timeoutMs;
            return this;
        }

        public ITestDevice build(@Nonnull TestDevice device) throws DeviceNotAvailableException {
            if (this.mNumCpus != null) {
                if (device.getApiLevel() != 33) {
                    throw new IllegalStateException("Setting number of CPUs only supported with API level 33");
                }
                if (this.mNumCpus < 1) {
                    throw new IllegalArgumentException("Number of vCPUs can not be less than 1.");
                }
            }
            if (!Strings.isNullOrEmpty(this.mCpuTopology)) {
                device.checkApiLevelAgainstNextRelease("vm-cpu-topology", 34);
            }
            if (this.mCpuAffinity != null) {
                if (device.getApiLevel() != 33) {
                    throw new IllegalStateException("Setting CPU affinity only supported with API level 33");
                }
                if (!Pattern.matches("[\\d]+(-[\\d]+)?(,[\\d]+(-[\\d]+)?)*", this.mCpuAffinity) && !Pattern.matches("[\\d]+=[\\d]+(:[\\d]+=[\\d]+)*", this.mCpuAffinity)) {
                    throw new IllegalArgumentException("CPU affinity [" + this.mCpuAffinity + "] is invalid");
                }
            }
            return device.startMicrodroid(this);
        }
    }
}

