/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.Log;
import com.android.tradefed.config.Option;
import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.util.ArrayUtil;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TestDeviceOptions {
    public static final int DEFAULT_ADB_PORT = 5555;
    public static final String INSTANCE_TYPE_OPTION = "instance-type";
    @Option(name="enable-root", description="enable adb root on boot.")
    private boolean mEnableAdbRoot = true;
    @Option(name="disable-keyguard", description="attempt to disable keyguard once boot is complete.")
    private boolean mDisableKeyguard = true;
    @Option(name="enable-logcat", description="Enable background logcat capture when invocation is running.")
    private boolean mEnableLogcat = true;
    @Option(name="max-tmp-logcat-file", description="The maximum size of tmp logcat data to retain, in bytes. Only used if --enable-logcat is set")
    private long mMaxLogcatDataSize = 0x1400000L;
    @Option(name="logcat-options", description="Options to be passed down to logcat command, if unspecified, \"-v threadtime\" will be used. Only used if --enable-logcat is set")
    private String mLogcatOptions = null;
    @Option(name="fastboot-timeout", description="time in ms to wait for a device to boot into fastboot.")
    private int mFastbootTimeout = 60000;
    @Option(name="adb-command-timeout", description="time to wait for an adb command.", isTimeVal=true)
    private long mAdbCommandTimeout = 120000L;
    @Option(name="adb-recovery-timeout", description="time in ms to wait for a device to boot into recovery.")
    private int mAdbRecoveryTimeout = 60000;
    @Option(name="reboot-timeout", description="time in ms to wait for a device to reboot to full system.")
    private int mRebootTimeout = 120000;
    @Option(name="device-fastboot-binary", description="The fastboot binary to use for the test session. If null, will use the same fastboot binary as DeviceManager.")
    private File mFastbootBinary = null;
    @Option(name="use-fastboot-erase", description="use fastboot erase instead of fastboot format to wipe partitions")
    private boolean mUseFastbootErase = false;
    @Option(name="unencrypt-reboot-timeout", description="time in ms to wait for the device to format the filesystem and reboot after unencryption")
    private int mUnencryptRebootTimeout = 0;
    @Option(name="online-timeout", description="default time in ms to wait for the device to be visible on adb.", isTimeVal=true)
    private long mOnlineTimeout = 60000L;
    @Option(name="available-timeout", description="default time in ms to wait for the device to be available aka fully boot.")
    private long mAvailableTimeout = 360000L;
    @Option(name="adb-root-unavailable-timeout", description="time in ms to wait for a device to become unavailable after adb root.", isTimeVal=true)
    private long mAdbRootUnavailableTimeout = 2000L;
    @Option(name="conn-check-url", description="default URL to be used for connectivity checks.")
    private String mConnCheckUrl = "http://www.google.com";
    @Option(name="wifi-attempts", description="default number of attempts to connect to wifi network.")
    private int mWifiAttempts = 4;
    @Option(name="wifi-retry-wait-time", description="the base wait time in ms between wifi connect retries. The actual wait time would be a multiple of this value.")
    private int mWifiRetryWaitTime = 15000;
    @Option(name="max-wifi-connect-time", isTimeVal=true, description="the maximum amount of time to attempt to connect to wifi.")
    private long mMaxWifiConnectTime = 300000L;
    @Option(name="wifi-exponential-retry", description="Change the wifi connection retry strategy from a linear wait time into a binary exponential back-offs when retrying.")
    private boolean mWifiExpoRetryEnabled = false;
    @Option(name="wifiutil-apk-path", description="path to the wifiutil APK file")
    private String mWifiUtilAPKPath = null;
    @Option(name="post-boot-command", description="shell command to run after reboots during invocation")
    private List<String> mPostBootCommands = new ArrayList<String>();
    @Option(name="disable-reboot", description="disables device reboots globally, making them no-ops")
    private boolean mDisableReboot = false;
    @Option(name="cutoff-battery", description="the minimum battery level required to continue the invocation. Scale: 0-100")
    private Integer mCutoffBattery = null;
    @Option(name="use-content-provider", description="Allow to disable the use of the content provider at the device level. This results in falling back to standard adb push/pull.")
    private boolean mUseContentProvider = true;
    @Option(name="exit-status-workaround", description="On older devices that do not support ADB shell v2, use a workaround to get the exit status of shell commands")
    private boolean mExitStatusWorkaround = false;
    @Option(name="use-updated-bootloader-status", description="Feature flag to test out an updated approach to bootloader state status.")
    private boolean mUpdatedBootloaderStatus = true;
    @Option(name="bugreportz-timeout", description="Timeout applied to bugreportz capture.", isTimeVal=true)
    private long mBugreportzTimeout = 300000L;
    @Option(name="enable-device-connection", description="Use the new Connection descriptor for devices.")
    private boolean mEnableConnectionFeature = true;
    @Option(name="instance-type", description="The type of virtual device instance to create")
    private InstanceType mInstanceType = InstanceType.GCE;
    @Option(name="gce-boot-timeout", description="timeout to wait in ms for GCE to be online.", isTimeVal=true)
    private long mGceCmdTimeout = 1800000L;
    @Option(name="allow-gce-boot-timeout-override", description="Acloud can take boot-timeout as an arg already, this flag allows to use the Acloud value as a basis instead of the gce-boot-timeout option.")
    private boolean mAllowGceCmdTimeoutOverride = false;
    @Option(name="gce-driver-path", description="path of the binary to launch GCE devices")
    private File mAvdDriverBinary = null;
    @Option(name="gce-driver-config-path", description="path of the config to use to launch GCE devices.")
    private File mAvdConfigFile = null;
    @Option(name="gce-driver-service-account-json-key-path", description="path to the service account json key location.")
    private File mJsonKeyFile = null;
    @Option(name="gce-private-key-path", description="path to the ssh key private key location.")
    private File mSshPrivateKeyPath = new File("~/.ssh/id_rsa");
    @Option(name="gce-driver-log-level", description="Log level for gce driver")
    private Log.LogLevel mGceDriverLogLevel = Log.LogLevel.DEBUG;
    @Option(name="gce-driver-param", description="Additional args to pass to gce driver as parameters.")
    private List<String> mGceDriverParams = new ArrayList<String>();
    @Option(name="gce-driver-file-param", description="Additional file paths to pass to gce driver as parameters. For example, local-image=/path/to/image is converted to --local-image /path/to/image.")
    private MultiMap<String, File> mGceDriverFileParams = new MultiMap();
    @Deprecated
    @Option(name="gce-driver-build-id-param", description="The parameter to be paired with build id from build info when passed down to gce driver")
    private String mGceDriverBuildIdParam = "build_id";
    @Option(name="gce-account", description="email account to use with GCE driver.")
    private String mGceAccount = null;
    @Option(name="max-gce-attempt", description="Maximum number of attempts to start Gce before throwing an exception.")
    private int mGceMaxAttempt = 1;
    @Option(name="skip-gce-teardown", description="Whether or not to skip the GCE tear down. Skipping tear down will result in the instance being left.")
    private boolean mSkipTearDown = false;
    @Option(name="use-oxygen", description="Whether or not to use virtual devices created by Oxygen.")
    private boolean mUseOxygen = false;
    @Deprecated
    @Option(name="use-oxygen-client", description="Whether or not to use Oxygen client tool to create virtual devices.")
    private boolean mUseOxygenClient = true;
    @Option(name="oxygen-target-region", description="Oxygen device target region.")
    private String mOxygenTargetRegion = null;
    @Option(name="oxygen-lease-length", description="Oxygen device lease length.", isTimeVal=true)
    private long mOxygenLeaseLength = 36000000L;
    @Option(name="oxygen-device-size", description="The size of the host which Oxygen virtual device will be running on.")
    private DeviceSize mOxygenDeviceSize = DeviceSize.STANDARD;
    @Option(name="oxygen-service-address", description="Oxygen service address.")
    private String mOxygenServiceAddress = null;
    @Option(name="oxygen-accounting-user", description="Oxygen account user.")
    private String mOxygenAccountingUser = null;
    @Option(name="extra-oxygen-args", description="Extra arguments passed to Oxygen client to lease a device.")
    private Map<String, String> mExtraOxygenArgs = new LinkedHashMap<String, String>();
    @Option(name="wait-gce-teardown", description="Whether or not to block on gce teardown before proceeding.")
    private boolean mWaitForGceTearDown = false;
    @Option(name="instance-user", description="The account to be used to interact with the outer layer of the GCE VM, e.g. to SSH in")
    private String mInstanceUser = "root";
    @Option(name="remote-adb-port", description="The port on remote instance where the adb server listens to.")
    private int mRemoteAdbPort = 5555;
    @Option(name="base-host-image", description="The base image to be used for the GCE VM to host emulator.")
    private String mBaseImage = null;
    @Option(name="remote-fetch-file-pattern", description="Only for remote VM devices. Allows to specify patterns to fetch file on the remote VM via scp. Pattern must follow the scp notations.")
    private Set<String> mRemoteFetchFilePattern = new HashSet<String>();
    @Option(name="cros-user", description="(CHEEPS ONLY) Account to log in to Chrome OS with.")
    private String mCrosUser = null;
    @Option(name="cros-password", description="(CHEEPS ONLY) Password to log in to Chrome OS with. Only used if cros-user is specified.")
    private String mCrosPassword = null;
    @Option(name="invocation-attribute-to-metadata", description="Pass the named attribute found in invocation context to GCE driver (acloud) as metadata to be associated with the GCE VM. e.g. if invocation context has form_factor=phone, it'll be added to GCE VM as metadata form_factor=phone.")
    private List<String> mInvocationAttributeToMetadata = new ArrayList<String>();
    @Option(name="gce-extra-files", description="Path of extra files need to upload GCE instance during Acloud create.Key is local file, value is GCE destination path.")
    private MultiMap<File, String> mGceExtraFiles = new MultiMap();
    @Option(name="use-cmd-wifi", description="Feature flag to switch the wifi connection to using cmd commands.")
    private boolean mUseCmdWidi = false;
    public static final String REMOTE_TF_VERSION_OPTION = "remote-tf-version";
    @Option(name="remote-tf-version", description="The TF to push to the remote VM to drive the invocation. If null, current TF will be pushed.")
    private File mRemoteTFVersion = null;

    public boolean isEnableAdbRoot() {
        return this.mEnableAdbRoot;
    }

    public boolean isDisableKeyguard() {
        return this.mDisableKeyguard;
    }

    public void setDisableKeyguard(boolean disableKeyguard) {
        this.mDisableKeyguard = disableKeyguard;
    }

    public long getMaxLogcatDataSize() {
        return this.mMaxLogcatDataSize;
    }

    public void setMaxLogcatDataSize(long maxLogcatDataSize) {
        this.mMaxLogcatDataSize = maxLogcatDataSize;
    }

    public long getAdbCommandTimeout() {
        return this.mAdbCommandTimeout;
    }

    public void setAdbCommandTimeout(long adbCommandTimeout) {
        this.mAdbCommandTimeout = adbCommandTimeout;
    }

    public int getFastbootTimeout() {
        return this.mFastbootTimeout;
    }

    public void setFastbootTimeout(int fastbootTimeout) {
        this.mFastbootTimeout = fastbootTimeout;
    }

    public int getAdbRecoveryTimeout() {
        return this.mAdbRecoveryTimeout;
    }

    public void setAdbRecoveryTimeout(int adbRecoveryTimeout) {
        this.mAdbRecoveryTimeout = adbRecoveryTimeout;
    }

    public int getRebootTimeout() {
        return this.mRebootTimeout;
    }

    public void setRebootTimeout(int rebootTimeout) {
        this.mRebootTimeout = rebootTimeout;
    }

    public boolean getUseFastbootErase() {
        return this.mUseFastbootErase;
    }

    public void setUseFastbootErase(boolean useFastbootErase) {
        this.mUseFastbootErase = useFastbootErase;
    }

    public File getFastbootBinary() {
        return this.mFastbootBinary;
    }

    public int getUnencryptRebootTimeout() {
        return this.mUnencryptRebootTimeout;
    }

    public void setUnencryptRebootTimeout(int unencryptRebootTimeout) {
        this.mUnencryptRebootTimeout = unencryptRebootTimeout;
    }

    public long getOnlineTimeout() {
        return this.mOnlineTimeout;
    }

    public void setOnlineTimeout(long onlineTimeout) {
        this.mOnlineTimeout = onlineTimeout;
    }

    public long getAvailableTimeout() {
        return this.mAvailableTimeout;
    }

    public long getAdbRootUnavailableTimeout() {
        return this.mAdbRootUnavailableTimeout;
    }

    public void setAdbRootUnavailableTimeout(long adbRootUnavailableTimeout) {
        this.mAdbRootUnavailableTimeout = adbRootUnavailableTimeout;
    }

    public String getConnCheckUrl() {
        return this.mConnCheckUrl;
    }

    public void setConnCheckUrl(String url) {
        this.mConnCheckUrl = url;
    }

    public boolean isLogcatCaptureEnabled() {
        return this.mEnableLogcat;
    }

    public int getWifiAttempts() {
        return this.mWifiAttempts;
    }

    public void setWifiAttempts(int wifiAttempts) {
        this.mWifiAttempts = wifiAttempts;
    }

    public int getWifiRetryWaitTime() {
        return this.mWifiRetryWaitTime;
    }

    public long getMaxWifiConnectTime() {
        return this.mMaxWifiConnectTime;
    }

    public List<String> getPostBootCommands() {
        return this.mPostBootCommands;
    }

    public Integer getCutoffBattery() {
        return this.mCutoffBattery;
    }

    public void setCutoffBattery(int cutoffBattery) {
        if (cutoffBattery < 0 || cutoffBattery > 100) {
            throw new RuntimeException(String.format("Battery cutoff wasn't changed,the value %s isn't within possible range (0-100).", cutoffBattery));
        }
        this.mCutoffBattery = cutoffBattery;
    }

    public String getLogcatOptions() {
        return this.mLogcatOptions;
    }

    public void setLogcatOptions(String logcatOptions) {
        this.mLogcatOptions = logcatOptions;
    }

    public boolean shouldDisableReboot() {
        return this.mDisableReboot;
    }

    public boolean isWifiExpoRetryEnabled() {
        return this.mWifiExpoRetryEnabled;
    }

    public String getWifiUtilAPKPath() {
        return this.mWifiUtilAPKPath;
    }

    public InstanceType getInstanceType() {
        return this.mInstanceType;
    }

    public void setInstanceType(InstanceType type) {
        this.mInstanceType = type;
    }

    public boolean shouldUseContentProvider() {
        return this.mUseContentProvider;
    }

    public boolean useExitStatusWorkaround() {
        return this.mExitStatusWorkaround;
    }

    public long getGceCmdTimeout() {
        return this.mGceCmdTimeout;
    }

    public void setGceCmdTimeout(long gceCmdTimeout) {
        this.mGceCmdTimeout = gceCmdTimeout;
    }

    public boolean allowGceCmdTimeoutOverride() {
        return this.mAllowGceCmdTimeoutOverride;
    }

    public File getAvdDriverBinary() {
        if (this.mAvdDriverBinary == null) {
            throw new HarnessRuntimeException("The avd driver binary is not specified.", InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
        }
        if (!this.mAvdDriverBinary.exists()) {
            throw new HarnessRuntimeException(String.format("Could not find the avd driver binary at %s", this.mAvdDriverBinary.getAbsolutePath()), InfraErrorIdentifier.CONFIGURED_ARTIFACT_NOT_FOUND);
        }
        if (!this.mAvdDriverBinary.canExecute()) {
            FileUtil.chmodGroupRWX(this.mAvdDriverBinary);
        }
        return this.mAvdDriverBinary;
    }

    public void setAvdDriverBinary(File avdDriverBinary) {
        this.mAvdDriverBinary = avdDriverBinary;
    }

    public File getAvdConfigFile() {
        return this.mAvdConfigFile;
    }

    public void setAvdConfigFile(File avdConfigFile) {
        this.mAvdConfigFile = avdConfigFile;
    }

    public File getServiceAccountJsonKeyFile() {
        return this.mJsonKeyFile;
    }

    public void setServiceAccountJsonKeyFile(File jsonKeyFile) {
        this.mJsonKeyFile = jsonKeyFile;
    }

    public File getSshPrivateKeyPath() {
        return this.mSshPrivateKeyPath;
    }

    public void setSshPrivateKeyPath(File sshPrivateKeyPath) {
        this.mSshPrivateKeyPath = sshPrivateKeyPath;
    }

    public Log.LogLevel getGceDriverLogLevel() {
        return this.mGceDriverLogLevel;
    }

    public void setGceDriverLogLevel(Log.LogLevel mGceDriverLogLevel) {
        this.mGceDriverLogLevel = mGceDriverLogLevel;
    }

    public List<String> getGceDriverParams() {
        return this.mGceDriverParams;
    }

    public void addGceDriverParams(String param) {
        this.mGceDriverParams.add(param);
    }

    public MultiMap<String, File> getGceDriverFileParams() {
        return this.mGceDriverFileParams;
    }

    public void setGceDriverBuildIdParam(String gceDriverBuildIdParam) {
        this.mGceDriverBuildIdParam = gceDriverBuildIdParam;
    }

    public String getGceDriverBuildIdParam() {
        return this.mGceDriverBuildIdParam;
    }

    public String getGceAccount() {
        return this.mGceAccount;
    }

    public int getGceMaxAttempt() {
        if (this.mGceMaxAttempt < 1) {
            throw new RuntimeException("--max-gce-attempt cannot be bellow 1 attempt.");
        }
        return this.mGceMaxAttempt;
    }

    public void setGceMaxAttempt(int gceMaxAttempt) {
        this.mGceMaxAttempt = gceMaxAttempt;
    }

    public void setSkipTearDown(boolean shouldSkipTearDown) {
        this.mSkipTearDown = shouldSkipTearDown;
    }

    public boolean shouldSkipTearDown() {
        return this.mSkipTearDown;
    }

    public boolean waitForGceTearDown() {
        return this.mWaitForGceTearDown;
    }

    public boolean useOxygen() {
        return this.mUseOxygen;
    }

    public String getInstanceUser() {
        return this.mInstanceUser;
    }

    public void setInstanceUser(String instanceUser) {
        this.mInstanceUser = instanceUser;
    }

    public int getRemoteAdbPort() {
        return this.mRemoteAdbPort;
    }

    public void setRemoteAdbPort(int remoteAdbPort) {
        this.mRemoteAdbPort = remoteAdbPort;
    }

    public String getBaseImage() {
        return this.mBaseImage;
    }

    public Set<String> getRemoteFetchFilePattern() {
        return this.mRemoteFetchFilePattern;
    }

    public String getCrosUser() {
        return this.mCrosUser;
    }

    public String getCrosPassword() {
        return this.mCrosPassword;
    }

    public File getRemoteTf() {
        return this.mRemoteTFVersion;
    }

    public MultiMap<File, String> getExtraFiles() {
        return this.mGceExtraFiles;
    }

    public void setExtraFiles(MultiMap<File, String> extraFiles) {
        this.mGceExtraFiles = extraFiles;
    }

    public boolean useCmdWifiCommands() {
        return this.mUseCmdWidi;
    }

    public static String getCreateCommandByInstanceType(InstanceType type) {
        switch (type) {
            case CHEEPS: 
            case GCE: 
            case REMOTE_AVD: 
            case CUTTLEFISH: 
            case REMOTE_NESTED_AVD: {
                return "create";
            }
            case EMULATOR: {
                return "create_gf";
            }
        }
        throw new RuntimeException("Unexpected InstanceType: " + (Object)((Object)type));
    }

    public static List<String> getExtraParamsByInstanceType(InstanceType type, String baseImage) {
        if (InstanceType.EMULATOR.equals((Object)type)) {
            List<String> params = ArrayUtil.list(new String[0]);
            if (baseImage != null) {
                params.add("--base_image");
                params.add(baseImage);
            }
            return params;
        }
        return Collections.emptyList();
    }

    public List<String> getInvocationAttributeToMetadata() {
        return this.mInvocationAttributeToMetadata;
    }

    @Deprecated
    public boolean useOxygenProxy() {
        return this.mUseOxygenClient;
    }

    public String getOxygenTargetRegion() {
        return this.mOxygenTargetRegion;
    }

    public long getOxygenLeaseLength() {
        return this.mOxygenLeaseLength;
    }

    public DeviceSize getOxygenDeviceSize() {
        return this.mOxygenDeviceSize;
    }

    public String getOxygenServiceAddress() {
        return this.mOxygenServiceAddress;
    }

    public String getOxygenAccountingUser() {
        return this.mOxygenAccountingUser;
    }

    public Map<String, String> getExtraOxygenArgs() {
        return this.mExtraOxygenArgs;
    }

    public boolean useUpdatedBootloaderStatus() {
        return this.mUpdatedBootloaderStatus;
    }

    public long getBugreportzTimeout() {
        return this.mBugreportzTimeout;
    }

    public boolean shouldUseConnection() {
        return this.mEnableConnectionFeature;
    }

    public void setUseConnection(boolean useConnection) {
        this.mEnableConnectionFeature = useConnection;
    }

    public static enum InstanceType {
        GCE,
        REMOTE_AVD,
        CUTTLEFISH,
        REMOTE_NESTED_AVD,
        EMULATOR,
        CHEEPS;

    }

    private static enum DeviceSize {
        STANDARD,
        LARGE,
        EXTRA_LARGE;

    }
}

