/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

public final class UserInfo {
    public static final int FLAG_PRIMARY = 1;
    public static final int FLAG_GUEST = 4;
    public static final int FLAG_RESTRICTED = 8;
    public static final int FLAG_EPHEMERAL = 256;
    public static final int FLAG_MANAGED_PROFILE = 32;
    public static final int FLAG_PROFILE = 4096;
    public static final int USER_SYSTEM = 0;
    public static final int FLAG_MAIN = 16384;
    public static final int FLAG_FOR_TESTING = 32768;
    public static final int FLAGS_NOT_SECONDARY = 45;
    public static final String CLONE_PROFILE_TYPE = "profile.CLONE";
    private final int mUserId;
    private final String mUserName;
    private final int mFlag;
    private final boolean mIsRunning;
    private String mUserType;

    public UserInfo(int userId, String userName, int flag, boolean isRunning) {
        this.mUserId = userId;
        this.mUserName = userName;
        this.mFlag = flag;
        this.mIsRunning = isRunning;
    }

    public UserInfo(int userId, String userName, int flag, boolean isRunning, String userType) {
        this(userId, userName, flag, isRunning);
        this.mUserType = userType;
    }

    public int userId() {
        return this.mUserId;
    }

    public String userName() {
        return this.mUserName;
    }

    public int flag() {
        return this.mFlag;
    }

    public boolean isRunning() {
        return this.mIsRunning;
    }

    public boolean isGuest() {
        return (this.mFlag & 4) == 4;
    }

    public boolean isPrimary() {
        return (this.mFlag & 1) == 1;
    }

    public boolean isSecondary() {
        return !this.isSystem() && (this.mFlag & 0x2D) == 0;
    }

    public boolean isSystem() {
        return this.mUserId == 0;
    }

    public boolean isMain() {
        return (this.mFlag & 0x4000) == 16384;
    }

    public boolean isManagedProfile() {
        return (this.mFlag & 0x20) == 32;
    }

    public boolean isCloneProfile() {
        return CLONE_PROFILE_TYPE.equals(this.mUserType);
    }

    public boolean isEphemeral() {
        return (this.mFlag & 0x100) == 256;
    }

    public boolean isFlagForTesting() {
        return (this.mFlag & 0x8000) == 32768;
    }

    public boolean isUserType(UserType userType, int currentUserId) {
        switch (userType) {
            case CURRENT: {
                return this.mUserId == currentUserId;
            }
            case GUEST: {
                return this.isGuest();
            }
            case PRIMARY: {
                return this.isPrimary();
            }
            case SYSTEM: {
                return this.isSystem();
            }
            case MAIN: {
                return this.isMain();
            }
            case SECONDARY: {
                return this.isSecondary();
            }
            case MANAGED_PROFILE: {
                return this.isManagedProfile();
            }
            case CLONE_PROFILE: {
                return this.isCloneProfile();
            }
        }
        throw new RuntimeException("Variant not covered: " + (Object)((Object)userType));
    }

    public static enum UserType {
        CURRENT,
        GUEST,
        PRIMARY,
        SYSTEM,
        MAIN,
        SECONDARY,
        MANAGED_PROFILE,
        CLONE_PROFILE;


        public boolean isCurrent() {
            return this == CURRENT;
        }

        public boolean isGuest() {
            return this == GUEST;
        }

        public boolean isPrimary() {
            return this == PRIMARY;
        }

        public boolean isSystem() {
            return this == SYSTEM;
        }

        public boolean isMain() {
            return this == MAIN;
        }

        public boolean isSecondary() {
            return this == SECONDARY;
        }

        public boolean isManagedProfile() {
            return this == MANAGED_PROFILE;
        }

        public boolean isCloneProfile() {
            return this == CLONE_PROFILE;
        }

        public boolean isProfile() {
            return this.isManagedProfile() || this.isCloneProfile();
        }
    }
}

