/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.TimeoutException;
import com.android.helper.aoa.UsbDevice;
import com.android.helper.aoa.UsbHelper;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.DeviceUnresponsiveException;
import com.android.tradefed.device.IDeviceRecovery;
import com.android.tradefed.device.IDeviceStateMonitor;
import com.android.tradefed.device.TestDeviceState;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.concurrent.ExecutionException;

public class WaitDeviceRecovery
implements IDeviceRecovery {
    protected static final long INITIAL_PAUSE_TIME = 5000L;
    private static final long WAIT_FOR_DEVICE_OFFLINE = 20000L;
    public static final int BOOTLOADER_POLL_ATTEMPTS = 3;
    @Option(name="online-wait-time", description="maximum time in ms to wait for device to come online.")
    protected long mOnlineWaitTime = 60000L;
    @Option(name="device-wait-time", description="maximum time in ms to wait for a single device recovery command.")
    protected long mWaitTime = 240000L;
    @Option(name="bootloader-wait-time", description="maximum time in ms to wait for device to be in fastboot.")
    protected long mBootloaderWaitTime = 30000L;
    @Option(name="shell-wait-time", description="maximum time in ms to wait for device shell to be responsive.")
    protected long mShellWaitTime = 30000L;
    @Option(name="fastboot-wait-time", description="maximum time in ms to wait for a fastboot command result.")
    protected long mFastbootWaitTime = 30000L;
    @Option(name="min-battery-after-recovery", description="require a min battery level after successful recovery, default to 0 for ignoring.")
    protected int mRequiredMinBattery = 0;
    @Option(name="disable-unresponsive-reboot", description="If this is set, we will not attempt to reboot an unresponsive devicethat is in userspace.  Note that this will have no effect if the device is in fastboot or is expected to be in fastboot.")
    protected boolean mDisableUnresponsiveReboot = false;
    @Option(name="disable-usb-reset", description="Do not attempt reset via USB in order to recover devices.")
    protected boolean mDisableUsbReset = false;
    private String mFastbootPath = "fastboot";

    protected IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }

    void setWaitTime(long waitTime) {
        this.mWaitTime = waitTime;
    }

    @Override
    public void setFastbootPath(String fastbootPath) {
        this.mFastbootPath = fastbootPath;
    }

    @Override
    public void recoverDevice(IDeviceStateMonitor monitor, boolean recoverUntilOnline) throws DeviceNotAvailableException {
        IDevice device;
        LogUtil.CLog.i("Pausing for %d for %s to recover", 5000L, monitor.getSerialNumber());
        this.getRunUtil().sleep(5000L);
        monitor.waitForDeviceBootloaderStateUpdate();
        TestDeviceState state = monitor.getDeviceState();
        if (TestDeviceState.FASTBOOT.equals((Object)state) || TestDeviceState.FASTBOOTD.equals((Object)state)) {
            LogUtil.CLog.i("Found device %s in %s but expected online. Rebooting...", new Object[]{monitor.getSerialNumber(), state});
            this.getRunUtil().runTimedCmd(this.mFastbootWaitTime, this.mFastbootPath, "-s", monitor.getFastbootSerialNumber(), "reboot");
        }
        if ((device = monitor.waitForDeviceOnline(this.mOnlineWaitTime)) == null) {
            this.handleDeviceNotAvailable(monitor, recoverUntilOnline);
            this.checkMinBatteryLevel(this.getDeviceAfterRecovery(monitor));
            return;
        }
        if (!monitor.waitForDeviceShell(this.mShellWaitTime)) {
            this.handleDeviceNotAvailable(monitor, recoverUntilOnline);
            this.checkMinBatteryLevel(this.getDeviceAfterRecovery(monitor));
            return;
        }
        if (!recoverUntilOnline && monitor.waitForDeviceAvailableInRecoverPath(this.mWaitTime) == null) {
            this.handleDeviceUnresponsive(device, monitor);
        }
        this.checkMinBatteryLevel(this.getDeviceAfterRecovery(monitor));
    }

    private IDevice getDeviceAfterRecovery(IDeviceStateMonitor monitor) throws DeviceNotAvailableException {
        IDevice device = monitor.waitForDeviceOnline(this.mOnlineWaitTime);
        if (device == null) {
            throw new DeviceNotAvailableException("Device still not online after successful recovery", monitor.getSerialNumber(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNAVAILABLE);
        }
        return device;
    }

    protected void checkMinBatteryLevel(IDevice device) throws DeviceNotAvailableException {
        if (this.mRequiredMinBattery <= 0) {
            return;
        }
        try {
            Integer level = device.getBattery().get();
            if (level == null) {
                throw new DeviceNotAvailableException("Cannot read battery level but a min is required", device.getSerialNumber(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
            }
            if (level < this.mRequiredMinBattery) {
                throw new DeviceNotAvailableException(String.format("After recovery, device battery level %d is lower than required minimum %d", level, this.mRequiredMinBattery), device.getSerialNumber());
            }
            return;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new DeviceNotAvailableException("exception while reading battery level", (Throwable)e, device.getSerialNumber(), DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
        }
    }

    protected void handleDeviceUnresponsive(IDevice device, IDeviceStateMonitor monitor) throws DeviceNotAvailableException {
        if (!this.mDisableUnresponsiveReboot) {
            LogUtil.CLog.i("Device %s unresponsive. Rebooting...", monitor.getSerialNumber());
            this.rebootDevice(device, null);
            IDevice newdevice = monitor.waitForDeviceOnline(this.mOnlineWaitTime);
            if (newdevice == null) {
                this.handleDeviceNotAvailable(monitor, false);
                return;
            }
            if (monitor.waitForDeviceAvailable(this.mWaitTime) != null) {
                return;
            }
        }
        throw new DeviceUnresponsiveException(String.format("Device %s is online but unresponsive", monitor.getSerialNumber()), monitor.getSerialNumber(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNRESPONSIVE);
    }

    protected void handleDeviceNotAvailable(IDeviceStateMonitor monitor, boolean recoverTillOnline) throws DeviceNotAvailableException {
        if (this.attemptDeviceUnavailableRecovery(monitor, recoverTillOnline)) {
            return;
        }
        String serial = monitor.getSerialNumber();
        throw new DeviceNotAvailableException(String.format("Could not find device %s", serial), serial, (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNAVAILABLE);
    }

    @Override
    public void recoverDeviceBootloader(IDeviceStateMonitor monitor) throws DeviceNotAvailableException {
        LogUtil.CLog.i("Pausing for %d for %s to recover", 5000L, monitor.getSerialNumber());
        this.getRunUtil().sleep(5000L);
        long pollTime = this.mBootloaderWaitTime / 3L;
        for (int i = 0; i < 3; ++i) {
            if (monitor.waitForDeviceBootloader(pollTime)) {
                this.handleDeviceBootloaderUnresponsive(monitor);
                return;
            }
            if (monitor.getDeviceState() != TestDeviceState.ONLINE) continue;
            this.handleDeviceOnlineExpectedBootloader(monitor);
            return;
        }
        this.handleDeviceBootloaderOrFastbootNotAvailable(monitor, "bootloader");
    }

    @Override
    public void recoverDeviceFastbootd(IDeviceStateMonitor monitor) throws DeviceNotAvailableException {
        LogUtil.CLog.i("Pausing for %d for %s to recover", 5000L, monitor.getSerialNumber());
        this.getRunUtil().sleep(5000L);
        long pollTime = this.mBootloaderWaitTime / 3L;
        for (int i = 0; i < 3; ++i) {
            if (monitor.waitForDeviceFastbootd(this.mFastbootPath, pollTime)) {
                this.handleDeviceFastbootdUnresponsive(monitor);
                return;
            }
            if (monitor.getDeviceState() != TestDeviceState.ONLINE) continue;
            this.handleDeviceOnlineExpectedFasbootd(monitor);
            return;
        }
        this.handleDeviceBootloaderOrFastbootNotAvailable(monitor, "fastbootd");
    }

    private void handleDeviceOnlineExpectedBootloader(IDeviceStateMonitor monitor) throws DeviceNotAvailableException {
        LogUtil.CLog.i("Found device %s online but expected bootloader.", monitor.getSerialNumber());
        IDevice device = monitor.waitForDeviceOnline(this.mOnlineWaitTime);
        if (device == null) {
            this.handleDeviceBootloaderOrFastbootNotAvailable(monitor, "bootloader");
            return;
        }
        this.rebootDevice(device, "bootloader");
        if (!monitor.waitForDeviceBootloader(this.mBootloaderWaitTime)) {
            throw new DeviceNotAvailableException(String.format("Device %s not in bootloader after reboot", monitor.getSerialNumber()), monitor.getSerialNumber(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNAVAILABLE);
        }
    }

    private void handleDeviceOnlineExpectedFasbootd(IDeviceStateMonitor monitor) throws DeviceNotAvailableException {
        LogUtil.CLog.i("Found device %s online but expected fastbootd.", monitor.getSerialNumber());
        IDevice device = monitor.waitForDeviceOnline(this.mOnlineWaitTime);
        if (device == null) {
            this.handleDeviceBootloaderOrFastbootNotAvailable(monitor, "fastbootd");
            return;
        }
        this.rebootDevice(device, "fastboot");
        if (!monitor.waitForDeviceFastbootd(this.mFastbootPath, this.mBootloaderWaitTime)) {
            throw new DeviceNotAvailableException(String.format("Device %s not in fastbootd after reboot", monitor.getSerialNumber()), monitor.getSerialNumber(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNAVAILABLE);
        }
    }

    private void handleDeviceFastbootdUnresponsive(IDeviceStateMonitor monitor) throws DeviceNotAvailableException {
        LogUtil.CLog.i("Found device %s in fastbootd but potentially unresponsive.", monitor.getSerialNumber());
        this.getRunUtil().runTimedCmd(this.mFastbootWaitTime, this.mFastbootPath, "-s", monitor.getSerialNumber(), "reboot", "fastboot");
        monitor.waitForDeviceNotAvailable(20000L);
        if (!monitor.waitForDeviceFastbootd(this.mFastbootPath, this.mBootloaderWaitTime)) {
            throw new DeviceNotAvailableException(String.format("Device %s not in fastbootd after reboot", monitor.getSerialNumber()), monitor.getSerialNumber(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNAVAILABLE);
        }
        CommandResult result = this.getRunUtil().runTimedCmd(this.mFastbootWaitTime, this.mFastbootPath, "-s", monitor.getSerialNumber(), "getvar", "product");
        if (result.getStatus().equals((Object)CommandStatus.TIMED_OUT)) {
            throw new DeviceNotAvailableException(String.format("Device %s is in fastbootd but unresponsive", monitor.getSerialNumber()), monitor.getSerialNumber(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNRESPONSIVE);
        }
    }

    private void handleDeviceBootloaderUnresponsive(IDeviceStateMonitor monitor) throws DeviceNotAvailableException {
        LogUtil.CLog.i("Found device %s in fastboot but potentially unresponsive.", monitor.getSerialNumber());
        this.getRunUtil().runTimedCmd(this.mFastbootWaitTime, this.mFastbootPath, "-s", monitor.getSerialNumber(), "reboot-bootloader");
        monitor.waitForDeviceNotAvailable(20000L);
        if (!monitor.waitForDeviceBootloader(this.mBootloaderWaitTime)) {
            throw new DeviceNotAvailableException(String.format("Device %s not in bootloader after reboot", monitor.getSerialNumber()), monitor.getSerialNumber(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNAVAILABLE);
        }
        CommandResult result = this.getRunUtil().runTimedCmd(this.mFastbootWaitTime, this.mFastbootPath, "-s", monitor.getSerialNumber(), "getvar", "product");
        if (result.getStatus().equals((Object)CommandStatus.TIMED_OUT)) {
            throw new DeviceNotAvailableException(String.format("Device %s is in fastboot but unresponsive", monitor.getSerialNumber()), monitor.getSerialNumber(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNRESPONSIVE);
        }
    }

    private void rebootDevice(IDevice device, String mode) throws DeviceNotAvailableException {
        block4: {
            try {
                device.reboot(mode);
            }
            catch (IOException e) {
                LogUtil.CLog.w("%s: failed to reboot %s: %s", e.getClass().getSimpleName(), device.getSerialNumber(), e.getMessage());
            }
            catch (TimeoutException e) {
                LogUtil.CLog.w("failed to reboot %s: timeout", device.getSerialNumber());
            }
            catch (AdbCommandRejectedException e) {
                LogUtil.CLog.w("%s: failed to reboot %s: %s", e.getClass().getSimpleName(), device.getSerialNumber(), e.getMessage());
                if (!e.isDeviceOffline() && !e.wasErrorDuringDeviceSelection()) break block4;
                throw new DeviceNotAvailableException(e.getMessage(), (Throwable)e, device.getSerialNumber(), DeviceErrorIdentifier.DEVICE_UNAVAILABLE);
            }
        }
    }

    private void handleDeviceBootloaderOrFastbootNotAvailable(IDeviceStateMonitor monitor, String mode) throws DeviceNotAvailableException {
        throw new DeviceNotAvailableException(String.format("Could not find device %s in %s", monitor.getSerialNumber(), mode), monitor.getSerialNumber(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNAVAILABLE);
    }

    @Override
    public void recoverDeviceRecovery(IDeviceStateMonitor monitor) throws DeviceNotAvailableException {
        throw new DeviceNotAvailableException("device unexpectedly went into recovery mode.", monitor.getSerialNumber(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNAVAILABLE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean attemptDeviceUnavailableRecovery(IDeviceStateMonitor monitor, boolean recoverTillOnline) throws DeviceNotAvailableException {
        IDevice device;
        TestDeviceState state = monitor.getDeviceState();
        if (TestDeviceState.RECOVERY.equals((Object)state)) {
            LogUtil.CLog.d("Device is in '%s' state skipping USB reset attempt.", new Object[]{state});
            this.recoverDeviceRecovery(monitor);
            return false;
        }
        if (TestDeviceState.FASTBOOT.equals((Object)state) || TestDeviceState.FASTBOOTD.equals((Object)state)) {
            LogUtil.CLog.d("Device is in '%s' state skipping USB reset attempt.", new Object[]{state});
            return false;
        }
        String serial = monitor.getSerialNumber();
        boolean recoveryAttempted = false;
        if (!this.mDisableUsbReset) {
            try (UsbHelper usb = this.getUsbHelper();
                 UsbDevice usbDevice = usb.getDevice(serial);){
                if (usbDevice != null) {
                    LogUtil.CLog.d("Resetting USB port for device '%s'", serial);
                    usbDevice.reset();
                    recoveryAttempted = true;
                    if (this.waitForDevice(monitor, recoverTillOnline)) {
                        LogUtil.CLog.d("Device recovered from USB reset and is online.");
                        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.DEVICE_RECOVERY, 1L);
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            catch (LinkageError e) {
                LogUtil.CLog.w("Problem initializing USB helper, skipping USB reset and disabling it.");
                LogUtil.CLog.w(e);
                this.mDisableUsbReset = true;
            }
        }
        if (!recoveryAttempted) return false;
        if (TestDeviceState.RECOVERY.equals((Object)monitor.getDeviceState()) && (device = monitor.waitForDeviceInRecovery()) != null) {
            LogUtil.CLog.d("Device came back in 'RECOVERY' mode when we expected 'ONLINE'");
            this.rebootDevice(device, null);
            if (this.waitForDevice(monitor, recoverTillOnline)) {
                LogUtil.CLog.d("Device recovered from recovery mode and is online.");
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.DEVICE_RECOVERY, 1L);
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.DEVICE_RECOVERY_FROM_RECOVERY, 1L);
                return true;
            }
        }
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.DEVICE_RECOVERY_FAIL, 1L);
        LogUtil.CLog.w("USB reset recovery was unsuccessful");
        return false;
    }

    private boolean waitForDevice(IDeviceStateMonitor monitor, boolean recoverTillOnline) {
        return recoverTillOnline ? monitor.waitForDeviceOnline() != null : monitor.waitForDeviceAvailable() != null;
    }

    @VisibleForTesting
    UsbHelper getUsbHelper() {
        return new UsbHelper();
    }
}

