/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.MultiLineReceiver;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.DeviceRuntimeException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.IWifiHelper;
import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class WifiHelper
implements IWifiHelper {
    private static final String NULL = "null";
    private static final String NULL_IP_ADDR = "0.0.0.0";
    private static final String INSTRUMENTATION_CLASS = ".WifiUtil";
    public static final String INSTRUMENTATION_PKG = "com.android.tradefed.utils.wifi";
    static final String FULL_INSTRUMENTATION_NAME = String.format("%s/%s", "com.android.tradefed.utils.wifi", ".WifiUtil");
    static final String CHECK_PACKAGE_CMD = String.format("dumpsys package %s", "com.android.tradefed.utils.wifi");
    static final String ENABLE_WIFI_CMD = "svc wifi enable";
    static final String DISABLE_WIFI_CMD = "svc wifi disable";
    static final Pattern PACKAGE_VERSION_PAT = Pattern.compile("versionCode=(\\d*)");
    static final int PACKAGE_VERSION_CODE = 21;
    private static final String WIFIUTIL_APK_NAME = "WifiUtil.apk";
    private static final String WIFIUTIL_APK_RES = "/WifiUtil.apk";
    private static final String WIFIUTIL_APK_RES_FALLBACK = "/com/android/tradefed/utils/wifi/WifiUtil.apk";
    private static final long WIFIUTIL_CMD_TIMEOUT_MINUTES = 5L;
    private static final long DEFAULT_WIFI_STATE_TIMEOUT = 200000L;
    private final ITestDevice mDevice;
    private File mWifiUtilApkFile;

    public WifiHelper(ITestDevice device) throws DeviceNotAvailableException {
        this(device, null, true);
    }

    public WifiHelper(ITestDevice device, String wifiUtilApkPath) throws DeviceNotAvailableException {
        this(device, wifiUtilApkPath, true);
    }

    public WifiHelper(ITestDevice device, String wifiUtilApkPath, boolean doSetup) throws DeviceNotAvailableException {
        this.mDevice = device;
        if (doSetup) {
            this.ensureDeviceSetup(wifiUtilApkPath);
        }
    }

    IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }

    void ensureDeviceSetup(String wifiUtilApkPath) throws DeviceNotAvailableException {
        Matcher matcher;
        String inst = this.mDevice.executeShellCommand(CHECK_PACKAGE_CMD);
        if (inst != null && (matcher = PACKAGE_VERSION_PAT.matcher(inst)).find()) {
            try {
                if (21 <= Integer.parseInt(matcher.group(1))) {
                    return;
                }
            }
            catch (NumberFormatException e) {
                LogUtil.CLog.w("failed to parse WifiUtil version code: %s", matcher.group(1));
            }
        }
        try {
            String error;
            this.setupWifiUtilApkFile(wifiUtilApkPath);
            String[] extraArgs = new String[]{};
            if (this.mDevice.isBypassLowTargetSdkBlockSupported()) {
                extraArgs = new String[]{"--bypass-low-target-sdk-block"};
            }
            if ((error = this.mDevice.installPackage(this.mWifiUtilApkFile, true, extraArgs)) == null) {
                return;
            }
            try {
                if (error.contains("cmd: Failure calling service package") || error.contains("Can't find service: package")) {
                    String message2 = String.format("Failed to install WifiUtil utility. Device might have crashed, it returned: %s", error);
                    throw new DeviceRuntimeException(message2, DeviceErrorIdentifier.DEVICE_CRASHED);
                }
                throw new HarnessRuntimeException(String.format("Unable to install WifiUtil utility: %s on %s", error, this.mDevice.getSerialNumber()), DeviceErrorIdentifier.APK_INSTALLATION_FAILED);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Failed to unpack WifiUtil utility: %s", e.getMessage()));
            }
        }
        finally {
            if (wifiUtilApkPath == null) {
                FileUtil.deleteFile(this.mWifiUtilApkFile);
            }
        }
    }

    private void setupWifiUtilApkFile(String wifiUtilApkPath) throws IOException {
        this.mWifiUtilApkFile = wifiUtilApkPath != null ? new File(wifiUtilApkPath) : WifiHelper.extractWifiUtilApk();
    }

    @VisibleForTesting
    File getWifiUtilApkFile() {
        return this.mWifiUtilApkFile;
    }

    public static File extractWifiUtilApk() throws IOException {
        File apkTempFile = FileUtil.createTempFile(WIFIUTIL_APK_NAME, ".apk");
        try {
            InputStream apkStream = WifiHelper.class.getResourceAsStream(WIFIUTIL_APK_RES);
            FileUtil.writeToFile(apkStream, apkTempFile);
        }
        catch (IOException e) {
            InputStream apkStream = WifiHelper.class.getResourceAsStream(WIFIUTIL_APK_RES_FALLBACK);
            FileUtil.writeToFile(apkStream, apkTempFile);
        }
        return apkTempFile;
    }

    @Override
    public boolean enableWifi() throws DeviceNotAvailableException {
        CommandResult result = this.mDevice.executeShellV2Command(ENABLE_WIFI_CMD);
        if (!CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
            LogUtil.CLog.e("Failed to enable wifi. status: %s\nstdout: %s\nstderr: %s", new Object[]{result.getStatus(), result.getStdout(), result.getStderr()});
        }
        return this.waitForWifiEnabled(120000L);
    }

    @Override
    public boolean disableWifi() throws DeviceNotAvailableException {
        this.mDevice.executeShellCommand(DISABLE_WIFI_CMD);
        return this.waitForWifiDisabled();
    }

    @Override
    public boolean waitForWifiState(IWifiHelper.WifiState ... expectedStates) throws DeviceNotAvailableException {
        return this.waitForWifiState(200000L, expectedStates);
    }

    boolean waitForWifiState(long timeout, IWifiHelper.WifiState ... expectedStates) throws DeviceNotAvailableException {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() < startTime + timeout) {
            String state = this.runWifiUtil("getSupplicantState", new String[0]);
            for (IWifiHelper.WifiState expectedState : expectedStates) {
                if (!expectedState.name().equals(state)) continue;
                return true;
            }
            this.getRunUtil().sleep(this.getPollTime());
        }
        return false;
    }

    long getPollTime() {
        return 1000L;
    }

    boolean removeNetwork(int networkId) throws DeviceNotAvailableException {
        if (!WifiHelper.asBool(this.runWifiUtil("removeNetwork", "id", Integer.toString(networkId)))) {
            return false;
        }
        return WifiHelper.asBool(this.runWifiUtil("saveConfiguration", new String[0]));
    }

    @Override
    public boolean addOpenNetwork(String ssid) throws DeviceNotAvailableException {
        return this.addOpenNetwork(ssid, false);
    }

    @Override
    public boolean addOpenNetwork(String ssid, boolean scanSsid) throws DeviceNotAvailableException {
        int id = WifiHelper.asInt(this.runWifiUtil("addOpenNetwork", "ssid", ssid, "scanSsid", Boolean.toString(scanSsid)));
        if (id < 0) {
            return false;
        }
        if (!WifiHelper.asBool(this.runWifiUtil("associateNetwork", "id", Integer.toString(id)))) {
            return false;
        }
        return WifiHelper.asBool(this.runWifiUtil("saveConfiguration", new String[0]));
    }

    @Override
    public boolean addWpaPskNetwork(String ssid, String psk) throws DeviceNotAvailableException {
        return this.addWpaPskNetwork(ssid, psk, false);
    }

    @Override
    public boolean addWpaPskNetwork(String ssid, String psk, boolean scanSsid) throws DeviceNotAvailableException {
        int id = WifiHelper.asInt(this.runWifiUtil("addWpaPskNetwork", "ssid", ssid, "psk", psk, "scan_ssid", Boolean.toString(scanSsid)));
        if (id < 0) {
            return false;
        }
        if (!WifiHelper.asBool(this.runWifiUtil("associateNetwork", "id", Integer.toString(id)))) {
            return false;
        }
        return WifiHelper.asBool(this.runWifiUtil("saveConfiguration", new String[0]));
    }

    @Override
    public boolean waitForIp(long timeout) throws DeviceNotAvailableException {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() < startTime + timeout) {
            if (this.hasValidIp()) {
                return true;
            }
            this.getRunUtil().sleep(this.getPollTime());
        }
        return false;
    }

    @Override
    public boolean hasValidIp() throws DeviceNotAvailableException {
        String ip = this.getIpAddress();
        return ip != null && !ip.isEmpty() && !NULL_IP_ADDR.equals(ip);
    }

    @Override
    public String getIpAddress() throws DeviceNotAvailableException {
        return this.runWifiUtil("getIpAddress", new String[0]);
    }

    @Override
    public String getSSID() throws DeviceNotAvailableException {
        return this.runWifiUtil("getSSID", new String[0]);
    }

    @Override
    public String getBSSID() throws DeviceNotAvailableException {
        return this.runWifiUtil("getBSSID", new String[0]);
    }

    @Override
    public boolean removeAllNetworks() throws DeviceNotAvailableException {
        if (!WifiHelper.asBool(this.runWifiUtil("removeAllNetworks", new String[0]))) {
            return false;
        }
        return WifiHelper.asBool(this.runWifiUtil("saveConfiguration", new String[0]));
    }

    @Override
    public boolean isWifiEnabled() throws DeviceNotAvailableException {
        return WifiHelper.asBool(this.runWifiUtil("isWifiEnabled", 2L, new String[0]));
    }

    @Override
    public boolean waitForWifiEnabled() throws DeviceNotAvailableException {
        return this.waitForWifiEnabled(200000L);
    }

    @Override
    public boolean waitForWifiEnabled(long timeout) throws DeviceNotAvailableException {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() < startTime + timeout) {
            if (this.isWifiEnabled()) {
                return true;
            }
            this.getRunUtil().sleep(this.getPollTime());
        }
        return false;
    }

    @Override
    public boolean waitForWifiDisabled() throws DeviceNotAvailableException {
        return this.waitForWifiDisabled(200000L);
    }

    @Override
    public boolean waitForWifiDisabled(long timeout) throws DeviceNotAvailableException {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() < startTime + timeout) {
            if (!this.isWifiEnabled()) {
                return true;
            }
            this.getRunUtil().sleep(this.getPollTime());
        }
        return false;
    }

    @Override
    public Map<String, String> getWifiInfo() throws DeviceNotAvailableException {
        HashMap<String, String> info = new HashMap<String, String>();
        String result = this.runWifiUtil("getWifiInfo", new String[0]);
        if (result != null) {
            try {
                JSONObject json = new JSONObject(result);
                Iterator keys = json.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    info.put(key, json.getString(key));
                }
            }
            catch (JSONException e) {
                LogUtil.CLog.w("Failed to parse wifi info: %s", e.getMessage());
            }
        }
        return info;
    }

    @Override
    public boolean checkConnectivity(String urlToCheck) throws DeviceNotAvailableException {
        return WifiHelper.asBool(this.runWifiUtil("checkConnectivity", "urlToCheck", urlToCheck));
    }

    @Override
    public boolean connectToNetwork(String ssid, String psk, String urlToCheck) throws DeviceNotAvailableException {
        return IWifiHelper.WifiConnectionResult.SUCCESS == this.connectToNetwork(ssid, psk, urlToCheck, false);
    }

    @Override
    public IWifiHelper.WifiConnectionResult connectToNetwork(String ssid, String psk, String urlToCheck, boolean scanSsid) throws DeviceNotAvailableException {
        if (!this.enableWifi()) {
            LogUtil.CLog.e("Failed to enable wifi");
            return IWifiHelper.WifiConnectionResult.FAILED_TO_ENABLE;
        }
        if (!WifiHelper.asBool(this.runWifiUtil("connectToNetwork", "ssid", ssid, "psk", psk, "urlToCheck", urlToCheck, "scan_ssid", Boolean.toString(scanSsid)))) {
            return IWifiHelper.WifiConnectionResult.FAILED_TO_CONNECT;
        }
        return IWifiHelper.WifiConnectionResult.SUCCESS;
    }

    @Override
    public boolean disconnectFromNetwork() throws DeviceNotAvailableException {
        if (!WifiHelper.asBool(this.runWifiUtil("disconnectFromNetwork", new String[0]))) {
            return false;
        }
        if (!this.disableWifi()) {
            LogUtil.CLog.e("Failed to disable wifi");
            return false;
        }
        return true;
    }

    @Override
    public boolean startMonitor(long interval, String urlToCheck) throws DeviceNotAvailableException {
        return WifiHelper.asBool(this.runWifiUtil("startMonitor", "interval", Long.toString(interval), "urlToCheck", urlToCheck));
    }

    @Override
    public List<Long> stopMonitor() throws DeviceNotAvailableException {
        String output = this.runWifiUtil("stopMonitor", new String[0]);
        if (output == null || output.isEmpty() || NULL.equals(output)) {
            return new ArrayList<Long>(0);
        }
        String[] tokens = output.split(",");
        ArrayList<Long> values2 = new ArrayList<Long>(tokens.length);
        for (String token : tokens) {
            values2.add(Long.parseLong(token));
        }
        return values2;
    }

    private String runWifiUtil(String method, String ... args) throws DeviceNotAvailableException {
        return this.runWifiUtil(method, 5L, args);
    }

    private String runWifiUtil(String method, long timeout, String ... args) throws DeviceNotAvailableException {
        String cmd = WifiHelper.buildWifiUtilCmd(method, args);
        WifiUtilOutput parser = new WifiUtilOutput();
        this.mDevice.executeShellCommand(cmd, parser, timeout, timeout, TimeUnit.MINUTES, 0);
        if (parser.getError() != null) {
            String errorMessage = String.format("Failed to %s due to: '%s'. See logcat for details.", method, parser.getError());
            LogUtil.CLog.e(errorMessage);
        }
        return parser.getResult();
    }

    static String buildWifiUtilCmd(String method, String ... args) {
        HashMap<String, String> argMap = new HashMap<String, String>();
        argMap.put("method", method);
        if ((args.length & 1) == 1) {
            throw new IllegalArgumentException("args should have even length, consisting of key and value pairs");
        }
        for (int i = 0; i < args.length; i += 2) {
            if (args[i + 1] == null) continue;
            argMap.put(args[i], args[i + 1]);
        }
        return WifiHelper.buildWifiUtilCmdFromMap(argMap);
    }

    static String buildWifiUtilCmdFromMap(Map<String, String> args) {
        StringBuilder sb = new StringBuilder("am instrument");
        for (Map.Entry<String, String> arg : args.entrySet()) {
            sb.append(" -e ");
            sb.append(arg.getKey());
            sb.append(" ");
            sb.append(WifiHelper.quote(arg.getValue()));
        }
        sb.append(" -w ");
        sb.append(INSTRUMENTATION_PKG);
        sb.append("/");
        sb.append(INSTRUMENTATION_CLASS);
        return sb.toString();
    }

    private static int asInt(String str) {
        if (str == null) {
            return -1;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static boolean asBool(String str) {
        return "true".equals(str);
    }

    private static String quote(String str) {
        return "'" + str.replace("'", "'\\''") + "'";
    }

    @Override
    public void cleanUp() throws DeviceNotAvailableException {
        String output = this.mDevice.uninstallPackage(INSTRUMENTATION_PKG);
        if (output != null) {
            LogUtil.CLog.w("Error '%s' occurred when uninstalling %s", output, INSTRUMENTATION_PKG);
        } else {
            LogUtil.CLog.d("Successfully clean up WifiHelper.");
        }
    }

    private static class WifiUtilOutput
    extends MultiLineReceiver {
        private static final Pattern RESULT_PAT = Pattern.compile("INSTRUMENTATION_RESULT: result=(.*)");
        private static final Pattern ERROR_PAT = Pattern.compile("INSTRUMENTATION_RESULT: error=(.*)");
        private String mResult = null;
        private String mError = null;

        private WifiUtilOutput() {
        }

        @Override
        public void processNewLines(String[] lines) {
            for (String line : lines) {
                Matcher resultMatcher = RESULT_PAT.matcher(line);
                if (resultMatcher.matches()) {
                    this.mResult = resultMatcher.group(1);
                    continue;
                }
                Matcher errorMatcher = ERROR_PAT.matcher(line);
                if (!errorMatcher.matches()) continue;
                this.mError = errorMatcher.group(1);
            }
        }

        String getResult() {
            return this.mResult;
        }

        String getError() {
            return this.mError;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }
    }
}

