/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.battery;

import com.android.ddmlib.IDevice;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.device.battery.IBatteryInfo;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.StreamUtil;
import com.google.common.collect.ImmutableSet;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class BatteryController {
    private static Map<String, IBatteryInfo> sSupportProduct = new HashMap<String, IBatteryInfo>();
    private static final Set<String> BATTERY_CONFIGS = ImmutableSet.of("/battery_config/battery.cfg", "/battery_config/google_battery.cfg");
    private static boolean sConfigLoaded = false;

    public static IBatteryInfo.BatteryState getDeviceChargingState(ITestDevice device) throws DeviceNotAvailableException {
        IDevice idevice;
        if (!sConfigLoaded) {
            BatteryController.loadConfigs();
        }
        if ((idevice = device.getIDevice()) instanceof StubDevice) {
            return IBatteryInfo.BatteryState.UNDEFINED;
        }
        String product = device.getProductType();
        IBatteryInfo info = sSupportProduct.get(product);
        if (info == null) {
            LogUtil.CLog.d("Device product %s is not supported. Check battery_config/battery.csv.", product);
            return IBatteryInfo.BatteryState.UNDEFINED;
        }
        if (!device.isAdbRoot()) {
            return IBatteryInfo.BatteryState.INFEASIBLE;
        }
        return info.checkBatteryState(device);
    }

    public static IBatteryInfo getBatteryInfoForDevice(ITestDevice device) {
        if (!sConfigLoaded) {
            BatteryController.loadConfigs();
        }
        String product = null;
        try {
            product = device.getProductType();
            return sSupportProduct.get(product);
        }
        catch (DeviceNotAvailableException e) {
            LogUtil.CLog.e("Failed to get the device product type for getBatteryInfoForDevice.");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadConfigs() {
        Class<BatteryController> clazz = BatteryController.class;
        synchronized (BatteryController.class) {
            for (String resourceConfig : BATTERY_CONFIGS) {
                Closeable reader = null;
                try {
                    InputStream resStream = BatteryController.class.getResourceAsStream(resourceConfig);
                    try {
                        if (resStream == null) {
                            LogUtil.CLog.w("No battery configuration file for resource: %s", resourceConfig);
                            continue;
                        }
                        Properties properties = new Properties();
                        properties.load(resStream);
                        for (Object key : properties.keySet()) {
                            String deviceName = (String)key;
                            String batteryClass = (String)properties.get(key);
                            try {
                                Object battery = Class.forName(batteryClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                                if (!(battery instanceof IBatteryInfo)) continue;
                                sSupportProduct.put(deviceName, (IBatteryInfo)battery);
                            }
                            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                                LogUtil.CLog.e(e);
                            }
                        }
                    }
                    finally {
                        if (resStream == null) continue;
                        resStream.close();
                    }
                }
                catch (IOException e) {
                    LogUtil.CLog.e(e);
                }
                finally {
                    StreamUtil.close(reader);
                }
            }
            sConfigLoaded = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

