/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.cloud;

import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class AcloudConfigParser {
    private Map<String, String> mConfigValues = new HashMap<String, String>();

    private AcloudConfigParser() {
    }

    public static AcloudConfigParser parseConfig(File configFile) {
        if (configFile == null || !configFile.exists()) {
            LogUtil.CLog.e("Could not read acloud config file: %s.", configFile);
            return null;
        }
        AcloudConfigParser config = new AcloudConfigParser();
        try {
            String[] lines;
            String content = FileUtil.readStringFromFile(configFile);
            for (String line : lines = content.split("\n")) {
                if (!line.contains(": ")) continue;
                String key = line.split(": ")[0];
                String value = line.split(": ")[1].replace("\"", "");
                config.mConfigValues.put(key, value);
            }
        }
        catch (IOException e) {
            LogUtil.CLog.e(e);
            return null;
        }
        return config;
    }

    public String getValueForKey(AcloudKeys key) {
        return this.mConfigValues.get(key.toString());
    }

    public static enum AcloudKeys {
        SERVICE_ACCOUNT_NAME("service_account_name"),
        SERVICE_ACCOUNT_PRIVATE_KEY("service_account_private_key_path"),
        ZONE("zone"),
        PROJECT("project"),
        MACHINE_TYPE("machine_type"),
        SERVICE_ACCOUNT_JSON_PRIVATE_KEY("service_account_json_private_key_path"),
        STABLE_HOST_IMAGE_NAME("stable_host_image_name"),
        STABLE_HOST_IMAGE_PROJECT("stable_host_image_project");

        private String mName;

        private AcloudKeys(String name) {
            this.mName = name;
        }

        public String toString() {
            return this.mName;
        }
    }
}

