/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.cloud;

import com.android.tradefed.device.TestDeviceOptions;
import com.android.tradefed.device.cloud.GceAvdInfo;
import com.android.tradefed.device.cloud.GceManager;
import com.android.tradefed.device.cloud.RemoteFileUtil;
import com.android.tradefed.device.cloud.RemoteSshUtil;
import com.android.tradefed.log.ITestLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ByteArrayInputStreamSource;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.MultiMap;
import com.android.tradefed.util.ZipUtil;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CommonLogRemoteFileUtil {
    public static final String NESTED_REMOTE_LOG_DIR = "/home/%s/cuttlefish_runtime/";
    public static final String EMULATOR_REMOTE_LOG_DIR = "/home/%s/log/";
    public static final String TOMBSTONES_ZIP_NAME = "tombstones-zip";
    public static final String OXYGEN_EMULATOR_LOG_DIR = "/tmp/device_launcher/";
    public static final String OXYGEN_CUTTLEFISH_LOG_DIR = "/tmp/cfbase/3/cuttlefish/instances/cvd-1/logs/";
    public static final String OXYGEN_RUNTIME_LOG_DIR = "/tmp/cfbase/3/cuttlefish_runtime/";
    public static final String OXYGEN_GOLDFISH_LOG_DIR = "/tmp/android_platform_gf*/logs/";
    public static final String NETSIM_LOG_DIR = "/tmp/android/netsimd/";
    public static final String NETSIM_USER_LOG_DIR = "/tmp/android-%s/netsimd/";
    public static final List<KnownLogFileEntry> NETSIM_LOG_FILES = new ArrayList<KnownLogFileEntry>();
    public static final List<KnownLogFileEntry> OXYGEN_LOG_FILES = new ArrayList<KnownLogFileEntry>();
    public static final List<KnownLogFileEntry> OXYGEN_LOG_FILES_FALLBACK = new ArrayList<KnownLogFileEntry>();
    public static final MultiMap<TestDeviceOptions.InstanceType, KnownLogFileEntry> KNOWN_FILES_TO_FETCH = new MultiMap();

    public static void fetchCommonFiles(ITestLogger testLogger, GceAvdInfo gceAvd, TestDeviceOptions options, IRunUtil runUtil) {
        if (gceAvd == null || gceAvd.hostAndPort() == null) {
            LogUtil.CLog.e("GceAvdInfo or its host setting was null, cannot collect remote files.");
            return;
        }
        List<KnownLogFileEntry> toFetch = null;
        if (options.useOxygen()) {
            toFetch = new ArrayList<KnownLogFileEntry>(OXYGEN_LOG_FILES);
            if (!RemoteFileUtil.doesRemoteFileExist(gceAvd, options, runUtil, 60000L, OXYGEN_CUTTLEFISH_LOG_DIR)) {
                toFetch.addAll(OXYGEN_LOG_FILES_FALLBACK);
            }
        } else {
            boolean reported = false;
            for (GceAvdInfo.LogFileEntry entry : gceAvd.getLogs()) {
                if (!CommonLogRemoteFileUtil.logRemoteFile(testLogger, gceAvd, options, runUtil, entry.path, entry.type, Strings.isNullOrEmpty(entry.name) ? null : entry.name)) continue;
                reported = true;
            }
            if (!reported) {
                LogUtil.CLog.i("GceAvdInfo does not contain logs. Fall back to known log files.");
                toFetch = KNOWN_FILES_TO_FETCH.get(options.getInstanceType());
            }
        }
        if (toFetch != null) {
            toFetch.addAll(NETSIM_LOG_FILES);
            for (KnownLogFileEntry entry : toFetch) {
                CommonLogRemoteFileUtil.logRemoteFile(testLogger, gceAvd, options, runUtil, String.format(entry.path, options.getInstanceUser()), entry.type, entry.logName);
            }
        }
        if (options.getRemoteFetchFilePattern().isEmpty()) {
            return;
        }
        for (String file2 : options.getRemoteFetchFilePattern()) {
            CommonLogRemoteFileUtil.logRemoteFile(testLogger, gceAvd, options, runUtil, file2, LogDataType.CUTTLEFISH_LOG, null);
        }
    }

    public static boolean isRemoteGceReachableBySsh(GceAvdInfo gceAvd, TestDeviceOptions options, IRunUtil runUtil) {
        CommandStatus sshAttemptStatus = RemoteSshUtil.remoteSshCommandExec(gceAvd, options, runUtil, 10000L, "exit").getStatus();
        if (!CommandStatus.SUCCESS.equals((Object)sshAttemptStatus)) {
            LogUtil.CLog.e(String.format("Unable to ssh to the remote GCE, ssh failed with status %s.", new Object[]{sshAttemptStatus}));
            return false;
        }
        return true;
    }

    public static void logRemoteCommandOutput(ITestLogger testLogger, GceAvdInfo gceAvd, TestDeviceOptions options, IRunUtil runUtil, String logName, String ... remoteCommand) {
        if (gceAvd == null || gceAvd.hostAndPort() == null) {
            LogUtil.CLog.e("GceAvdInfo or its host setting was null, cannot collect remote files.");
            return;
        }
        CommandResult commandResult = GceManager.remoteSshCommandExecution(gceAvd, options, runUtil, 60000L, remoteCommand);
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("Command: %s\n", Arrays.asList(remoteCommand)));
        builder.append(String.format("Exit code: %d, Status: %s\n", new Object[]{commandResult.getExitCode(), commandResult.getStatus()}));
        builder.append(String.format("stdout:\n%s\n", commandResult.getStdout()));
        builder.append(String.format("stderr:\n%s\n", commandResult.getStderr()));
        testLogger.testLog(logName, LogDataType.CUTTLEFISH_LOG, new ByteArrayInputStreamSource(builder.toString().getBytes()));
    }

    public static void fetchTombstones(ITestLogger testLogger, GceAvdInfo gceAvd, TestDeviceOptions options, IRunUtil runUtil) {
        String pattern;
        CommandResult resultList;
        if (gceAvd == null || gceAvd.hostAndPort() == null) {
            LogUtil.CLog.e("GceAvdInfo or its host setting was null, cannot collect remote files.");
            return;
        }
        TestDeviceOptions.InstanceType type = options.getInstanceType();
        if (!TestDeviceOptions.InstanceType.CUTTLEFISH.equals((Object)type) && !TestDeviceOptions.InstanceType.REMOTE_AVD.equals((Object)type)) {
            return;
        }
        String path = String.format("/home/%s/cuttlefish_runtime/tombstones", options.getInstanceUser());
        for (GceAvdInfo.LogFileEntry entry : gceAvd.getLogs()) {
            if (!entry.name.equals(TOMBSTONES_ZIP_NAME)) continue;
            path = entry.path;
            break;
        }
        if (!CommandStatus.SUCCESS.equals((Object)(resultList = GceManager.remoteSshCommandExecution(gceAvd, options, runUtil, 60000L, "ls", "-A1", pattern = path + "/*")).getStatus())) {
            LogUtil.CLog.e("Failed to list the tombstones: %s", resultList.getStderr());
            return;
        }
        if (resultList.getStdout().split("\n").length <= 0) {
            return;
        }
        File tombstonesDir = RemoteFileUtil.fetchRemoteDir(gceAvd, options, runUtil, 120000L, path);
        if (tombstonesDir == null) {
            LogUtil.CLog.w("No tombstones directory was pulled.");
            return;
        }
        try {
            File zipTombstones = ZipUtil.createZip(tombstonesDir);
            try (FileInputStreamSource source = new FileInputStreamSource(zipTombstones, true);){
                testLogger.testLog(TOMBSTONES_ZIP_NAME, LogDataType.TOMBSTONEZ, source);
            }
        }
        catch (IOException e) {
            LogUtil.CLog.e("Failed to zip the tombstones:");
            LogUtil.CLog.e(e);
        }
    }

    private static boolean logRemoteFile(ITestLogger testLogger, GceAvdInfo gceAvd, TestDeviceOptions options, IRunUtil runUtil, String fileToRetrieve, LogDataType logType, String baseName) {
        if (baseName != null && baseName.startsWith(TOMBSTONES_ZIP_NAME)) {
            return false;
        }
        return GceManager.logNestedRemoteFile(testLogger, gceAvd, options, runUtil, fileToRetrieve, logType, baseName);
    }

    static {
        KNOWN_FILES_TO_FETCH.put(TestDeviceOptions.InstanceType.CUTTLEFISH, new KnownLogFileEntry("/home/%s/fetcher_config.json", null, LogDataType.CUTTLEFISH_LOG));
        KNOWN_FILES_TO_FETCH.put(TestDeviceOptions.InstanceType.CUTTLEFISH, new KnownLogFileEntry("/home/%s/cuttlefish_runtime/kernel.log", null, LogDataType.CUTTLEFISH_LOG));
        KNOWN_FILES_TO_FETCH.put(TestDeviceOptions.InstanceType.CUTTLEFISH, new KnownLogFileEntry("/home/%s/cuttlefish_runtime/logcat", "full_gce_logcat", LogDataType.LOGCAT));
        KNOWN_FILES_TO_FETCH.put(TestDeviceOptions.InstanceType.CUTTLEFISH, new KnownLogFileEntry("/home/%s/cuttlefish_runtime/cuttlefish_config.json", null, LogDataType.CUTTLEFISH_LOG));
        KNOWN_FILES_TO_FETCH.put(TestDeviceOptions.InstanceType.CUTTLEFISH, new KnownLogFileEntry("/home/%s/cuttlefish_runtime/launcher.log", "cuttlefish_launcher.log", LogDataType.CUTTLEFISH_LOG));
        KNOWN_FILES_TO_FETCH.put(TestDeviceOptions.InstanceType.CUTTLEFISH, new KnownLogFileEntry("/home/%s/cuttlefish_runtime/crosvm_openwrt_boot.log", null, LogDataType.CUTTLEFISH_LOG));
        KNOWN_FILES_TO_FETCH.put(TestDeviceOptions.InstanceType.CUTTLEFISH, new KnownLogFileEntry("/home/%s/cuttlefish_runtime/crosvm_openwrt.log", null, LogDataType.CUTTLEFISH_LOG));
        KNOWN_FILES_TO_FETCH.put(TestDeviceOptions.InstanceType.CUTTLEFISH, new KnownLogFileEntry("/var/log/kern.log", "host_kernel.log", LogDataType.CUTTLEFISH_LOG));
        KNOWN_FILES_TO_FETCH.put(TestDeviceOptions.InstanceType.EMULATOR, new KnownLogFileEntry("/home/%s/log/logcat.log", "full_gce_emulator_logcat", LogDataType.LOGCAT));
        KNOWN_FILES_TO_FETCH.put(TestDeviceOptions.InstanceType.EMULATOR, new KnownLogFileEntry("/home/%s/log/adb.log", null, LogDataType.CUTTLEFISH_LOG));
        KNOWN_FILES_TO_FETCH.put(TestDeviceOptions.InstanceType.EMULATOR, new KnownLogFileEntry("/home/%s/log/kernel.log", null, LogDataType.CUTTLEFISH_LOG));
        KNOWN_FILES_TO_FETCH.put(TestDeviceOptions.InstanceType.EMULATOR, new KnownLogFileEntry("/var/log/daemon.log", null, LogDataType.CUTTLEFISH_LOG));
        KNOWN_FILES_TO_FETCH.put(TestDeviceOptions.InstanceType.EMULATOR, new KnownLogFileEntry("/var/log/kern.log", "host_kernel.log", LogDataType.CUTTLEFISH_LOG));
        OXYGEN_LOG_FILES.add(new KnownLogFileEntry(OXYGEN_EMULATOR_LOG_DIR, null, LogDataType.DIR));
        OXYGEN_LOG_FILES.add(new KnownLogFileEntry(OXYGEN_CUTTLEFISH_LOG_DIR, null, LogDataType.DIR));
        OXYGEN_LOG_FILES.add(new KnownLogFileEntry(OXYGEN_GOLDFISH_LOG_DIR, null, LogDataType.DIR));
        NETSIM_LOG_FILES.add(new KnownLogFileEntry(NETSIM_LOG_DIR, null, LogDataType.DIR));
        NETSIM_LOG_FILES.add(new KnownLogFileEntry(NETSIM_USER_LOG_DIR, null, LogDataType.DIR));
        OXYGEN_LOG_FILES_FALLBACK.add(new KnownLogFileEntry("/tmp/cfbase/3/cuttlefish_runtime/launcher.log", null, LogDataType.CUTTLEFISH_LOG));
        OXYGEN_LOG_FILES_FALLBACK.add(new KnownLogFileEntry("/tmp/cfbase/3/cuttlefish_runtime/crosvm_openwrt_boot.log", null, LogDataType.CUTTLEFISH_LOG));
        OXYGEN_LOG_FILES_FALLBACK.add(new KnownLogFileEntry("/tmp/cfbase/3/cuttlefish_runtime/crosvm_openwrt.log", null, LogDataType.CUTTLEFISH_LOG));
        OXYGEN_LOG_FILES_FALLBACK.add(new KnownLogFileEntry("/tmp/cfbase/3/cuttlefish_runtime/vdl_stdout.txt", null, LogDataType.CUTTLEFISH_LOG));
        OXYGEN_LOG_FILES_FALLBACK.add(new KnownLogFileEntry("/tmp/cfbase/3/cuttlefish_runtime/kernel.log", null, LogDataType.CUTTLEFISH_LOG));
        OXYGEN_LOG_FILES_FALLBACK.add(new KnownLogFileEntry("/tmp/cfbase/3/cuttlefish_runtime/logcat", null, LogDataType.CUTTLEFISH_LOG));
    }

    public static class KnownLogFileEntry {
        public String path;
        public String logName;
        public LogDataType type;

        KnownLogFileEntry(String path, String logName, LogDataType type) {
            this.path = path;
            this.logName = logName;
            this.type = type;
        }
    }
}

