/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.cloud;

import com.android.tradefed.command.remote.DeviceDescriptor;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.HostAndPort;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GceAvdInfo {
    private static final LinkedHashMap<InfraErrorIdentifier, String> OXYGEN_ERROR_PATTERN_MAP = new LinkedHashMap();
    private static final ImmutableMap<InfraErrorIdentifier, String> OXYGEN_ERROR_MESSAGE_MAP;
    public static final List<String> BUILD_VARS;
    private String mInstanceName;
    private HostAndPort mHostAndPort;
    private ErrorIdentifier mErrorType;
    private String mErrors;
    private GceStatus mStatus;
    private HashMap<String, String> mBuildVars;
    private List<LogFileEntry> mLogs;
    private boolean mIsIpPreconfigured = false;
    private Integer mDeviceOffset = null;
    private String mInstanceUser = null;
    private boolean mSkipBugreportCollection = false;

    public GceAvdInfo(String instanceName, HostAndPort hostAndPort) {
        this.mInstanceName = instanceName;
        this.mHostAndPort = hostAndPort;
        this.mBuildVars = new HashMap();
        this.mLogs = new ArrayList<LogFileEntry>();
    }

    public GceAvdInfo(String instanceName, HostAndPort hostAndPort, ErrorIdentifier errorType, String errors, GceStatus status) {
        this(instanceName, hostAndPort);
        this.mErrorType = errorType;
        this.mErrors = errors;
        this.mStatus = status;
    }

    public String toString() {
        return "GceAvdInfo [mInstanceName=" + this.mInstanceName + ", mHostAndPort=" + this.mHostAndPort + ", mDeviceOffset=" + this.mDeviceOffset + ", mInstanceUser=" + this.mInstanceUser + ", mErrorType=" + this.mErrorType + ", mErrors=" + this.mErrors + ", mStatus=" + (Object)((Object)this.mStatus) + ", mIsIpPreconfigured=" + this.mIsIpPreconfigured + ", mBuildVars=" + this.mBuildVars.toString() + ", mLogs=" + this.mLogs.toString() + "]";
    }

    public String instanceName() {
        return this.mInstanceName;
    }

    public HostAndPort hostAndPort() {
        return this.mHostAndPort;
    }

    public ErrorIdentifier getErrorType() {
        return this.mErrorType;
    }

    public void setErrorType(ErrorIdentifier errorType) {
        this.mErrorType = errorType;
    }

    public String getErrors() {
        return this.mErrors;
    }

    public void setErrors(String errors) {
        this.mErrors = errors;
    }

    public List<LogFileEntry> getLogs() {
        return this.mLogs;
    }

    public GceStatus getStatus() {
        return this.mStatus;
    }

    public void setStatus(GceStatus status) {
        this.mStatus = status;
    }

    private void addBuildVar(String buildKey, String buildValue) {
        this.mBuildVars.put(buildKey, buildValue);
    }

    public void setIpPreconfigured(boolean isIpPreconfigured) {
        this.mIsIpPreconfigured = isIpPreconfigured;
    }

    public boolean isIpPreconfigured() {
        return this.mIsIpPreconfigured;
    }

    public void setDeviceOffset(Integer deviceOffset) {
        this.mDeviceOffset = deviceOffset;
    }

    public Integer getDeviceOffset() {
        return this.mDeviceOffset;
    }

    public void setInstanceUser(String instanceUser) {
        this.mInstanceUser = instanceUser;
    }

    public String getInstanceUser() {
        return this.mInstanceUser;
    }

    public HashMap<String, String> getBuildVars() {
        return new HashMap<String, String>(this.mBuildVars);
    }

    public boolean getSkipBugreportCollection() {
        return this.mSkipBugreportCollection;
    }

    public void setSkipBugreportCollection(boolean skipBugreportCollection) {
        this.mSkipBugreportCollection = skipBugreportCollection;
    }

    public static GceAvdInfo parseGceInfoFromFile(File f, DeviceDescriptor descriptor, int remoteAdbPort) throws TargetSetupError {
        String data;
        try {
            data = FileUtil.readStringFromFile(f);
        }
        catch (IOException e) {
            LogUtil.CLog.e("Failed to read result file from GCE driver:");
            LogUtil.CLog.e(e);
            return null;
        }
        return GceAvdInfo.parseGceInfoFromString(data, descriptor, remoteAdbPort);
    }

    public static GceAvdInfo parseGceInfoFromString(String data, DeviceDescriptor descriptor, int remoteAdbPort) throws TargetSetupError {
        if (Strings.isNullOrEmpty(data)) {
            LogUtil.CLog.w("No data provided");
            return null;
        }
        InfraErrorIdentifier errorId = null;
        String errors = data;
        try {
            errors = GceAvdInfo.parseErrorField(data);
            JSONObject res = new JSONObject(data);
            String status = res.getString("status");
            GceStatus gceStatus = GceStatus.valueOf(status);
            String errorType = res.has("error_type") ? res.getString("error_type") : null;
            InfraErrorIdentifier infraErrorIdentifier = errorId = GceStatus.SUCCESS.equals((Object)gceStatus) ? null : GceAvdInfo.determineAcloudErrorType(errorType);
            if (errorId == InfraErrorIdentifier.ACLOUD_OXYGEN_LEASE_ERROR) {
                errorId = GceAvdInfo.refineOxygenErrorType(errors);
            }
            JSONArray devices = null;
            if (GceStatus.FAIL.equals((Object)gceStatus) || GceStatus.BOOT_FAIL.equals((Object)gceStatus)) {
                if (res.getJSONObject("data").has("devices_failing_boot")) {
                    devices = res.getJSONObject("data").getJSONArray("devices_failing_boot");
                }
            } else {
                devices = res.getJSONObject("data").getJSONArray("devices");
            }
            if (devices != null) {
                if (devices.length() == 1) {
                    JSONObject d = (JSONObject)devices.get(0);
                    GceAvdInfo.addCfStartTimeMetrics(d);
                    String ip = d.getString("ip");
                    String instanceName = d.getString("instance_name");
                    GceAvdInfo avdInfo = new GceAvdInfo(instanceName, HostAndPort.fromString(ip).withDefaultPort(remoteAdbPort), errorId, errors, gceStatus);
                    avdInfo.mLogs.addAll(GceAvdInfo.parseLogField(d));
                    for (String buildVar : BUILD_VARS) {
                        if (!d.has(buildVar) || d.getString(buildVar).trim().isEmpty()) continue;
                        avdInfo.addBuildVar(buildVar, d.getString(buildVar).trim());
                    }
                    return avdInfo;
                }
                LogUtil.CLog.w("Expected only one device to return but found %d", devices.length());
            } else {
                LogUtil.CLog.w("No device information, device was not started.");
            }
        }
        catch (JSONException e) {
            LogUtil.CLog.e("Failed to parse JSON %s:", data);
            LogUtil.CLog.e(e);
        }
        if (errorId == null) {
            errorId = InfraErrorIdentifier.ACLOUD_UNDETERMINED;
        }
        throw new TargetSetupError(String.format("acloud errors: %s", !errors.isEmpty() ? errors : data), descriptor, (ErrorIdentifier)errorId);
    }

    public static List<GceAvdInfo> parseGceInfoFromOxygenClientOutput(CommandResult oxygenRes, int remoteAdbPort) throws TargetSetupError {
        CommandStatus oxygenCliStatus = oxygenRes.getStatus();
        if (CommandStatus.SUCCESS.equals((Object)oxygenCliStatus)) {
            return GceAvdInfo.parseSucceedOxygenClientOutput(oxygenRes.getStdout() + oxygenRes.getStderr(), remoteAdbPort);
        }
        if (CommandStatus.TIMED_OUT.equals((Object)oxygenCliStatus)) {
            return Arrays.asList(new GceAvdInfo(null, null, InfraErrorIdentifier.OXYGEN_CLIENT_BINARY_TIMEOUT, "Oxygen client binary CLI timed out", GceStatus.FAIL));
        }
        LogUtil.CLog.d("OxygenClient - CommandStatus: %s, output: %s\", output", new Object[]{oxygenCliStatus, oxygenRes.getStdout() + " " + oxygenRes.getStderr()});
        InfraErrorIdentifier identifier = GceAvdInfo.refineOxygenErrorType(oxygenRes.getStderr());
        throw new TargetSetupError(OXYGEN_ERROR_MESSAGE_MAP.getOrDefault(identifier, "Oxygen client failed to lease a device"), (Throwable)new Exception(oxygenRes.getStderr()), (ErrorIdentifier)identifier);
    }

    private static List<GceAvdInfo> parseSucceedOxygenClientOutput(String output, int remoteAdbPort) throws TargetSetupError {
        LogUtil.CLog.d("Parsing oxygen client output: %s", output);
        Pattern pattern = Pattern.compile("session_id:\"(.*?)\".*?server_url:\"(.*?)\".*?oxygen_version:\"(.*?)\"", 32);
        Matcher matcher = pattern.matcher(output);
        ArrayList<GceAvdInfo> gceAvdInfos = new ArrayList<GceAvdInfo>();
        int deviceOffset = 0;
        while (matcher.find()) {
            String sessionId = matcher.group(1);
            String serverUrl = matcher.group(2);
            String oxygenVersion = matcher.group(3);
            gceAvdInfos.add(new GceAvdInfo(sessionId, HostAndPort.fromString(serverUrl).withDefaultPort(remoteAdbPort + deviceOffset), null, null, GceStatus.SUCCESS));
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.CF_OXYGEN_VERSION, oxygenVersion);
            ++deviceOffset;
        }
        if (gceAvdInfos.isEmpty()) {
            throw new TargetSetupError(String.format("Failed to parse the output: %s", output), (ErrorIdentifier)InfraErrorIdentifier.OXYGEN_CLIENT_BINARY_ERROR);
        }
        return gceAvdInfos;
    }

    @VisibleForTesting
    static InfraErrorIdentifier refineOxygenErrorType(String errors) {
        for (Map.Entry<InfraErrorIdentifier, String> entry : OXYGEN_ERROR_PATTERN_MAP.entrySet()) {
            if (!errors.contains(entry.getValue())) continue;
            return entry.getKey();
        }
        return InfraErrorIdentifier.ACLOUD_OXYGEN_LEASE_ERROR;
    }

    private static String parseErrorField(String data) throws JSONException {
        String res = "";
        JSONObject response = new JSONObject(data);
        JSONArray errors = response.getJSONArray("errors");
        for (int i = 0; i < errors.length(); ++i) {
            res = res + errors.getString(i) + "\n";
        }
        return res;
    }

    private static List<LogFileEntry> parseLogField(JSONObject device) throws JSONException {
        ArrayList<LogFileEntry> logs = new ArrayList<LogFileEntry>();
        JSONArray logArray = device.optJSONArray("logs");
        if (logArray == null) {
            return logs;
        }
        for (int i = 0; i < logArray.length(); ++i) {
            JSONObject logObject = logArray.getJSONObject(i);
            logs.add(new LogFileEntry(logObject));
        }
        return logs;
    }

    @VisibleForTesting
    static InfraErrorIdentifier determineAcloudErrorType(String errorType) {
        InfraErrorIdentifier identifier;
        if (errorType == null || errorType.isEmpty()) {
            return InfraErrorIdentifier.ACLOUD_UNRECOGNIZED_ERROR_TYPE;
        }
        try {
            identifier = InfraErrorIdentifier.valueOf(errorType);
        }
        catch (Exception e) {
            identifier = InfraErrorIdentifier.ACLOUD_UNRECOGNIZED_ERROR_TYPE;
        }
        return identifier;
    }

    @VisibleForTesting
    static void addCfStartTimeMetrics(JSONObject json) {
        JSONObject fetch_cvd_wrapper_log;
        String launch_cvd_time;
        String gce_create_time;
        String fetch_artifact_time = json.optString("fetch_artifact_time");
        if (!fetch_artifact_time.isEmpty()) {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.CF_FETCH_ARTIFACT_TIME, Double.valueOf(Double.parseDouble(fetch_artifact_time) * 1000.0).longValue());
        }
        if (!(gce_create_time = json.optString("gce_create_time")).isEmpty()) {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.CF_GCE_CREATE_TIME, Double.valueOf(Double.parseDouble(gce_create_time) * 1000.0).longValue());
        }
        if (!(launch_cvd_time = json.optString("launch_cvd_time")).isEmpty()) {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.CF_LAUNCH_CVD_TIME, Double.valueOf(Double.parseDouble(launch_cvd_time) * 1000.0).longValue());
        }
        if ((fetch_cvd_wrapper_log = json.optJSONObject("fetch_cvd_wrapper_log")) != null) {
            String cf_artifacts_fetch_source;
            String cf_cache_wait_time_sec = fetch_cvd_wrapper_log.optString("cf_cache_wait_time_sec");
            if (!Strings.isNullOrEmpty(cf_cache_wait_time_sec)) {
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.CF_CACHE_WAIT_TIME, Integer.parseInt(cf_cache_wait_time_sec));
            }
            if (!Strings.isNullOrEmpty(cf_artifacts_fetch_source = fetch_cvd_wrapper_log.optString("cf_artifacts_fetch_source"))) {
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.CF_ARTIFACTS_FETCH_SOURCE, cf_artifacts_fetch_source);
            }
        }
        if (!InvocationMetricLogger.getInvocationMetrics().containsKey(InvocationMetricLogger.InvocationMetricKey.CF_INSTANCE_COUNT.toString())) {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.CF_INSTANCE_COUNT, 1L);
        }
    }

    static {
        OXYGEN_ERROR_PATTERN_MAP.put(InfraErrorIdentifier.OXYGEN_SERVER_SHUTTING_DOWN, "server_shutting_down");
        OXYGEN_ERROR_PATTERN_MAP.put(InfraErrorIdentifier.OXYGEN_BAD_GATEWAY_ERROR, "UNAVAILABLE: HTTP status code 502");
        OXYGEN_ERROR_PATTERN_MAP.put(InfraErrorIdentifier.OXYGEN_REQUEST_TIMEOUT, "DeadlineExceeded");
        OXYGEN_ERROR_PATTERN_MAP.put(InfraErrorIdentifier.OXYGEN_RESOURCE_EXHAUSTED, "ResourceExhausted");
        OXYGEN_ERROR_PATTERN_MAP.put(InfraErrorIdentifier.OXYGEN_NOT_ENOUGH_RESOURCE, "Oxygen currently doesn't have enough resources to fulfil this request");
        OXYGEN_ERROR_PATTERN_MAP.put(InfraErrorIdentifier.OXYGEN_SERVER_CONNECTION_FAILURE, "Bad Gateway");
        OXYGEN_ERROR_PATTERN_MAP.put(InfraErrorIdentifier.OXYGEN_CLIENT_LEASE_ERROR, "OxygenClient");
        OXYGEN_ERROR_PATTERN_MAP.put(InfraErrorIdentifier.OXYGEN_DEVICE_LAUNCHER_TIMEOUT, "Lease aborted due to launcher failure: Timed out waiting for virtual device to start");
        OXYGEN_ERROR_PATTERN_MAP.put(InfraErrorIdentifier.OXYGEN_DEVICE_LAUNCHER_FAILURE, "Lease aborted due to launcher failure");
        OXYGEN_ERROR_PATTERN_MAP.put(InfraErrorIdentifier.OXYGEN_SERVER_LB_CONNECTION_ERROR, "desc = connection error");
        OXYGEN_ERROR_MESSAGE_MAP = ImmutableMap.of(InfraErrorIdentifier.OXYGEN_DEVICE_LAUNCHER_FAILURE, "AVD failed to boot up properly", InfraErrorIdentifier.OXYGEN_SERVER_SHUTTING_DOWN, "Unexpected error from Oxygen service", InfraErrorIdentifier.OXYGEN_BAD_GATEWAY_ERROR, "Unexpected error from Oxygen service", InfraErrorIdentifier.OXYGEN_REQUEST_TIMEOUT, "Unexpected error from Oxygen service. Request timed out.", InfraErrorIdentifier.OXYGEN_RESOURCE_EXHAUSTED, "Oxygen ran out of capacity to lease virtual device", InfraErrorIdentifier.OXYGEN_SERVER_CONNECTION_FAILURE, "Unexpected error from Oxygen service", InfraErrorIdentifier.OXYGEN_CLIENT_LEASE_ERROR, "Oxygen client failed to lease a device", InfraErrorIdentifier.OXYGEN_DEVICE_LAUNCHER_TIMEOUT, "AVD boot timed out");
        BUILD_VARS = Arrays.asList("build_id", "build_target", "branch", "kernel_build_id", "kernel_build_target", "kernel_branch", "system_build_id", "system_build_target", "system_branch", "emulator_build_id", "emulator_build_target", "emulator_branch");
    }

    public static enum GceStatus {
        SUCCESS,
        FAIL,
        BOOT_FAIL,
        DEVICE_OFFLINE;

    }

    public static class LogFileEntry {
        public final String path;
        public final LogDataType type;
        public final String name;

        @VisibleForTesting
        LogFileEntry(String path, LogDataType type, String name) {
            this.path = path;
            this.type = type;
            this.name = name;
        }

        LogFileEntry(JSONObject log) throws JSONException {
            this.path = log.getString("path");
            this.type = this.parseLogDataType(log.getString("type"));
            this.name = log.optString("name", "");
        }

        private LogDataType parseLogDataType(String typeString) {
            try {
                return LogDataType.valueOf(typeString);
            }
            catch (IllegalArgumentException e) {
                LogUtil.CLog.w("Unknown log type in GCE AVD info: %s", typeString);
                return LogDataType.UNKNOWN;
            }
        }
    }
}

