/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.cloud;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.command.remote.DeviceDescriptor;
import com.android.tradefed.device.TestDeviceOptions;
import com.android.tradefed.device.cloud.AcloudConfigParser;
import com.android.tradefed.device.cloud.CommonLogRemoteFileUtil;
import com.android.tradefed.device.cloud.GceAvdInfo;
import com.android.tradefed.device.cloud.OxygenClient;
import com.android.tradefed.device.cloud.OxygenUtil;
import com.android.tradefed.device.cloud.RemoteFileUtil;
import com.android.tradefed.device.cloud.RemoteSshUtil;
import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.log.ITestLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ByteArrayInputStreamSource;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.ArrayUtil;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.GoogleApiClientUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.MultiMap;
import com.android.tradefed.util.RunUtil;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.SerialPortOutput;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.net.HostAndPort;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GceManager {
    public static final String GCE_INSTANCE_NAME_KEY = "gce-instance-name";
    public static final String GCE_HOSTNAME_KEY = "gce-hostname";
    public static final String GCE_INSTANCE_CLEANED_KEY = "gce-instance-clean-called";
    public static final String GCE_IP_PRECONFIGURED_KEY = "gce-ip-pre-configured";
    private static final long BUGREPORT_TIMEOUT = 300000L;
    private static final long REMOTE_FILE_OP_TIMEOUT = 600000L;
    private static final Pattern BUGREPORTZ_RESPONSE_PATTERN = Pattern.compile("(OK:)(.*)");
    private static final JsonFactory JSON_FACTORY = GsonFactory.getDefaultInstance();
    private static final List<String> SCOPES = Arrays.asList("https://www.googleapis.com/auth/compute.readonly");
    private static final List<InfraErrorIdentifier> RETRIABLE_LEASE_ERRORS = new ArrayList<InfraErrorIdentifier>(Arrays.asList(InfraErrorIdentifier.OXYGEN_BAD_GATEWAY_ERROR, InfraErrorIdentifier.OXYGEN_CLIENT_BINARY_ERROR, InfraErrorIdentifier.OXYGEN_SERVER_CONNECTION_FAILURE, InfraErrorIdentifier.OXYGEN_SERVER_LB_CONNECTION_ERROR, InfraErrorIdentifier.OXYGEN_SERVER_SHUTTING_DOWN));
    private static final int MAX_LEASE_RETRIES = 3;
    private DeviceDescriptor mDeviceDescriptor;
    private TestDeviceOptions mDeviceOptions;
    private IBuildInfo mBuildInfo;
    private String mGceInstanceName = null;
    private String mGceHost = null;
    private GceAvdInfo mGceAvdInfo = null;
    private boolean mSkipSerialLogCollection = false;

    public GceManager(DeviceDescriptor deviceDesc, TestDeviceOptions deviceOptions, IBuildInfo buildInfo) {
        this.mDeviceDescriptor = deviceDesc;
        this.mDeviceOptions = deviceOptions;
        this.mBuildInfo = buildInfo;
        if (!deviceOptions.allowGceCmdTimeoutOverride()) {
            return;
        }
        int index = deviceOptions.getGceDriverParams().lastIndexOf("--boot-timeout");
        if (index != -1 && deviceOptions.getGceDriverParams().size() > index + 1) {
            String driverTimeoutStringSec = deviceOptions.getGceDriverParams().get(index + 1);
            try {
                long driverTimeoutMs = Long.parseLong(driverTimeoutStringSec) * 1000L + 180000L;
                long gceCmdTimeoutMs = deviceOptions.getGceCmdTimeout();
                deviceOptions.setGceCmdTimeout(driverTimeoutMs);
                LogUtil.CLog.i("Replacing --gce-boot-timeout %s by --boot-timeout %s.", gceCmdTimeoutMs, driverTimeoutMs);
            }
            catch (NumberFormatException e) {
                LogUtil.CLog.e(e);
            }
        }
    }

    @Deprecated
    public GceManager(DeviceDescriptor deviceDesc, TestDeviceOptions deviceOptions, IBuildInfo buildInfo, List<IBuildInfo> testResourceBuildInfos) {
        this(deviceDesc, deviceOptions, buildInfo);
    }

    public GceManager(DeviceDescriptor deviceDesc, TestDeviceOptions deviceOptions, IBuildInfo buildInfo, String gceInstanceName, String gceHost) {
        this(deviceDesc, deviceOptions, buildInfo);
        this.mGceInstanceName = gceInstanceName;
        this.mGceHost = gceHost;
    }

    public GceAvdInfo startGce() throws TargetSetupError {
        return this.startGce(null, null, null, null);
    }

    public GceAvdInfo startGce(String ipDevice, MultiMap<String, String> attributes) throws TargetSetupError {
        return this.startGce(ipDevice, null, null, attributes);
    }

    public GceAvdInfo startGce(String ipDevice, String user, Integer offset, MultiMap<String, String> attributes) throws TargetSetupError {
        return this.startGce(ipDevice, user, offset, attributes, null);
    }

    public GceAvdInfo startGce(String ipDevice, String user, Integer offset, MultiMap<String, String> attributes, ITestLogger logger) throws TargetSetupError {
        boolean bl = this.mSkipSerialLogCollection = !Strings.isNullOrEmpty(ipDevice) || this.getTestDeviceOptions().useOxygen();
        if (this.getTestDeviceOptions().useOxygen()) {
            return this.startGceWithOxygenClient(logger, attributes);
        }
        return this.startGceWithAcloud(ipDevice, user, offset, attributes);
    }

    @Deprecated
    public List<GceAvdInfo> startMultiDevicesGce(List<IBuildInfo> buildInfos) throws TargetSetupError {
        return this.startMultiDevicesGce(buildInfos, null);
    }

    public List<GceAvdInfo> startMultiDevicesGce(List<IBuildInfo> buildInfos, MultiMap<String, String> attributes) throws TargetSetupError {
        long startTime = System.currentTimeMillis();
        try {
            CloseableTraceScope ignore = new CloseableTraceScope("startMultiDevicesGce");
            try {
                OxygenClient oxygenClient = new OxygenClient(this.getTestDeviceOptions().getAvdDriverBinary());
                CommandResult res = oxygenClient.leaseMultipleDevices(buildInfos, this.getTestDeviceOptions(), attributes);
                List<GceAvdInfo> gceAvdInfos = GceAvdInfo.parseGceInfoFromOxygenClientOutput(res, this.mDeviceOptions.getRemoteAdbPort());
                this.mGceAvdInfo = gceAvdInfos.get(0);
                List<GceAvdInfo> list2 = gceAvdInfos;
                ignore.close();
                return list2;
            }
            catch (Throwable throwable) {
                try {
                    ignore.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.OXYGEN_DEVICE_DIRECT_LEASE_COUNT, 2L);
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.CF_LAUNCH_CVD_TIME, System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GceAvdInfo startGceWithOxygenClient(ITestLogger logger, MultiMap<String, String> attributes) throws TargetSetupError {
        long startTime = System.currentTimeMillis();
        long fetchTime = 0L;
        try {
            Object identifier;
            OxygenClient oxygenClient = new OxygenClient(this.getTestDeviceOptions().getAvdDriverBinary());
            CommandResult res = oxygenClient.leaseDevice(this.mBuildInfo, this.getTestDeviceOptions(), attributes);
            for (int iteration = 1; res.getStatus() != CommandStatus.SUCCESS && iteration < 3 && RETRIABLE_LEASE_ERRORS.contains(identifier = GceAvdInfo.refineOxygenErrorType(res.getStderr())); ++iteration) {
                LogUtil.CLog.d("Retrying lease call due to earlier failure of %s", identifier);
                res = oxygenClient.leaseDevice(this.mBuildInfo, this.getTestDeviceOptions(), attributes);
                if (res.getStatus() == CommandStatus.SUCCESS) {
                    InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.LEASE_RETRY_COUNT_SUCCESS, iteration);
                    continue;
                }
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.LEASE_RETRY_COUNT_FAILURE, iteration);
            }
            this.mGceAvdInfo = GceAvdInfo.parseGceInfoFromOxygenClientOutput(res, this.mDeviceOptions.getRemoteAdbPort()).get(0);
            if (this.mGceAvdInfo.hostAndPort() == null) {
                LogUtil.CLog.w("Failed to lease a device: %s", this.mGceAvdInfo);
                identifier = this.mGceAvdInfo;
                return identifier;
            }
            if (oxygenClient.noWaitForBootSpecified(this.getTestDeviceOptions()).booleanValue()) {
                LogUtil.CLog.d("Device leased without waiting for boot to finish. Poll emulator_stderr.txt for flag `VIRTUAL_DEVICE_BOOT_COMPLETED`");
                fetchTime = System.currentTimeMillis() - startTime;
                Boolean bootSuccess = false;
                long timeout = startTime + this.getTestDeviceOptions().getGceCmdTimeout() - System.currentTimeMillis();
                startTime = System.currentTimeMillis();
                String remoteFile = "/tmp/device_launcher/3/emulator_stderr.txt";
                String cfBootStatusSshCmd = "tail -F -n +1 /tmp/device_launcher/3/emulator_stderr.txt | grep -m 1 VIRTUAL_DEVICE_BOOT_COMPLETED";
                String[] cfBootStatusSshCommand = cfBootStatusSshCmd.split(" ");
                res = GceManager.remoteSshCommandExecution(this.mGceAvdInfo, this.getTestDeviceOptions(), RunUtil.getDefault(), timeout, cfBootStatusSshCommand);
                if (CommandStatus.SUCCESS.equals((Object)res.getStatus())) {
                    bootSuccess = true;
                    LogUtil.CLog.d("Device boot completed after %sms, flag located: %s", System.currentTimeMillis() - startTime, res.getStdout().trim());
                }
                if (!bootSuccess.booleanValue()) {
                    if (logger != null) {
                        CommonLogRemoteFileUtil.fetchCommonFiles(logger, this.mGceAvdInfo, this.getTestDeviceOptions(), this.getRunUtil());
                    }
                    this.mGceAvdInfo.setErrorType(InfraErrorIdentifier.OXYGEN_DEVICE_LAUNCHER_TIMEOUT);
                    this.mGceAvdInfo.setStatus(GceAvdInfo.GceStatus.BOOT_FAIL);
                    this.mGceAvdInfo.setErrors("Timed out waiting for virtual device to start.");
                }
            }
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.CF_OXYGEN_SESSION_ID, this.mGceAvdInfo.instanceName());
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.CF_OXYGEN_SERVER_URL, this.mGceAvdInfo.hostAndPort().getHost());
            GceAvdInfo gceAvdInfo = this.mGceAvdInfo;
            return gceAvdInfo;
        }
        finally {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.OXYGEN_DEVICE_DIRECT_LEASE_COUNT, 1L);
            if (this.mGceAvdInfo != null && GceAvdInfo.GceStatus.SUCCESS.equals((Object)this.mGceAvdInfo.getStatus())) {
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.CF_FETCH_ARTIFACT_TIME, fetchTime);
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.CF_LAUNCH_CVD_TIME, System.currentTimeMillis() - startTime);
            }
        }
    }

    private GceAvdInfo startGceWithAcloud(String ipDevice, String user, Integer offset, MultiMap<String, String> attributes) throws TargetSetupError {
        this.mGceAvdInfo = null;
        if (this.mGceHost != null && this.mGceInstanceName != null) {
            this.mGceAvdInfo = new GceAvdInfo(this.mGceInstanceName, HostAndPort.fromString(this.mGceHost).withDefaultPort(this.mDeviceOptions.getRemoteAdbPort()));
            this.mGceAvdInfo.setIpPreconfigured(ipDevice != null);
            this.mGceAvdInfo.setDeviceOffset(offset);
            this.mGceAvdInfo.setInstanceUser(user);
            return this.mGceAvdInfo;
        }
        this.mBuildInfo.addBuildAttribute(GCE_IP_PRECONFIGURED_KEY, Boolean.toString(ipDevice != null));
        File reportFile = null;
        try {
            reportFile = FileUtil.createTempFile("gce_avd_driver", ".json");
            if (user != null) {
                this.getTestDeviceOptions().setInstanceUser(user);
            }
            List<String> gceArgs = this.buildGceCmd(reportFile, this.mBuildInfo, ipDevice, user, offset, attributes);
            long driverTimeoutMs = this.getTestDeviceOptions().getGceCmdTimeout();
            if (!this.getTestDeviceOptions().allowGceCmdTimeoutOverride()) {
                long driverTimeoutSec = Duration.ofMillis(driverTimeoutMs - 180000L).toSeconds();
                gceArgs.add("--boot-timeout");
                gceArgs.add(Long.toString(driverTimeoutSec));
                driverTimeoutMs = driverTimeoutSec * 1000L;
            }
            LogUtil.CLog.i("Launching GCE with %s", gceArgs.toString());
            CommandResult cmd = this.getRunUtil().runTimedCmd(this.getTestDeviceOptions().getGceCmdTimeout(), gceArgs.toArray(new String[gceArgs.size()]));
            LogUtil.CLog.i("GCE driver stderr: %s", cmd.getStderr());
            String instanceName = this.extractInstanceName(cmd.getStderr());
            if (instanceName != null) {
                this.mBuildInfo.addBuildAttribute(GCE_INSTANCE_NAME_KEY, instanceName);
            } else {
                LogUtil.CLog.w("Could not extract an instance name for the gce device.");
            }
            if (CommandStatus.TIMED_OUT.equals((Object)cmd.getStatus())) {
                String errors = String.format("acloud errors: timeout after %dms, acloud did not return", driverTimeoutMs);
                if (instanceName != null) {
                    this.mGceAvdInfo = new GceAvdInfo(instanceName, null, null, errors, GceAvdInfo.GceStatus.BOOT_FAIL);
                    this.mGceAvdInfo.setIpPreconfigured(ipDevice != null);
                    this.mGceAvdInfo.setDeviceOffset(offset);
                    this.mGceAvdInfo.setInstanceUser(user);
                    GceAvdInfo gceAvdInfo = this.mGceAvdInfo;
                    return gceAvdInfo;
                }
                throw new TargetSetupError(errors, this.mDeviceDescriptor, (ErrorIdentifier)InfraErrorIdentifier.ACLOUD_TIMED_OUT);
            }
            if (!CommandStatus.SUCCESS.equals((Object)cmd.getStatus())) {
                LogUtil.CLog.w("Error when booting the Gce instance, reading output of gce driver");
                this.mGceAvdInfo = GceAvdInfo.parseGceInfoFromFile(reportFile, this.mDeviceDescriptor, this.mDeviceOptions.getRemoteAdbPort());
                String errors = "";
                if (this.mGceAvdInfo != null) {
                    this.mGceAvdInfo.setIpPreconfigured(ipDevice != null);
                    this.mGceAvdInfo.setDeviceOffset(offset);
                    this.mGceAvdInfo.setInstanceUser(user);
                    GceAvdInfo gceAvdInfo = this.mGceAvdInfo;
                    return gceAvdInfo;
                }
                errors = "Could not get a valid instance name, check the gce driver's output.The instance may not have booted up at all.";
                InfraErrorIdentifier errorId = InfraErrorIdentifier.NO_ACLOUD_REPORT;
                LogUtil.CLog.e(errors);
                if (cmd.getStderr() != null && cmd.getStderr().contains("Invalid JWT Signature")) {
                    errorId = InfraErrorIdentifier.ACLOUD_INVALID_SERVICE_ACCOUNT_KEY;
                }
                throw new TargetSetupError(String.format("acloud errors: %s\nGCE driver stderr: %s", errors, cmd.getStderr()), this.mDeviceDescriptor, (ErrorIdentifier)errorId);
            }
            this.mGceAvdInfo = GceAvdInfo.parseGceInfoFromFile(reportFile, this.mDeviceDescriptor, this.mDeviceOptions.getRemoteAdbPort());
            this.mGceAvdInfo.setIpPreconfigured(ipDevice != null);
            this.mGceAvdInfo.setDeviceOffset(offset);
            this.mGceAvdInfo.setInstanceUser(user);
            GceAvdInfo gceAvdInfo = this.mGceAvdInfo;
            return gceAvdInfo;
        }
        catch (IOException e) {
            throw new TargetSetupError("failed to create log file", (Throwable)e, this.mDeviceDescriptor, InfraErrorIdentifier.FAIL_TO_CREATE_FILE);
        }
        finally {
            this.logCloudDeviceMetadata();
            FileUtil.deleteFile(reportFile);
        }
    }

    protected String extractInstanceName(String bootupLogs) {
        if (bootupLogs != null) {
            String pattern = "'name': u?'(((gce-)|(ins-))(.*?))'";
            Pattern namePattern = Pattern.compile("'name': u?'(((gce-)|(ins-))(.*?))'");
            Matcher matcher = namePattern.matcher(bootupLogs);
            if (matcher.find()) {
                return matcher.group(1);
            }
        }
        return null;
    }

    protected List<String> buildGceCmd(File reportFile, IBuildInfo b, String ipDevice, String user, Integer offset, MultiMap<String, String> attributes) {
        MultiMap<File, String> extraFiles;
        List<String> gceArgs = ArrayUtil.list(this.getTestDeviceOptions().getAvdDriverBinary().getAbsolutePath());
        gceArgs.add(TestDeviceOptions.getCreateCommandByInstanceType(this.getTestDeviceOptions().getInstanceType()));
        if (TestDeviceOptions.InstanceType.CHEEPS.equals((Object)this.getTestDeviceOptions().getInstanceType())) {
            gceArgs.add("--avd-type");
            gceArgs.add("cheeps");
            if (this.getTestDeviceOptions().getCrosUser() != null && this.getTestDeviceOptions().getCrosPassword() != null) {
                gceArgs.add("--user");
                gceArgs.add(this.getTestDeviceOptions().getCrosUser());
                gceArgs.add("--password");
                gceArgs.add(this.getTestDeviceOptions().getCrosPassword());
            }
        }
        List<String> gceDriverParams = this.getTestDeviceOptions().getGceDriverParams();
        MultiMap<String, File> gceDriverFileParams = this.getTestDeviceOptions().getGceDriverFileParams();
        if (!(gceDriverParams.contains("--build-target") || gceDriverParams.contains("--build_target") || gceDriverFileParams.containsKey("local-image") && gceDriverFileParams.containsKey("cvd-host-package"))) {
            gceArgs.add("--build-target");
            if (b.getBuildAttributes().containsKey("build_target")) {
                gceArgs.add(b.getBuildAttributes().get("build_target"));
            } else {
                gceArgs.add(b.getBuildFlavor());
            }
            gceArgs.add("--branch");
            gceArgs.add(b.getBuildBranch());
            gceArgs.add("--build-id");
            gceArgs.add(b.getBuildId());
        }
        for (Map.Entry<String, File> entry : gceDriverFileParams.entries()) {
            gceArgs.add("--" + entry.getKey());
            gceArgs.add(entry.getValue().getAbsolutePath());
        }
        if (attributes != null) {
            for (String key : this.getTestDeviceOptions().getInvocationAttributeToMetadata()) {
                for (String value : attributes.get(key)) {
                    gceArgs.add("--gce-metadata");
                    gceArgs.add(String.format("%s:%s", key, value));
                }
            }
        }
        if (!(extraFiles = this.getTestDeviceOptions().getExtraFiles()).isEmpty()) {
            gceArgs.add("--extra-files");
            for (File local : extraFiles.keySet()) {
                for (String remoteDestination : extraFiles.get(local)) {
                    gceArgs.add(local.getAbsolutePath() + "," + remoteDestination);
                }
            }
        }
        gceArgs.addAll(gceDriverParams);
        gceArgs.addAll(TestDeviceOptions.getExtraParamsByInstanceType(this.getTestDeviceOptions().getInstanceType(), this.getTestDeviceOptions().getBaseImage()));
        if (this.getAvdConfigFile() != null) {
            gceArgs.add("--config_file");
            gceArgs.add(this.getAvdConfigFile().getAbsolutePath());
        }
        if (this.getTestDeviceOptions().getServiceAccountJsonKeyFile() != null) {
            gceArgs.add("--service-account-json-private-key-path");
            gceArgs.add(this.getTestDeviceOptions().getServiceAccountJsonKeyFile().getAbsolutePath());
        }
        if (ipDevice != null) {
            gceArgs.add("--host");
            gceArgs.add(ipDevice);
            gceArgs.add("--host-user");
            if (user != null) {
                gceArgs.add(user);
            } else {
                gceArgs.add(this.getTestDeviceOptions().getInstanceUser());
            }
            gceArgs.add("--host-ssh-private-key-path");
            gceArgs.add(this.getTestDeviceOptions().getSshPrivateKeyPath().getAbsolutePath());
        }
        gceArgs.add("--report_file");
        gceArgs.add(reportFile.getAbsolutePath());
        if (offset != null) {
            this.getTestDeviceOptions().setRemoteAdbPort(6520 + offset);
            gceArgs.add("--base-instance-num");
            gceArgs.add(String.valueOf(offset + 1));
        }
        switch (this.getTestDeviceOptions().getGceDriverLogLevel()) {
            case DEBUG: {
                gceArgs.add("-v");
                break;
            }
            case VERBOSE: {
                gceArgs.add("-vv");
                break;
            }
        }
        if (this.getTestDeviceOptions().getGceAccount() != null) {
            gceArgs.add("--email");
            gceArgs.add(this.getTestDeviceOptions().getGceAccount());
        }
        return gceArgs;
    }

    public boolean shutdownGce() {
        if (this.getTestDeviceOptions().useOxygen()) {
            return this.shutdownGceWithOxygen();
        }
        return this.shutdownGceWithAcloud();
    }

    private boolean shutdownGceWithOxygen() {
        try {
            OxygenClient oxygenClient = new OxygenClient(this.getTestDeviceOptions().getAvdDriverBinary());
            boolean bl = oxygenClient.release(this.mGceAvdInfo, this.getTestDeviceOptions());
            return bl;
        }
        finally {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.OXYGEN_DEVICE_DIRECT_RELEASE_COUNT, 1L);
            this.mGceAvdInfo = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shutdownGceWithAcloud() {
        if (!this.getTestDeviceOptions().getAvdDriverBinary().canExecute()) {
            this.mGceAvdInfo = null;
            throw new HarnessRuntimeException(String.format("GCE launcher %s is invalid", this.getTestDeviceOptions().getAvdDriverBinary()), InfraErrorIdentifier.CONFIGURED_ARTIFACT_NOT_FOUND);
        }
        String instanceName = null;
        boolean notFromGceAvd = false;
        if (this.mGceAvdInfo != null) {
            instanceName = this.mGceAvdInfo.instanceName();
        }
        if (instanceName == null) {
            instanceName = this.mBuildInfo.getBuildAttributes().get(GCE_INSTANCE_NAME_KEY);
            notFromGceAvd = true;
        }
        if (instanceName == null) {
            LogUtil.CLog.d("No instance to shutdown.");
            return false;
        }
        String hostname = null;
        if (this.mGceAvdInfo != null && this.mGceAvdInfo.hostAndPort() != null) {
            hostname = this.mGceAvdInfo.hostAndPort().getHost();
        }
        boolean ipPreconfigured = false;
        if (this.mGceAvdInfo != null) {
            ipPreconfigured = this.mGceAvdInfo.isIpPreconfigured();
        }
        try {
            boolean res = GceManager.AcloudShutdown(this.getTestDeviceOptions(), this.getRunUtil(), instanceName, hostname, ipPreconfigured);
            if (res || notFromGceAvd) {
                this.mBuildInfo.addBuildAttribute(GCE_INSTANCE_CLEANED_KEY, "true");
            }
            boolean bl = res;
            return bl;
        }
        finally {
            this.mGceAvdInfo = null;
        }
    }

    protected static List<String> buildShutdownCommand(File config, TestDeviceOptions options, String instanceName, String hostname, boolean isIpPreconfigured) {
        List<String> gceArgs = ArrayUtil.list(options.getAvdDriverBinary().getAbsolutePath());
        gceArgs.add("delete");
        if (options.getServiceAccountJsonKeyFile() != null) {
            gceArgs.add("--service-account-json-private-key-path");
            gceArgs.add(options.getServiceAccountJsonKeyFile().getAbsolutePath());
        }
        if (isIpPreconfigured) {
            gceArgs.add("--host");
            gceArgs.add(hostname);
            gceArgs.add("--host-user");
            gceArgs.add(options.getInstanceUser());
            gceArgs.add("--host-ssh-private-key-path");
            gceArgs.add(options.getSshPrivateKeyPath().getAbsolutePath());
        } else if (config != null) {
            gceArgs.add("--config_file");
            gceArgs.add(config.getAbsolutePath());
        }
        gceArgs.add("--instance_names");
        gceArgs.add(instanceName);
        return gceArgs;
    }

    public static boolean AcloudShutdown(TestDeviceOptions options, IRunUtil runUtil, String instanceName, String hostname, boolean isIpPreconfigured) {
        File config = null;
        try {
            List<String> gceArgs;
            File originalConfig = options.getAvdConfigFile();
            if (originalConfig != null) {
                config = FileUtil.createTempFile(originalConfig.getName(), "config");
                FileUtil.copyFile(originalConfig, config);
            }
            if ((gceArgs = GceManager.buildShutdownCommand(config, options, instanceName, hostname, isIpPreconfigured)) == null) {
                LogUtil.CLog.w("Shutdown command as <null>, see earlier logs for reasons.");
                return false;
            }
            LogUtil.CLog.i("Tear down of GCE with %s", gceArgs.toString());
            if (options.waitForGceTearDown()) {
                CommandResult cmd = runUtil.runTimedCmd(options.getGceCmdTimeout(), gceArgs.toArray(new String[gceArgs.size()]));
                FileUtil.deleteFile(config);
                LogUtil.CLog.i("GCE driver teardown output:\nstdout:%s\nstderr:%s", cmd.getStdout(), cmd.getStderr());
                if (!CommandStatus.SUCCESS.equals((Object)cmd.getStatus())) {
                    LogUtil.CLog.w("Failed to tear down GCE %s with the following arg: %s.", instanceName, gceArgs);
                    return false;
                }
            } else {
                Process p = runUtil.runCmdInBackground(ProcessBuilder.Redirect.DISCARD, gceArgs);
                if (config != null) {
                    new AcloudDeleteCleaner(p, config).start();
                }
            }
        }
        catch (IOException ioe) {
            LogUtil.CLog.e("failed to create log file for GCE Teardown");
            LogUtil.CLog.e(ioe);
            FileUtil.deleteFile(config);
            return false;
        }
        return true;
    }

    public static File getBugreportzWithSsh(GceAvdInfo gceAvd, TestDeviceOptions options, IRunUtil runUtil) throws IOException {
        File localTmpFile;
        String output = GceManager.remoteSshCommandExec(gceAvd, options, runUtil, "bugreportz");
        Matcher match = BUGREPORTZ_RESPONSE_PATTERN.matcher(output);
        if (!match.find()) {
            LogUtil.CLog.e("Something went wrong during bugreportz collection: '%s'", output);
            return null;
        }
        String remoteFilePath = match.group(2);
        if (!RemoteFileUtil.fetchRemoteFile(gceAvd, options, runUtil, 600000L, remoteFilePath, localTmpFile = FileUtil.createTempFile("bugreport-ssh", ".zip"))) {
            FileUtil.deleteFile(localTmpFile);
            return null;
        }
        return localTmpFile;
    }

    public static File getNestedDeviceSshBugreportz(GceAvdInfo gceAvd, TestDeviceOptions options, IRunUtil runUtil) throws IOException {
        String output;
        if (gceAvd == null || gceAvd.hostAndPort() == null) {
            return null;
        }
        String adbTool = "./bin/adb";
        if (options.useOxygen() && (output = GceManager.remoteSshCommandExec(gceAvd, options, runUtil, adbTool = "./tools/dynamic_adb_tool", "connect", "localhost:6520")).contains("failed to connect to")) {
            LogUtil.CLog.e("Bugreport collection skipped due to device can't be connected: %s", output);
            return null;
        }
        output = options.useOxygen() ? GceManager.remoteSshCommandExec(gceAvd, options, runUtil, adbTool, "-s", "localhost:6520", "wait-for-device", "shell", "bugreportz") : GceManager.remoteSshCommandExec(gceAvd, options, runUtil, adbTool, "wait-for-device", "shell", "bugreportz");
        Matcher match = BUGREPORTZ_RESPONSE_PATTERN.matcher(output);
        if (!match.find()) {
            LogUtil.CLog.e("Something went wrong during bugreportz collection: '%s'", output);
            return null;
        }
        String deviceFilePath = match.group(2);
        String pullOutput = options.useOxygen() ? GceManager.remoteSshCommandExec(gceAvd, options, runUtil, adbTool, "-s", "localhost:6520", "pull", deviceFilePath) : GceManager.remoteSshCommandExec(gceAvd, options, runUtil, adbTool, "pull", deviceFilePath);
        LogUtil.CLog.d(pullOutput);
        String remoteFilePath = "./" + new File(deviceFilePath).getName();
        File localTmpFile = FileUtil.createTempFile("bugreport-ssh", ".zip");
        if (!RemoteFileUtil.fetchRemoteFile(gceAvd, options, runUtil, 600000L, remoteFilePath, localTmpFile)) {
            FileUtil.deleteFile(localTmpFile);
            return null;
        }
        return localTmpFile;
    }

    public static boolean logNestedRemoteFile(ITestLogger logger, GceAvdInfo gceAvd, TestDeviceOptions options, IRunUtil runUtil, String remoteFilePath, LogDataType type) {
        return GceManager.logNestedRemoteFile(logger, gceAvd, options, runUtil, remoteFilePath, type, null);
    }

    public static boolean logNestedRemoteFile(ITestLogger logger, GceAvdInfo gceAvd, TestDeviceOptions options, IRunUtil runUtil, String remoteFilePath, LogDataType type, String baseName) {
        if (type == LogDataType.DIR) {
            File remoteFile = RemoteFileUtil.fetchRemoteDir(gceAvd, options, runUtil, 600000L, remoteFilePath);
            if (remoteFile != null && remoteFile.listFiles().length == 0) {
                FileUtil.recursiveDelete(remoteFile);
                return false;
            }
            if (options.useOxygen() && remoteFile != null) {
                try (CloseableTraceScope ignore = new CloseableTraceScope("avd:collectErrorSignature");){
                    List<String> signatures = OxygenUtil.collectErrorSignatures(remoteFile);
                    if (signatures.size() > 0) {
                        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.DEVICE_ERROR_SIGNATURES, String.join((CharSequence)",", signatures));
                    }
                }
                ignore = new CloseableTraceScope("avd:collectDeviceLaunchMetrics");
                try {
                    long[] launchMetrics = OxygenUtil.collectDeviceLaunchMetrics(remoteFile);
                    if (launchMetrics[0] > 0L) {
                        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.CF_FETCH_ARTIFACT_TIME, launchMetrics[0]);
                        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.CF_LAUNCH_CVD_TIME, launchMetrics[1]);
                    }
                }
                finally {
                    ignore.close();
                }
                ignore = new CloseableTraceScope("avd:collectOxygenVersion");
                try {
                    String oxygenVersion = OxygenUtil.collectOxygenVersion(remoteFile);
                    if (!Strings.isNullOrEmpty(oxygenVersion)) {
                        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.CF_OXYGEN_VERSION, oxygenVersion);
                    }
                }
                finally {
                    ignore.close();
                }
            }
            type = LogDataType.CUTTLEFISH_LOG;
            if (remoteFile != null) {
                GceManager.logDirectory(remoteFile, baseName, logger, type);
                return true;
            }
        } else {
            File remoteFile = RemoteFileUtil.fetchRemoteFile(gceAvd, options, runUtil, 600000L, remoteFilePath);
            if (remoteFile != null) {
                GceManager.logFile(remoteFile, baseName, logger, type);
                return true;
            }
        }
        return false;
    }

    private static void logDirectory(File remoteDirectory, String baseName, ITestLogger logger, LogDataType type) {
        for (File f : remoteDirectory.listFiles()) {
            if (f.isFile()) {
                LogDataType typeFromName = OxygenUtil.getDefaultLogType(f.getName());
                if (!typeFromName.equals((Object)LogDataType.UNKNOWN)) {
                    type = typeFromName;
                }
                GceManager.logFile(f, baseName, logger, type);
                continue;
            }
            if (!f.isDirectory()) continue;
            GceManager.logDirectory(f, baseName, logger, type);
        }
    }

    private static void logFile(File remoteFile, String baseName, ITestLogger logger, LogDataType type) {
        try (FileInputStreamSource remoteFileStream = new FileInputStreamSource(remoteFile, true);){
            String name = baseName;
            if (name == null) {
                name = remoteFile.getName();
            }
            logger.testLog(name, type, remoteFileStream);
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.CF_LOG_SIZE, remoteFileStream.size());
        }
    }

    public static CommandResult remoteSshCommandExecution(GceAvdInfo gceAvd, TestDeviceOptions options, IRunUtil runUtil, long timeoutMs, String ... command) {
        return RemoteSshUtil.remoteSshCommandExec(gceAvd, options, runUtil, timeoutMs, command);
    }

    private static String remoteSshCommandExec(GceAvdInfo gceAvd, TestDeviceOptions options, IRunUtil runUtil, String ... command) {
        CommandResult res = GceManager.remoteSshCommandExecution(gceAvd, options, runUtil, 300000L, command);
        String output = res.getStdout().trim();
        if (!CommandStatus.SUCCESS.equals((Object)res.getStatus())) {
            LogUtil.CLog.e("issue when attempting to execute '%s':", Arrays.asList(command));
            LogUtil.CLog.e("Stderr: %s", res.getStderr());
        } else if (output.isEmpty()) {
            LogUtil.CLog.e("Stdout from '%s' was empty", Arrays.asList(command));
            LogUtil.CLog.e("Stderr: %s", res.getStderr());
        }
        return output;
    }

    public static String getInstanceSerialLog(GceAvdInfo infos, File avdConfigFile, File jsonKeyFile, IRunUtil runUtil) {
        AcloudConfigParser config = AcloudConfigParser.parseConfig(avdConfigFile);
        if (config == null) {
            LogUtil.CLog.e("Failed to parse our acloud config.");
            return null;
        }
        if (infos == null) {
            return null;
        }
        try {
            Credential credential = GceManager.createCredential(config, jsonKeyFile);
            String project = config.getValueForKey(AcloudConfigParser.AcloudKeys.PROJECT);
            String zone = config.getValueForKey(AcloudConfigParser.AcloudKeys.ZONE);
            String instanceName = infos.instanceName();
            Compute compute = new Compute.Builder(GoogleNetHttpTransport.newTrustedTransport(), JSON_FACTORY, null).setApplicationName(project).setHttpRequestInitializer(credential).build();
            Compute.Instances.GetSerialPortOutput outputPort = compute.instances().getSerialPortOutput(project, zone, instanceName);
            SerialPortOutput output = (SerialPortOutput)outputPort.execute();
            return output.getContents();
        }
        catch (IOException | GeneralSecurityException e) {
            LogUtil.CLog.e(e);
            return null;
        }
    }

    private static Credential createCredential(AcloudConfigParser config, File jsonKeyFile) throws GeneralSecurityException, IOException {
        if (jsonKeyFile != null) {
            return GoogleApiClientUtil.createCredentialFromJsonKeyFile(jsonKeyFile, SCOPES);
        }
        if (config.getValueForKey(AcloudConfigParser.AcloudKeys.SERVICE_ACCOUNT_JSON_PRIVATE_KEY) != null) {
            jsonKeyFile = new File(config.getValueForKey(AcloudConfigParser.AcloudKeys.SERVICE_ACCOUNT_JSON_PRIVATE_KEY));
            return GoogleApiClientUtil.createCredentialFromJsonKeyFile(jsonKeyFile, SCOPES);
        }
        String serviceAccount = config.getValueForKey(AcloudConfigParser.AcloudKeys.SERVICE_ACCOUNT_NAME);
        String serviceKey = config.getValueForKey(AcloudConfigParser.AcloudKeys.SERVICE_ACCOUNT_PRIVATE_KEY);
        return GoogleApiClientUtil.createCredentialFromP12File(serviceAccount, new File(serviceKey), SCOPES);
    }

    public void cleanUp() {
    }

    @VisibleForTesting
    IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }

    public void logSerialOutput(GceAvdInfo infos, ITestLogger logger) {
        if (this.mSkipSerialLogCollection) {
            LogUtil.CLog.d("Serial log collection is skipped");
            return;
        }
        String output = GceManager.getInstanceSerialLog(infos, this.getAvdConfigFile(), this.getTestDeviceOptions().getServiceAccountJsonKeyFile(), this.getRunUtil());
        if (output == null) {
            LogUtil.CLog.w("Failed to collect the instance serial logs.");
            return;
        }
        try (ByteArrayInputStreamSource source = new ByteArrayInputStreamSource(output.getBytes());){
            logger.testLog("gce_full_serial_log", LogDataType.TEXT, source);
        }
    }

    private void logCloudDeviceMetadata() {
        AcloudConfigParser config = AcloudConfigParser.parseConfig(this.getAvdConfigFile());
        if (config == null) {
            LogUtil.CLog.e("Failed to parse our acloud config.");
            return;
        }
        if (config.getValueForKey(AcloudConfigParser.AcloudKeys.STABLE_HOST_IMAGE_NAME) != null) {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.CLOUD_DEVICE_STABLE_HOST_IMAGE, config.getValueForKey(AcloudConfigParser.AcloudKeys.STABLE_HOST_IMAGE_NAME));
        }
        if (config.getValueForKey(AcloudConfigParser.AcloudKeys.STABLE_HOST_IMAGE_PROJECT) != null) {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.CLOUD_DEVICE_STABLE_HOST_IMAGE_PROJECT, config.getValueForKey(AcloudConfigParser.AcloudKeys.STABLE_HOST_IMAGE_PROJECT));
        }
        if (config.getValueForKey(AcloudConfigParser.AcloudKeys.PROJECT) != null) {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.CLOUD_DEVICE_PROJECT, config.getValueForKey(AcloudConfigParser.AcloudKeys.PROJECT));
        }
        if (config.getValueForKey(AcloudConfigParser.AcloudKeys.ZONE) != null) {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.CLOUD_DEVICE_ZONE, config.getValueForKey(AcloudConfigParser.AcloudKeys.ZONE));
        }
        if (config.getValueForKey(AcloudConfigParser.AcloudKeys.MACHINE_TYPE) != null) {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.CLOUD_DEVICE_MACHINE_TYPE, config.getValueForKey(AcloudConfigParser.AcloudKeys.MACHINE_TYPE));
        }
    }

    private TestDeviceOptions getTestDeviceOptions() {
        return this.mDeviceOptions;
    }

    @VisibleForTesting
    File getAvdConfigFile() {
        return this.getTestDeviceOptions().getAvdConfigFile();
    }

    private static class AcloudDeleteCleaner
    extends Thread {
        private Process mProcess;
        private File mConfigFile;

        public AcloudDeleteCleaner(Process p, File config) {
            this.setDaemon(true);
            this.setName("acloud-delete-cleaner");
            this.mProcess = p;
            this.mConfigFile = config;
        }

        @Override
        public void run() {
            try {
                this.mProcess.waitFor();
            }
            catch (InterruptedException e) {
                LogUtil.CLog.e(e);
            }
            FileUtil.deleteFile(this.mConfigFile);
        }
    }
}

