/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.cloud;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class GceRemoteCmdFormatter {
    public static List<String> getSshCommand(File sshKey, List<String> extraOptions, String user, String hostName, String ... command) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("ssh");
        cmd.add("-o");
        cmd.add("LogLevel=ERROR");
        cmd.add("-o");
        cmd.add("UserKnownHostsFile=/dev/null");
        cmd.add("-o");
        cmd.add("StrictHostKeyChecking=no");
        cmd.add("-o");
        cmd.add("ServerAliveInterval=10");
        cmd.add("-i");
        cmd.add(sshKey.getAbsolutePath());
        if (extraOptions != null) {
            for (String op : extraOptions) {
                cmd.add(op);
            }
        }
        cmd.add(user + "@" + hostName);
        for (String cmdOption : command) {
            cmd.add(cmdOption);
        }
        return cmd;
    }

    public static List<String> getScpCommand(File sshKey, List<String> extraOptions, String user, String hostName, String remoteFile, String localFile, ScpMode mode) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("scp");
        cmd.add("-o");
        cmd.add("LogLevel=ERROR");
        cmd.add("-o");
        cmd.add("UserKnownHostsFile=/dev/null");
        cmd.add("-o");
        cmd.add("StrictHostKeyChecking=no");
        cmd.add("-o");
        cmd.add("ServerAliveInterval=10");
        cmd.add("-i");
        cmd.add(sshKey.getAbsolutePath());
        if (extraOptions != null) {
            for (String op : extraOptions) {
                cmd.add(op);
            }
        }
        if (ScpMode.PULL.equals((Object)mode)) {
            cmd.add(String.format("%s@%s:%s", user, hostName, remoteFile));
            cmd.add(localFile);
        } else {
            cmd.add(localFile);
            cmd.add(String.format("%s@%s:%s", user, hostName, remoteFile));
        }
        return cmd;
    }

    public static enum ScpMode {
        PUSH,
        PULL;

    }
}

