/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.cloud;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.device.IManagedTestDevice;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.RemoteAvdIDevice;
import com.android.tradefed.device.TestDeviceOptions;
import com.android.tradefed.device.cloud.GceRemoteCmdFormatter;
import com.android.tradefed.device.connection.AbstractConnection;
import com.android.tradefed.device.connection.AdbTcpConnection;
import com.android.tradefed.log.ITestLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.StreamUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.net.HostAndPort;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class GceSshTunnelMonitor
extends Thread {
    public static final String VIRTUAL_DEVICE_SERIAL = "virtual-device-serial";
    private static final long ADBD_RETRY_INTERVAL_MS = 15000L;
    private static final int ADBD_MAX_RETRIES = 10;
    private static final long DEFAULT_LONG_CMD_TIMEOUT = 60000L;
    private static final long DEFAULT_SHORT_CMD_TIMEOUT = 20000L;
    private static final int WAIT_FOR_FIRST_CONNECT = 10000;
    private static final long WAIT_AFTER_REBOOT = 60000L;
    private static final String DEFAULT_LOCAL_HOST = "127.0.0.1:%d";
    private static final String TUNNEL_PARAM = "-L%d:127.0.0.1:%d";
    private boolean mQuit = false;
    private boolean mAdbRebootCalled = false;
    private ITestDevice mDevice;
    private TestDeviceOptions mDeviceOptions;
    private HostAndPort mGceHostAndPort;
    private HostAndPort mLocalHostAndPort;
    private Process mSshTunnelProcess;
    private IBuildInfo mBuildInfo;
    private int mLastUsedPort = 0;
    private Exception mLastException = null;
    private boolean mSshChecked = false;
    private File mSshTunnelLogs = null;
    private File mAdbConnectionLogs = null;

    public GceSshTunnelMonitor(ITestDevice device, IBuildInfo buildInfo, HostAndPort gce, TestDeviceOptions deviceOptions) {
        super(String.format("GceSshTunnelMonitor-%s-%s-%s", buildInfo.getBuildBranch(), buildInfo.getBuildFlavor(), buildInfo.getBuildId()));
        this.setDaemon(true);
        this.mDevice = device;
        this.mGceHostAndPort = gce;
        this.mBuildInfo = buildInfo;
        this.mDeviceOptions = deviceOptions;
        this.mLastException = null;
        this.mQuit = false;
        this.mSshTunnelLogs = null;
    }

    @VisibleForTesting
    IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }

    TestDeviceOptions getTestDeviceOptions() {
        return this.mDeviceOptions;
    }

    public boolean isTunnelAlive() {
        if (this.mSshTunnelProcess != null) {
            return this.mSshTunnelProcess.isAlive();
        }
        return false;
    }

    public void isAdbRebootCalled(boolean isCalled) {
        this.mAdbRebootCalled = isCalled;
    }

    public void shutdown() {
        this.mQuit = true;
        this.closeConnection();
        this.getRunUtil().allowInterrupt(true);
        this.getRunUtil().interrupt(this, "shutting down the monitor thread.", null);
        this.interrupt();
    }

    public void joinMonitor() throws InterruptedException {
        super.join(60000L);
    }

    public void closeConnection() {
        AbstractConnection conn;
        LogUtil.CLog.d("closeConnection is triggered.");
        if (this.mLocalHostAndPort != null && (conn = this.mDevice.getConnection()) instanceof AdbTcpConnection && !((AdbTcpConnection)conn).adbTcpDisconnect(this.mLocalHostAndPort.getHost(), Integer.toString(this.mLocalHostAndPort.getPort()))) {
            LogUtil.CLog.d("Failed to disconnect from local host %s", this.mLocalHostAndPort.toString());
        }
        if (this.mSshTunnelProcess != null) {
            this.mSshTunnelProcess.destroy();
            try {
                boolean res = this.mSshTunnelProcess.waitFor(20000L, TimeUnit.MILLISECONDS);
                if (!res) {
                    LogUtil.CLog.e("SSH tunnel may not have properly terminated.");
                }
            }
            catch (InterruptedException e) {
                LogUtil.CLog.e("SSH tunnel interrupted during shutdown: %s", e.getMessage());
            }
        }
    }

    @VisibleForTesting
    void checkSshKey() {
        if (!this.getTestDeviceOptions().getSshPrivateKeyPath().canRead()) {
            if (this.mSshChecked) {
                this.getRunUtil().sleep(20000L);
                if (this.getTestDeviceOptions().getSshPrivateKeyPath().canRead()) {
                    LogUtil.CLog.w("ssh key was not available for a temporary period of time.");
                    return;
                }
            }
            throw new RuntimeException(String.format("Ssh private key is unavailable %s", this.getTestDeviceOptions().getSshPrivateKeyPath().getAbsolutePath()));
        }
        this.mSshChecked = true;
    }

    void initGce() {
        this.checkSshKey();
        if (TestDeviceOptions.InstanceType.GCE.equals((Object)this.mDeviceOptions.getInstanceType()) || TestDeviceOptions.InstanceType.REMOTE_AVD.equals((Object)this.mDeviceOptions.getInstanceType())) {
            List<String> stopAdb = GceRemoteCmdFormatter.getSshCommand(this.getTestDeviceOptions().getSshPrivateKeyPath(), null, this.getTestDeviceOptions().getInstanceUser(), this.mGceHostAndPort.getHost(), "stop", "adbd");
            LogUtil.CLog.d("Running %s", stopAdb);
            CommandResult result = this.getRunUtil().runTimedCmdSilentlyRetry(20000L, 15000L, 10, stopAdb.toArray(new String[0]));
            if (!CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
                LogUtil.CLog.w("failed to stop adbd %s", result.getStderr());
                throw new RuntimeException("failed to stop adbd");
            }
            if (this.mQuit) {
                throw new RuntimeException("Shutdown has been requested. stopping init.");
            }
            List<String> startAdb = GceRemoteCmdFormatter.getSshCommand(this.getTestDeviceOptions().getSshPrivateKeyPath(), null, this.getTestDeviceOptions().getInstanceUser(), this.mGceHostAndPort.getHost(), "start", "adbd");
            result = this.getRunUtil().runTimedCmdSilentlyRetry(20000L, 15000L, 10, startAdb.toArray(new String[0]));
            LogUtil.CLog.d("Running %s", startAdb);
            if (!CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
                LogUtil.CLog.w("failed to start adbd", result);
                throw new RuntimeException("failed to start adbd");
            }
        }
    }

    @Override
    public void run() {
        while (!this.mQuit) {
            try {
                if (this.mQuit) {
                    LogUtil.CLog.d("Final shutdown of the tunnel has been requested. terminating.");
                    return;
                }
                this.initGce();
            }
            catch (RuntimeException e) {
                this.mLastException = e;
                LogUtil.CLog.d("Failed to init remote GCE. Terminating due to:");
                LogUtil.CLog.e(e);
                return;
            }
            if (this.mAdbConnectionLogs == null) {
                try {
                    this.mAdbConnectionLogs = FileUtil.createTempFile("adb-connection", ".txt");
                }
                catch (IOException e) {
                    FileUtil.deleteFile(this.mAdbConnectionLogs);
                    LogUtil.CLog.e(e);
                }
            }
            if (this.mAdbConnectionLogs != null && this.mDevice.getConnection() instanceof AdbTcpConnection) {
                ((AdbTcpConnection)this.mDevice.getConnection()).setAdbLogFile(this.mAdbConnectionLogs);
            }
            this.mSshTunnelProcess = this.createSshTunnel(this.mDevice, this.mGceHostAndPort.getHost(), this.mGceHostAndPort.getPortOrDefault(5555));
            if (this.mSshTunnelProcess == null) {
                LogUtil.CLog.e("Failed creating the ssh tunnel to GCE.");
                return;
            }
            this.getRunUtil().sleep(10000L);
            if (this.isTunnelAlive()) {
                this.mLocalHostAndPort = HostAndPort.fromString(this.mDevice.getSerialNumber());
                AbstractConnection conn = this.mDevice.getConnection();
                if (conn instanceof AdbTcpConnection && !((AdbTcpConnection)conn).adbTcpConnect(this.mLocalHostAndPort.getHost(), Integer.toString(this.mLocalHostAndPort.getPort()))) {
                    LogUtil.CLog.e("Adb connect failed, re-init GCE connection.");
                    this.closeConnection();
                    continue;
                }
                try {
                    this.mSshTunnelProcess.waitFor();
                }
                catch (InterruptedException e) {
                    LogUtil.CLog.d("SSH tunnel terminated %s", e.getMessage());
                }
                LogUtil.CLog.d("Reached end of loop, tunnel is going to re-init.");
                if (!this.mAdbRebootCalled) continue;
                this.mAdbRebootCalled = false;
                LogUtil.CLog.d("Tunnel reached end of loop due to adbReboot, waiting a little for device to come online");
                this.getRunUtil().sleep(60000L);
                continue;
            }
            LogUtil.CLog.e("SSH Tunnel is not alive after starting it. It must have returned.");
        }
    }

    @VisibleForTesting
    Process createSshTunnel(ITestDevice device, String remoteHost, int remotePort) {
        try {
            ServerSocket s = null;
            try {
                s = new ServerSocket(this.mLastUsedPort);
            }
            catch (SocketException se) {
                s = new ServerSocket(0);
                LogUtil.CLog.w("Our previous port: %s was already in use, switching to: %s", this.mLastUsedPort, s.getLocalPort());
            }
            s.setReuseAddress(true);
            this.mLastUsedPort = s.getLocalPort();
            String serial = String.format(DEFAULT_LOCAL_HOST, this.mLastUsedPort);
            if (this.mQuit) {
                LogUtil.CLog.d("Shutdown has been requested. Skipping creation of the ssh process");
                StreamUtil.close(s);
                return null;
            }
            LogUtil.CLog.d("Setting device %s serial to %s", device.getSerialNumber(), serial);
            ((IManagedTestDevice)device).setIDevice(new RemoteAvdIDevice(serial));
            this.mBuildInfo.addBuildAttribute(VIRTUAL_DEVICE_SERIAL, serial);
            StreamUtil.close(s);
            ArrayList<String> tunnelParam = new ArrayList<String>();
            tunnelParam.add(String.format(TUNNEL_PARAM, this.mLastUsedPort, remotePort));
            tunnelParam.add("-N");
            List<String> sshTunnel = GceRemoteCmdFormatter.getSshCommand(this.getTestDeviceOptions().getSshPrivateKeyPath(), tunnelParam, this.getTestDeviceOptions().getInstanceUser(), remoteHost, "");
            if (this.mSshTunnelLogs == null || !this.mSshTunnelLogs.exists()) {
                this.mSshTunnelLogs = FileUtil.createTempFile("ssh-tunnel-logs", ".txt");
                FileUtil.writeToFile("=== Beginning ===\n", this.mSshTunnelLogs);
            }
            Process p = this.getRunUtil().runCmdInBackground(sshTunnel, new FileOutputStream(this.mSshTunnelLogs, true));
            return p;
        }
        catch (IOException e) {
            LogUtil.CLog.d("Failed to connect to remote GCE using ssh tunnel %s", e.getMessage());
            return null;
        }
    }

    public Exception getLastException() {
        return this.mLastException;
    }

    public void logSshTunnelLogs(ITestLogger logger) {
        if (this.mDevice.getConnection() instanceof AdbTcpConnection) {
            ((AdbTcpConnection)this.mDevice.getConnection()).setAdbLogFile(null);
        }
        if (this.mSshTunnelLogs != null) {
            try (FileInputStreamSource sshBridge = new FileInputStreamSource(this.mSshTunnelLogs, true);){
                logger.testLog("ssh-bridge-logs", LogDataType.TEXT, sshBridge);
            }
        }
        if (this.mAdbConnectionLogs != null) {
            try (FileInputStreamSource adbLogs = new FileInputStreamSource(this.mAdbConnectionLogs, true);){
                logger.testLog("adb-connect-logs", LogDataType.TEXT, adbLogs);
            }
        }
    }
}

