/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.cloud;

import com.android.ddmlib.IDevice;
import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Configuration;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.DynamicRemoteFileResolver;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.OptionCopier;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.IDeviceMonitor;
import com.android.tradefed.device.IDeviceStateMonitor;
import com.android.tradefed.device.TestDevice;
import com.android.tradefed.device.TestDeviceOptions;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestLoggerReceiver;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.MultiMap;

public class ManagedRemoteDevice
extends TestDevice
implements ITestLoggerReceiver {
    private TestDeviceOptions mCopiedOptions;
    private IConfiguration mValidationConfig;

    public ManagedRemoteDevice(IDevice device, IDeviceStateMonitor stateMonitor, IDeviceMonitor allocationMonitor) {
        super(device, stateMonitor, allocationMonitor);
    }

    @Override
    public void preInvocationSetup(IBuildInfo info, MultiMap<String, String> attributes) throws TargetSetupError, DeviceNotAvailableException {
        this.mCopiedOptions = null;
        super.preInvocationSetup(info, attributes);
    }

    @Override
    public void postInvocationTearDown(Throwable exception) {
        this.mCopiedOptions = null;
        if (this.mValidationConfig != null) {
            this.mValidationConfig.cleanConfigurationData();
            this.mValidationConfig = null;
        }
        super.postInvocationTearDown(exception);
    }

    @Override
    public TestDeviceOptions getOptions() {
        if (this.mCopiedOptions == null) {
            LogUtil.CLog.d("Copying TestDeviceOptions for dynamic configs.");
            this.mCopiedOptions = new TestDeviceOptions();
            TestDeviceOptions options = super.getOptions();
            OptionCopier.copyOptionsNoThrow(options, this.mCopiedOptions);
            this.mValidationConfig = new Configuration("validation", "validation");
            this.mValidationConfig.setDeviceOptions(this.mCopiedOptions);
            try {
                this.mValidationConfig.resolveDynamicOptions(new DynamicRemoteFileResolver());
            }
            catch (BuildRetrievalError | ConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
        return this.mCopiedOptions;
    }
}

