/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.cloud;

import com.android.ddmlib.IDevice;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.DeviceStateMonitor;
import com.android.tradefed.device.IDeviceManager;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.RunUtil;

public class NestedDeviceStateMonitor
extends DeviceStateMonitor {
    private static final String DUMPSYS_ERROR = "Error dumping service info";
    private ITestDevice mDevice;

    public NestedDeviceStateMonitor(IDeviceManager mgr, IDevice device, boolean fastbootEnabled) {
        super(mgr, device, fastbootEnabled);
    }

    @Override
    protected boolean postOnlineCheck(long waitTime) throws DeviceNotAvailableException {
        long startTime = System.currentTimeMillis();
        if (!super.postOnlineCheck(waitTime)) {
            return false;
        }
        long elapsedTime = System.currentTimeMillis() - startTime;
        return this.nestedWaitForDeviceOnline(waitTime - elapsedTime);
    }

    private boolean nestedWaitForDeviceOnline(long maxWaitTime) {
        long maxTime = System.currentTimeMillis() + maxWaitTime;
        CommandResult res = null;
        while (maxTime > System.currentTimeMillis()) {
            try {
                res = this.mDevice.executeShellV2Command("dumpsys package");
                if (CommandStatus.SUCCESS.equals((Object)res.getStatus()) && !res.getStdout().contains(DUMPSYS_ERROR)) {
                    return true;
                }
            }
            catch (DeviceNotAvailableException e) {
                LogUtil.CLog.e(e);
            }
            RunUtil.getDefault().sleep(200L);
        }
        if (res != null) {
            LogUtil.CLog.e("Error checking device ready: %s", res.getStderr());
        }
        return false;
    }

    final void setDevice(ITestDevice device) {
        this.mDevice = device;
    }
}

