/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.cloud;

import com.android.ddmlib.IDevice;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.IDeviceMonitor;
import com.android.tradefed.device.IDeviceStateMonitor;
import com.android.tradefed.device.TestDevice;
import com.android.tradefed.device.cloud.NestedDeviceStateMonitor;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import java.util.HashMap;
import java.util.Map;

public class NestedRemoteDevice
extends TestDevice {
    private static final Map<String, String> IP_TO_USER = new HashMap<String, String>();

    public NestedRemoteDevice(IDevice device, IDeviceStateMonitor stateMonitor, IDeviceMonitor allocationMonitor) {
        super(device, stateMonitor, allocationMonitor);
        if (stateMonitor instanceof NestedDeviceStateMonitor) {
            ((NestedDeviceStateMonitor)stateMonitor).setDevice(this);
        }
    }

    public final boolean resetVirtualDevice() throws DeviceNotAvailableException {
        String usernameId = IP_TO_USER.get(this.getSerialNumber());
        if (usernameId == null) {
            throw new DeviceNotAvailableException(String.format("Cannot reset %s, no mapping in IP_TO_USER", this.getSerialNumber()), this.getSerialNumber(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_FAILED_TO_RESET);
        }
        String powerwashCommand = String.format("powerwash_cvd -instance_num %s", usernameId);
        long timeout = Math.max(300000L, this.getOptions().getGceCmdTimeout());
        CommandResult powerwashRes = this.getRunUtil().runTimedCmd(timeout, powerwashCommand.split(" "));
        if (!CommandStatus.SUCCESS.equals((Object)powerwashRes.getStatus())) {
            LogUtil.CLog.e("%s", powerwashRes.getStderr());
            CommandResult printAdbDevices = this.getRunUtil().runTimedCmd(60000L, "adb", "devices");
            LogUtil.CLog.e("%s\n%s", printAdbDevices.getStdout(), printAdbDevices.getStderr());
            return false;
        }
        this.getRunUtil().sleep(5000L);
        this.waitForDeviceAvailable();
        this.resetContentProviderSetup();
        return true;
    }

    static {
        IP_TO_USER.put("0.0.0.0:6520", "1");
        IP_TO_USER.put("0.0.0.0:6521", "2");
        IP_TO_USER.put("0.0.0.0:6522", "3");
        IP_TO_USER.put("0.0.0.0:6523", "4");
        IP_TO_USER.put("0.0.0.0:6524", "5");
        IP_TO_USER.put("0.0.0.0:6525", "6");
        IP_TO_USER.put("0.0.0.0:6526", "7");
        IP_TO_USER.put("0.0.0.0:6527", "8");
        IP_TO_USER.put("0.0.0.0:6528", "9");
        IP_TO_USER.put("0.0.0.0:6529", "10");
        IP_TO_USER.put("0.0.0.0:6530", "11");
        IP_TO_USER.put("0.0.0.0:6531", "12");
        IP_TO_USER.put("0.0.0.0:6532", "13");
        IP_TO_USER.put("0.0.0.0:6533", "14");
        IP_TO_USER.put("0.0.0.0:6534", "15");
    }
}

